/*
  
   GargonScene n3                                                    
   Efecto nieve                                                       
   Compilar con modelo de memoria 'compact'                           
  
   
*/
#include <stdio.h>
#include <conio.h>
#include <malloc.h>
#include <stdlib.h>
#include <dos.h>

#define MAX_COPOS 90			/* Nmero de copos en la nevada */

char *Vga = (char *) 0xa0000000L;	/* Puntero al la video-ram      */
char *VScreen;				/* Pantalla virtual	   	*/

char pal[256*3];			/* Paleta del fichero raw       */


struct Copos				/* Para controlar los puntos (copos) */
	{
	 int x;
	 int y;
	 int Jock;
	}Copo[MAX_COPOS];

/* Declaracin de funciones grficas y dems */
void ini_mode(char mode);
void flip_screens(char *source, char *where);
void gets_palette(char *file, char *where);
void gets_raw(char *file, char *where);
void set_palette(char *palette);
void set_color(char color, char red, char green, char blue);
void put_pixel(int x, int y, char color, char *where);
char get_pixel(int x, int y, char *where);
void wait_retrace();


/* Incio del programa .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.*/
void main()
{
 int count;		/* Contador para bucles */

 ini_mode(19);		/* Modo 13h (320x200x256). Para sacar ms provecho */
			/* a este efecto, intenta pasarlo a svga. Yo no lo */
			/* he echo para no complicar ms de lo devido el   */
			/* cdigo. */

 randomize();		/* Inicializamos semilla para que random no sea    */
			/* siempre igual.				   */


 if((VScreen=(char *) malloc(64000U)) == NULL) /* Si no hay memoria, salir */
		{
		 printf("Insufiente memoria... :'( \n\n\r");
		 exit(-1);
		}


 gets_raw("logo.raw", VScreen);		/* Leemos fichero que est en for- */
 gets_palette("logo.pal", pal);		/* mato crudo */
 set_palette(pal);

 set_color(1, 55,55,55);		/* Color nieve: blanco */


 for(count=0;count<MAX_COPOS;count++)   /* Inicializamos todos los copos */
	{
	 Copo[count].x=random(320);
	 Copo[count].y=random(35);
	 if(!(Copo[count].Jock=random(2)))
				Copo[count].Jock=(-1);
	}


 do {					 /* Bucle principal del efecto */
     for(count=0;count<MAX_COPOS;count++)
		{                /* Si y == 200, entonces estamos en*/
		 if(Copo[count].y<200) /* el suelo, y no borramos.  */
			 put_pixel(Copo[count].x,Copo[count].y++, 0,VScreen);

		 if(!random(2))  /* No movemos el copo siempre en 'x' */
			Copo[count].x+=Copo[count].Jock*(-1);

				 /* Si el copo se va de nuestra pantalla, */
		 if(Copo[count].x==319 || Copo[count].x==0)
			{	 /* entonces, creamos otro nuevo. */
			 Copo[count].x=random(320);
			 Copo[count].y=0;
			 Copo[count].Jock=random(2);
			 if(!Copo[count].Jock)
				Copo[count].Jock=(-1);
			}

				/* Esto es para que el copo se 'caiga' si */
				/* est en un borde de algn grfico.     */
		  if(get_pixel(Copo[count].x,Copo[count].y,VScreen)==0)
			put_pixel(Copo[count].x,Copo[count].y,1,VScreen);

		  else if(get_pixel(Copo[count].x+1,Copo[count].y+1,VScreen)==0)
			put_pixel(++Copo[count].x,++Copo[count].y,1,VScreen);

		  else if(get_pixel(Copo[count].x-1,Copo[count].y+1,VScreen)==0)
			put_pixel(--Copo[count].x,++Copo[count].y,1,VScreen);

		  else if(get_pixel(Copo[count].x, Copo[count].y+1, VScreen)==0)
			 put_pixel(Copo[count].x,++Copo[count].y,1,VScreen);


		  else { /* No est en ningn borde, por lo tanto, lo deja-*/
			 /* mos en ese sitio, y nuevo copo. */
			 put_pixel(Copo[count].x,Copo[count].y-1,1,VScreen);
			 Copo[count].x=random(320)+1;
			 Copo[count].y=0;
			 Copo[count].Jock=random(2);
			 if(!Copo[count].Jock)
				Copo[count].Jock=(-1);
			}
		  }

     wait_retrace();			/* Esperamos retrazado de pantalla */
     flip_screens(VScreen, Vga);	/* Volcamos vscreen a la video-ram */
    }while(!kbhit());

 ini_mode(3);			  /* Volvemos al modo texto. */
 printf("GargonScene n3 - Seccin demoscene 'la nieve'\n\n\n");
}


/* Rutinas grficas */

void ini_mode(char mode)
{
 asm xor ah, ah
 asm mov al, mode
 asm int 0x10
}

void flip_screens(char *source, char *where)
{
 asm push ds
 asm push si
 asm lds si, [source]
 asm les di, [where]
 asm mov cx, 32000
 asm cld
 asm rep movsw
 asm pop si
 asm pop ds
}

void gets_palette(char *file, char *where)
{
 FILE *Fp;

 if((Fp=fopen(file,"rb"))==NULL)
		{
		 ini_mode(19);
		 printf("No se encontro el fichero %s!!", file);
		 exit(-1);
		}

 fread(where, 768, 1, Fp);

 fclose(Fp);
}

void gets_raw(char *file, char *where)
{
 FILE *Fp;

 if((Fp=fopen(file,"rb"))==NULL)
		{
		 ini_mode(19);
		 printf("No se encontro el fichero %s!!", file);
		 exit(-1);
		}

 fread(where, 64000U, 1, Fp);

 fclose(Fp);
}

void set_palette(char *palette)
{
 asm push ds
 asm lds si, [palette]
 asm mov cx, 768
 asm xor al, al
 asm mov dx, 3c8h
 asm out dx, al
 asm inc dx
 asm rep outsb
 asm pop ds
}

void set_color(char color, char red, char green, char blue)
{
 asm mov dx, 3c8h
 asm mov al, color
 asm out dx, al

 asm inc dx

 asm mov al, red
 asm out dx, al

 asm mov al, green
 asm out dx, al

 asm mov al, blue
 asm out dx, al
}

void put_pixel(int x, int y, char color, char *where)
{
 where[(y<<8) + (y<<6) + x] = color;
}

char get_pixel(int x, int y, char *where)
{
 return  where[(y<<8) + (y<<6) + x];
}

void wait_retrace()
{
 asm mov dx, 3DAh

wait_one:
 asm in  al,dx
 asm test al, 8
 asm jnz wait_one

wait_two:
 asm in  al,dx
 asm test al, 8
 asm jz  wait_two
}

/* --------------------------- End Of File ------------------------------- */


