#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include "mtypes.h"
#include "mloader.h"


BOOL UNI_Test(void)
{
	char id[4];
	_mm_lseek(modfd,0,SEEK_SET);
	if(_mm_read(modfd,id,4)<4) return 0;
	if(! _mm_memcmp(id,"UN04",4)) return 1;
	return 0;
}


BOOL UNI_Init(void)
{
	return 1;
}


void UNI_Cleanup(void)
{
	;
}


char *StrRead(void)
{
	char *s;
	UWORD len=0;

	_mm_read(modfd,&len,sizeof(UWORD));

	if(!len) return NULL;

	s=_mm_malloc(len+1);
	_mm_read(modfd,s,len);
	s[len]=0;

	return s;
}


UBYTE *TrkRead(void)
{
	UBYTE *t;
	UWORD len;

	_mm_read(modfd,&len,sizeof(UWORD));
	t=_mm_malloc(len);
	_mm_read(modfd,t,len);
	return t;
}



BOOL UNI_Load(void)
{
	int t,u;

	_mm_lseek(modfd,4,SEEK_SET);

	// try to _mm_read module header

	if(_mm_read(modfd,&of,sizeof(UNIHEADER))<sizeof(UNIHEADER)){
		myerr=ERROR_LOADING_HEADER;
		return 0;
	}

	of.songname=StrRead();
	of.modtype=StrRead();
	of.comment=StrRead();   // <- new since UN01

	if(!AllocInstruments()) return 0;

	if(!AllocTracks()) return 0;
	if(!AllocPatterns()) return 0;

	// Read sampleinfos

	for(t=0;t<of.numins;t++){

		INSTRUMENT *i=&of.instruments[t];

		_mm_read(modfd,i,sizeof(UNIINSTRUMENT));
		i->insname=StrRead();

		if(!AllocSamples(i)) return 0;

		for(u=0;u<i->numsmp;u++){

			SAMPLE *s=&i->samples[u];

			_mm_read(modfd,s,sizeof(UNISAMPLE));
			s->samplename=StrRead();
			s->seekpos=0;
		}
	}

	// Read patterns

	_mm_read(modfd,of.pattrows,sizeof(UWORD)*of.numpat);
	_mm_read(modfd,of.patterns,sizeof(UWORD)*of.numpat*of.numchn);

	// Read tracks

	for(t=0;t<of.numtrk;t++){
		of.tracks[t]=TrkRead();
	}

	return 1;
}





LOADER uniload={
	NULL,
	"UNI",
	"UNI loader v0.2",
	UNI_Init,
	UNI_Test,
	UNI_Load,
	UNI_Cleanup
};
