#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include "mtypes.h"
#include "mloader.h"
#include "mdriver.h"
#include "mplayer.h"
#include "vtimer.h"

/*
	Declare external loader & driver:
*/
extern LOADER uniload;
extern DRIVER gusdriver;	// ,sbdriver,nosnddriver;

WORD playertimer;


volatile int didupdate;

void tickhandler(void)
{
	MP_HandleTick();    // play 1 tick of the module
	VT_SetBPM(playertimer,mp_bpm);
	MD_Update();
	didupdate=1;
}


int main(int argc,char *argv[])
{
	UNIMOD *mf;
	int t,quit=0;

	puts(mikbanner);

	/*
		Initialize soundcard parameters.. you _have_ to do this
		before calling MD_Init(), and it's illegal to change them
		after you've called MD_Init()
	*/

	md_mixfreq      =44100;                     // standard mixing freq
	md_dmabufsize   =10000;                     // standard dma buf size
	md_mode         =DMODE_16BITS|DMODE_STEREO; // standard mixing mode
	md_device       =0;                                                     // standard device: autodetect

	/*
		Register the loaders we want to use..
	*/

	ML_RegisterLoader(&uniload);
	MD_RegisterDriver(&gusdriver);

	if(argc<2){

		/*
			there was an error in the commandline, or there were no true
			arguments, so display a usage message
		*/

		puts("Usage: MIKMOD <fletch.uni> ... \n");
		exit(-1);
	}

	//      initialize virtual timer routines

	VT_Init();
	atexit(VT_Exit);
	playertimer=VT_Alloc();
	VT_SetHandler(playertimer,tickhandler);

	//  initialize soundcard

	if(!MD_Init()){
		puts("Driver error:");
		puts(myerr);
		return 0;
	}

/*	printf("Using %s for %d bit %s sound at %u Hz\n\n",
			md_driver->Name,
			(md_mode&DMODE_16BITS) ? 16:8,
			(md_mode&DMODE_STEREO) ? "stereo":"mono",
			md_mixfreq);
*/

	for(t=1; !quit && t<argc; t++){

//		printf("File    : %s\n",argv[t]);

		//      load the module

		mf=ML_LoadFN(argv[t]);

		//      didn't work -> exit with errormsg.

		if(mf==NULL){
			puts("MikMod error:");
			puts(myerr);
			break;
		}

		//      initialize modplayer to play this module

		MP_Init(mf);

/*		printf( "Songname: %s\n"
				"Modtype : %s\n"
				"Periods : %s,%s\n",
				mf->songname,
				mf->modtype,
				(mf->flags&UF_XMPERIODS) ? "XM type" : "mod type",
				(mf->flags&UF_LINEAR) ? "Linear" : "Log");
*/
		/*
			set the number of voices to use.. you
			could add extra channels here (e.g. md_numchn=mf->numchn+4; )
			to use for your own soundeffects:
		*/

		md_numchn=mf->numchn;

		//  start playing the module:

		MD_PlayStart();

		VT_SetBPM(playertimer,125);
		VT_Start(playertimer);

		while(!MP_Ready()){

			char c;

			c=kbhit() ? getch() : 0;

			if(c=='+')
				MP_NextPosition();
			else if(c=='-')
				MP_PrevPosition();
			else if(c==0x1b){
				quit=1;
				break;
			}
			else if(c==' ') break;

			// wait a bit

			while(!didupdate);
			didupdate=0;

//			printf("\rsngpos:%d patpos:%d sngspd %d bpm %d   ",mp_sngpos,mp_patpos,mp_sngspd,mp_bpm);
		}

		VT_Stop(playertimer);
		MD_PlayStop();          // stop playing
		ML_Free(mf);            // and free the module

		puts("\n");
	}

	MD_Exit();

	return 0;
}
