#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include "mtypes.h"
#include "mdriver.h"

DRIVER *firstdriver=NULL,*md_driver;

UWORD md_device         =0;
UWORD md_mixfreq        =44100;
UWORD md_mode           =0;
UWORD md_dmabufsize     =8192;
UBYTE md_numchn         =0;

static int   sl_fd;
static WORD  sl_old;
static UWORD sl_infmt;
static UWORD sl_outfmt;
static WORD  sl_buffer[1024];

GHOLD ghld[32];

static BOOL isplaying=0;


void SL_Init(int fhandle,UWORD infmt,UWORD outfmt)
{
	sl_old=0;
	sl_fd=fhandle;
	sl_infmt=infmt;
	sl_outfmt=outfmt;
}

/*
int SL_GetSample(void)
{
	static WORD s;

	if(sl_infmt & SF_16BITS){
		s=*((WORD *)sl_index);
		sl_index+=2;
	}
	else{
		s=*((BYTE *)sl_index);
		s<<=8;
		sl_index+=1;
	}

	if(sl_infmt & SF_DELTA){
		s+=sl_old;
		sl_old=s;
	}

	if((sl_infmt^sl_outfmt) & SF_SIGNED) s^=0x8000;

	return s;
}
*/


void SL_Load(void *buffer,ULONG length)
{
	BYTE *bptr=buffer;
	WORD *wptr=buffer;
	ULONG stodo;
	int t;

	// compute number of samples to load
	if(sl_outfmt & SF_16BITS) length>>=1;

	while(length){

		stodo=(length<1024) ? length : 1024;

		if(sl_infmt&SF_16BITS){
			_mm_read(sl_fd,sl_buffer,stodo<<1);
		}
		else{
			BYTE *s;
			WORD *d;

			_mm_read(sl_fd,sl_buffer,stodo);

			s=sl_buffer;
			d=sl_buffer;
			s+=stodo;
			d+=stodo;

			for(t=0;t<stodo;t++){
				s--;
				d--;
				*d=(*s)<<8;
			}
		}

		if(sl_infmt & SF_DELTA){
			for(t=0;t<stodo;t++){
				sl_buffer[t]+=sl_old;
				sl_old=sl_buffer[t];
			}
		}

		if((sl_infmt^sl_outfmt) & SF_SIGNED){
			for(t=0;t<stodo;t++){
				sl_buffer[t]^=0x8000;
			}
		}

		if(sl_outfmt & SF_16BITS){
			for(t=0;t<stodo;t++) *(wptr++)=sl_buffer[t];
		}
		else{
			for(t=0;t<stodo;t++) *(bptr++)=sl_buffer[t]>>8;
		}

		length-=stodo;
	}
}


/*
void MD_InfoDriver(void)
{
	int t;
	DRIVER *l;

	for(t=1,l=firstdriver; l!=NULL; l=l->next, t++){
		printf("%d. %s\n",t,l->Version);
	}
}
*/

void MD_RegisterDriver(DRIVER *drv)
{
	if(firstdriver==NULL){
		firstdriver=drv;
		drv->next=NULL;
	}
	else{
		drv->next=firstdriver;
		firstdriver=drv;
	}
}


WORD MD_SampleLoad(int fhandle,ULONG size,ULONG reppos,ULONG repend,UWORD flags)
{
	return(md_driver->SampleLoad(fhandle,size,reppos,repend,flags));
}


void MD_SampleUnLoad(WORD handle)
{
	md_driver->SampleUnLoad(handle);
}


BOOL MD_Init(void)
{
	UWORD t;

	// if md_device==0, try to find a device number

	if(md_device==0){

		for(t=1,md_driver=firstdriver; md_driver!=NULL; md_driver=md_driver->next, t++){
			if(md_driver->IsPresent()) break;
		}

		if(md_driver==NULL){
			myerr="You don't have any of the supported sound-devices";
			return 0;
		}

		md_device=t;
	}

	// if n>0 use that driver

	for(t=1,md_driver=firstdriver; md_driver!=NULL && t!=md_device; md_driver=md_driver->next, t++);

	if(md_driver==NULL){
		myerr="Device number out of range";
		return 0;
	}

	return(md_driver->Init());
}


void MD_Exit(void)
{
	md_driver->Exit();
}


void MD_PlayStart(void)
{
	UWORD t;

	/* safety valve, prevents entering
	   playstart twice: */

	if(isplaying) return;

	for(t=0;t<md_numchn;t++){
		ghld[t].flags=0;
		ghld[t].handle=0;
		ghld[t].kick=0;
		ghld[t].active=0;
		ghld[t].frq=10000;
		ghld[t].vol=0;
		ghld[t].pan=(t&1)?0:255;
		ghld[t].iter=0;
		ghld[t].current=0;
	}
	md_driver->PlayStart();
	isplaying=1;
}


void MD_PlayStop(void)
{
	/* safety valve, prevents calling playStop when playstart
	   hasn't been called: */

	if(isplaying){
		isplaying=0;
		md_driver->PlayStop();
	}
}


void MD_Update(void)
{
	if(isplaying) md_driver->Update();
}


void MD_VoiceSetVolume(UBYTE voice,UBYTE vol)
{
	ghld[voice].vol=vol;
}


void MD_VoiceSetFrequency(UBYTE voice,ULONG frq)
{
	ghld[voice].frq=frq;
}

void MD_VoiceSetPanning(UBYTE voice,ULONG pan)
{
	ghld[voice].pan=pan;
}

void MD_VoicePlay(UBYTE voice,WORD handle,ULONG start,ULONG size,ULONG reppos,ULONG repend,UWORD flags)
{
	if(start>=size) return;

	if(flags&SF_LOOP){
		if(repend>size) repend=size;    // repend can't be bigger than size
	}

	ghld[voice].flags=flags;
	ghld[voice].handle=handle;
	ghld[voice].start=start;
	ghld[voice].size=size;
	ghld[voice].reppos=reppos;
	ghld[voice].repend=repend;
	ghld[voice].kick=1;
}

