/*      MOD.H
 *
 * ProTracker Module Player, v1.36
 *
 * Copyright 1996 Petteri Kangaslampi and Jarno Paananen
 *
 * This file is part of the MIDAS Sound System, and may only be
 * used, modified and distributed under the terms of the MIDAS
 * Sound System license, LICENSE.TXT. By continuing to use,
 * modify or distribute this file you indicate that you have
 * read the license and understand and accept it fully.
*/

#ifndef __MOD_H
#define __MOD_H


/****************************************************************************\
*       struct modInstHdr
*       -----------------
* Description:  Protracker module instrument header. Note that all 16-bit
*               fields are big-endian.
\****************************************************************************/

typedef struct
{
    char        iname[22];              /* instrument name */
    ushort      slength;                /* sample length */
    uchar       finetune;               /* sample finetune value */
    uchar       volume;                 /* sample default volume */
    ushort      loopStart;              /* sample loop start, in words */
    ushort      loopLength;             /* sample loop length, in words */
} modInstHdr;



/****************************************************************************\
*       struct modHeader
*       ----------------
* Description:  Protracker module file header
\****************************************************************************/

typedef struct
{
    char        songName[20];           /* song name */
    modInstHdr  instruments[31];        /* instrument headers */
    uchar       songLength;             /* song length */
    uchar       unused;                 /* unused by Protracker, used to be
                                           song restart position */
    uchar       orders[128];            /* pattern playing orders */
    char        sign[4];                /* module signature */
} modHeader;


/****************************************************************************\
*       struct modChannel
*       -----------------
* Description:  Protracker Module Player internal channel structure
\****************************************************************************/

typedef struct
{
    uchar   note;
    uchar   inst;
    uchar   cmd;
    uchar   info;
    uchar   comp;

    uchar   sample;
    uchar   volume;

    ushort  period;
    ushort  sNote;
    uchar   lOff;
    uchar   cOff;
    ushort  toPeri;
    uchar   notePSp;
    uchar   retrigC;

    uchar   status;

    uchar   vibCmd;
    uchar   vibPos;

    uchar   treCmd;
    uchar   trePos;

    uchar   volBar;

    uchar   loopPos;
    uchar   loopCnt;

    ushort  playOff;
} modChannel;