
// gfxxwin.cpp
//
// Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "gfxxwin.h"
  
XWINDRIVER::XWINDRIVER ()
  {
    Width = Height = 0;
    #if defined (__FORUNIX__)
      MainXDisplay = NULL;
      XWinGC = NULL;
      XWinImage = NULL;
      XWinColormap = NULL;
    #endif
  } // End of Constructor for XWINDRIVER

XWINDRIVER::~XWINDRIVER ()
  {
    #if defined (__FORUNIX__)
      if (XWinGC!=NULL)      
        XFreeGC ( MainXDisplay, XWinGC );
      XWinGC = NULL;

      if (XWinImage!=NULL)
        XDestroyImage ( XWinImage );
      XWinImage = NULL;

      if (XWinColormap!=NULL)
        XFreeColormap ( MainXDisplay, XWinColormap );
    #endif
  } // End of Destructor for XWINDRIVER

BOOLEAN XWINDRIVER::SetUp ( DISPLAYDATA *Data )
  {
    if (Data)
      {}  
    #if defined (__FORWINDOWS__)
      return FAILURE;
    #elif defined (__FOROS2__)
      return FAILURE;
    #elif defined (__FORDOS__)
      return FAILURE;
    #elif defined (__FORUNIX__)
      MainXDisplay = Data->MainXDisplay;
      Window Root;

      MainXScreen = DefaultScreenOfDisplay ( MainXDisplay );
      Root = RootWindowOfScreen ( MainXScreen );
      
      if (XWinGC!=NULL)
        XFreeGC ( MainXDisplay, XWinGC );
      XWinGC = XCreateGC ( MainXDisplay, Root, NULL, NULL );

      Visual *XWinVisual;
      XWinVisual = DefaultVisual ( MainXDisplay, DefaultScreen(MainXDisplay) );
      INT Format,Offset,BitmapPad,BytesPerLine;
      UINT Width,Height,Depth;

      Format = ZPixmap;
      Offset = 0;
      BitmapPad = 8;
      BytesPerLine = 0;
      Depth = 8;
      
      /*if (XWinImage!=NULL)
        XDestroyImage ( XWinImage );
      XWinImage = XCreateImage ( MainXDisplay, XWinVisual, Depth, Format,
                                 Offset, NULL, Width, Height, BitmapPad,
                                 BytesPerLine );
      XWinImage->byte_order = LSBFirst;*/
      return SUCCESS;
    #endif
  } // End of SetUp for XWINDRIVER

VOID XWINDRIVER::Reset ()
  {
    SetUp ( M80x25x16 );
  } // End of SetUp for XWINDRIVER

VOID XWINDRIVER::Clear ( HDISPLAY hDisplay, LONG Color )
  {
    if (hDisplay)
      {}
    if (Color)
      {}

    #if defined (__FORUNIX__)
      XClearArea ( MainXDisplay, hDisplay, 0, 0, 0, 0, FALSE );
    #endif
  } // End of Clear for XWINDRIVER

LONG XWINDRIVER::GetWidth ( HDISPLAY hDisplay )
  {
    if (hDisplay)
      {}
    return 3000;
  } // End of GetWidth for XWINDRIVER

LONG XWINDRIVER::GetHeight ( HDISPLAY hDisplay )
  {
    if (hDisplay)
      {}
    return 2000;
  } // End of GetHeight for XWINDRIVER

VOID XWINDRIVER::DisplayImage ( IMAGE *Image, LONG Sx, LONG Sy,
                                LONG Wd, LONG Ht, HDISPLAY Dest,
                                LONG Cx, LONG Cy, LONG DestWd, LONG DestHt )
  {
    if (Image)
      {}
    if (Sx&Sy&Wd&Ht&Cx&Cy&DestWd&DestHt)
      {}
    if (Dest)
      {}  
    #if defined (__FORUNIX__)
      Visual *XWinVisual;
      XWinVisual = DefaultVisual ( MainXDisplay, DefaultScreen(MainXDisplay) );

      XWinImage = XCreateImage ( MainXDisplay, XWinVisual, 8, ZPixmap,
                                 0, Image->GetBuffer(), Image->GetWidth(),
                                 Image->GetHeight(), 8, 0 );

      INT Depth;

      Depth = DefaultDepth ( MainXDisplay, DefaultScreen ( MainXDisplay ) );

      if (Depth>=8)
        {
          /*XWinImage->data = (char*)(Image->GetBuffer());
          XWinImage->width = Image->GetWidth();
          XWinImage->height = Image->GetHeight();
          XWinImage->xoffset = 0;
          XWinImage->bitmap_unit = 8;
          XWinImage->bits_per_pixel = 8;
          XWinImage->bytes_per_line = 0;      
*/
          XPutImage ( MainXDisplay, Dest, XWinGC, XWinImage, 
                      Sx, Sy, Cx, Cy, 
                      DestWd, DestHt );
        } // End if
      else
        {
          INT i,j;
          BYTE *Buffer;
          for (i=Sy;i<Sy+DestHt;i++)
            {
              Buffer = Image->SetOffset ( 0, i );
              for (j=Sx;j<Sx+DestWd;j++)
                {
                  DrawPixel ( Dest, Cx+j-Sx, Cy+i-Sy, Buffer[j] ); 
                } // End for
            } // End for
        } // End else 

      XFree ( XWinImage );
      XWinImage = NULL;
    #endif
  } // End of DisplayImage for XWINDRIVER

#if defined (__FORUNIX__)
  Visual* GetProperVisual ( Display *MainXDisplay, INT ScreenID, INT Depth, INT Class )
    {
      XVisualInfo *VisualList, TemplateVisual;
      INT NumVisuals;

      TemplateVisual.screen = ScreenID;
      
      VisualList = XGetVisualInfo ( MainXDisplay, VisualScreenMask,
                                    &TemplateVisual, &NumVisuals );
      if (NumVisuals==0)
        return NULL;

      INT i;

      for (i=0;i<NumVisuals;i++)
        {
          if ((VisualList[i].c_class==Class)&&(VisualList[i].depth>=Depth))
            {
              return VisualList[i].visual;
            } // End if
        } // End for 

      return NULL;
    } // End of GetProperVisual
#endif 

VOID XWINDRIVER::SetPalette ( HDISPLAY hDisplay, RGBPALETTE *Pal )
  {
    RGBCOLOR *Entry;

    if (hDisplay)
      {}
      
    if (Pal==NULL)
      return;

    Entry = Pal->GetEntry ();
    if (Entry==NULL)
      return;

    #if defined (__FORUNIX__)
      XColor XWinColors[256];
      INT i;
      for (i=0;i<256;i++)
        {
          XWinColors[i].red = Entry[i].Red*256;
          XWinColors[i].green = Entry[i].Green*256;
          XWinColors[i].blue = Entry[i].Blue*256;
          XWinColors[i].pixel = i;
          XWinColors[i].flags = DoRed | DoGreen | DoBlue;
        } // End for

      Visual *LocalVisual;

      LocalVisual = DefaultVisual ( MainXDisplay, DefaultScreen(MainXDisplay) );
      if (DefaultDepth ( MainXDisplay, DefaultScreen(MainXDisplay))<8)
        LocalVisual = GetProperVisual ( MainXDisplay, DefaultScreen(MainXDisplay),
                                        8,  PseudoColor );
  
      if (LocalVisual==NULL)
        return;

      if (XWinColormap==NULL)
        XWinColormap = XCreateColormap ( MainXDisplay, 
                          RootWindow(MainXDisplay,DefaultScreen(MainXDisplay)),
                          LocalVisual, AllocAll );

      XStoreColors ( MainXDisplay, XWinColormap, XWinColors, 256 );
      XSetWindowColormap ( MainXDisplay, hDisplay, XWinColormap );
    #endif
  } // End of SetPalette for XWINDRIVER

VOID XWINDRIVER::GetPalette ( HDISPLAY hDisplay, RGBPALETTE *Pal )
  {
    RGBCOLOR *Entry;

    if (hDisplay)
      {}
    if (Pal==NULL)
      return;

    Entry = Pal->GetEntry ();
    if (Entry==NULL)
      return;
  } // End of GetPalette for XWINDRIVER

VOID XWINDRIVER::DrawLine ( HDISPLAY hDisplay, LONG x1, LONG y1, LONG x2, LONG y2,
                            COLOR  Color )
  {
    if (hDisplay)
      {}
    if (x1&y1&x2&y2)
      {}
    if (Color)
      {}
    #if defined (__FORUNIX__)      
      XSetForeground ( MainXDisplay, XWinGC, Color );
      XDrawLine ( MainXDisplay, hDisplay, XWinGC, x1, y1, x2, y2 );
    #endif
  } // End of DrawLine for XWINDRIVER

VOID XWINDRIVER::DrawRect ( HDISPLAY hDisplay, LONG x1, LONG y1, LONG x2, LONG y2,
                           COLOR Color )
  {
    DrawLine ( hDisplay, x1, y2, x2, y2, Color );
    DrawLine ( hDisplay, x1, y1, x2, y1, Color );
    DrawLine ( hDisplay, x1, y1, x1, y2, Color );
    DrawLine ( hDisplay, x2, y1, x2, y2, Color );
  } // End of DrawRect for XWINDRIVER

VOID XWINDRIVER::FillRect ( HDISPLAY hDisplay, LONG x1, LONG y1, LONG x2, LONG y2,
                           COLOR Color )
  {
    if (hDisplay)
      {}
    if (x1&y1&x2&y2)
      {}
    if (Color)
      {}      
    #if defined (__FORUNIX__)      
      XSetForeground ( MainXDisplay, XWinGC, Color );
      XFillRectangle ( MainXDisplay, hDisplay, XWinGC, x1, y1, x2-x1+1, 
                       y2-y1+1 );
    #endif
  } // End of FillRect for XWINDRIVER

VOID XWINDRIVER::DrawPixel ( HDISPLAY hDisplay, LONG x, LONG y,
                            COLOR Color )
  {
    if (hDisplay)
      {}
    if (x&y)
      {}
    if (Color)
      {}      
    #if defined (__FORUNIX__)      
      XSetForeground ( MainXDisplay, XWinGC, Color );
      
      XDrawPoint ( MainXDisplay, hDisplay, XWinGC, x, y );
    #endif
  } // End of DrawPixel for XWINDRIVER

VOID XWINDRIVER::DrawEllipse ( HDISPLAY hDisplay, LONG Cx, LONG Cy, LONG Rx, LONG Ry,
                              COLOR Color )
  {
    if (hDisplay)
      {}
    if (Cx&Cy&Rx&Ry)
      {}
    if (Color)
      {}      
    #if defined (__FORUNIX__)      
      XSetForeground ( MainXDisplay, XWinGC, Color );      
      XDrawArc ( MainXDisplay, hDisplay, XWinGC, Cx-Rx, Cy-Ry, Rx*2, Ry*2,
                 0, 360*64 );
    #endif
  } // End of DrawEllipse for XWINDRIVER

VOID XWINDRIVER::FillEllipse ( HDISPLAY hDisplay, LONG Cx, LONG Cy,
                              LONG Rx, LONG Ry, COLOR Color )
  {
    if (hDisplay)
      {}
    if (Cx&Cy&Rx&Ry)
      {}
    if (Color)
      {}      
    #if defined (__FORUNIX__)      
      XSetForeground ( MainXDisplay, XWinGC, Color );      
      XDrawArc ( MainXDisplay, hDisplay, XWinGC, Cx-Rx, Cy-Ry, Rx*2, Ry*2,
                 0, 360*64 );
    #endif
  } // End of FillEllipse for XWINDRIVER

