{ // WATER EFFECTS // }

{$X+,N-,S-,R-}

UNIT WATER;

Interface

Uses Global, PasDVT;

  procedure Finish;

  procedure Calm;
  procedure BigSplash;
  procedure SmallSplash;
  procedure pIguana;
  procedure pGreets;
  procedure pGreets2;

  procedure pDust;
  procedure pDustDown;
  procedure pFC;
  procedure pSurprise;
  procedure pLegend;
  procedure pMajic;
  procedure pInfiny;
  procedure pRena;
  procedure pPostumum;
  procedure pReset;

  procedure pMental;
  procedure pTriton;
  procedure pCodex;
  procedure pUnexpected;
  procedure pCapaCala;
  procedure pVLA;
  procedure pPrime;
  procedure pPsychicMonks;
  procedure pSKP;
  procedure pXography;
  procedure pEMF;
  procedure pFive;
  procedure pExtreme;
  procedure pAvalanch;
  procedure pGollum;
  procedure pOthers;

  procedure pShark;

  procedure pWanderer1;
  procedure pWanderer2;

type
  RWSchedule = record
     when : longint;
     dens : byte;
     what : procedure;
  end;

const

  Base = 398;
  Rate = 192;  {  pattern @ 125 bpm = (64/2)/(4*125/60)*50 = 192 * 1/50sec }

  NWScript = 42;
  WScript : array[0..NWScript-1] of RWSchedule = (
      ( when:              0; dens: 4; what:Calm         ),
      ( when: Base + 00*Rate; dens: 4; what:pIguana      ),
      ( when: Base + 02*Rate; dens: 4; what:pShark       ),
      ( when: Base + 06*Rate; dens: 4; what:pGreets      ),
      ( when: Base + 07*Rate; dens: 4; what:pGreets2     ),
      ( when: Base + 08*Rate; dens: 4; what:pDust        ),
      ( when:  2040         ; dens: 4; what:pDustDown    ),
      ( when:  2250         ; dens: 4; what:SmallSplash  ),
      ( when: Base + 10*Rate; dens: 4; what:pFC          ),
      ( when: Base + 11*Rate; dens: 4; what:pWanderer1   ),
      ( when: Base + 12*Rate; dens: 3; what:pSurprise    ),
      ( when: Base + 13*Rate; dens: 3; what:pLegend      ),
      ( when: Base + 14*Rate; dens: 4; what:pMajic       ),
      ( when: Base + 15*Rate; dens: 4; what:pInfiny      ),
      ( when: Base + 16*Rate; dens: 3; what:pRena        ),
      ( when: Base + 17*Rate; dens: 4; what:pPostumum    ),
      ( when: Base + 18*Rate; dens: 4; what:pReset       ),
      ( when: Base + 19*Rate; dens: 3; what:pMental      ),
      ( when: Base + 20*Rate; dens: 4; what:pTriton      ),
      ( when: Base + 21*Rate; dens: 4; what:pCodex       ),
      ( when: Base + 22*Rate; dens: 3; what:pUnexpected  ),
      ( when: Base + 23*Rate; dens: 4; what:pCapaCala    ),
      ( when: Base + 24*Rate; dens: 4; what:pVLA         ),
      ( when: Base + 25*Rate; dens: 3; what:pPrime       ),
      ( when: Base + 26*Rate; dens: 4; what:pPsychicMonks),
      ( when: Base + 27*Rate; dens: 4; what:pSKP         ),
      ( when: Base + 28*Rate; dens: 3; what:pXography    ),
      ( when: Base + 29*Rate; dens: 4; what:pEMF         ),
      ( when: Base + 30*Rate; dens: 4; what:pFive        ),
      ( when: Base + 31*Rate; dens: 3; what:pExtreme     ),
      ( when: Base + 32*Rate; dens: 4; what:pAvalanch    ),
      ( when: Base + 33*Rate; dens: 4; what:pGollum      ),
      ( when: Base + 34*Rate; dens: 3; what:pOthers      ),

      ( when: Base + 36*Rate; dens: 4; what:pWanderer1   ),
      ( when: Base + 38*Rate; dens: 4; what:BigSplash    ),
      ( when: Base + 40*Rate; dens: 4; what:pWanderer2   ),
      ( when: Base + 50*Rate; dens: 4; what:BigSplash    ),
      ( when: Base + 52*Rate; dens: 4; what:pWanderer2   ),
      ( when: Base + 58*Rate; dens: 4; what:BigSplash    ),
      ( when: Base + 60*Rate; dens: 4; what:pWanderer2   ),
      ( when: Base + 66*Rate; dens: 4; what:SmallSplash  ),
      ( when: Base + 68*Rate - 60; dens: 4; what:Finish       )
  );



Implementation

procedure Finish;
begin
  Leaving := True;
  VT_SetVolume(0);
end;


procedure SquareSplash( X,Y,S,D : integer ); external;
procedure BitLift( P : Pointer; L : integer ); external;
procedure IntLift( X, Y, L : integer; P : Pointer ); external;
{$L asmfx.obj}


procedure Calm;      { calm waters }
begin
  SquareSplash( random(NX-6)+3, random(NY-6)+3, random(10)+1, random(16)+4 );
end;

procedure BigSplash;  { high splashes }
begin
  SquareSplash( random(NX-6)+3, random(NY-6)+3, random(10)+1, random(64)+64 );
end;

procedure SmallSplash;  { low splashes }
begin
  SquareSplash( random(NX-6)+3, random(NY-6)+3, random(10)+1, random(32)+16 );
end;

{ ================================================================== }

procedure _Iguana; external; {$L iguana.ooo}
procedure pIguana;
begin
  BitLift( @_Iguana, 192 );
end;

procedure _Greets; external; {$L greets.ooo}
procedure pGreets;
begin
  BitLift( @_Greets, 128 );
end;
procedure pGreets2;
begin
  BitLift( @_Greets, -80 );
end;

procedure _Dust; external; {$L dust.ooo}
procedure pDust;
begin
  BitLift( @_Dust, 128 );
end;
procedure pDustDown;
begin
  BitLift( @_Dust, 128 - longint(384*(VT_Timer-2040)) div (2250-2040) );
end;

procedure _FC; external; {$L fc.ooo}
procedure pFC;
begin
  BitLift( @_FC, 128 );
end;

procedure _Surprise; external; {$L surprise.ooo}
procedure pSurprise;
begin
  Calm;
  BitLift( @_Surprise, 256 );
end;

procedure _Legend; external; {$L legend.ooo}
procedure pLegend;
begin
  Calm;
  BitLift( @_Legend, 256 );
end;

procedure _Majic; external; {$L majic.ooo}
procedure pMajic;
begin
  Calm;
  BitLift( @_Majic, 192 );
end;

procedure _Infiny; external; {$L infiny.ooo}
procedure pInfiny;
begin
  Calm;
  BitLift( @_Infiny, 192 );
end;

procedure _Rena; external; {$L rena.ooo}
procedure pRena;
begin
  Calm;
  BitLift( @_Rena, 256 );
end;

procedure _Postumum; external; {$L postumum.ooo}
procedure pPostumum;
begin
  Calm;
  BitLift( @_Postumum, 128 );
end;

procedure _Reset; external; {$L reset.ooo}
procedure pReset;
begin
  Calm;
  BitLift( @_Reset, 192 );
end;

procedure _Mental; external; {$L mental.ooo}
procedure pMental;
begin
  Calm;
  BitLift( @_Mental, 256 );
end;

procedure _Triton; external; {$L triton.ooo}
procedure pTriton;
begin
  pWanderer1;
  BitLift( @_Triton, 128 );
end;

procedure _Codex; external; {$L codex.ooo}
procedure pCodex;
begin
  pWanderer1;
  BitLift( @_Codex, 192 );
end;

procedure _Unexpect; external; {$L unexpect.ooo}
procedure pUnexpected;
begin
  pWanderer1;
  BitLift( @_Unexpect, 256 );
end;

procedure _CapaCala; external; {$L capacala.ooo}
procedure pCapaCala;
begin
  pWanderer1;
  BitLift( @_CapaCala, 192 );
end;

procedure _VLA; external; {$L vla.ooo}
procedure pVLA;
begin
  pWanderer1;
  BitLift( @_VLA, 192 );
end;

procedure _prime; external; {$L prime.ooo}
procedure pPrime;
begin
  pWanderer1;
  BitLift( @_prime, 256 );
end;

procedure _psymonk; external; {$L psymonk.ooo}
procedure pPsychicMonks;
begin
  Calm;
  BitLift( @_psymonk, 128 );
end;

procedure _skp; external; {$L skp.ooo}
procedure pSKP;
begin
  Calm;
  BitLift( @_skp, 192 );
end;

procedure _xography; external; {$L xography.ooo}
procedure pXography;
begin
  Calm;
  BitLift( @_xography, 256 );
end;

procedure _emf; external; {$L emf.ooo}
procedure pEMF;
begin
  Calm;
  BitLift( @_emf, 128 );
end;

procedure _five; external; {$L five.ooo}
procedure pFive;
begin
  Calm;
  BitLift( @_five, 192 );
end;

procedure _extreme; external; {$L extreme.ooo}
procedure pExtreme;
begin
  Calm;
  BitLift( @_extreme, 256 );
end;

procedure _avalanch; external; {$L avalanch.ooo}
procedure pAvalanch;
begin
  Calm;
  BitLift( @_avalanch, 128 );
end;

procedure _gollum; external; {$L gollum.ooo}
procedure pGollum;
begin
  Calm;
  BitLift( @_gollum, 192 );
end;

procedure _others; external; {$L others.ooo}
procedure pOthers;
begin
  BitLift( @_others, 256 );
end;

{ don't you sometimes wish TP had macros? O:-) }



{ ---------------------------------------------------- }

procedure pShark;
var t : real;
begin
  t := (VT_Timer-790)/(1560-790)*Pi;
  SquareSplash( 80 + round( 60*sin(6*t) ), 42 + round( 32*cos(t) ), 3, -128);
end;

const
  X2 : integer = 0;
  X3 : integer = 0;
procedure pWanderer1;
var r : real;
begin
  r := X2/20;
  SquareSplash( 80+round(60*sin(r)), 42+round(30*cos(r)), 3, 128 );
  inc( X2 );
end;

procedure pWanderer2;
var r,r1 : real;
begin
  r := X2/20;
  SquareSplash( 80+round(60*sin(r)), 42+round(30*cos(r)), 3, 128 );
  inc( X2 );
{
  r := -X3/35;
  r1:= -X3/8;
  SquareSplash( 80 + round(40*sin(r1)+15*cos(r)),
                42 + round(20*cos(r1)+5*sin(r)),
                3, -128 );
}
  r := -X3/20;
  r1:= -X3/120;
  SquareSplash( 80 + round( 60*sin(r) ), 42 + round( 32*cos(r1) ), 3, -128);
  inc( X3 );
end;



END.

