//--------------------------------------------------------------//
// TV
//--------------------------------------------------------------//
struct VS_OUTPUT
{
  float4 Pos: POSITION;
  float2 pos: TEXCOORD0;
};

VS_OUTPUT VS_OldTV(float4 Pos: POSITION)
{
  VS_OUTPUT Out;
  
  // Clean up inaccuracies
  Pos.xy    = sign(Pos.xy);
  Out.Pos   = float4(Pos.xy, 0, 1);
  Out.pos   = Pos.xy;

  return Out;
}


sampler Image = sampler_state
{
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
};

sampler Noise = sampler_state
{
   ADDRESSU = WRAP;
   ADDRESSV = WRAP;
   ADDRESSW = WRAP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};

sampler Rand = sampler_state
{
   ADDRESSU = WRAP;
   ADDRESSV = WRAP;
   ADDRESSW = WRAP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};

float V_Time;
float V_SinTime;
float V_Alpha;
float V_Var1; // interference    = 0.39;
float distortionFreq  = 8.70;
float distortionRoll  = 0.6;
float frameLimit      = 0.38;
float frameShape      = 0.34;
float frameSharpness  = 5.40;

float4 PS_OldTV(float2 pos: TEXCOORD0) : COLOR
{
   // Define a frame shape
   pos*=2;
   pos-=1;
   float f = (1 - pos.x * pos.x) * (1 - pos.y * pos.y);
   float frame = saturate(frameSharpness * (pow(f, frameShape) - frameLimit));
   float alpha = 1.5-frame;
   
   // Interference ... just a texture filled with rand()
   float2 pos2 = float2(1.6 * pos.x - V_Time*15, 1.2*pos.y - V_Time*50);
   float  rand = tex2D(Rand, pos2) - 0.2;
   alpha-=rand;
   
   // Some signed noise for the distortion effect
   float4 noisy = tex3D(Noise, float3(0, 0.5 * pos.y, 0.1 * V_Time * 3)) - 0.5;

   // Repeat a 1 - x^2 (0 < x < 1) curve and roll it with sinus.
   float dst = frac(pos.y * distortionFreq + distortionRoll * V_SinTime * 15);
   dst *= (1 - dst);
   dst /= 1 + abs(pos.y);

   // ... and finally distort
   float2 img;
   img.x = 0.5 * (1 + pos.x) + noisy.x * dst * V_Var1 * 2.5;
   img.y = 0.5 * (1 - pos.y);
   float4 image = tex2D(Image, img);
   alpha+=image.a;

   // Combine frame, distorted image and interference
   float4 c = frame * (V_Var1 * rand + image);
   c.a = alpha * V_Alpha;
   return c;
}


technique OldTV
{
  pass TV
  {
    CULLMODE = NONE;
    VertexShader = compile vs_1_1 VS_OldTV();
    PixelShader = compile ps_2_0 PS_OldTV();
  }
}

