struct VS_OUTPUT
{
   float4 Pos: POSITION;
   float2 Tex: TEXCOORD0;
   float2 texCoord: TEXCOORD1;
};

VS_OUTPUT Procedural_Graphic_Effects_2D_Dizzy_Single_Pass_Vertex_Shader_main(float4 Pos: POSITION, float2 Tex: TEXCOORD0)
{
  VS_OUTPUT Out;

  // Clean up inaccuracies
  Pos.xy = sign(Pos.xy);

  Out.Pos = float4(Pos.xy, 0, 1);
  Out.Tex.x = Pos.x - 320;
  Out.Tex.y = Pos.y - 240;
  Out.texCoord = Tex;

  return Out;
}

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Time;
float V_Alpha;

// Basic idea:
// Rings = sin(radius)
// Spiral = slow offset according to angle, so sin(angle + radius)
// Add time for animation

float4 Procedural_Graphic_Effects_2D_Dizzy_Single_Pass_Pixel_Shader_main(float2 texCoord: TEXCOORD0, float2 Tex: TEXCOORD1) : COLOR
{
  //float ang = atan2(texCoord.x, texCoord.y);
  //float rad = pow(dot(texCoord, texCoord), 0.2);
  float ang = atan2(Tex.x-0.5, Tex.y-0.5);
  float rad = pow(dot(Tex-0.5, Tex-0.5), 0.2);  

  float4 color = tex2D(Sampler, texCoord.xy-0.0025)*1.5;
  color *= (1 + sin(ang + 30.0 * rad + 5 * V_Time));
  color.a = V_Alpha;
  return color;
}


//--------------------------------------------------------------//
// Technique Section for Procedural Graphic Effects 2D
//--------------------------------------------------------------//
technique Dizzy
{
   pass Single_Pass
   {
      CullMode     = NONE;
  		AlphaBlendEnable = true;
	  	SrcBlend     = srcalpha;
		  DestBlend    = invsrcalpha;
		  
      VertexShader = compile vs_1_1 Procedural_Graphic_Effects_2D_Dizzy_Single_Pass_Vertex_Shader_main();
      PixelShader  = compile ps_2_0 Procedural_Graphic_Effects_2D_Dizzy_Single_Pass_Pixel_Shader_main();
   }
}
