/*
 * Decompiled with CFR 0.152.
 */
package codigo.Comportamientos;

import codigo.Engine3D.Fuente2D;
import codigo.Engine3D.Objeto3D;
import codigo.Engine3D.Texto2D;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class MostrarFps
extends Behavior {
    private double tiempoAnterior;
    private double tiempoActual;
    private Texto2D miTexto;
    private Objeto3D miObjeto;
    private BranchGroup miPadre;
    private double contaFrames;
    private boolean mostrarFps;

    public MostrarFps(BranchGroup padre) {
        this.miPadre = padre;
        Fuente2D miFuente = new Fuente2D("Arial", 20, Fuente2D.NORMAL, new Color3f(1.0f, 1.0f, 1.0f));
        this.miTexto = new Texto2D("FPS: 0", miFuente);
        this.miObjeto = new Objeto3D((Node)this.miTexto, new Vector3f(0.0f, 7.4f, 0.0f), null);
        this.miObjeto.setEscalado(3.0);
        padre.addChild((Node)this.miObjeto);
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 10000.0));
        padre.addChild((Node)this);
        this.mostrarFps = true;
    }

    public void initialize() {
        this.contaFrames = 0.0;
        this.tiempoAnterior = System.currentTimeMillis();
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
    }

    public void processStimulus(Enumeration criterio) {
        this.tiempoActual = System.currentTimeMillis();
        this.contaFrames += 1.0;
        if (this.tiempoActual >= this.tiempoAnterior + 1000.0 || this.tiempoActual < this.tiempoAnterior) {
            this.tiempoAnterior += 1000.0;
            if (this.mostrarFps) {
                this.miTexto.setTexto("FPS: " + (int)this.contaFrames);
            } else {
                this.miTexto = null;
            }
            this.contaFrames = 0.0;
        }
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
    }

    public void setMostrarFps(boolean valor) {
        if (!this.mostrarFps && valor) {
            Fuente2D miFuente = new Fuente2D("Arial", 20, Fuente2D.NORMAL, new Color3f(1.0f, 1.0f, 1.0f));
            this.miTexto = new Texto2D("FPS: 0.0", miFuente);
            this.miObjeto = new Objeto3D((Node)this.miTexto, new Vector3f(0.0f, 7.4f, 0.0f), null);
            this.miObjeto.setEscalado(3.0);
            this.miPadre.addChild((Node)this.miObjeto);
        }
        if (this.mostrarFps && !valor) {
            this.miObjeto.BorrarObjeto();
        }
        this.mostrarFps = valor;
    }

    public boolean getMostrarFps() {
        return this.mostrarFps;
    }
}

