/*
 * Decompiled with CFR 0.152.
 */
package codigo.Comportamientos;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Vector3f;

public class MiPropioTraslationInterpolator
extends Behavior {
    private double tiempoDuracion;
    private double tiempoInicio;
    private double tiempoParcial;
    private double tiempoInicial;
    private Vector3f posicionInicial;
    private Vector3f posicionFinal;
    private TransformGroup objetivo;

    public MiPropioTraslationInterpolator(TransformGroup obj, Vector3f posIni, Vector3f posFin, double inicio, double duracion) {
        this.objetivo = obj;
        this.tiempoInicio = inicio;
        this.tiempoDuracion = duracion;
        this.posicionInicial = posIni;
        this.posicionFinal = posFin;
    }

    public void initialize() {
        this.tiempoInicial = System.currentTimeMillis();
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
    }

    public void processStimulus(Enumeration criteria) {
        this.tiempoParcial = (double)System.currentTimeMillis() - this.tiempoInicial;
        Transform3D transformacion = new Transform3D();
        if (this.tiempoParcial >= this.tiempoInicio) {
            double mult = 1.0 - (this.tiempoDuracion + this.tiempoInicio - this.tiempoParcial) / this.tiempoDuracion;
            Vector3f posicion = new Vector3f();
            posicion.x = this.posicionInicial.x + (this.posicionFinal.x - this.posicionInicial.x) * (float)mult;
            posicion.y = this.posicionInicial.y + (this.posicionFinal.y - this.posicionInicial.y) * (float)mult;
            posicion.z = this.posicionInicial.z + (this.posicionFinal.z - this.posicionInicial.z) * (float)mult;
            transformacion.set(posicion);
            this.objetivo.setTransform(transformacion);
        }
        if (this.tiempoParcial >= this.tiempoDuracion + this.tiempoInicio | this.tiempoDuracion + this.tiempoInicio < 0.0) {
            transformacion.set(this.posicionFinal);
            this.objetivo.setTransform(transformacion);
            this.setEnable(false);
        }
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
    }
}

