/*
 * Decompiled with CFR 0.152.
 */
package codigo.Comportamientos;

import codigo.Comportamientos.EnviaMensaje;
import codigo.Escena;
import codigo.Mensaje;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public class ControlTiempo
extends Behavior {
    private Shape3D barraTiempo;
    private double tiempoTotal;
    private double tiempoParcial;
    private double tiempoInicial;

    public ControlTiempo() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.setEnable(false);
        this.barraTiempo = new Shape3D();
        this.barraTiempo.setCapability(12);
        this.barraTiempo.setCapability(13);
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(4));
    }

    public void processStimulus(Enumeration criterio) {
        this.tiempoParcial = (double)System.currentTimeMillis() - this.tiempoInicial;
        if (this.tiempoParcial < this.tiempoTotal) {
            float valor = (float)((this.tiempoTotal - this.tiempoParcial) / this.tiempoTotal);
            QuadArray geometria = new QuadArray(4, 5);
            geometria.setCoordinate(0, new Point3f(0.0f, 0.0f, 0.0f));
            geometria.setColor(0, new Color3f(1.0f, 0.0f, 0.0f));
            geometria.setCoordinate(1, new Point3f(valor * 2.0f, 0.0f, 0.0f));
            geometria.setColor(1, new Color3f(1.0f - valor, valor, 0.0f));
            geometria.setCoordinate(2, new Point3f(valor * 2.0f, 0.5f, 0.0f));
            geometria.setColor(2, new Color3f(1.0f - valor, valor, 0.0f));
            geometria.setCoordinate(3, new Point3f(0.0f, 0.5f, 0.0f));
            geometria.setColor(3, new Color3f(1.0f, 0.0f, 0.0f));
            this.barraTiempo.setGeometry((Geometry)geometria);
        } else {
            BranchGroup mensajero = new BranchGroup();
            mensajero.addChild((Node)new EnviaMensaje(new Mensaje(Mensaje.GAME_OVER)));
            Escena.miSubescena.addChild((Node)mensajero);
            this.setEnable(false);
        }
        this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(4));
    }

    public void setTiempo(double milisegundos) {
        this.tiempoTotal = milisegundos;
        this.tiempoParcial = 0.0;
        this.tiempoInicial = System.currentTimeMillis();
        this.setEnable(true);
    }

    public Shape3D getBarraTiempo() {
        return this.barraTiempo;
    }

    public void paraYa() {
        this.setEnable(false);
    }

    public double getTiempoRestante() {
        return this.tiempoTotal - this.tiempoParcial;
    }
}

