/*
 * Decompiled with CFR 0.152.
 */
package codigo;

import codigo.Comportamientos.ControlMenu;
import codigo.Comportamientos.ControlTiempo;
import codigo.Comportamientos.EnviaMensaje;
import codigo.Comportamientos.SeleccionFichas;
import codigo.Engine3D.Fuente2D;
import codigo.Engine3D.Objeto3D;
import codigo.Engine3D.Texto2D;
import codigo.Escena;
import codigo.ManejoFicheros.ManejoFicheros;
import codigo.Mensaje;
import codigo.Menu;
import codigo.Opciones;
import java.awt.Point;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;

public class Nivel {
    public static int puntuacion = 0;
    public static int piezasEnPantalla;
    private static long tiempoNivel;
    private static int puntosNivel;
    private static int numeroNivel;
    Objeto3D[][][] arrayFichas;
    int[][][] arrayValores;
    int[][][] arrayForma;
    Point3i tamanoArray = new Point3i();
    private static BranchGroup resultado;
    private static BranchGroup parteJuego;
    private static BranchGroup parteMenu;
    private BranchGroup conjuntoFichas;
    private BranchGroup mundoFichas;
    Objeto3D objetoJuego;
    private static Objeto3D[] elementoMenu;
    private static ControlTiempo controlTiempo;
    private static Texto2D textoPuntos;
    private static Texto2D textoNivel;
    private static Objeto3D textoNivelSuperado;
    boolean yaHemosSel;
    Point3i piezaSelAnt;
    Objeto3D seleccion;
    Objeto3D seleccion2;
    private File fichero;
    private FileReader lectorFichero;
    public static int FORMA_VACIA;
    public static int FORMA_VISIBLE;
    public static int FORMA_OCULTA;
    public static int FORMA_BLOQUE;

    static {
        FORMA_VACIA = 0;
        FORMA_VISIBLE = 1;
        FORMA_OCULTA = 2;
        FORMA_BLOQUE = 3;
    }

    private long leeNumero(int tamano) {
        char[] digito = new char[1];
        long resultado = 0L;
        int var = 0;
        long multiploDeDiez = 1L;
        var = 0;
        while (var < tamano - 1) {
            multiploDeDiez *= 10L;
            ++var;
        }
        var = 0;
        while (var < tamano) {
            try {
                if (this.lectorFichero.ready()) {
                    this.lectorFichero.read(digito, 0, 1);
                    switch (digito[0]) {
                        case '1': {
                            resultado += 1L * multiploDeDiez;
                            break;
                        }
                        case '2': {
                            resultado += 2L * multiploDeDiez;
                            break;
                        }
                        case '3': {
                            resultado += 3L * multiploDeDiez;
                            break;
                        }
                        case '4': {
                            resultado += 4L * multiploDeDiez;
                            break;
                        }
                        case '5': {
                            resultado += 5L * multiploDeDiez;
                            break;
                        }
                        case '6': {
                            resultado += 6L * multiploDeDiez;
                            break;
                        }
                        case '7': {
                            resultado += 7L * multiploDeDiez;
                            break;
                        }
                        case '8': {
                            resultado += 8L * multiploDeDiez;
                            break;
                        }
                        case '9': {
                            resultado += 9L * multiploDeDiez;
                        }
                    }
                    multiploDeDiez /= 10L;
                }
            }
            catch (IOException e1) {
                System.err.println("Error de lectura en el fichero de nivel");
                System.exit(1);
            }
            ++var;
        }
        return resultado;
    }

    private void saltaLinea() {
        char[] caracter = new char[1];
        try {
            while (caracter[0] != '\n' & this.lectorFichero.ready()) {
                this.lectorFichero.read(caracter, 0, 1);
            }
        }
        catch (IOException e1) {
            System.err.println("Error de lectura en el fichero de nivel");
            System.exit(1);
        }
    }

    private void saltaCaracteres(long num) {
        try {
            this.lectorFichero.skip(num);
        }
        catch (IOException e1) {
            System.err.println("Error de lectura en el fichero de nivel");
            System.exit(1);
        }
    }

    public void cargaFicheroNivel(URL miUrl, String mod, String nivel) {
        this.lectorFichero = null;
        this.fichero = new File(String.valueOf(mod) + nivel);
        try {
            this.lectorFichero = new FileReader(this.fichero.getAbsolutePath());
        }
        catch (IOException e1) {
            System.err.println("Error de lectura en el fichero de nivel");
            System.exit(1);
        }
        this.saltaLinea();
        this.saltaLinea();
        this.saltaLinea();
        tiempoNivel = this.leeNumero(3) * 1000L;
        controlTiempo.setTiempo(tiempoNivel);
        this.saltaLinea();
        this.saltaLinea();
        puntosNivel = (int)this.leeNumero(3);
        this.saltaLinea();
        this.saltaLinea();
        Material material = new Material();
        Color3f ambiental = new Color3f();
        Color3f difusa = new Color3f();
        Color3f especular = new Color3f();
        ambiental.x = (float)this.leeNumero(1) / 10.0f;
        this.saltaCaracteres(1L);
        ambiental.y = (float)this.leeNumero(1) / 10.0f;
        this.saltaCaracteres(1L);
        ambiental.z = (float)this.leeNumero(1) / 10.0f;
        this.saltaLinea();
        material.setAmbientColor(ambiental);
        difusa.x = (float)this.leeNumero(1) / 10.0f;
        this.saltaCaracteres(1L);
        difusa.y = (float)this.leeNumero(1) / 10.0f;
        this.saltaCaracteres(1L);
        difusa.z = (float)this.leeNumero(1) / 10.0f;
        this.saltaLinea();
        material.setDiffuseColor(difusa);
        especular.x = (float)this.leeNumero(1) / 10.0f;
        this.saltaCaracteres(1L);
        especular.y = (float)this.leeNumero(1) / 10.0f;
        this.saltaCaracteres(1L);
        especular.z = (float)this.leeNumero(1) / 10.0f;
        this.saltaLinea();
        material.setSpecularColor(especular);
        int var = 0;
        while (var < 8) {
            Escena.misModelos[var].setMaterial(material);
            ++var;
        }
        this.saltaLinea();
        this.tamanoArray.x = (int)this.leeNumero(1);
        this.saltaCaracteres(1L);
        this.tamanoArray.y = (int)this.leeNumero(1);
        this.saltaCaracteres(1L);
        this.tamanoArray.z = (int)this.leeNumero(1);
        this.saltaLinea();
        this.saltaLinea();
        this.arrayForma = new int[this.tamanoArray.x][this.tamanoArray.y][this.tamanoArray.z];
        int zz = 0;
        while (zz < this.tamanoArray.z) {
            int yy = 0;
            while (yy < this.tamanoArray.y) {
                int xx = 0;
                while (xx < this.tamanoArray.x) {
                    int num;
                    this.arrayForma[xx][yy][zz] = num = (int)this.leeNumero(1);
                    ++xx;
                }
                this.saltaLinea();
                ++yy;
            }
            this.saltaLinea();
            ++zz;
        }
    }

    public BranchGroup creaEscenaJuego(URL url, Canvas3D miCanvas3D) {
        resultado = Escena.creaBranchGroupCompleto();
        BoundingSphere limites = new BoundingSphere(new Point3d(), 1000.0);
        AmbientLight luzAmbiental = new AmbientLight(new Color3f(0.4f, 0.4f, 0.4f));
        luzAmbiental.setInfluencingBounds((Bounds)limites);
        resultado.addChild((Node)luzAmbiental);
        DirectionalLight luzDireccional = new DirectionalLight(new Color3f(0.8f, 0.8f, 0.8f), new Vector3f(1.0f, -1.0f, -1.0f));
        luzDireccional.setInfluencingBounds((Bounds)limites);
        resultado.addChild((Node)luzDireccional);
        controlTiempo = new ControlTiempo();
        resultado.addChild((Node)controlTiempo);
        puntuacion = 0;
        numeroNivel = 1;
        parteMenu = Escena.creaBranchGroupCompleto();
        resultado.addChild((Node)parteMenu);
        Fuente2D miFuente = new Fuente2D("Arial", 60, Fuente2D.NEGRITA, Menu.colorNormal);
        textoPuntos = new Texto2D(Nivel.creaPuntuacion7Letras(), miFuente);
        textoNivel = new Texto2D("NIVEL: " + numeroNivel, miFuente);
        elementoMenu = new Objeto3D[7];
        Nivel.elementoMenu[0] = new Objeto3D((Node)Escena.misModelos[11].creaCopia(), new Vector3f(16.0f, 6.5f, 0.0f), null);
        Nivel.elementoMenu[1] = new Objeto3D((Node)textoNivel, new Vector3f(15.25f, 5.0f, -1.0f), null);
        Nivel.elementoMenu[2] = new Objeto3D((Node)new Texto2D("PUNTUACION: ", miFuente), new Vector3f(15.0f, 4.0f, -1.0f), null);
        Nivel.elementoMenu[3] = new Objeto3D((Node)textoPuntos, new Vector3f(15.3f, 3.5f, -1.0f), null);
        Nivel.elementoMenu[4] = new Objeto3D((Node)new Texto2D("TIEMPO: ", miFuente), new Vector3f(15.2f, 2.35f, -1.0f), null);
        Nivel.elementoMenu[5] = new Objeto3D((Node)controlTiempo.getBarraTiempo(), new Vector3f(15.2f, 1.8f, -1.0f), null);
        Nivel.elementoMenu[6] = new Objeto3D((Node)new Texto2D("SALIR ", miFuente), new Vector3f(15.75f, 0.25f, -1.0f), new Mensaje(Mensaje.GAME_OVER));
        elementoMenu[1].setEscalado(2.0);
        elementoMenu[2].setEscalado(1.5);
        elementoMenu[3].setEscalado(2.0);
        elementoMenu[4].setEscalado(2.0);
        elementoMenu[6].setEscalado(2.0);
        int var = 0;
        while (var < elementoMenu.length) {
            Vector3f pos = elementoMenu[var].getTraslacion();
            elementoMenu[var].creaInterpoladorTraslacion(pos, new Vector3f(pos.x - 7.0f, pos.y, pos.z), var * 200, 200.0);
            elementoMenu[var].rotarY(-0.5);
            parteMenu.addChild((Node)elementoMenu[var]);
            ++var;
        }
        ControlMenu controlMenu = new ControlMenu(miCanvas3D, parteMenu);
        parteJuego = this.cargaNivel(url, miCanvas3D);
        resultado.addChild((Node)parteJuego);
        return resultado;
    }

    public BranchGroup cargaNivel(URL url, Canvas3D miCanvas3D) {
        this.yaHemosSel = false;
        BranchGroup nivel = Escena.creaBranchGroupCompleto();
        this.conjuntoFichas = Escena.creaBranchGroupCompleto();
        this.mundoFichas = Escena.creaBranchGroupCompleto();
        this.cargaFicheroNivel(url, "Mods/" + Opciones.getModSeleccionado(), "/Nivel" + numeroNivel + ".niv");
        SeleccionFichas seleccion = new SeleccionFichas(this, miCanvas3D, this.conjuntoFichas);
        this.creaArrayFichas();
        this.mundoFichas.addChild((Node)this.conjuntoFichas);
        int maxTamano = 0;
        maxTamano = this.tamanoArray.x >= this.tamanoArray.y & this.tamanoArray.x >= this.tamanoArray.z ? this.tamanoArray.x : (this.tamanoArray.y >= this.tamanoArray.x & this.tamanoArray.y >= this.tamanoArray.z ? this.tamanoArray.y : this.tamanoArray.z);
        this.objetoJuego = new Objeto3D((Node)this.mundoFichas, new Vector3f(-7.84f, 3.84f, 0.0f), new Point3i());
        this.objetoJuego.setEscalado(2.0 / (double)maxTamano);
        this.objetoJuego.creaInterpoladorTraslacion(this.objetoJuego.getTraslacion(), new Vector3f(3.84f, 3.84f, 0.0f), 0.0, 1000.0);
        this.objetoJuego.AsociaBehaviorRotaMouse();
        nivel.addChild((Node)this.objetoJuego);
        return nivel;
    }

    public void creaArrayFichas() {
        this.arrayFichas = new Objeto3D[this.tamanoArray.x][this.tamanoArray.y][this.tamanoArray.z];
        this.arrayValores = new int[this.tamanoArray.x][this.tamanoArray.y][this.tamanoArray.z];
        this.creaValoresIniciales(7);
        int xx = 0;
        while (xx < this.tamanoArray.x) {
            int yy = 0;
            while (yy < this.tamanoArray.y) {
                int zz = 0;
                while (zz < this.tamanoArray.z) {
                    Vector3f posicion;
                    if (this.arrayForma[xx][yy][zz] == FORMA_VISIBLE) {
                        posicion = new Vector3f(((float)xx - (float)this.tamanoArray.x / 2.0f) * 2.0f + 1.0f, ((float)yy - (float)this.tamanoArray.y / 2.0f) * 2.0f + 1.0f, ((float)zz - (float)this.tamanoArray.z / 2.0f) * 2.0f + 1.0f);
                        this.arrayFichas[xx][yy][zz] = new Objeto3D((Node)Escena.misModelos[this.arrayValores[xx][yy][zz]].creaCopia(), posicion, new Point3i(xx, yy, zz));
                        this.conjuntoFichas.addChild((Node)this.arrayFichas[xx][yy][zz]);
                    }
                    if (this.arrayForma[xx][yy][zz] == FORMA_OCULTA) {
                        posicion = new Vector3f(((float)xx - (float)this.tamanoArray.x / 2.0f) * 2.0f + 1.0f, ((float)yy - (float)this.tamanoArray.y / 2.0f) * 2.0f + 1.0f, ((float)zz - (float)this.tamanoArray.z / 2.0f) * 2.0f + 1.0f);
                        this.arrayFichas[xx][yy][zz] = new Objeto3D((Node)Escena.misModelos[8].creaCopia(), posicion, null);
                        this.conjuntoFichas.addChild((Node)this.arrayFichas[xx][yy][zz]);
                    }
                    if (this.arrayForma[xx][yy][zz] == FORMA_BLOQUE) {
                        this.arrayValores[xx][yy][zz] = 100;
                        posicion = new Vector3f(((float)xx - (float)this.tamanoArray.x / 2.0f) * 2.0f + 1.0f, ((float)yy - (float)this.tamanoArray.y / 2.0f) * 2.0f + 1.0f, ((float)zz - (float)this.tamanoArray.z / 2.0f) * 2.0f + 1.0f);
                        this.arrayFichas[xx][yy][zz] = new Objeto3D((Node)Escena.misModelos[9].creaCopia(), posicion, null);
                        this.conjuntoFichas.addChild((Node)this.arrayFichas[xx][yy][zz]);
                    }
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
    }

    public void creaValoresIniciales(int tiposFichasDiferentes) {
        int zz;
        int yy;
        Random aleatorio = new Random();
        int contaPosibles = 0;
        int xx = 0;
        while (xx < this.tamanoArray.x) {
            yy = 0;
            while (yy < this.tamanoArray.y) {
                zz = 0;
                while (zz < this.tamanoArray.z) {
                    if (this.arrayForma[xx][yy][zz] == FORMA_VISIBLE || this.arrayForma[xx][yy][zz] == FORMA_OCULTA) {
                        ++contaPosibles;
                    }
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
        if (contaPosibles % 2 != 0) {
            System.err.println("Son impares, ERROR");
            System.exit(1);
        }
        piezasEnPantalla = contaPosibles;
        Point[] arrayParejas = new Point[contaPosibles / 2];
        xx = 0;
        while (xx < contaPosibles / 2) {
            arrayParejas[xx] = new Point();
            arrayParejas[xx].y = aleatorio.nextInt(tiposFichasDiferentes);
            ++xx;
        }
        xx = 0;
        while (xx < this.tamanoArray.x) {
            yy = 0;
            while (yy < this.tamanoArray.y) {
                zz = 0;
                while (zz < this.tamanoArray.z) {
                    if (this.arrayForma[xx][yy][zz] == FORMA_VISIBLE || this.arrayForma[xx][yy][zz] == FORMA_OCULTA) {
                        boolean encontrado = false;
                        int miParejaAleatoria = 0;
                        while (!encontrado) {
                            miParejaAleatoria = aleatorio.nextInt(contaPosibles / 2);
                            if (arrayParejas[miParejaAleatoria].x >= 2) continue;
                            ++arrayParejas[miParejaAleatoria].x;
                            encontrado = true;
                        }
                        this.arrayValores[xx][yy][zz] = arrayParejas[miParejaAleatoria].y;
                    }
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
    }

    public void PiezaSeleccionada(Node nodo) {
        Point3i piezaSel = (Point3i)nodo.getUserData();
        if (!this.yaHemosSel) {
            this.piezaSelAnt = piezaSel;
            this.yaHemosSel = true;
            this.seleccion = new Objeto3D((Node)Escena.misModelos[7].creaCopia(), this.arrayFichas[piezaSel.x][piezaSel.y][piezaSel.z].getTraslacion(), null);
            this.seleccion.setEscalado(0.9);
            Alpha BumBum = new Alpha();
            BumBum.setMode(3);
            BumBum.setPhaseDelayDuration(100L);
            BumBum.setLoopCount(-1);
            BumBum.setIncreasingAlphaDuration(300L);
            BumBum.setDecreasingAlphaDuration(300L);
            this.seleccion.creaInterpoladorEscalado(BumBum, this.seleccion.getEscalado(), 0.9f, 1.1f);
            this.mundoFichas.addChild((Node)this.seleccion);
        } else {
            if (piezaSel != this.piezaSelAnt) {
                if (this.arrayValores[piezaSel.x][piezaSel.y][piezaSel.z] == this.arrayValores[this.piezaSelAnt.x][this.piezaSelAnt.y][this.piezaSelAnt.z]) {
                    this.arrayFichas[piezaSel.x][piezaSel.y][piezaSel.z].detach();
                    this.arrayFichas[this.piezaSelAnt.x][this.piezaSelAnt.y][this.piezaSelAnt.z].detach();
                    this.actualizaAPartirDeLaFichas(piezaSel);
                    this.actualizaAPartirDeLaFichas(this.piezaSelAnt);
                    this.arrayFichas[piezaSel.x][piezaSel.y][piezaSel.z].BorrarObjetoEn(500.0, true);
                    this.arrayFichas[this.piezaSelAnt.x][this.piezaSelAnt.y][this.piezaSelAnt.z].BorrarObjetoEn(500.0, true);
                    this.mundoFichas.addChild((Node)this.arrayFichas[piezaSel.x][piezaSel.y][piezaSel.z]);
                    this.mundoFichas.addChild((Node)this.arrayFichas[this.piezaSelAnt.x][this.piezaSelAnt.y][this.piezaSelAnt.z]);
                    puntuacion += puntosNivel;
                    textoPuntos.setTexto(Nivel.creaPuntuacion7Letras());
                    piezasEnPantalla -= 2;
                    this.funcionDeControl();
                }
                this.seleccion2 = new Objeto3D((Node)Escena.misModelos[7].creaCopia(), this.arrayFichas[piezaSel.x][piezaSel.y][piezaSel.z].getTraslacion(), null);
                this.seleccion2.BorrarObjetoEn(500.0, true);
                this.mundoFichas.addChild((Node)this.seleccion2);
            }
            this.yaHemosSel = false;
            this.seleccion.BorrarObjeto();
            this.seleccion.BorrarObjetoEn(500.0, true);
            this.mundoFichas.addChild((Node)this.seleccion);
        }
    }

    public void actualizaAPartirDeLaFichas(Point3i ficha) {
        if (ficha.x < this.tamanoArray.x - 1) {
            this.descubrePieza(new Point3i(ficha.x + 1, ficha.y, ficha.z));
        }
        if (ficha.x > 0) {
            this.descubrePieza(new Point3i(ficha.x - 1, ficha.y, ficha.z));
        }
        if (ficha.y < this.tamanoArray.z - 1) {
            this.descubrePieza(new Point3i(ficha.x, ficha.y + 1, ficha.z));
        }
        if (ficha.y > 0) {
            this.descubrePieza(new Point3i(ficha.x, ficha.y - 1, ficha.z));
        }
        if (ficha.z < this.tamanoArray.z - 1) {
            this.descubrePieza(new Point3i(ficha.x, ficha.y, ficha.z + 1));
        }
        if (ficha.z > 0) {
            this.descubrePieza(new Point3i(ficha.x, ficha.y, ficha.z - 1));
        }
    }

    private void descubrePieza(Point3i ficha) {
        if (this.arrayForma[ficha.x][ficha.y][ficha.z] == FORMA_OCULTA) {
            this.arrayForma[ficha.x][ficha.y][ficha.z] = FORMA_VISIBLE;
            this.arrayFichas[ficha.x][ficha.y][ficha.z].detach();
            Objeto3D copia = new Objeto3D((Node)Escena.misModelos[8].creaCopia(), this.arrayFichas[ficha.x][ficha.y][ficha.z].getTraslacion(), null);
            this.arrayFichas[ficha.x][ficha.y][ficha.z] = new Objeto3D((Node)Escena.misModelos[this.arrayValores[ficha.x][ficha.y][ficha.z]].creaCopia(), this.arrayFichas[ficha.x][ficha.y][ficha.z].getTraslacion(), new Point3i((Tuple3i)ficha));
            copia.BorrarObjetoEn(500.0, true);
            this.mundoFichas.addChild((Node)copia);
            this.conjuntoFichas.addChild((Node)this.arrayFichas[ficha.x][ficha.y][ficha.z]);
        }
    }

    private void funcionDeControl() {
        if (piezasEnPantalla == 0) {
            if (Opciones.getModoDebug()) {
                System.out.println("Pantalla superada");
            }
            controlTiempo.paraYa();
            puntuacion = (int)((double)puntuacion + controlTiempo.getTiempoRestante() / 1000.0 * (double)puntosNivel);
            textoPuntos.setTexto(Nivel.creaPuntuacion7Letras());
            this.objetoJuego.detach();
            parteJuego.detach();
            Fuente2D miFuente = new Fuente2D("Arial", 60, Fuente2D.NEGRITA, new Color3f(1.0f, 1.0f, 1.0f));
            textoNivelSuperado = new Objeto3D((Node)new Texto2D("\u00a1NIVEL SUPERADO!", miFuente), new Vector3f(1.8f, 6.5f, 3.0f), null);
            textoNivelSuperado.setEscalado(2.0);
            textoNivelSuperado.creaInterpoladorTraslacion(new Vector3f(1.8f, 6.5f, 3.0f), new Vector3f(1.8f, 3.5f, 3.0f), 0.0, 1000.0);
            parteJuego.addChild((Node)textoNivelSuperado);
            this.objetoJuego.BorrarObjetoEn(2000.0, true);
            parteJuego.addChild((Node)this.objetoJuego);
            parteJuego.addChild((Node)new EnviaMensaje(new Mensaje(Mensaje.CAMBIA_A_SIGUIENTE_NIVEL, 1500L)));
            resultado.addChild((Node)parteJuego);
        }
    }

    public void pasaAlSiguienteNivel(URL url, Canvas3D miCanvas3D) {
        textoNivelSuperado.detach();
        textoNivelSuperado.creaInterpoladorTraslacion(new Vector3f(1.8f, 3.5f, 3.0f), new Vector3f(1.8f, 0.0f, 3.0f), 0.0, 1000.0);
        if (numeroNivel == 3) {
            textoNivelSuperado.addChild((Node)new EnviaMensaje(new Mensaje(Mensaje.GAME_OVER)));
        }
        parteJuego.addChild((Node)textoNivelSuperado);
        if (numeroNivel != 3) {
            textoNivel.setTexto("NIVEL: " + ++numeroNivel);
            parteJuego = this.cargaNivel(url, miCanvas3D);
            resultado.addChild((Node)parteJuego);
        }
    }

    public void GameOver() {
        this.objetoJuego.detach();
        parteJuego.detach();
        parteMenu.detach();
        Fuente2D miFuente = new Fuente2D("Arial", 60, Fuente2D.NEGRITA, new Color3f(1.0f, 1.0f, 1.0f));
        textoNivelSuperado = new Objeto3D((Node)new Texto2D("GAME OVER", miFuente), new Vector3f(2.4f, 6.5f, 3.0f), null);
        textoNivelSuperado.setEscalado(2.0);
        textoNivelSuperado.creaInterpoladorTraslacion(new Vector3f(2.4f, 6.5f, 3.0f), new Vector3f(2.4f, 3.5f, 3.0f), 0.0, 1000.0);
        parteJuego.addChild((Node)textoNivelSuperado);
        this.objetoJuego.BorrarObjetoEn(500.0, true);
        int var = 0;
        while (var < elementoMenu.length) {
            elementoMenu[var].detach();
            Vector3f pos = elementoMenu[var].getTraslacion();
            elementoMenu[var].creaInterpoladorTraslacion(pos, new Vector3f(pos.x + 7.0f, pos.y, pos.z), var * 200, 200.0);
            parteMenu.addChild((Node)elementoMenu[var]);
            ++var;
        }
        boolean nuevoHighScore = ManejoFicheros.EsNuevoHighScore(puntuacion);
        if (puntuacion == 0) {
            nuevoHighScore = false;
        }
        if (nuevoHighScore) {
            parteJuego.addChild((Node)new EnviaMensaje(new Mensaje(Mensaje.CAMBIA_A_INTRODUCIR_NOMBRE, 2000L)));
        } else {
            parteJuego.addChild((Node)new EnviaMensaje(new Mensaje(Mensaje.VUELVE_AL_MENU_PRINCIPAL, 2000L)));
        }
        resultado.addChild((Node)parteMenu);
        resultado.addChild((Node)parteJuego);
    }

    public static String creaPuntuacion7Letras() {
        String resultado = new String();
        resultado = "" + puntuacion * 100;
        while (resultado.length() < 7) {
            resultado = "0" + resultado;
        }
        return resultado;
    }
}

