/*
 * Decompiled with CFR 0.152.
 */
package codigo.ManejoFicheros;

import codigo.ManejoFicheros.SOpciones;
import codigo.ManejoFicheros.SPuntos;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ManejoFicheros {
    private static File fichero;
    private static FileReader lectorFichero;
    private static FileWriter escritorFichero;
    private static SPuntos HighScores;

    public static SOpciones CargaOpciones(String fich) {
        lectorFichero = null;
        fichero = new File(fich);
        try {
            lectorFichero = new FileReader(fichero.getAbsolutePath());
        }
        catch (IOException e1) {
            System.err.println("No se puede abrir el fichero de opciones");
            System.exit(1);
        }
        SOpciones resultado = new SOpciones();
        char[] paraleer = new char[1];
        try {
            lectorFichero.read(paraleer);
        }
        catch (IOException e) {
            System.err.println("Error al leer el fichero de opciones");
            System.exit(1);
        }
        if (paraleer[0] == '\u0001') {
            resultado.inv = true;
        }
        try {
            lectorFichero.read(paraleer);
        }
        catch (IOException e) {
            System.err.println("Error al leer el fichero de opciones");
            System.exit(1);
        }
        if (paraleer[0] == '\u0001') {
            resultado.mfps = true;
        }
        try {
            lectorFichero.read(paraleer);
        }
        catch (IOException e) {
            System.err.println("Error al leer el fichero de opciones");
            System.exit(1);
        }
        if (paraleer[0] == '\u0001') {
            resultado.reg = true;
        }
        try {
            lectorFichero.close();
        }
        catch (IOException e2) {
            System.err.println("Error al cerrar el fichero de opciones");
            System.exit(1);
        }
        return resultado;
    }

    public static void GuardaOpciones(String fich, SOpciones op) {
        escritorFichero = null;
        fichero = new File(fich);
        try {
            escritorFichero = new FileWriter(fichero.getAbsolutePath());
        }
        catch (IOException e1) {
            System.err.println("No se puede abrir el fichero de opciones");
            System.exit(1);
        }
        int paraEscribir = op.inv ? 1 : 0;
        try {
            escritorFichero.write(paraEscribir);
        }
        catch (IOException e) {
            System.err.println("Error al escribir el fichero de opciones");
            System.exit(1);
        }
        paraEscribir = op.mfps ? 1 : 0;
        try {
            escritorFichero.write(paraEscribir);
        }
        catch (IOException e) {
            System.err.println("Error al escribir el fichero de opciones");
            System.exit(1);
        }
        paraEscribir = op.reg ? 1 : 0;
        try {
            escritorFichero.write(paraEscribir);
        }
        catch (IOException e) {
            System.err.println("Error al escribir el fichero de opciones");
            System.exit(1);
        }
        try {
            escritorFichero.close();
        }
        catch (IOException e2) {
            System.err.println("Error al cerrar el fichero de opciones");
            System.exit(1);
        }
    }

    private static char[] TrasformaString(String st, int tamano, int desplazamiento) {
        char[] resultado = new char[tamano];
        int conta = 0;
        while (conta < tamano) {
            resultado[conta] = conta < st.length() ? (char)((st.charAt(conta) + desplazamiento) % 256) : (char)(desplazamiento % 256);
            ++conta;
        }
        return resultado;
    }

    private static String RecuperaString(char[] array, int tamano, int desplazamiento) {
        String resultado = new String();
        int conta = 0;
        while (conta < tamano) {
            int valor = (array[conta] + 256 - desplazamiento) % 256;
            if (valor == 0) break;
            resultado = String.valueOf(resultado) + (char)valor;
            ++conta;
        }
        return resultado;
    }

    public static void CargaHighScores(String fich) {
        lectorFichero = null;
        fichero = new File(fich);
        try {
            lectorFichero = new FileReader(fichero.getAbsolutePath());
        }
        catch (IOException e1) {
            System.err.println("No se puede abrir el fichero de HighScores");
            System.exit(1);
        }
        char[] paraLeer = new char[10];
        int conta = 0;
        while (conta < 10) {
            try {
                lectorFichero.read(paraLeer, 0, 10);
            }
            catch (IOException e) {
                System.err.println("Error al leer el fichero de HighScores");
                System.exit(1);
            }
            SPuntos.nombre[conta] = ManejoFicheros.RecuperaString(paraLeer, 10, 13);
            String p = SPuntos.nombre[conta];
            try {
                lectorFichero.read(paraLeer, 0, 10);
            }
            catch (IOException e) {
                System.err.println("Error al leer el fichero de HighScores");
                System.exit(1);
            }
            SPuntos.puntos[conta] = Integer.parseInt(ManejoFicheros.RecuperaString(paraLeer, 10, 13));
            ++conta;
        }
        try {
            lectorFichero.close();
        }
        catch (IOException e2) {
            System.err.println("Error al cerrar el fichero de HighScores");
            System.exit(1);
        }
    }

    public static void GuardaHighScores(String fich) {
        escritorFichero = null;
        fichero = new File(fich);
        try {
            escritorFichero = new FileWriter(fichero.getAbsolutePath());
        }
        catch (IOException e1) {
            System.err.println("Error al escribir el fichero de HighScores");
            System.exit(1);
        }
        int conta = 0;
        while (conta < 10) {
            char[] paraEscribir = ManejoFicheros.TrasformaString(SPuntos.nombre[conta], 10, 13);
            try {
                escritorFichero.write(paraEscribir);
            }
            catch (IOException e) {
                System.err.println("Error al escribir el fichero de HighScores");
                System.exit(1);
            }
            paraEscribir = ManejoFicheros.TrasformaString(Integer.toString(SPuntos.puntos[conta]), 10, 13);
            try {
                escritorFichero.write(paraEscribir);
            }
            catch (IOException e) {
                System.err.println("Error al escribir el fichero de HighScores");
                System.exit(1);
            }
            ++conta;
        }
        try {
            escritorFichero.close();
        }
        catch (IOException e2) {
            System.err.println("Error al cerrar el fichero de HighScores");
            System.exit(1);
        }
    }

    public static void RetornaHighScores(String[] nombres, int[] puntos) {
        int conta = 0;
        while (conta < 10) {
            nombres[conta] = SPuntos.nombre[conta];
            puntos[conta] = SPuntos.puntos[conta];
            ++conta;
        }
    }

    public static boolean EsNuevoHighScore(int puntos) {
        return SPuntos.puntos[9] < puntos;
    }

    public static void IntroduceHighScore(String nombre, int puntos) {
        int conta = 0;
        while (conta < 10) {
            if (SPuntos.puntos[conta] <= puntos) break;
            ++conta;
        }
        int conta2 = 9;
        while (conta2 > conta) {
            SPuntos.puntos[conta2] = SPuntos.puntos[conta2 - 1];
            SPuntos.nombre[conta2] = SPuntos.nombre[conta2 - 1];
            --conta2;
        }
        SPuntos.puntos[conta] = puntos;
        SPuntos.nombre[conta] = nombre;
    }

    public static void DatosDePrueba() {
        SPuntos.nombre[0] = "SYSTEMBD";
        SPuntos.puntos[0] = 220;
        SPuntos.nombre[1] = "ALPHA83";
        SPuntos.puntos[1] = 200;
        SPuntos.nombre[2] = "CYMORIL";
        SPuntos.puntos[2] = 180;
        SPuntos.nombre[3] = "MIAU";
        SPuntos.puntos[3] = 160;
        SPuntos.nombre[4] = "PATROKLO";
        SPuntos.puntos[4] = 140;
        SPuntos.nombre[5] = "MURO";
        SPuntos.puntos[5] = 120;
        SPuntos.nombre[6] = "NONSENSE";
        SPuntos.puntos[6] = 100;
        SPuntos.nombre[7] = "AINGERU";
        SPuntos.puntos[7] = 80;
        SPuntos.nombre[8] = "KARONTE";
        SPuntos.puntos[8] = 60;
        SPuntos.nombre[9] = "UNKN";
        SPuntos.puntos[9] = 40;
    }
}

