/*
 * Decompiled with CFR 0.152.
 */
package codigo.Engine3D;

import codigo.Comportamientos.BorrameEn;
import codigo.Comportamientos.MiPropioTraslationInterpolator;
import codigo.Comportamientos.RotaMouse;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class Objeto3D
extends BranchGroup {
    TransformGroup traslacion = null;
    TransformGroup rotacion = null;
    TransformGroup escalado = null;
    MiPropioTraslationInterpolator traslator;
    RotationInterpolator rotator;
    ScaleInterpolator escalator;
    Node nodo;

    public Objeto3D(Node nod, Vector3f pos, Object obj) {
        Transform3D posicion = new Transform3D();
        posicion.set(pos);
        this.setCapability(17);
        this.setCapability(14);
        this.setCapability(13);
        this.setCapability(12);
        this.escalado = new TransformGroup();
        this.escalado.setCapability(17);
        this.escalado.setCapability(18);
        this.rotacion = new TransformGroup();
        this.rotacion.setCapability(17);
        this.rotacion.setCapability(18);
        this.traslacion = new TransformGroup(posicion);
        this.traslacion.setCapability(17);
        this.traslacion.setCapability(18);
        this.nodo = nod;
        this.nodo.setUserData(obj);
        this.addChild((Node)this.traslacion);
        this.traslacion.addChild((Node)this.rotacion);
        this.rotacion.addChild((Node)this.escalado);
        this.escalado.addChild(this.nodo);
    }

    public Node getObjeto() {
        return this.nodo;
    }

    public void setTraslacion(Vector3f pos) {
        Transform3D posicion = new Transform3D();
        posicion.set(pos);
        this.traslacion.setTransform(posicion);
    }

    public Vector3f getTraslacion() {
        Vector3f resultado = new Vector3f();
        Transform3D posicion = new Transform3D();
        this.traslacion.getTransform(posicion);
        posicion.get(resultado);
        return resultado;
    }

    public Transform3D getTraslacionT3D() {
        Vector3f resultado = new Vector3f();
        Transform3D posicion = new Transform3D();
        this.traslacion.getTransform(posicion);
        return posicion;
    }

    public void rotarX(double angulo) {
        Transform3D giro = this.getRotacion();
        giro.rotX(angulo);
        this.rotacion.setTransform(giro);
    }

    public void rotarY(double angulo) {
        Transform3D giro = this.getRotacion();
        giro.rotY(angulo);
        this.rotacion.setTransform(giro);
    }

    public void rotarZ(double angulo) {
        Transform3D giro = this.getRotacion();
        giro.rotZ(angulo);
        this.rotacion.setTransform(giro);
    }

    public Transform3D getRotacion() {
        Transform3D giro = new Transform3D();
        this.rotacion.getTransform(giro);
        return giro;
    }

    public void setEscalado(double valor) {
        Transform3D tamano = new Transform3D();
        tamano.set(valor);
        this.escalado.setTransform(tamano);
    }

    public Transform3D getEscalado() {
        Transform3D tamano = new Transform3D();
        this.escalado.getTransform(tamano);
        return tamano;
    }

    public double getEscaladoEnDouble() {
        double[] resultado = new double[16];
        Transform3D tamano = new Transform3D();
        this.escalado.getTransform(tamano);
        tamano.get(resultado);
        return resultado[0];
    }

    public void creaInterpoladorTraslacion(Vector3f posIni, Vector3f posFin, double inicio, double duracion) {
        this.traslator = new MiPropioTraslationInterpolator(this.traslacion, posIni, posFin, inicio, duracion);
        this.traslator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.addChild((Node)this.traslator);
    }

    public void creaInterpoladorRotacion(Alpha miAlpha, Transform3D miEje, float angMin, float angMax) {
        this.rotator = new RotationInterpolator(miAlpha, this.rotacion, miEje, angMin, angMax);
        this.rotator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.addChild((Node)this.rotator);
    }

    public void creaInterpoladorEscalado(Alpha miAlpha, Transform3D miEje, float escMin, float escMax) {
        this.escalator = new ScaleInterpolator(miAlpha, this.escalado, miEje, escMin, escMax);
        this.escalator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.addChild((Node)this.escalator);
    }

    public void AsociaBehaviorRotaMouse() {
        RotaMouse girator = new RotaMouse(this.rotacion);
        girator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.addChild((Node)girator);
    }

    public void BorrarObjeto() {
        this.detach();
    }

    public void BorrarObjetoEn(double tiempo, boolean reduce) {
        if (this.escalator != null) {
            this.removeChild((Node)this.escalator);
        }
        BorrameEn borrator = new BorrameEn(this, tiempo, reduce);
        borrator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.addChild((Node)borrator);
    }
}

