/*
 * Decompiled with CFR 0.152.
 */
package codigo.Engine3D;

import codigo.Opciones;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.picking.PickTool;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3d;

public class Modelo3D
extends Shape3D {
    public Modelo3D() {
    }

    public Modelo3D(URL fmodelo, URL ftextura) {
        if (Opciones.getModoDebug()) {
            System.out.println("Cargando modelo: " + fmodelo.toString());
        }
        this.cargaObj(fmodelo);
        Appearance apariencia = new Appearance();
        this.setAppearance(apariencia);
        if (Opciones.getModoDebug()) {
            System.out.println("Cargando textura: " + ftextura.toString());
        }
        this.cargaTextura(ftextura);
        PickTool.setCapabilities((Node)this, (int)4100);
    }

    public Modelo3D(URL fmodelo, URL ftextura, Material material) {
        if (Opciones.getModoDebug()) {
            System.out.println("Cargando modelo: " + fmodelo.toString());
        }
        this.cargaObj(fmodelo);
        if (Opciones.getModoDebug()) {
            System.out.println("Cargando textura: " + ftextura.toString());
        }
        this.cargaTextura(ftextura);
        if (Opciones.getModoDebug()) {
            System.out.println("Aplicando material...");
        }
        this.setMaterial(material);
        PickTool.setCapabilities((Node)this, (int)4100);
    }

    public void cargaObj(URL fmodelo) {
        URL mifichero = fmodelo;
        int flags = 64;
        ObjectFile f = new ObjectFile(flags);
        Scene escena = null;
        try {
            escena = f.load(mifichero);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        BranchGroup sceneGroup = escena.getSceneGroup();
        Hashtable misObjetos = escena.getNamedObjects();
        Enumeration enumeration = misObjetos.keys();
        while (enumeration.hasMoreElements()) {
            String nombre = (String)enumeration.nextElement();
            Shape3D forma = (Shape3D)misObjetos.get(nombre);
            this.setGeometry(forma.getGeometry());
        }
    }

    public void cargaTextura(URL texImage) {
        Appearance apariencia = new Appearance();
        TextureLoader cargadorTextura = new TextureLoader(texImage, null);
        Texture textura = cargadorTextura.getTexture();
        textura.setEnable(true);
        apariencia.setTexture(textura);
        TextureAttributes texAtrib = new TextureAttributes();
        texAtrib.setTextureMode(2);
        apariencia.setTextureAttributes(texAtrib);
        this.setAppearance(apariencia);
    }

    public Shape3D creaCopia() {
        Shape3D objeto = new Shape3D();
        objeto.setAppearance(this.getAppearance());
        objeto.setGeometry(this.getGeometry());
        objeto.setBoundsAutoCompute(false);
        objeto.setBounds((Bounds)new BoundingBox(new Point3d(-1.0, -1.0, -1.0), new Point3d(1.0, 1.0, 1.0)));
        objeto.setCapability(15);
        objeto.setCapability(14);
        objeto.setCapability(13);
        objeto.setCapability(12);
        objeto.setCapability(18);
        objeto.setCapability(5);
        objeto.setCapability(6);
        objeto.setCapability(0);
        objeto.setCapability(1);
        return objeto;
    }

    public void setMaterial(Material material) {
        Appearance apariencia = this.getAppearance();
        if (apariencia == null) {
            apariencia = new Appearance();
        }
        apariencia.setMaterial(material);
        this.setAppearance(apariencia);
    }

    public Material getMaterial() {
        Appearance apariencia = this.getAppearance();
        if (apariencia == null) {
            apariencia = new Appearance();
        }
        Material material = apariencia.getMaterial();
        return material;
    }

    public void aplicaTransparencia(float trasp) {
        Appearance apariencia = this.getAppearance();
        TransparencyAttributes transparencia = new TransparencyAttributes();
        transparencia.setTransparency(trasp);
        transparencia.setTransparencyMode(0);
        apariencia.setTransparencyAttributes(transparencia);
        this.setAppearance(apariencia);
    }
}

