/*
 * Decompiled with CFR 0.152.
 */
package codigo.Comportamientos;

import codigo.Comportamientos.EnviaMensaje;
import codigo.Engine3D.Texto2D;
import codigo.Mensaje;
import codigo.Menu;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;

public class ControlMenu
extends Behavior {
    private static int MODIF_BOTON_DER = 4;
    private static int MODIF_BOTON_IZQ = 16;
    private Canvas3D miCanvas;
    private WakeupCriterion[] condiciones;
    private PickCanvas pickCanvas;
    private BranchGroup miPadre;
    private Node antiguoSel;

    public ControlMenu(Canvas3D canvas, BranchGroup padre) {
        this.miCanvas = canvas;
        this.miPadre = padre;
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 10000.0));
        this.miPadre.addChild((Node)this);
        this.pickCanvas = new PickCanvas(canvas, padre);
        this.pickCanvas.setMode(512);
    }

    public void initialize() {
        this.condiciones = new WakeupCriterion[3];
        this.condiciones[0] = new WakeupOnAWTEvent(503);
        this.condiciones[1] = new WakeupOnAWTEvent(502);
        this.condiciones[2] = new WakeupOnAWTEvent(506);
        this.wakeupOn((WakeupCondition)new WakeupOr(this.condiciones));
    }

    public void processStimulus(Enumeration criterio) {
        while (criterio.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criterio.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] evento = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            int i = 0;
            while (i < evento.length) {
                MouseEvent miEvento = (MouseEvent)evento[i];
                this.actualizaEscena(miEvento.getID(), miEvento.getX(), miEvento.getY(), miEvento.getModifiers());
                ++i;
            }
        }
        this.wakeupOn((WakeupCondition)new WakeupOr(this.condiciones));
    }

    private void actualizaEscena(int evento, int X, int Y, int modificador) {
        BranchGroup mensajero = new BranchGroup();
        Node seleccion = null;
        this.pickCanvas.setShapeLocation(X, Y);
        PickResult resultadoSeleccion = this.pickCanvas.pickClosest();
        if (resultadoSeleccion != null) {
            seleccion = resultadoSeleccion.getObject();
            if (seleccion.getUserData() != null) {
                if (this.antiguoSel != seleccion) {
                    ((Texto2D)seleccion).setColor(Menu.colorSeleccionado);
                    if (this.antiguoSel != null) {
                        ((Texto2D)this.antiguoSel).setColor(Menu.colorNormal);
                    }
                    this.antiguoSel = seleccion;
                }
                if (evento == 502 && modificador == MODIF_BOTON_IZQ) {
                    mensajero.addChild((Node)new EnviaMensaje((Mensaje)seleccion.getUserData()));
                    this.miPadre.addChild((Node)mensajero);
                }
            }
        } else if (this.antiguoSel != null) {
            ((Texto2D)this.antiguoSel).setColor(Menu.colorNormal);
            this.antiguoSel = null;
        }
    }
}

