//////////////////////////////////////////////////////////////////////////
//	Name: CameraDX
//
//	Description: simple and intuitive camera for DirectX
//
//	Author: Mario Garcia Lazaro (thenend@hotmail.com)
//
//	Notes:  delta is the time transcurred from the last frame
//
//////////////////////////////////////////////////////////////////////////

#pragma once

#include <windows.h>
#include <D3D9.h>
#include <D3DX9.h>


class CameraDX
{
private:
	float m_Speed;

	D3DXMATRIX m_D3DViewMatrix;
	float m_PosX;
	float m_PosY;
	float m_PosZ;
	float m_Yaw;
	float m_Pitch;
	float m_Roll;
	
	D3DXMATRIX m_D3DProjectionMatrix;
	float m_FOV;
	float m_Aspect;
	float m_zNear;
	float m_zFar;

	void CreateViewMatrix( float posX, float posY, float posZ, float yaw, float pitch, float roll );

public:
	CameraDX();
	~CameraDX();
	D3DXMATRIX *GetViewMatrix();
	D3DXMATRIX *GetProjectionMatrix();
	void SetSpeed( float speed );
	float GetSpeed();
	void SetPosition( float posX, float posY, float posZ );
	float GetPosX();
	float GetPosY();
	float GetPosZ();
	// move in the direction of the camera, including Y displacement (fly effect)
	void MoveFrontFly( float delta );
	// move in the opposite direction of the camera, including Y displacement (fly effect)
	void MoveBackFly( float delta );
	// move in the direction of the camera in the horizontal plane with no Y displacement (walk effect)
	void MoveFront( float delta );
	// move in the opposite direction of the camera in the horizontal plane with no Y displacement (walk effect)
	void MoveBack( float delta );
	void MoveRight( float delta );
	void MoveLeft( float delta );
	void SetOrientation( float yaw, float pitch, float roll = 0 );
	void MoveUp( float delta );
	void MoveDown( float delta );
	void SetProjection( float fov, float aspect, float zNear, float zFar );
	void SetPlanes( float zNear, float zFar );
	void SetFOV( float fov );
	float GetFOV();
};