// Camera.h: interface for the CCamera class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CAMERA_H__140E233B_D8F9_42A9_BC96_1C861ACAE72F__INCLUDED_)
#define AFX_CAMERA_H__140E233B_D8F9_42A9_BC96_1C861ACAE72F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Vector.h"	// Added by ClassView
#include "viewport.h"
#include "Matrix4.h"

class CCamera
{
public:
	void backup();
	void restore();
	void rotate(CMatrix4 &m);
	void move(CVector &v);
	float farplane;
	float nearplane;
	float fov;
	void setViewport(CViewport *v);
	void pitch(float upinc);
	void turn(float rightinc);
	void rotate(CVector &v, float a);
	void refresh();
	void fly(float upinc);
	void strafe(float rightinc);
	void forward(float advance);
	void setUp(CVector &up);
	void setPosition(CVector &pos);
	void setTarget(CVector &target);
	void set(CVector &pos);
	void set(CVector &pos, CVector &target);
	void set(CVector &pos, CVector &target, CVector &up);
	bool active;
	void setName(char *n);
	char name[1024];
	CVector old_position, old_target, old_up;
	CVector position, target, up;
	CCamera();
	virtual ~CCamera();

private:
	CViewport * vp;
};

#endif // !defined(AFX_CAMERA_H__140E233B_D8F9_42A9_BC96_1C861ACAE72F__INCLUDED_)
