#include <stdlib.h>
#include <conio.h>
#include <dos.h>

#ifdef _MSC_VER
#include <bios.h>
#endif

#include "cthugha.h"
#include "zorilkey.h"
#include "mouse.h"
#include "cdmixrg.c"

#include "sb_drive.h"
#include "cdmaster.h"

#include "initscrn.h"
#include "patch.h"

#define disp(x,y,z) { pokeb(0xB800,(160*(y))+(14+6*(x)),(z) ? '' : ''); pokeb(0xB800,(160*(y))+(16+6*(x)),(z) ? '' : '' ); }
#define volbar(y,level) { int i; for( i=0; i<16; i++ ) pokeb(0xB800,(160*(y))+(124+2*i),(level/16) > i ? '' : ' '); }
#define invert(x) pokeb(0xB800,1+(2*(x)),0x40 ^ peekb(0xB800,1+(2*(x))));

#define outc(x,y,z) pokeb(0xB800,(160*(y))+(2*(x)),(z))
#define outn(x,y,z); { outc(x,y,(z) > 99 ? 48+(((z)/100)%10) : ' '); outc(x+1,y,((z)>9) ? 48+(((z)/10)%10) : ' '); outc(x+2,y,48+((z)%10)); };

#define MIXmic MIXmicrophone

extern enum device_list { CDInput, LineInput, MicInput } device;

void disp_num(int x, int y, int num);
int get_levels(int *left, int *right);

extern int curpal;
extern int numluts;

int lasttrack,stopflag = 0;

extern int mouse_inst;

extern int debug_mode;
extern int SBtype;

extern int (*init_audio)(void);
extern int (*close_audio)(void);
extern int (*audio_firsttime)(void);
extern int (*audio_everytime)(int wait);

extern int (*get_level)(int channel);
extern void (*set_level)(int channel, int level);
extern int  (*level_incr)(int channel);

extern void (*set_input)(enum device_list device);

void cd_playtrack(int track);
void cd_playpause(void);
void cd_backtrack(void);
void cd_fwdtrack(void);
void cd_backscan(void);
void cd_fwdscan(void);
void cd_stop(void);

void vu(int level, int y)
{
	disp(10,y,level==255);
	disp(9,y,level>220);
	disp(8,y,level>>7);
	disp(7,y,level>>6);
	disp(6,y,level>>5);
	disp(5,y,level>>4);
	disp(4,y,level>>3);
	disp(3,y,level>>2);
	disp(2,y,level>>1);
	disp(1,y,level);
}

void choose_track(void)
{
//	char scrbuf[200];

	char *disp_ptr;

	int i,j;
	int leave;
	int track;

	static char trackmsg[] =
		"         "
		"               "
		"              ";

	if( lasttrack == -1 )
		return;

//	gettext(48,18,77,20,scrbuf);

	disp_ptr = trackmsg;

	for( i = 0; i < 3; i++ )
		for( j = 0; j < 30; j++ )
			outc(47+j,17+i,*disp_ptr++);

	leave = 0;
	track = 0;

	while( !leave )
	{
		if( get_levels(&i,&j) )
		{
			vu(i,8);
			vu(j,10);
		}

		i = 0;

		if( kbhit() )
			i = getch();

		if( i == 27 )
			leave = 1;

		if( i == 13 )
		{
			if( (track > 0) && (track <= lasttrack) )
				cd_playtrack(track);

			leave = 1;
		}

		if( i >= '0' && i <= '9' )
		{
			track = (track%10)*10 + (i-48);

			disp_num(47,17,track);
		}
	}

//	puttext(48,18,77,20,scrbuf);
}


void cd_backscan(void)
{
	struct cdtable *cdt;
	int ourdrive;
	int tracknum;

	struct qchaninfo qci;

	stopflag = 0;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	cdqchaninfo(ourdrive,&qci);

	qci.track = (qci.track/16)*10 + (qci.track%16);

	playcdtrack(ourdrive,qci.track,(qci.min*60)+qci.sec-15,-1);

	destroyaudiotoc(ourdrive);
}

void cd_fwdscan(void)
{
	struct cdtable *cdt;
	int ourdrive;
	int tracknum;

	struct qchaninfo qci;

	stopflag = 0;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	cdqchaninfo(ourdrive,&qci);

	qci.track = (qci.track/16)*10 + (qci.track%16);

	playcdtrack(ourdrive,qci.track,(qci.min*60)+qci.sec+15,-1);

	destroyaudiotoc(ourdrive);
}

void cd_backtrack(void)
{
	struct cdtable *cdt;
	int ourdrive;
	int tracknum;

	struct qchaninfo qci;

	stopflag = 0;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	cdqchaninfo(ourdrive,&qci);

	qci.track = (qci.track/16)*10 + (qci.track%16);

	if( (qci.min) || (qci.sec > 2) )
		playcdtrack(ourdrive,qci.track  ,0,-1);
	else
		playcdtrack(ourdrive,qci.track-1,0,-1);

	destroyaudiotoc(ourdrive);
}

void cd_fwdtrack(void)
{
	struct cdtable *cdt;
	int ourdrive;
	int tracknum;

	struct qchaninfo qci;

	stopflag = 0;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	cdqchaninfo(ourdrive,&qci);

	qci.track = (qci.track/16)*10 + (qci.track%16);

	playcdtrack(ourdrive,qci.track+1,0,-1);

	destroyaudiotoc(ourdrive);
}

void cd_playtrack(int track)
{
	struct cdtable *cdt;
	int ourdrive;
	int tracknum;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	stopflag = 0;

	playcdtrack(ourdrive,track,0,-1);

	destroyaudiotoc(ourdrive);
}

void cd_playpause(void)
{
	struct cdtable *cdt;
	struct trackinfo ti;
	int ourdrive;
	int tracknum;

	long frames,f;

	stopflag = 0;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	if( cdstatus(ourdrive) & CDISPAUSED )
		cdresume(ourdrive);
	else
	{
		if( cdstatus(ourdrive) & CDISPLAYING )
			cdpause(ourdrive);
		else
			playcdtrack(ourdrive,1,0,-1);
	}

	destroyaudiotoc(ourdrive);
}

void cd_stop(void)
{
	struct cdtable *cdt;
	struct trackinfo ti;
	int ourdrive;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	if( (cdstatus(ourdrive) & CDISPLAYING) || (cdstatus(ourdrive) & CDISPAUSED) )
	{
		cdstop(ourdrive);
		cdreset(ourdrive);

		stopflag = 60;
	}
	else
		cdeject(ourdrive);

	destroyaudiotoc(ourdrive);
}

void disp_num(int x, int y, int num)
{
	int i,j;
	char *ptr1,*ptr2;

	static char numbers[10][12] =
	{
		""
		"  "
		"",
		"  "
		"   "
		"   ",
		""
		""
		"",
		""
		""
		"",
		"  "
		""
		"   ",
		""
		""
		"",
		""
		""
		"",
		""
		"  "
		"   ",
		""
		""
		"",
		""
		""
		""
	};

	if( num > 99 )
		num = 99;

	ptr1 = numbers[num / 10];
	ptr2 = numbers[num % 10];

	for( j = 0; j < 3; j++ )
		for( i = 0; i < 4; i++ )
		{
			outc(  x+i,y+j,*ptr1++);
			outc(5+x+i,y+j,*ptr2++);
		}
}

void cd_display(void)
{
	struct cdtable *cdt;
	int ourdrive;

	struct qchaninfo qci;

	static long lasttime,thistime;

	char *disp_ptr;

	int stat;

	int i,j;

	static char nodisc[] =
		"          "
		"                  "
		"                ";

	static char stopped[] =
		"       "
		"                 "
		"               ";
#ifdef _MSC_VER
	_bios_timeofday(_TIME_GETCLOCK,&thistime);
#else
	thistime = biostime(0,0);
#endif

	if( (thistime > lasttime) && (thistime < (lasttime+5)) )
		return;

	lasttime = thistime;

	ourdrive = getfirstcdrom();
	cdt = createaudiotoc(ourdrive);

	if( stopflag > 1 )
		stopflag--;

	if( (stopflag<2) && (!(isanaudiocd(ourdrive))) )
	{
		disp_ptr = nodisc;

		lasttrack = -1;

		for( i = 0; i < 3; i++ )
			for( j = 0; j < 30; j++ )
				outc(47+j,17+i,*disp_ptr++);

		outc(44,17,32);
		outc(45,17,32);

		for( i = 0; i < 10; i++ )
		{
			outc(47+3*i,21,' ');
			outc(48+3*i,21,' ');
			outc(47+3*i,23,' ');
			outc(48+3*i,23,' ');
		}

		outc(77,22,' ');
		outc(78,22,' ');

		return;
	}

	if( lasttrack == -1 )
	{
		struct discinfo di;

		cddiscinfo(ourdrive,&di);

		lasttrack = di.ltrk;

		if( lasttrack > 0 )
		{
			for( i = 0; i < 10; i++ )
			{
				outc(47+3*i,21,' ');
				outc(48+3*i,21,' ');
				outc(47+3*i,23,' ');
				outc(48+3*i,23,' ');

				if( lasttrack > i )
					outc(48+3*i,21, i==9 ? 48 : i+49);

				if( lasttrack > (i+10) )
				{
					outc(48+3*i,23, i==9 ? 48 : i+49);
					outc(47+3*i,23,'1');
				}
			}

			if( lasttrack >= 10 )
				outc(74,21,'1');

			if( lasttrack >= 20 )
				outc(74,23,'2');

			if( lasttrack > 20 )
			{
				outc(77,22,48+lasttrack/10);
				outc(78,22,48+lasttrack%10);
			}

			stopflag = 0;
		}
		else
			lasttrack = -1;
	}

	if( (stopflag) || !((stat=cdstatus(ourdrive))&CDISPLAYING) && !(stat&CDISPAUSED) )
	{
		disp_ptr = stopped;

		if( !stopflag )
			stopflag = 1;

		for( i = 0; i < 3; i++ )
			for( j = 0; j < 30; j++ )
				outc(47+j,17+i,*disp_ptr++);

		outc(44,17,32);
		outc(45,17,32);

		return;
	}

	outc(62,17,' ');
	outc(62,18,' ');
	outc(62,19,' ');

	outc(67,17,'');
	outc(67,18,'');
	outc(67,19,' ');

	outc(72,17,' ');
	outc(72,18,' ');
	outc(72,19,' ');

	if( stat&CDISPAUSED )
	{
		outc(44,17,'');
		outc(45,17,'');
	}
	else if( stat&CDISPLAYING )
	{
		outc(44,17,32);
		outc(45,17,16);
	}

	cdqchaninfo(ourdrive,&qci);

	disp_num(47,17,(qci.track/16)*10+(qci.track%16));
	disp_num(58,17,qci.min  );
	disp_num(68,17,qci.sec  );

	destroyaudiotoc(ourdrive);
}

void display_window(enum device_list device)
{

	static char windows[3][42] =
	{
		"      "
		"           "
		"      ",

		"      "
		"      "
		"     ",

		"     "
		"         "
		"       "
	};

	int i,j;

	char *cptr;

	cptr = windows[device];

	for( j = 0; j < 3; j++ )
		for( i = 0; i < 14; i++ )
			pokeb(0xB800,(160*(j+12))+(50+2*i),*cptr++);
}

void cd_player(void)
{
	int m1,m2,m3,m4;

	int leave = 0;
	int count;

	int CDok;

	union REGS regset;

	int mx,my;

	char action, cursor = 'A';

	regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
	int86(0x10, &regset, &regset);

	CDok = 1;

	lasttrack = -1;

	if( !ismscdex() )
		CDok = 0;

	if( !getnumcdroms() )
		CDok = 0;

	cdmix_screen(CDok);

	if( CDok )
		cd_display();

	display_window(device);

	volbar( 8,get_level(MIXmaster));
	volbar( 9,get_level(MIXcd));
	volbar(10,get_level(MIXline));
	volbar(11,get_level(MIXmicrophone));

	outn(59,14,((long)get_level(MIXtreble)*107)/255);
	outc(62,14,'%')
	outn(70,14,((long)get_level(MIXbass)*107)/255);
	outc(73,14,'%');

	gotoxy(80,25);

	if( mouse_inst )
	{
		m1 = MOUSE_RESET;
		mouse_call(&m1,&m2,&m3,&m4);

		m1 = SHOW_CURSOR;
		mouse_call(&m1,&m2,&m3,&m4);
	}

	for( m1 = 0; m1 < 2000; m1++ )
		if( CDMIX_REGION[m1] == cursor )
			invert(m1);

	while( !leave )
	{
		m2 = 0;

		action = 0;

		if( mouse_inst )
		{
			m1 = GET_POSITION;
			mouse_call(&m1,&m2,&m3,&m4);
		}
		while( !action )
		{
			if( CDok )
				cd_display();

			if( get_levels(&m1,&m2) )
			{
				vu(m1,8);
				vu(m2,10);

				m2 = 0;
			}

			if( mouse_inst )
			{
				m1 = GET_POSITION;
				mouse_call(&m1,&m2,&m3,&m4);

				if( m2==1 )
				{
					delay(20);
					count++;

                        if( count > 99 )
                             count = -7;       // Delay before repeat
                        else
                             if( count < 5 )   // Repeat rate
                                  m2 = 0;
                             else
                                  count = 0;
				}
				else
					count = 99;
/*				if( m2 )
				{
					gotoxy(0,0);
					printf("%i %i   ",(m3/8),(m4/8));
				}
*/			}

			if( m2 )
			{
				mx = m3 /= 8;
				my = m4 /= 8;

				if( CDMIX_REGION[(80*m4)+m3] != ' ' )
				{
					m1 = HIDE_CURSOR; mouse_call(&m1,&m2,&m3,&m4);

					for( m1 = 0; m1 < 2000; m1++ )
						if( CDMIX_REGION[m1] == cursor )
							invert(m1);

					action = CDMIX_REGION[(80*m4)+m3];

					if( !CDok )
						if( (action > 'L') || (action == '-') )
							action = ' ';
						else
						{
							if( action != '-' )
								cursor = action;
							else
								cursor = 'S';
						}
					else
					{
						if( action != '-' )
							cursor = action;
						else
							cursor = 'S';
					}

					for( m1 = 0; m1 < 2000; m1++ )
						if( CDMIX_REGION[m1] == cursor )
							invert(m1);

					m1 = SHOW_CURSOR; mouse_call(&m1,&m2,&m3,&m4);
				}
			}

			if( kbhit() )
			{
				m2 = getch();
				if( !m2 )
					m2 = getch() + 256;

				if( mouse_inst )
				{
					m1 = HIDE_CURSOR;
					mouse_call(&m1,&m2,&m3,&m4);
				}

				for( m1 = 0; m1 < 2000; m1++ )
					if( CDMIX_REGION[m1] == cursor )
						invert(m1);

				switch( m2 )
				{
					case 256+0x50: cursor++; if( cursor > (CDok ? CDMIX_REGION_END : 'L') ) cursor = 'A'; break;
					case 256+0x48: cursor--; if( cursor < 'A' ) cursor = (CDok ? CDMIX_REGION_END : 'L'); break;

					case ' ':	action = cursor; break;
					case 13 : 	action = cursor; break;
					case 27 :   action = 'A';    break;
				}

				for( m1 = 0; m1 < 2000; m1++ )
					if( CDMIX_REGION[m1] == cursor )
						invert(m1);

				if( mouse_inst )
				{
					m1 = SHOW_CURSOR;
					mouse_call(&m1,&m2,&m3,&m4);
				}

			}
		}

		switch( action )
		{
			case 'A' : leave = 1; break;

			case 'B' : device = CDInput;   set_input(device); display_window(device); break;
			case 'C' : device = LineInput; set_input(device); display_window(device); break;
			case 'D' : device = MicInput;  set_input(device); display_window(device); break;

			case 'E' :
#if 0
				m2 = mix_read(MIXmaster,MIXboth)+(SBtype>3?8:32);
				m2 = min(m2,255);

				mix_write(MIXmaster,MIXboth,m2);

				break;
#else
				m2 = get_level(MIXmaster)+(SBtype>3?8:32);
				m2 = min(m2,255);
				set_level(MIXmaster,m2);
				break;
#endif
			case 'F' :
#if 0
				m2 = mix_read(MIXmaster,MIXboth)-(SBtype>3?8:32);
				m2 = max(m2,0);

				mix_write(MIXmaster,MIXboth,m2);

				break;
#else
				m2 = get_level(MIXmaster)-(SBtype>3?8:32);
				m2 = min(m2,255);
				set_level(MIXmaster,m2);
				break;
#endif

			case 'G' : switch( device )
						  {
							  case CDInput  : m2 = get_level(MIXcd);
													m2 += level_incr(MIXcd);
													break;
							  case LineInput: m2 = get_level(MIXline);
													m2 += level_incr(MIXline);
													break;
							  case MicInput : m2 = get_level(MIXmic);
													m2 += level_incr(MIXmic);
													break;
						  }

						  m2=min(m2,255);

						  switch( device )
						  {
								case CDInput  : set_level(MIXcd  ,m2); break;
								case LineInput: set_level(MIXline,m2); break;
								case MicInput : set_level(MIXmic ,m2); break;
						  }

						  break;

			case 'H' : switch( device )
						  {
							  case CDInput  : m2 = get_level(MIXcd);
													m2 -= level_incr(MIXcd);
													break;
							  case LineInput: m2 = get_level(MIXline);
													m2 -= level_incr(MIXline);
													break;
							  case MicInput : m2 = get_level(MIXmic);
													m2 -= level_incr(MIXmic);
													break;
						  }

						  m2=max(m2,0);

						  switch( device )
						  {
								case CDInput  : set_level(MIXcd  ,m2); break;
								case LineInput: set_level(MIXline,m2); break;
								case MicInput : set_level(MIXmic ,m2); break;
						  }

						  break;

			case 'I' : m2 = get_level(MIXtreble)+level_incr(MIXtreble);
						  m2 = min(m2,255);

						  set_level(MIXtreble,m2);

						  break;

			case 'J' : m2 = get_level(MIXtreble)-level_incr(MIXtreble);
						  m2 = max(m2,0);

						  set_level(MIXtreble,m2);

						  break;

			case 'K' : m2 = get_level(MIXbass)+level_incr(MIXbass);
						  m2 = min(m2,255);

						  set_level(MIXbass,m2);

						  break;

			case 'L' : m2 = get_level(MIXbass)-level_incr(MIXbass);
						  m2 = max(m2,0);

						  set_level(MIXbass,m2);

						  break;

			case 'M' : cd_playpause();  break;
			case 'N' : cd_backtrack();  break;
			case 'O' : cd_fwdtrack();   break;
			case 'P' : cd_backscan();   break;
			case 'Q' : cd_fwdscan();    break;
			case 'R' : cd_stop(); 		 break;

			case 'S' : choose_track();  break;

			case '-' : mx -= 47;
						  mx /= 3;

						  if( my == 21 )
								m2 = 1+mx;
						  else
								m2 = 11+mx;

						  cd_playtrack(m2);	break;

		}

		if( (action >= 'E') && (action <= 'L') )
		{
			volbar( 8,get_level(MIXmaster));
			volbar( 9,get_level(MIXcd));
			volbar(10,get_level(MIXline));
			volbar(11,get_level(MIXmicrophone));

			outn(59,14,((long)get_level(MIXtreble)*107)/255);
			outc(62,14,'%')
			outn(70,14,((long)get_level(MIXbass)*107)/255);
			outc(73,14,'%');
		}

	}

	m1 = HIDE_CURSOR;
	mouse_call(&m1,&m2,&m3,&m4);

	regset.x.ax = 0x0013;
	int86(0x10, &regset, &regset);

	FillLUTBuffer((curpal)%numluts);
}
