// c_interface.h: interface for the c_driver class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(INTERFACE_H)
#define INTERFACE_H
#if defined __BORLANDC__
extern "C" void __stdcall pi_config(bool linear_interpolation, 
									signed long sampling_rate, 
									signed long latency,
									bool loop_allowed,
									bool nnas,
									signed long ramp_length,
									signed long priority_scheme,
									unsigned long feedback_delay,
									double feedback_volume, 
									bool use_reset);
extern "C" void  __stdcall pi_set_latency(signed long latency);
extern "C" void  __stdcall pi_get_module_title(signed long mixer, char *buffer, signed long buffer_length);
extern "C" void  __stdcall pi_unload(signed long mixer);
extern "C" void  __stdcall pi_stop_all();
extern "C" void  __stdcall pi_stop(signed long mixer);
extern "C" void  __stdcall pi_play_all();
extern "C" void  __stdcall pi_play(signed long mixer);
extern "C" signed long  __stdcall pi_load(char *module);
extern "C" void  __stdcall pi_set_mixing_volume(signed long mixer, double mixing_volume_left, double mixing_volume_right, double panning);
extern "C" void  __stdcall pi_rewind_all();
extern "C" void  __stdcall pi_rewind(signed long mixer);
extern "C" void  __stdcall pi_set_feedback_delay(unsigned long feedback_delay);
extern "C" void  __stdcall pi_set_feedback_volume(double feedback_volume);

#else // __BORLANDC__
#ifdef _EXPORTING
   #define CLASS_DECLSPEC    __declspec(dllexport)
#else
   #define CLASS_DECLSPEC    __declspec(dllimport)
#endif

extern "C" void CLASS_DECLSPEC __stdcall pi_config(bool linear_interpolation, 
												   signed long sampling_rate, 
												   signed long latency,
												   bool loop_allowed,
												   bool nnas,
												   signed long ramp_length,
												   signed long priority_scheme,
												   unsigned long feedback_delay,
												   double feedback_volume, 
												   bool use_reset);
extern "C" void CLASS_DECLSPEC __stdcall pi_set_latency(signed long latency);
extern "C" void CLASS_DECLSPEC __stdcall pi_get_module_title(signed long mixer, char *buffer, signed long buffer_length);
extern "C" void CLASS_DECLSPEC __stdcall pi_unload(signed long mixer);
extern "C" void CLASS_DECLSPEC __stdcall pi_stop_all();
extern "C" void CLASS_DECLSPEC __stdcall pi_stop(signed long mixer);
extern "C" void CLASS_DECLSPEC __stdcall pi_play_all();
extern "C" void CLASS_DECLSPEC __stdcall pi_play(signed long mixer);
extern "C" signed long CLASS_DECLSPEC __stdcall pi_load(char *module);
extern "C" void CLASS_DECLSPEC __stdcall pi_set_mixing_volume(signed long mixer, double mixing_volume_left, double mixing_volume_right, double panning);
extern "C" void CLASS_DECLSPEC __stdcall pi_rewind_all();
extern "C" void CLASS_DECLSPEC __stdcall pi_rewind(signed long mixer);
extern "C" void CLASS_DECLSPEC __stdcall pi_set_feedback_delay(unsigned long feedback_delay);
extern "C" void CLASS_DECLSPEC __stdcall pi_set_feedback_volume(double feedback_volume);

#endif // __BORLANDC__

#endif // INTERFACE_H