// c_virtual_channel.h: interface for the c_virtual_channel class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_VIRTUAL_CHANNEL_H__EB69AC62_2087_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_VIRTUAL_CHANNEL_H__EB69AC62_2087_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_virtual_channel  
{
public:
	void set_surround(bool surround) ;
	double pitch_to_speed(double pitch);
	double pitch_to_amiga(double pitch, signed long sample);
	double amiga_to_pitch(double amiga_value, signed long sample);
	double speed_to_pitch(double speed);
	void reset_second_pitch() ;
	void reset_second_panning() ;
	void reset_second_volume() ;
	void reset_volume();
	void set_note_volume(double note_volume);
	double get_note_volume();
	void slide_note_volume(signed long slide_value);
	void multiply_note_volume(double mul_value);
	void set_volume(double volume, double panning);
	signed long m_ramp_length;
	bool fill_buffer(double * buffer, double * end);
	void set_pitch(double);
	void init(signed long real_channel);
	bool update_frame(bool frame_0);
	void clear_playing();
	void set_playing();
	void set_sample_offset(unsigned long);
	void update_volume();
	void new_note(signed long instrument, signed long note);
	void note_off();
	void note_fade();
	void note_cut();
	void set_channel_panning(double panning);
	c_virtual_channel(p_mixer mixer, p_module module);
	virtual ~c_virtual_channel();

	// inline access functions
	bool is_playing()  { return m_playing ; }
	bool is_in_background()  { return m_in_background ; }
	void set_in_background()  { m_in_background = true ; }
	signed long get_real_channel()  { return m_real_channel ; }
	void set_fade_on()  { m_fade_on = true ; }
	void set_volume_envelope(bool value) ;
	void set_second_volume(double volume);
	void slide_second_volume(double slide_value) ;
	void slide_second_panning(double slide_value) ;
	void slide_second_pitch(double slide_value, bool linear) ;

private:
	bool ping_pong_mix_v_ramp(double* &buffer, 
		double* &end, 
		signed short *loop_beginning, 
		signed short *loop_end);
	void ping_pong_mix(double* &buffer, 
		double* &end, 
		signed short *loop_beginning, 
		signed short *loop_end);
	bool forward_mix_v_ramp(double* &buffer, 
		double* &end, 
		signed short *loop_beginning, 
		signed short *loop_end);
	void forward_mix(double* &buffer, 
		double* &end, 
		signed short *loop_beginning, 
		signed short *loop_end);
	bool no_loop_mix_v_ramp(double* &buffer, 
		double* &end, 
		signed short *sample_end);
	bool no_loop_mix(double* &buffer, 
		double* &end, 
		signed short *sample_end);
	bool no_lin_ping_pong_mix_v_ramp(double* &buffer, 
		double* &end, 
		p_coefs loop_beginning, 
		p_coefs loop_end);
	void no_lin_ping_pong_mix(double* &buffer, 
		double* &end, 
		p_coefs loop_beginning, 
		p_coefs loop_end);
	bool no_lin_forward_mix_v_ramp(double* &buffer, 
		double* &end, 
		p_coefs loop_beginning, 
		p_coefs loop_end);
	void no_lin_forward_mix(double* &buffer, 
		double* &end, 
		p_coefs loop_beginning, 
		p_coefs loop_end);
	bool no_lin_no_loop_mix_v_ramp(double* &buffer, 
		double* &end, 
		p_coefs sample_end);
	bool no_lin_no_loop_mix(double* &buffer, 
		double* &end, 
		p_coefs sample_end);
	double m_instrument_note;
	double get_pitch_panning();
	void update_pitch_envelope();
	double m_channel_panning;
	double m_channel_volume;
	double note_to_pitch(double pitch);
	bool m_use_default_panning;
	void update_panning_envelope();
	bool update_volume_envelope();
	void update_vibrato();
	double get_waveform_value(signed long index, signed long waveform);
	
	/* these fields describe the status of the channel */
	bool m_playing ; /* true = channel playing, false = channel not playing anymore */
	bool m_in_background ; /* true = channel is a real channel, false = channel is a virtual channel */
	signed long m_real_channel ; 
	
	/* these fields describe the datas of the channel */
	signed long m_instrument;
	signed long m_sample ;
	
	bool m_sustain_on ;
	bool m_fade_on ;
	
	double m_final_volume_left ;
	double m_final_volume_right ;
	double m_volume_left ;
	double m_volume_right ;
	
	double m_delta_volume_left ;
	double m_delta_volume_right ;
	
	signed long m_ramp_position ;
	
	bool m_new_sample_on ; /* true = an up volume ramping must be done */
	bool m_ending_sample_on ; /* true = a down volume ramping must be done. When 0 is reached, the channel is dropped */
	
	double m_note_volume ;
	
	double m_volume ;
	double m_panning ;
	double m_pitch;

	double m_second_volume ;
	double m_second_panning ;
	double m_second_pitch;
	
	double m_current_vibrato_depth ;
	signed long m_vibrato_time ;
	signed long m_vibrato_position ;
	
	signed long m_fade_component ;
	
	/* these fields concern the envelopes */
	signed long m_volume_envelope_tick ;
	double m_volume_envelope_value ;
	bool m_end_of_volume_envelope ;
	bool m_volume_envelope_on;

	signed long m_panning_envelope_tick ;
	double m_panning_envelope_value ;
	bool m_end_of_panning_envelope ;
	
	signed long m_pitch_envelope_tick ;
	double m_pitch_envelope_value ;
	bool m_end_of_pitch_envelope ;
	
	/* these fields show the mixing state of the channel */
	const signed short *m_sample_data ;
	const coefs *m_coefs ;
	bool m_use_linear_interpolation ;
	
	signed long m_frac_position ;
	signed long m_step_length ;
	
	signed long m_direction ;
	
	p_mixer m_mixer ;
	p_module m_module ;

	static const double m_amiga_const ; 
	static const double m_log2_const ;
	static const double m_sin_cst ;

	bool m_surround_on ;
};


#endif // !defined(AFX_C_VIRTUAL_CHANNEL_H__EB69AC62_2087_11D1_B35E_DCE971BF2962__INCLUDED_)
