// c_real_channel.h: interface for the c_real_channel class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_REAL_CHANNEL_H__EB69AC61_2087_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_REAL_CHANNEL_H__EB69AC61_2087_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_real_channel  
{
public:
	void clear_playing();
	void init();
	void update_frame(bool frame_0);
	void set_virtual_channel(signed long virtual_channel);
	c_real_channel(p_mixer mixer, p_module module, signed long channel, signed long volume, signed long panning);
	virtual ~c_real_channel();
	bool update_line(bool flag, bool just_read);
	bool set_muted(bool muted);
	void new_pattern();

private:
	bool apply_arpeggio();
	bool apply_retrigger();
	void arpeggio();
	void retrigger();
	double get_waveform_value(signed long index, signed long waveform);
	signed long m_panning_slide_value;
	void clear_effects();
	void set_pitch_slide_value(double slide_value);
	double speed_to_note(double speed);
	double note_to_speed(double note);
	double amiga_to_note(double amiga_value, signed long sample);
	double note_to_amiga(double note, signed long sample);
	bool slide_pitch(double slide_value);
	signed long m_channel_volume_slide_value;
	signed long m_channel_volume_slide;
	void set_panning_slide_value(signed long slide_value);
	void slide_panning(signed long slide_value);
	void set_volume_slide_value(signed long slide_value);
	void slide_volume(signed long slide_value);
	void set_channel_volume_slide_value(signed long slide_value);
	void slide_channel_volume(signed long slide_value);
	void set_sample_offset();
	bool pitch_slide_up();
	bool pitch_slide_down();
	void volume_slide();
	void pitch_slide_to_note(bool new_note, bool instrument_changed, signed long previous_note);
	void set_panning();
	void panning_slide();
	void channel_volume_slide();
	void set_channel_volume();
	void loop(signed long loop_param);

	double m_pitch_slide_value;
	signed long m_channel ;
	bool m_muted ;
	bool m_playing ;
	signed long m_mask_variable ;
	signed long m_instrument ;
	signed long m_sample ;
	signed long m_note ;
	double m_note_volume ;
	double m_sample_note ;
	signed long m_volume_panning ;
	signed long m_command ;
	signed long m_command_value ;
	bool m_effect_update ;
	double m_volume ;
	double m_panning ;
	signed long m_default_volume ;
	signed long m_default_panning ;
	bool m_default_muted_flag ;
	signed long m_volume_slide_value;
	signed long m_volume_slide ;
	signed long m_panning_slide ;
	signed long m_pitch_slide ;
	double m_pitch_slide_note ;
	signed long m_pitch_slide_speed ;
	signed long m_new_note_action ;
	signed long m_duplicate_check_type ;
	signed long m_duplicate_check_action ;

	signed long m_vibrato_waveform ;
	bool m_vibrato_on ;
	signed long m_vibrato_speed ;
	double m_vibrato_depth ;
	signed long m_vibrato_position ;
	signed long m_vibrato_time ;
	void vibrato() ;
	void apply_vibrato() ;

	signed long m_tremelo_waveform ;
	bool m_tremelo_on ;
	signed long m_tremelo_speed ;
	double m_tremelo_depth ;
	signed long m_tremelo_position ;
	signed long m_tremelo_time ;
	void tremelo() ;
	void apply_tremelo() ;

	signed long m_panbrello_waveform ;
	bool m_panbrello_on ;
	signed long m_panbrello_speed ;
	double m_panbrello_depth ;
	signed long m_panbrello_position ;
	signed long m_panbrello_time ;
	void panbrello() ;
	void apply_panbrello() ;

	signed long m_tremor_offtime ;
	signed long m_tremor_ontime ;
	bool m_tremor_on ;
	signed long m_tremor_time ;
	void tremor() ;
	void apply_tremor() ;

	signed long m_virtual_channel ;
	p_mixer m_mixer ;
	p_module m_module ;
	static const double m_amiga_const ;
	static const double m_log2_const ;
	static const double m_sin_cst ;

	bool m_arpeggio_on ;
	signed long m_arpeggio_counter ;
	signed long m_arpeggio_offset_1 ;
	signed long m_arpeggio_offset_2 ;
	bool m_retrigger_on ;
	signed long m_retrigger_counter ;
	signed long m_retrigger_delay ;
	signed long  m_retrigger_add ;
	double m_retrigger_mul ;

	bool m_surround_on ;

	signed long m_loop_begin ;
	signed long m_loop_counter ;
};

#endif // !defined(AFX_C_REAL_CHANNEL_H__EB69AC61_2087_11D1_B35E_DCE971BF2962__INCLUDED_)
