// c_envelope_node_inline.h: implementation of the c_envelope_node class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_ENVELOPE_NODE_INLINE_H__2691C102_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_ENVELOPE_NODE_INLINE_H__2691C102_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

c_envelope_node::c_envelope_node(signed long tick, signed long y_value)
{
	m_tick = tick ;
	m_y_value = y_value ;
}

c_envelope_node::c_envelope_node(FILE *module_file, bool signed_node)
{
	if (signed_node)
	{
		unsigned short tick ;
		signed char y_value ;

		(void) fread (&y_value, (size_t) 1, (size_t) 1, module_file) ;
		(void) fread (&tick, (size_t) 2, (size_t) 1, module_file) ;
			
		m_tick = (signed long)tick ;
		m_y_value = (signed long)y_value ;
	}
	else
	{
		unsigned short tick ;
		signed char y_value ;

 		(void) fread (&y_value, (size_t) 1, (size_t) 1, module_file) ;
		(void) fread (&tick, (size_t) 2, (size_t) 1, module_file) ;
			
		m_tick = (signed long)tick ;
		m_y_value = (signed long)y_value ;
	}
}

c_envelope_node::c_envelope_node(istream &is, bool signed_node)
{
	if (signed_node)
	{
		unsigned short us ;
		signed char sc ;

		is.read((char *)&sc, 1) ;
		m_y_value = (signed long)sc ;
		is.read((char *)&us, 2) ;
		m_tick = (signed long)us ;
	}
	else
	{
		unsigned short us ;
		unsigned char uc ;

		is.read((char *)&uc, 1) ;
		m_y_value = (signed long)uc ;
		is.read((char *)&us, 2) ;
		m_tick = (signed long)us ;
	}
}

c_envelope_node::~c_envelope_node()
{
	// nothing to be done here : no dynamic data
}


signed long c_envelope_node::get_y_value()
{
	return m_y_value ;
}

signed long c_envelope_node::get_tick()
{
	return m_tick ;
}

#endif // AFX_C_ENVELOPE_NODE_INLINE_H__2691C102_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_