// c_mixer.h: interface for the c_mixer class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_MIXER_H__F7DA69C2_206F_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_MIXER_H__F7DA69C2_206F_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_mixer  
{
public:
	p_module get_module();
	void set_ramp_length(signed long ramp_length);
	signed long get_ramp_length();
	signed long get_current_line ();
	double get_constant_volume_left();
	double get_constant_volume_right();
	double get_constant_panning();
	bool fill_buffer(double *buffer, 
		unsigned long buffer_length,
		signed long &order,
		signed long &line);
	void set_new_note_actions(bool nnas);
	void set_loop_allowed(bool loop_allowed);
	void set_mixing_volume(double mixing_volume_left, double mixing_volume_right, double panning);
	void set_sampling_rate(signed long sampling_rate);
	void set_order(signed long order, signed long line);
	void drop_active_channel(p_real_channel active_channel);
	void add_active_channel(p_real_channel active_channel);
	signed long m_jump_to_line;
	void past_note_fade(signed long channel);
	void past_note_off(signed long channel);
	void past_note_cut(signed long channel);
	void global_volume_slide(signed long command_value);
	void set_global_volume(signed long global_volume);
	void set_tempo(signed long tempo);
	void pattern_break(signed long line);
	void jump_to_order(signed long order);
	void loop_to_line(signed long line);
	void set_speed(signed long speed);
	bool are_new_note_actions_activated();
	signed long allocate_virtual_channel(signed long real_channel);
	void drop_virtual_channel(signed long virtual_channel);
	signed long get_pattern_data();
	p_virtual_channel get_virtual_channel(signed long virtual_channel);
	void new_pattern (signed long line);
	void new_frame();
	void new_line();
	c_mixer(char *module_file_name, 
		signed long sampling_rate, 
		double mixing_volume,
		bool loop_allowed,
		bool nnas,
		signed long ramp_length,
		bool linear_interpolation);
	virtual ~c_mixer();

private:
	signed long m_global_volume_slide;
	void set_global_volume_slide_value(signed long slide_value);
	signed long m_ramp_length;
	unsigned long m_current_sample;
	signed long m_order_played;
	signed long m_line_played;
	double m_mixing_volume_left;
	double m_mixing_volume_right;
	double m_mixing_panning ;
	double m_sampling_rate;
	bool m_pattern_jump;
	bool m_pattern_break;
	unsigned long m_samples_per_minute;
	unsigned long m_samples_per_frame;
	unsigned long m_beats_per_minute;
	signed long m_global_volume;
	bool m_new_note_actions_activated;
	bool m_last_order;
	bool m_loop_allowed;
	void slide_global_volume(signed long slide_value);
	signed long m_frames_per_line;
	void clear_active_channels();
	signed long m_global_volume_slide_value;
	bool m_last_frame;
	bool m_last_line;
	signed long m_current_frame;
	signed long m_current_line;
//	signed long m_current_pattern;
	signed long m_current_order;
	bool m_loop ;
	signed long m_loop_to_line ;
	p_module m_module;
	p_virtual_channel m_virtual_channels[256] ;
	signed long m_virtual_channels_counter ;
	p_real_channel m_real_channels[64] ;
	p_real_channel m_active_channels[64] ;
	p_pattern m_pattern ;
	signed long m_pattern_position ;
	signed long m_active_channels_counter ;
	static const signed long m_frames_per_beat ;
	static const double m_volume_divisor ;
	bool m_init ;
};

#endif // !defined(AFX_C_MIXER_H__F7DA69C2_206F_11D1_B35E_DCE971BF2962__INCLUDED_)
