;****************************************************************************
;*	Module contenant des fonctions DOS de base pour lire un overlay
;*	ATTENTION toutes ces fonctions sont de type NEAR
;*
;* Programm par Sbastien Granjoux
;* Commenc le 19/02/95
;* Modification le 19/02/95

IDEAL

INCLUDE "CRYSLOAD.INC"

PUBLIC	USEOVL

SEGMENT CSEG PARA PUBLIC USE16 'CODE'

ASSUME	cs:CSEG

UseOvl:
	FILESYS <OFFSET openovl,OFFSET closeovl,OFFSET seekovl,OFFSET readovl>

Handle	DW	-1

;***************************************************************************
;*	Ouvre un fichier en mode lecture, ATTENTION il ne peut y avoir
;*	qu'un seul fichier ouvert en mme temps
;*
;* Entre:
;*	DS:DX	position dans l'overlay du fichier
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	openovl

	mov	ah,51h
	int	21h
	jc	@@error
	push	dx
	push	ds
	push	es
	push	di
	mov	ds,bx
	mov	ax,[ds:2Ch]
	mov	ds,ax
	mov	es,ax
	xor	di,di
	mov	cx,0ffffh
	xor	al,al
@@next_envstr:
	repne	scasb
	scasb
	jne	@@next_envstr
	scasw
	mov	dx,di
	pop	di
	pop	es
	mov    	ax,3d00h
	int	21h
	pop     cx
	pop     dx
	jc	@@error
	mov	[cs:Handle],ax
	mov	bx,ax
	mov	ax,4200h
	int	21h
@@error:
	ret
ENDP

;***************************************************************************
;*	Lit un block d'octet dans un overlay prcdament ouvert
;*
;* Entre:
;*	CX	nombre d'octet  lire
;*	DS:DX	adresse du buffer recevant les donnes
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	readovl

	mov	bx,[cs:Handle]
	mov	ah,3Fh
	int	21h
	ret

ENDP

;***************************************************************************
;*	Se dplace dans l'overlay par rapport  la position courante
;*
;* Entre:
;*      CX:DX	nouvelle position dans l'overlay
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	seekovl

	mov	ax,4201h
	mov	bx,[cs:Handle]
	int	21h
	ret

ENDP

;***************************************************************************
;*	Ferme l'overlay ouvert prcdament
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	closeovl

	mov	ah,3eh
	mov	bx,[cs:Handle]
	int	21h
	ret

ENDP

ENDS

END
