#include <iostream.h>
#include <fstream.h>
#include <dos.h>
#include <sys\stat.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <unistd.h>

#define byte unsigned char
#define word unsigned int
#define dword long unsigned int

dword verts_in_wrl(char infile[]);
dword faces_in_wrl(char infile[]);
void seek_past(char what[], ifstream& infile);

int main()
{
    ifstream wrl;
    int file_3d;

	char infile[256];
	char outfile[256];

	char token[1024];

    char coords[16] = "Coordinate3";
    char faces[16] = "IndexedFaceSet";
    char bracket[16] = "[";

    char inchar;

    const float fzero = 0.0;

    float x, y, z;

    const dword zero = 0;

    dword obj_verts = 0;
    dword verts_done = 0;
    dword num_verts, num_faces, index, con1, con2, con3, normal;
    int inint;

	cout << "Input file   : ";
	cin >> infile;
	cout << "Output file  : ";
	cin >> outfile;

    wrl.open(infile);
    if(wrl.fail())
	{
		cout << "Error opening input file " << infile << endl;
		return 1;
	}

	_fmode = O_BINARY;
    file_3d = creat(outfile, S_IREAD | S_IWRITE);

    num_verts = verts_in_wrl(infile);
    cout << "Number of verts in .wrl: "<< num_verts << endl;
    num_faces = faces_in_wrl(infile);
    cout << "Number of faces in .wrl: "<< num_faces << endl;

    write(file_3d, &num_verts, 4);
    write(file_3d, &num_faces, 4);

    seek_past(coords, wrl);
    seek_past(bracket, wrl);
    for(index = 0; index < num_verts; index++)
    {
        wrl >> x >> y >> z >> inchar;
        x *= 500.0;
        y *= 500.0;
        z *= 500.0;
        write(file_3d, &x, 4);
        write(file_3d, &y, 4);
        write(file_3d, &z, 4);
        write(file_3d, &fzero, 4);
    }

    seek_past(faces, wrl);
    seek_past(bracket, wrl);
    for(index = 0; index < num_faces; index++)
    {
        wrl >> con1 >> inchar >> con2 >> inchar >> con3 >> inchar >> inint >> inchar;
        con1 *= 16;
        con2 *= 16;
        con3 *= 16;
        write(file_3d, &con1, 4);
        write(file_3d, &con2, 4);
        write(file_3d, &con3, 4);

        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);

        normal = index * 16;
        write(file_3d, &normal, 4);

        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);
        write(file_3d, &fzero, 4);
    }

    write(file_3d, &fzero, 4);
    write(file_3d, &fzero, 4);

    close(file_3d);
    wrl.close();
    return 0;

/*
	for(;;)
	{
        seek_past(coords, wrl);
        seek_past(vertices, wrl);
        wrl >> obj_verts;

        seek_past(vertexlist1, wrl);
        seek_past(vertexlist2, wrl);

        for(index = 0; index < obj_verts; index++)
        {
            seek_past(vertex, wrl);
            wrl >> token >> token >> x >> token
                >> y >> token >> z;
            write(file_3d, &x, 4);
            write(file_3d, &y, 4);
            write(file_3d, &z, 4);
            write(file_3d, &fzero, 4);
        }
        verts_done += obj_verts;
        if(verts_done == num_verts)
            break;
	}

    wrl.close();
    wrl.open(infile);

    dword obj_faces = 0;
    dword faces_done = 0;

    obj_verts = verts_done = 0;

	for(;;)
	{
        seek_past(object, wrl);
        seek_past(vertices, wrl);
        wrl >> obj_verts;
        seek_past(faces, wrl);
        wrl >> obj_faces;

        seek_past(facelist1, wrl);
        seek_past(facelist2, wrl);

        for(index = 0; index < obj_faces; index++)
        {
            seek_past(face, wrl);
            wrl >> token >> inchar >> inchar >> con1
                >> inchar >> inchar >> con2 >> inchar
                >> inchar >> con3;

            con1 += verts_done;
            con2 += verts_done;
            con3 += verts_done;
            con1 *= 16;
            con2 *= 16;
            con3 *= 16;
            write(file_3d, &con1, 4);
            write(file_3d, &con2, 4);
            write(file_3d, &con3, 4);

            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);

            normal = (index + faces_done) * 16;
            write(file_3d, &normal, 4);

            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
            write(file_3d, &fzero, 4);
        }
        verts_done += obj_verts;
        faces_done += obj_faces;
        if(faces_done == num_faces)
            break;
	}

    wrl.close();
    close(file_3d);
	return 0;
*/
}

dword verts_in_wrl(char infile[])
{
    ifstream wrl;
    char fred;
    char coords[16] = "Coordinate3";
    dword file_verts = 0;

    wrl.open(infile);
    if(wrl.fail())
	{
		cout << "Error opening input file " << infile << endl;
                return 0;
	}

    seek_past(coords, wrl);

	for(;;)
	{
        if(!(wrl >> fred))
			break;
                if(fred == ']') break;
                if(fred == ',') file_verts++;
	}
    file_verts++;
    wrl.close();
    return file_verts;
}

dword faces_in_wrl(char infile[])
{
    ifstream wrl;
    char fred;
    char faces[16] = "IndexedFaceSet";
    dword file_faces = 0;

    wrl.open(infile);
    if(wrl.fail())
	{
		cout << "Error opening input file " << infile << endl;
                return 0;
	}

    seek_past(faces, wrl);

	for(;;)
	{
        if(!(wrl >> fred))
			break;
                if(fred == ']') break;
                if(fred == '-') file_faces++;
	}
    wrl.close();
    return file_faces;
}

void seek_past(char what[], ifstream& infile)
{
    char token[1024];

    if(!( infile >> token)) return;
    while(strcmp(token, what) != 0)
    {
        if(!(infile >> token)) return;
    }

    return;
}
