;       TINYPCX.ASM
;
;       Quite possibly the smallest PCX viewer out there. (164 bytes)
;       (Views only 320x200x256 images, and performs no error checking.)
;
;       Sugar Less (Paul Wroblewski)
;       09/10/96

.model  tiny
.code
.startup
        mov  bx,  80h                   ; get ASCIIZ file name
        mov  dx,  82h
        mov  al,  byte ptr es:[bx]
        inc  al
        add  bx,  ax
        mov  byte ptr es:[bx], 0
        mov  ax, 03d00h
        int  21h                        ; open file
        jnc  Start
        ret
Start:
        mov  bx,  ax                    ; bx = file handle
        mov  ax,  0a000h
        mov  es,  ax                    ; es = video mem
        mov  di,  0fa01h
        mov  ax,  13h
        int  10h                        ; init vga mode 13h
        mov  ah,  42h                   ; seek to eof-768
        xor  cx,  cx                    ; (there may be a better way to
        xor  dx,  dx                    ; do this..)
        mov  al,  2
        int  21h
        sub  ax,  300h
        xor  cx,  cx
        mov  dx,  ax
        mov  ah,  42h
        mov  al,  0
        int  21h
        mov  cx,  300h                  ; load pcx palette
        push di
Loop0:
        push cx
        call GetByte
        shr  al,  2
        stosb
        pop  cx
        loop Loop0
        pop  dx
        push bx
        mov  ax,  1012h
        xor  bx,  bx
        mov  cx,  100h
        int  10h
        pop  bx
        mov  ah,  42h                   ; seek to start of pcx image
        xor  cx,  cx
        mov  dx,  80h
        mov  al,  0h
        int  21h
        xor  di,  di
Loop1:                                  ; show pcx image
        call GetByte
        and  al,  0c0h
        cmp  al,  0c0h
        mov  al,  B
        je   Run
        stosb
        jmp  Cont
Run:
        sub  al,  0c0h
        push ax
        call GetByte
        pop  cx
        rep  stosb
Cont:
        cmp  di,  0fa00h
        jb   Loop1
        mov  ah,  3eh                   ; close file
        int  21h
        mov  ah,  00h                   ; read a key
        int  16h
        mov  ax,  03h                   ; init text mode 03h
        int  10h
        ret
GetByte:                                ; get one byte from file
        lea  dx,  B
        mov  ah,  3Fh
        mov  cx,  1
        int  21h
        mov  al,  B
	ret

B       db      ?

end
