/*
   bin2pal.c (Binary to Palette) by pneyz/Smoof (pneyz@herbanisation.com)
   This code was done early on 11/23/97. For public consumption.

   This converts a raw data file into a C/C++ array of the type used in
   Denthor's VGA Trainer Program. The infile must be at least 768 (256*3)
   bytes. If it's longer, only the first 768 bytes will be used. It outputs
   to stdout so use redirection to write to a file. If you want to modify it
   to write to a file, open an outfile and replace the printf statements with
   fprintf(outfile,...);.

   Naturally, the source is 100% unix compatible. Anything else would be
   uncivilized. Compile with 'gcc -o bin2pal bin2pal.c'

   To use the generated array, #include the outfile and execute the following
   rountine with arrayname as the parameter. It assumes you use setpal to
   change the palette. Modify that if you don't.

   void loadpal (unsigned char pal[256][3])
   {
    for (int loop1 = 0; loop1 < 256; loop1++)
        setpal(loop1,pal[loop1][0],pal[loop1][1],pal[loop1][2]);
   }

*/

/*---- includes, defines, prototypes & global variables -------------------*/

#include <stdio.h>
#include <string.h>

unsigned long int flen (FILE *work);
void showhelp (void);

char title[] = "bin2pal 1.0.0 by pneyz/Smoof (pneyz@herbanisation.com)";

/*---- main function ------------------------------------------------------*/

void main (int argc, char *argv[])
{
 FILE *infile;
 unsigned char temp[1];

 if (!strcmp(argv[1],"-h") || !strcmp(argv[1],"--help")) {
    showhelp();
    return; }

 if (argc < 3) {
    printf("%s\n",title);
    printf("usage: bin2pal infile arrayname > outfile\n");
    printf("bin2pal -h for help.\n");
    return; }

 if (!(infile = fopen(argv[1], "rb"))) {
    printf("%s: could not open infile for some reason.\n",argv[1]);
    return; }

 if (flen(infile) < 768) {
    printf("%s: file is shorter than 786 bytes.\n");
    return; }

 printf("// generated by %s\n\n",title);
 printf("unsigned char %s[256][3] =\n{\n",argv[2]);

 for (int loop1 = 1; loop1 < 257; loop1++) {
     printf(" {");
     for (int loop2 = 0; loop2 < 3; loop2++) {
         fread(temp,1,1,infile);
         printf("0x%02x",*temp);
         if (loop2 != 2) printf(",");
     }
     printf("}");
     if (loop1 != 256) printf(",");
     if (!(loop1 % 4)) printf("\n");
 }
 printf("};");
 fclose(infile);
 return;
}

/*---- flen() : returns the file length in bytes --------------------------*/

unsigned long int flen(FILE *work)
{
 unsigned long int oldpos = ftell(work), curpos;

 fseek(work,0,2);
 curpos = ftell(work);
 fseek(work,oldpos,0);
 return curpos;
}

/*---- showhelp() : commandline help screen -------------------------------*/

void showhelp (void)
{
 printf("%s  -  11/22/97\n",title);
 printf("usage: bin2pal [-h] infile arrayname > outfile\n\n");
 printf(" -h --help   display this help screen.\n");
 printf(" infile      raw data file to read in.\n");
 printf(" arrayname   C/C++ array to create.\n");
 printf(" outfile     file to write to (if ommited, use stdout)\n\n");
 printf("(c)1997 Smoof Team, all rights reserved. Compiled on %s at %s.\n",__DATE__,__TIME__);
 return;
}
