; VIDEO Routines   Ver 1.30

; these PROCs are used for all grafix stuff like:setpal,mouse,gprintf,etc.

; Supports :
; - VGA 
; - VESA Ver 1.2 and 2.0
; - modeX

; To be supported :
; - DirectX

include qlib.inc
include dos.inc
include video.inc
include vesa.inc
include string.inc
include stdlib.inc
include stdio.inc

.data
align 4
exitmode dd NULLPROC ;this is called when ever a new mode is being switched to
_v_buffer dd 0    ;where everything is put/get from  ,this is set by gset()
_v_linear dd 0b8000h
               ;set to 0a0000h for VGA mode (13h)
               ;set to 0b8000h for Text mode (3h)
_v_x dd 80     ;X
_v_xb dd 0     ;X*bypp
_v_y dd 25     ;Y
_v_bpsl dd 0   ;bytes/scan line
_v_bpp dd 0    ;bits/pixel
_v_bypp dd 0   ;bytes/pixel
_v_xbpsl dd 0  ;extra bytes/scan line  ( bpsl-(x*bypp) )
_v_mode db 1   ;mode
 ; 1 = Text mode
 ; 2 = VGA mode
 ; 3 = VESA mode
 ; 4 = modeX mode
 ; 5 = DirectX mode (not yet implemented)

;info for current mode
curmode db G_TEXT  ;current mode type
banking db 0  ;using Vesa Banking mode

;info for getmode()
getmode db 0  ;g_getmode() last successful mode info
getmode_x dw 0
getmode_y dw 0
getmode_bpp db 0
getmode_banking db 0

include v-vesa.asm
include v-modex.asm
include v-mouse.asm

.code
align 4
g_getmode proc,x:word,y:word,bpp:byte
  ;try VGA 1st
  pushad
  .if x==320 && y==200 && bpp==8
    mov eax,G_VGA
    jmp ok
  .endif
  ;try VESA
  call vesa_init
  .if eax!=ERROR
    callp vesa_getmode,x,y,bpp
    .if eax!=ERROR
      .if !eax
        mov getmode_banking,1
      .else
        mov getmode_banking,0
      .endif
      mov eax,G_VESA
      jmp ok
    .endif
  .endif
  ;try modeX
  .if bpp!=8
bad:
    popad
    mov eax,ERROR
    ret
  .endif
  callp modex_getmode,x,y
  .if eax==ERROR
    jmp bad
  .endif
  mov eax,G_MODEX
ok:
  mov [esp].callstruct._eax,eax  ;save EAX for popad
  mov getmode,al
  mov ax,x
  mov getmode_x,ax
  mov ax,y
  mov getmode_y,ax
  mov al,bpp
  mov getmode_bpp,al
  popad
  ret
g_getmode endp

align 4
g_setmode proc
  pushad
  .if !getmode
bad:
    popad
    mov eax,ERROR
    ret
  .endif
  .if getmode==G_VGA
    call exitmode
    mov _v_x,320
    mov _v_y,200
    mov _v_xb,320
    mov _v_bpsl,320
    mov _v_bypp,1
    mov _v_xbpsl,0
    mov _v_linear,0a0000h
    mov ax,13h
    int 10h
    mov curmode,G_VGA
    popad
    xor eax,eax
    ret
  .endif
  .if getmode==G_VESA
    call exitmode
    call vesa_setmode
    mov curmode,G_VESA
    mov al,getmode_banking
    mov banking,al
    popad
    xor eax,eax
    ret
  .endif
  .if getmode==G_MODEX
    call exitmode
    call modex_setmode
    mov curmode,G_MODEX
    popad
    xor eax,eax
    ret
  .endif
  jmp bad 
g_setmode endp

align 4
;TEXT set mode
; Supports : (80x25) and (80x50)
t_setmode proc,x:byte,y:byte
  pushad
  call exitmode
  mov _v_linear,0b8000h
  mov curmode,G_TEXT
  mov _v_x,80
  mov _v_y,25
  mov ax,3
  int 10h
  .if x==80 && y==50
    mov _v_y,50
    call setmode50
  .endif
  popad
  xor eax,eax
  ret
t_setmode endp

align 4
g_waitvsync proc uses edx
  mov dx,3dah
@@:
  in al,dx
  test al,8
  jnz @b
@@:
  in al,dx
  test al,8
  jz @b
  xor eax,eax
  ret
g_waitvsync endp

;copys _v_buffer to video RAM
align 4
g_copy proc
  pushad

  .if (mouse_con)
    cli
    mov m_paws,1
    call _print
    sti
  .endif

  .if curmode == G_MODEX
    call modex_copy
    jmp done
  .endif

  .if curmode==G_VESA && banking
    callp vesa_setbank,0
    mov ecx,_v_xb
    mov ebx,_v_y
    mov edi,_v_linear
    mov esi,_v_buffer
    mov edx,64*1024 ;when this reaches 0 then we must switch to next bank
    .if (_v_xbpsl)
      ;copy a scan line
@@:
      .if edx<ecx
        push ecx
        mov ecx,edx  ;use rest of bank
        mov al,cl
        shr ecx,2
        rep movsd
        mov cl,al
        and cl,3
        rep movsb
        mov edi,_v_linear
        pop ecx
        sub ecx,edx
        mov edx,64*1024
        callp vesa_nextbank
        sub edx,ecx
        mov al,cl
        shr ecx,2
        rep movsd
        mov cl,al
        and cl,3
        rep movsb
      .else
        sub edx,ecx
        mov al,cl
        shr ecx,2
        rep movsd
        mov cl,al
        and cl,3
        rep movsb
      .endif
      mov ecx,_v_xb
      .if edx<_v_xbpsl
        callp vesa_nextbank
        mov edi,_v_linear
        mov eax,_v_xbpsl
        sub eax,edx
        mov edx,64*1024
        sub edx,eax
        add edi,eax
      .else
        sub edx,_v_xbpsl
        add edi,_v_xbpsl
      .endif
      dec ebx
      jnz @b
    .else
      ;copy a scan line
@@:
      .if edx<ecx
        push ecx
        mov ecx,edx  ;use rest of bank
        rep movsb
        mov edi,_v_linear
        pop ecx
        sub ecx,edx
        mov edx,64*1024
        call vesa_nextbank
        sub edx,ecx
        mov al,cl
        shr ecx,2
        rep movsd
        mov cl,al
        and cl,3
        rep movsb
      .else
        sub edx,ecx
        mov al,cl
        shr ecx,2
        rep movsd
        mov cl,al
        and cl,3
        rep movsb
      .endif
      mov ecx,_v_xb
      dec ebx
      jnz @b
    .endif
    jmp done
  .endif

  .if _v_xbpsl
    mov ecx,_v_xb
    mov ebx,_v_y
    mov edi,_v_linear
    mov esi,_v_buffer
@@:
    mov al,cl     ;opt it here!
    shr ecx,2
    rep movsd
    and al,3
    .if al
      mov cl,al
      rep movsb
    .endif
    mov ecx,_v_xb
    add edi,_v_xbpsl
    dec ebx
    jnz @b
  .else   ;linear mode!
    mov eax,_v_xb
    mul _v_y
    mov ecx,eax
    mov edi,_v_linear
    mov esi,_v_buffer
    mov al,cl
    shr ecx,2
    rep movsd
    and al,3
    .if al
      mov cl,al
      rep movsb
    .endif
  .endif

done:
  .if (mouse_con)
    cli
    callp erase,1
    mov m_paws,0
    sti
  .endif

  popad
  ret
g_copy endp

align 4
g_get proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local xl:dword,yl:dword

  pushad

  mov eax,x2
  sub eax,x1
  inc eax
  mov xl,eax

  mov eax,y2
  sub eax,y1
  inc eax
  mov yl,eax

  mov esi,_v_buffer
  mov eax,y1
  mul _v_x
  add esi,eax
  mov eax,x1
  mul wptr[_v_bypp]
  add esi,eax
  mov ebx,yl
  mov eax,xl
  mul _v_bypp
  mov xl,eax
  mov ecx,eax
  mov eax,_v_x
  sub eax,ecx
g_t2:
  mov ecx,xl
  rep movsb
  add esi,eax
  dec ebx
  jnz g_t2
done:
  popad
  mov eax,buf
  ret
g_get endp

;puts src into _v_buffer (no clipping)
align 4
g_put proc,src:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local xl:dword,yl:dword
  pushad
  mov eax,x2
  sub eax,x1
  inc eax
  mov xl,eax
  mov eax,y2
  sub eax,y1
  inc eax
  mov yl,eax

  mov edi,_v_buffer
  mov esi,src
  mov eax,y1
  mul _v_x
  add edi,eax
  mov eax,x1
  mul _v_bypp
  add edi,eax
  mov ecx,yl
  mov eax,xl
  mul _v_bypp
  mov xl,eax
  mov ebx,xl
  mov eax,_v_x
  sub eax,ebx
  mov edx,ecx
g_t1:
  mov ecx,ebx
  rep movsb
  add edi,eax
  dec edx   ;
  jnz g_t1  ;loop  (not restricted to CX) and faster!
  popad
  ret
g_put endp

;puts to _v_buffer except for color 0  (very nice but slower than put)
;no clipping

; NOTE : this checks each byte for color 0 before writting to _v_buffer
;        Not each entire pixel (ie: 24bit modes will check each byte)

align 4
g_put0 proc,src:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local xl:dword,yl:dword
  pushad
  mov eax,x2
  sub eax,x1
  inc eax
  mov xl,eax
  mov eax,y2
  sub eax,y1
  inc eax
  mov yl,eax

  mov edi,_v_buffer
  mov esi,src
  mov eax,y1
  mul _v_x
  add edi,eax
  mov eax,x1
  mul _v_bypp
  add edi,eax
  mov eax,xl
  mul wptr[_v_bypp]
  mov xl,eax
  mov ecx,eax
  mov ebx,yl
  mov eax,_v_x
  sub eax,ebx
put0_1:
  cmp byte ptr[esi],0
  jz put0_2
  movsb
  dec ecx      ;
  jnz put0_1  ;loop but faster!
  jmp put0_3
put0_2:
  inc esi
  inc edi
  dec ecx
  jnz put0_1  ;loop
put0_3:
  add edi,eax
  mov ecx,xl
  dec ebx
  jnz put0_1  ;loop
  popad
  ret
g_put0 endp

;grafix text support

.data?
align 4
font dd ?
fontxd label dword
fontx dw ?,?
fontyd label dword
fonty dw ?,?
fontcharsiz dd ? ;size of each char (x*y*bypp)

.code
align 4
g_setfnt proc uses ebx ecx edx esi,fbuf:dword
  mov esi,fbuf
  movzx eax,[esi].fnthead.x
  movzx ebx,[esi].fnthead.y
  movzx ecx,[esi].fnthead.bypp

  mov fontx,ax
  mov fonty,bx
  mul ebx
  mul ecx
  mov fontcharsiz,eax
  mov font,esi

  xor eax,eax
  ret
g_setfnt endp

g_getfnt proc
  mov eax,font
  ret
g_getfnt endp

fnttmp db (sizeof fnthead) dup (?)

;FONT files now have a header
align 4
g_loadfnt proc,nam:dword
  local h:word
  pushad
  mov font,0
  callp open,nam,0
  cmp eax,ERROR
  jnz @f
  popad
  mov eax,ERROR
  ret
@@:
  mov h,ax
  callp read,ax,offset fnttmp,sizeof fnthead
  .if eax!=sizeof fnthead
bad:
    callp free,font
    callp close,h
    popad
    mov eax,ERROR
    ret
  .endif
  mov esi,offset fnttmp
  cmp dptr[esi],01a544e46h  ;FNT,27
  jnz bad
  cmp [esi].fnthead.flg,0
  jnz bad
  movzx eax,[esi].fnthead.x
  movzx ebx,[esi].fnthead.y
  movzx ecx,[esi].fnthead.bypp

  mov fontxd,eax
  mov fontyd,ebx

  mul ebx
  mul ecx
  mov fontcharsiz,eax
  mov ebx,256  ;# of chars
  mul ebx
  mov ebx,eax
  add eax,sizeof fnthead
  callp malloc,eax
  .if eax==ERROR
    jmp bad
  .endif
  mov font,eax
  mov esi,offset fnttmp
  mov edi,eax
  mov ecx,sizeof fnthead
  rep movsb

  mov ecx,eax
  add ecx,sizeof fnthead
  callp read,h,ecx,ebx
  cmp eax,ebx
  jnz bad
  callp close,h
  popad
  mov eax,font
  ret
g_loadfnt endp

align 4
g_fntcolor proc,_font:dword,col:byte
  ;changes color of font
  ;for 256 color fonts only!!
  pushad
  mov edi,_font
  movzx eax,[edi].fnthead.x
  movzx ebx,[edi].fnthead.y
  .if [edi].fnthead.bypp>1
    popad
    mov eax,ERROR
    ret
  .endif

  add edi,sizeof fnthead
  mul ebx
  mov ebx,256
  mul ebx
  mov ecx,eax
  mov al,col
@@:
  .if bptr[edi]
    stosb
  .else
    inc edi
  .endif
  dec ecx
  jnz @b
  popad
  xor eax,eax
  ret
g_fntcolor endp

align 4
g_putch proc,x:dword,y:dword,char:byte
  pushad
  mov edi,_v_buffer
  movzx eax,char
  mul fontcharsiz
  mov esi,eax
  add esi,font
  add esi,sizeof fnthead
  mov eax,y
  mul _v_xb
  add edi,eax
  mov eax,x
  mul _v_bypp
  add edi,eax
  mov ax,fontx
  mul wptr[_v_bypp]
  mov cx,ax
  mov ebx,dptr[fonty]
  mov edx,_v_xb
  sub dx,cx  ;edx=_v_buffer add
top:
  push cx
gputch_1:
  cmp byte ptr[esi],0   ;BUG should check all bytes (not each individually)
  jz gputch_2
  movsb
  jmp gputch_3
gputch_2:
  inc esi
  inc edi
gputch_3:
  dec cx
  jnz gputch_1
  pop cx
  add edi,edx
  dec ebx
  jnz top
  popad
  ret
g_putch endp

align 4
g_printxy proc,x:dword,y:dword,s:dword
  pushad
  jmp gputstr_1
gputstr_2:
  callp g_putch,x,y,bl
  mov eax,dptr[fontx]
  add x,eax
  inc s
gputstr_1:
  mov eax,s
  mov bl,[eax]
  cmp bl,13
  jz enter1
  cmp bl,10
  jz ignore
  cmp bl,0
  jnz gputstr_2
  popad
  ret
enter1:
  inc s
  mov x,0
  mov eax,dptr[fonty]
  add y,eax
  jmp gputstr_1
ignore:
  inc s
  jmp gputstr_1
g_printxy endp

align 4
g_printf proc,x:dword,y:dword,str1:dword,argv:vararg
  local siz:dword
  pushad

  lea eax,argv
  callp _vprintf_siz,str1,eax

  mov siz,eax
  sub esp,eax
  lea eax,argv
  mov edi,esp
  callp vsprintf,edi,str1,eax

  callp g_printxy,x,y,esp

  callp strlen,esp

  movzx ecx,fontx
  mul ecx
  add x,eax

  add esp,siz
  popad
  xor eax,eax
  ret
g_printf endp

;sets '_v_buffer' for all other procs
;THIS functions must be called before all others
; requires a ptr to a RAM block for the temp area (must be resx*resy*bypp)
; EG: 320*200*1 ;for 320x200x256
align 4
g_setbuf proc,o:dword
  mov eax,o
  mov _v_buffer,eax
  xor eax,eax
  ret
g_setbuf endp

align 4
g_setpal proc uses esi ecx edx,pal:dword
  call g_waitvsync
  mov esi,pal
  mov ecx,256*3
  mov dx,03c8h
  mov al,0
  out dx,al
  inc dx
  rep outsb
  xor eax,eax
  ret
g_setpal endp

align 4
g_setcol proc uses edx,n:byte,r:byte,g:byte,b:byte
  call g_waitvsync
  mov dx,3c8h
  mov al,n
  out dx,al
  inc dx
  mov al,r
  out dx,al
  mov al,g
  out dx,al
  mov al,b
  out dx,al
  xor eax,eax
  ret
g_setcol endp

align 4
g_hline proc,x1:dword,y1:dword,x2:dword,col:dword
  local l:dword
  pushad
  mov eax,x2
  .if x1>eax
    xchg eax,x1
    mov x2,eax
  .endif
  sub eax,x1
  inc eax
  mov l,eax

  mov edi,_v_buffer
  mov eax,y1
  mul _v_xb
  add edi,eax
  mov eax,x1
  mul _v_bypp
  add edi,eax
  .if wptr[_v_bypp]==1
    mov ecx,l
    mov al,bptr[col]
    rep stosb
  .elseif wptr[_v_bypp]==2
    mov ecx,l
    mov ax,wptr[col]
    rep stosw
  .else
    mov eax,l
    lea esi,col
    mov ebx,_v_bypp
@@:
    mov ecx,ebx
    rep movsb
    sub esi,ebx
    dec eax
    jnz @b
  .endif
  popad
  ret
g_hline endp

align 4
g_vline proc,x1:dword,y1:dword,y2:dword,col:dword
  pushad
  mov eax,y2
  .if y1>eax
    xchg eax,y1
    mov y2,eax
  .endif
  sub eax,y1
  inc eax
  mov ebx,eax

  mov edi,_v_buffer
  mov eax,y1
  mul _v_xb
  add edi,eax
  mov eax,x1
  mul _v_bypp
  add edi,eax
  lea esi,col
  mov edx,_v_bypp
@@:
  mov ecx,edx
  rep movsb
  sub esi,edx
  add edi,_v_xb
  sub edi,edx
  dec ebx
  jnz @b
  popad
  ret
g_vline endp

align 4
g_box proc,x1:dword,y1:dword,x2:dword,y2:dword,col:dword
  callp g_hline,x1,y1,x2,col
  callp g_vline,x1,y1,y2,col
  callp g_vline,x2,y1,y2,col
  callp g_hline,x1,y2,x2,col
  ret
g_box endp

;Fixed : Ver 1.1    (gcls never worked before)
align 4
g_cls proc uses eax edi ecx edx
  mov eax,_v_bpsl
  mul _v_y
  mov edi,_v_linear
  mov ecx,eax
  mov bl,al
  xor eax,eax
  shr ecx,2
  rep stosd
  and bl,3
  .if bl
    mov cl,bl
    rep stosb
  .endif
  ret
g_cls endp

align 4
g_boxfill proc,x1:dword,y1:dword,x2:dword,y2:dword,col:dword
  local xl:dword,yl:dword
  pushad
  mov eax,x2
  .if x1>eax
    xchg eax,x1
    mov x2,eax
  .endif
  sub eax,x1
  inc eax
  mov xl,eax
  mov eax,y2
  .if y1>eax
    xchg eax,y1
    mov y2,eax
  .endif
  sub eax,y1
  inc eax
  mov yl,eax

  mov edi,_v_buffer
  mov eax,y1
  mul _v_x
  add edi,eax
  mov eax,x1
  mul _v_bypp
  add edi,eax
  mov eax,xl
  mul _v_bypp
  mov xl,eax
  mov eax,_v_x
  sub eax,xl  ;delta add
  mov ebx,yl
top:
  mov edx,xl
@@:
  lea esi,col
  mov ecx,_v_bypp
  rep movsb
  dec edx
  jnz @b
  add edi,eax
  dec ebx
  jnz top
  popad
  ret
g_boxfill endp

setmode50 proc private ;change to 80x50 video mode
  pushad
  mov ax,1112h
  xor bx,bx
  int 10h
  mov ax,1200h
  mov bx,20h
  int 10h
  popad
  xor eax,eax
  ret
setmode50 endp

end

