#pragma pack(1)

#include <dos.h>
#include "vesa12.h"

struct sVESAInfo VESAInfo;

struct sVESAModeInfo VESAModeInfo;

unsigned CurrentBank;
unsigned BankMult;
unsigned BankShiftModifier;

int VESAGetInfo()
{

_asm{
 mov ax,04f00h
 push ds			;assumes small or medium model
 pop es
 lea di,VESAInfo
 int 10h
 cmp ah,0
 jne fail
 mov ax,1
 jmp retsub
fail:
 mov ax,0
retsub:
}
}

int VESAGetModeInfo(unsigned mode)
{
_asm {
 mov ax,04f01h
 mov cx,mode
 push ds			;assumes small or medium model
 pop es
 lea di,VESAModeInfo
 int 10h
 cmp ax,004fh
 jne fail
 mov ax,1
 jmp retsub
fail:
 mov ax,0
retsub:
}
}

void VESASetMode(unsigned mode)
{
_asm {
 mov ax,03h
 int 10h			 ;{start from textmode}

 mov ax,4F02h
 mov bx,mode
 int 10h
 cmp ah,0
 jne fail			 ;{set the VESA mode through VESA function 02h}

 mov ax,4F05h
 xor bx,bx
 mov dx,0
 int 10h
 mov CurrentBank,0	 ;{initialize global page variable}
 cmp ah,0
 jne fail			 ;{Set bank 0}

 mov ax,1			 ;{Set call to succesful}
 jmp retsub
fail:
 mov ax,0
retsub:
}
}

void VESASetBank(unsigned nr)
{
_asm {
 xor bx,bx						 ;{Window 0 selected}
 mov dx,nr
 mov CurrentBank,dx				 ;{update global page variable}

 call [VESAModeInfo.BankSwitch]
}
}

void VESAPutPixel(unsigned x,unsigned y,unsigned char c)
{
  unsigned bank, segment;
  unsigned long offs;

  offs = (long)y * VESAModeInfo.XResolution + x;
  bank = offs >> (16-BankShiftModifier);
  offs = offs - (bank << (16-BankShiftModifier));
  segment = offs & 0xffff;

  if(bank != CurrentBank) //{page = global var - active page}
  {
	VESASetBank(bank);
  }
  _asm {
	mov ax,[VESAModeInfo.WinASegment]
	mov es,ax
	mov di,segment
	mov al,c
	mov es:[di],al
  }
}


void VESAInitVars()
{
	switch(VESAModeInfo.WinGranularity) {
	case 1:
		BankShiftModifier = 6;
		break;
	case 2:
		BankShiftModifier = 5;
		break;
	case 4:
		BankShiftModifier = 4;
		break;
	case 8:
		BankShiftModifier = 3;
		break;
	case 16:
		BankShiftModifier = 2;
		break;
	case 32:
		BankShiftModifier = 1;
		break;
	case 64:
		BankShiftModifier = 0;
		break;
	}
	BankMult = 64 / VESAModeInfo.WinGranularity;
}


int VESASetDACWidth(unsigned width)
{
_asm {
	mov ax,4f08h
	mov bx,width
	xchg bh,bl
	int 10h
	mov al,bh
	xor ah,ah
}
}

void VESASetLogicalScanLine(unsigned width)
{
_asm {
 mov ax,4f06h
 mov bl,0
 mov cx,width
 int 10h
}
}

void VESASetScreenPosition(unsigned x, unsigned y)
{
_asm {
 mov ax,4f07h
 xor bx,bx
 mov cx,[x]
 mov dx,[y]
 int 10h
}
}
