
program StaticPlasma2;
{
  Ejemplo de plasma esttico con rotacin de paleta.
  Por: FAC

  El algoritmo de generacin de plasma fractal fu copiado del programa
  ACPLASMA.PAS  por Alex Chalfin.
}

uses Mode13, Crt;

{ Valores para rugosidad:    1    -- poco rugoso      }
{                          2 a 3  -- normal           }
{                          4 a 6  -- muy rugoso       }
const Rugosidad = 2;  { se admiten decimales }

{ Este procedimiento calcula el color de un punto (x, y) a partir de  }
{ otros dos puntos (x1, y1) y (x2, y2)                                }
procedure NuevoColor(x1, y1, x, y, x2, y2 : integer);
var color : integer;
begin
     { Obtenemos la distancia entre (x1, y1) y (x2, y2) }
     color := abs(x1 - x2) + abs(y1 - y2);
     { La frmula anterior funciona solamente cuando x1 = x2  o  y1 = y2 }

     { Promediamos los colores de los puntos (x1, y1) y (x2, y2)    }
     { y aadimos un valor aleatorio proporcional a la distancia    }
     { que calculamos y a un coeficiente de "rugosidad"             }
     color := ((GetPixel(x1, y1, VGA) + GetPixel(x2, y2, VGA)) div 2) +
              round((random - 0.5) * color * Rugosidad);

     { Nos aseguramos de que el color est dentro de los lmites }
     if color < 1 then color := 1;
     if color > 255 then color := 255;

     { Y si no se ha dibujado un pxel en (x, y), entonces lo dibujamos }
     if GetPixel(x, y, VGA) = 0 then PutPixel(x, y, color, VGA);
end;


{ Este procedimiento genera el plasma recursivamente }
procedure GeneraPlasma(x1, y1, x2, y2 : integer);
var x, y, color : integer;
begin
     { Si la distancia entre las esquinas es mayor que 1, entonces... }
     if not (((x2 - x1) < 2) and ((y2 - y1) < 2)) then
     begin
          { Encontramos las coordenadas del punto central }
          x := (x1 + x2) div 2;
          y := (y1 + y2) div 2;

          { Dibujamos un pxel en el punto medio de cada lado }
          NuevoColor(x1, y1, x, y1, x2, y1);
          NuevoColor(x2, y1, x2, y, x2, y2);
          NuevoColor(x1, y2, x, y2, x2, y2);
          NuevoColor(x1, y1, x1, y, x1, y2);

          { Calculamos el color del punto central promediando los       }
          { colores de las esquinas                                     }
          color := (GetPixel(x1, y1, VGA) + GetPixel(x2, y1, VGA) +
                    GetPixel(x1, y2, VGA) + GetPixel(x2, y2, VGA) + 2) div 4;

          { Dibujamos el punto central }
          PutPixel(x, y, color, VGA);

          { Y llamamos recursivamente al procedimiento para cada uno    }
          { de los 4 rectngulos en que se divide la regin }
          GeneraPlasma(x1, y1, x, y);
          GeneraPlasma(x, y1, x2, y);
          GeneraPlasma(x, y, x2, y2);
          GeneraPlasma(x1, y, x, y2);
     end;
end;


var pal : TPalette;
    i : byte;

          { Este procedimiento genera un paleta alterna }
          procedure GeneraPaleta;
          var i : byte;
          begin
               for i := 0 to 63 do
               begin
                    pal[i][0] := 63 - i; { disminuye el rojo }
                    pal[i][1] := i;      { y aumenta el verde }
                    pal[i][2] := 0;      { nada de azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 64][0] := 0;        { nada de rojo }
                    pal[i + 64][1] := 63 - i;   { disminuye el verde }
                    pal[i + 64][2] := i;        { y aumenta el azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 128][0] := i;       { aumentamos el rojo }
                    pal[i + 128][1] := i;       { y tambin el verde }
                    pal[i + 128][2] := 63 - i;  { y disminuye el azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 192][0] := 63;      { El rojo al mximo }
                    pal[i + 192][1] := 63 - i;  { disminuye el verde }
                    pal[i + 192][2] := 0;       { y nada de azul }
               end;
          end;




{ programa principal }
begin
     randomize;

     clrscr;
     writeln;
     writeln(' Ejemplo de plasma esttico con rotacin de paleta.');
     writeln;
     writeln(' El plasma ha sido generado mediante el algoritmo de Alex Chalfin');
     writeln(' y la adicin de algunas semillas al azar.');
     writeln;
     writeln(' Oprime una tecla para continuar...');
     readkey;

     SetMode13;
     FadeOut(0);
     ClearScreen(0, VGA);

     { Fijamos una paleta que va de negro a rojo a amarillo a rojo a negro }
     for i := 0 to 63 do SetPal(i, i, 0, 0);
     for i := 64 to 127 do SetPal(i, 63, i - 64, 0);
     for i := 128 to 191 do SetPal(i, 63, 191 - i, 0);
     for i := 192 to 255 do SetPal(i, 255 - i, 0, 0);
     GetPalette(pal);

{     GeneraPaleta; }

     VRetrace;
     SetPalette(pal);

     { Generamos 5 "semillas" al azar (esta parte es opcional) }
{
     for i := 1 to 5 do
         PutPixel(random(320), random(200), random(255) + 1, VGA);
}

     GeneraPlasma(0, 0, 320, 200);

     while not keypressed do
     begin
          RotatePalette(pal, 255, 1);
          VRetrace;
          SetPalette(pal);
     end;
     readkey;

     FadeOut(0);
     SetTextMode;
end.
