
program Plasma;

{
  Otro ejemplo de plasma (exactamente el mismo que PLASMA2.PAS), pero
  con la diferencia de que se usa una resolucin menor, de 160 * 100,
  (en lugar de 320 * 200), para acelerar el efecto.

  Solamente el procedimiento DrawPlasma est comentado. Los dems
  procedimientos son iguales que en PLASMA1.PAS y PLASMA2.PAS

  Tambin se incluye una versin del procedimiento DrawPlasma en
  puro ensamblador, llamada DrawPlasmaASM. Este procedimiento dibuja
  8 pxels en cada ciclo, lo que lo hace unas 6 o 7 veces ms rpido
  que el procedimiento original en PLASMA1.PAS, y si modificamos
  las tabla ColorTable2 para que utilice ndices entre 0 y 159 nos
  podemos ahorrar una multiplicacin por cada dos pxels.
}


uses Mode13, Crt;

var pal : TPalette;
    VirScr : PTVirtual;
    VirSeg : word;
    ColorTable1 : array[0..255] of byte;
    ColorTable2 : array[0..319] of byte;

    pos1, pos2, pos3, pos4 : byte;


procedure InitPlasma;
var i : word;
begin
     SetupVirtual(VirScr, VirSeg);
     fillchar(pal, sizeof(pal), 0);
     SetMode13;
     SetPalette(pal);

     for i := 0 to 63 do
     begin
          pal[i][0] := i;
          pal[i][1] := 0;
          pal[i][2] := 0;
     end;
     for i := 64 to 127 do
     begin
          pal[i][0] := 63;
          pal[i][1] := i - 64;
          pal[i][2] := 0;
     end;
     for i := 128 to 191 do
     begin
          pal[i][0] := 191 - i;
          pal[i][1] := 63;
          pal[i][2] := 0;
     end;
     for i := 192 to 255 do
     begin
          pal[i][0] := 0;
          pal[i][1] := 255 - i;
          pal[i][2] := 0;
     end;

     for i := 0 to 255 do
         ColorTable1[i] := round(sin(2 * Pi * i / 512) *
                                 sqrt(abs(sin(2 * Pi * i / 256) * 16)) *
                                 cos(2 * Pi * i / 512) * 31) + 32;
     for i := 0 to 319 do
         ColorTable2[i] := round(cos(2 * Pi * i / 80) * 32 -
                                 sqr(abs(sin(Pi * i / 160) * 16)));
end;


{ Procedimiento que dibuja el plasma (en Pascal) }
procedure DrawPlasma;
var i, j : integer;
    p1, p2, p3, p4 : byte;
    color : byte;
    offset, col2bytes : word;

begin
     p3 := pos3;
     p4 := pos4;
     offset := 0;

     { La resolucin utilizada ahora es de 160 * 100 }
     for i := 0 to 99 do
     begin
          p1 := pos1;
          p2 := pos2;
          for j := 0 to 159 do
          begin
               { Calculamos el color de la misma forma, pero puesto que
                 la tabla ColorTable2 no fu modificada para utilizar la
                 nueva resolucin, debemos multiplicar los ndices por 2 }
               color := ColorTable1[p1] + ColorTable1[p2] + ColorTable1[p3] +
                        ColorTable1[p4] + ColorTable2[i*2] + ColorTable2[j*2];

               { Lo que se hace ahora es mover el valor de color a los
                 2 bytes de la variable col2bytes, que es de tipo word }
               col2bytes := color shl 8 + color;
               { Al desplazar un valor hacia la izquierda ocho posiciones
                 (color SHL 8), estamos moviendo ese valor al byte
                 inmediatamente superior. }

               { Ahora, en lugar de mem utilizamos memw para dibujar
                 2 pxels al mismo tiempo. MemW funciona igual que Mem,
                 pero en lugar de bytes, se le asignan palabras (2 bytes) }
               memw[VirSeg:offset] := col2bytes;
               memw[VirSeg:offset+320] := col2bytes;

               { El offset se incrementa ahora en 2 posiciones }
               inc(offset, 2);
               inc(p1, 3);
               inc(p2, 4);
          end;
          inc(offset, 320); { Pasamos a la siguiente lnea }
          dec(p3, 4);
          inc(p4, 3);
     end;
end;

{ Este es el equivalente en ensamblador de DrawPlasma }
{ Es un procedimiento relativamente largo y sin comentarios }
{ El procedimiento utiliza un poco de cdigo de 32 bits para poder
  dibujar 8 pxels al mismo tiempo (bueno, 4 y 4).

  La idea general es obtener en el registro EAX los valores de los
  4 pxels siguientes, de forma que primero se calcula el color del
  siguiente pxel en AL, luego se copia AL a AH y se mueve AX a la
  palabra superior de EAX mediante una rotacin. Luego se calcula
  el color siguiente en AL, se copia AL a AH y listo. }
procedure DrawPlasmaASM; assembler;
asm
   mov es, VirSeg
   mov di, 63676
   mov dh, pos3
   mov dl, pos4
   mov si, dx
   mov ch, 100

   @loopy:  mov dh, pos1
            mov dl, pos2
            mov cl, 160

   @loopx:  xor bh, bh
            mov bl, ch
            shl bl, 1
            mov al, byte ptr [ColorTable2 + bx]
            xchg si, dx
            mov bl, dh
            add al, byte ptr [ColorTable1 + bx]
            mov bl, dl
            add al, byte ptr [ColorTable1 + bx]
            xchg si, dx
            mov bl, al
            db long; shl ax, 16  { shl eax, 16 }

            mov al, bl
            mov bl, dh
            add al, byte ptr [ColorTable1 + bx]
            mov bl, dl
            add al, byte ptr [ColorTable1 + bx]
            mov bl, cl
            shl bx, 1
            add al, byte ptr [ColorTable2 + bx]
            mov ah, al
            db long; rol ax, 16  { rol eax, 16 }

            sub dh, 3
            sub dl, 4
            sub bx, 2
            add al, byte ptr [ColorTable2 + bx]
            xor bh, bh
            mov bl, dh
            add al, byte ptr [ColorTable1 + bx]
            mov bl, dl
            add al, byte ptr [ColorTable1 + bx]
            mov ah, al

            db long; mov es:[di], ax         { mov es:[di], eax }
            db long; mov es:[di + 320], ax   { mov es:[di + 320], eax }
            sub di, 4
            sub dh, 3
            sub dl, 4
            sub cl, 2
            jnz @loopx

            sub di, 320
            mov bx, si
            sub bh, 4
            sub bl, 3
            mov si, bx
            dec ch
            jnz @loopy
end;

procedure MovePlasma;
begin
     dec(pos1, 4);
     inc(pos3, 4);
     inc(pos1, random(4) - 1);
     dec(pos2, random(4) - 1);
     inc(pos3, random(4) - 1);
     dec(pos4, random(4) - 1);
end;


procedure DoPlasma;
begin
     while not keypressed do
     begin
          RotatePalette(pal, 255, 0);
          DrawPlasma;  { Se puede sustitur por DrawPlasmaASM; }
{          VRetrace;}
          SetPalette(pal);
          CopyScreen(VirSeg, VGA);
          MovePlasma;
     end;
     readkey;
end;


          procedure OtraPaleta;
          var i : byte;
          begin
               for i := 0 to 63 do
               begin
                    pal[i][0] := 63 - i; { disminuye el rojo }
                    pal[i][1] := i;      { y aumenta el verde }
                    pal[i][2] := 0;      { nada de azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 64][0] := 0;        { nada de rojo }
                    pal[i + 64][1] := 63 - i;   { disminuye el verde }
                    pal[i + 64][2] := i;        { y aumenta el azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 128][0] := i;       { aumentamos el rojo }
                    pal[i + 128][1] := i;       { y tambin el verde }
                    pal[i + 128][2] := 63 - i;  { y disminuye el azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 192][0] := 63;      { El rojo al mximo }
                    pal[i + 192][1] := 63 - i;  { disminuye el verde }
                    pal[i + 192][2] := 0;       { y nada de azul }
               end;
          end;


begin
     clrscr;
     writeln;
     writeln('Este programa presenta el mismo plasma que PLASMA2.PAS.');
     writeln('Sirve para mostrar la diferencia en velocidad cuando se');
     writeln('utiliza una resolucin menor y (opcionalmente) ensamblador.');
     writeln;
     writeln('Para ver la velocidad del ensamblador, usar el procedimiento');
     writeln('DrawPlasmaASM en lugar de DrawPlasma.');
     writeln;
     writeln('...');
     readkey;

     InitPlasma;
{     OtraPaleta;}
     DoPlasma;
     SetTextMode;
     ShutDownVirtual(VirScr);
end.