
// PLASMA3.CPP  --  Ejemplo de plasma en tiempo real  --  por FAC
// Este plasma usa una resolucin de 160 * 100

#include <iostream.h>       // cout
#include <conio.h>          // clrscr, getch, kbhit
#include <math.h>           // sin, cos, sqrt, fabs
#include <stdlib.h>         // randomize, random, exit
#include <dos.h>            // MK_FP
#include "mode13.h"
#include "mode13.cpp"

#define Pi 3.14159265
#define sqr(x) ((x) * (x))

TPalette pal;
PTVirtual VirScr;
word VirSeg;
byte ColorTable1[256];
byte ColorTable2[160];
byte pos1, pos2, pos3, pos4;


void InitPlasma()
{
     word i;

     if (!SetupVirtual(VirScr, VirSeg)) exit(EXIT_FAILURE);
     SetMode13();
     FadeOut(0);

     for (i = 0; i < 64; i++)
     {
          pal[i][0] = i;
          pal[i][1] = pal[i][2] = 0;

          pal[i + 64][0] = 63;
          pal[i + 64][1] = i;
          pal[i + 64][2] = 0;

          pal[i + 128][0] = 63 - i;
          pal[i + 128][1] = 63;
          pal[i + 128][2] = 0;

          pal[i + 192][0] = pal[i + 192][2] = 0;
          pal[i + 192][1] = 63 - i;
     }

     for (i = 0; i < 256; i++)
         ColorTable1[i] = sin(2 * Pi * i / 512) *
                          sqrt(fabs(sin(2 * Pi * i / 256) * 16)) *
                          cos(2 * Pi * i / 512) * 31 + 32;

     for (i = 0; i < 160; i++)
         ColorTable2[i] = cos(Pi * i / 20) * 32 -
                          sqr(fabs(sin(Pi * i / 80) * 16));
}


void DrawPlasma()
{
     int i, j;
     word col2bytes;
     byte p1, p2, color;
     word *off = (word *) MK_FP(VirSeg, 0);
     byte p3 = pos3;
     byte p4 = pos4;

     for (i = 0; i < 100; i++)
     {
          p1 = pos1;
          p2 = pos2;
          for (j = 0; j < 160; j++)
          {
               color = ColorTable1[p1] + ColorTable1[p2] + ColorTable1[p3] +
                       ColorTable1[p4] + ColorTable2[i] + ColorTable2[j];
               col2bytes = (color << 8) + color;
               *off = col2bytes;
               *(off + 160) = col2bytes;
               off++;
               p1 += 3;
               p2 += 4;
          }
          off += 160;
          p3 -= 4;
          p4 += 3;
     }
}


void MovePlasma()
{
     pos1 += random(4) - 5;
     pos2 -= random(4) - 1;
     pos3 += random(4) + 3;
     pos4 -= random(4) - 1;
}


void DoPlasma()
{
     SetPalette(pal);
     while (!kbhit())
     {
          RotatePalette(pal, 255, 0);
          DrawPlasma();
//        VRetrace();
          SetPalette(pal);
          CopyScreen(VirSeg, VGA);
          MovePlasma();
     }
     getch();
}


void main()
{
     clrscr();
     cout << "\nEjemplo de plasma en tiempo real en resolucin 160 * 100\n"
          << "\nPresiona una tecla...\n";
     getch();

     InitPlasma();
     DoPlasma();
     FadeOut(5);
     SetTextMode();
     ShutDownVirtual(VirScr);
}
