
program Plasma;
{ Otro ejemplo de plasma.
  Este programa tiene la misma estructura que PLASMA1.PAS.
  Las nicas diferencias son que utiliza otras funciones, otra paleta
  y adems se hace una rotacin de paleta al mover el plasma.

  Por lo tanto, este programa carece de comentarios... :(
}

uses Mode13, Crt;

var pal : TPalette;
    VirScr : PTVirtual;
    VirSeg : word;
    ColorTable1 : array[0..255] of byte;
    ColorTable2 : array[0..319] of byte;

    pos1, pos2, pos3, pos4 : byte;


procedure InitPlasma;
var i : word;
begin
     SetupVirtual(VirScr, VirSeg);
     fillchar(pal, sizeof(pal), 0);
     SetMode13;
     SetPalette(pal);

     for i := 0 to 63 do
     begin
          pal[i][0] := i;
          pal[i][1] := 0;
          pal[i][2] := 0;
     end;
     for i := 64 to 127 do
     begin
          pal[i][0] := 63;
          pal[i][1] := i - 64;
          pal[i][2] := 0;
     end;
     for i := 128 to 191 do
     begin
          pal[i][0] := 191 - i;
          pal[i][1] := 63;
          pal[i][2] := 0;
     end;
     for i := 192 to 255 do
     begin
          pal[i][0] := 0;
          pal[i][1] := 255 - i;
          pal[i][2] := 0;
     end;

     for i := 0 to 255 do
         ColorTable1[i] := round(sin(2 * Pi * i / 512) *
                                 sqrt(abs(sin(2 * Pi * i / 256) * 16)) *
                                 cos(2 * Pi * i / 512) * 31) + 32;
     for i := 0 to 319 do
         ColorTable2[i] := round(cos(2 * Pi * i / 80) * 32 -
                                 sqr(abs(sin(Pi * i / 160) * 16)));
end;


procedure DrawPlasma;
var i, j : integer;
    p1, p2, p3, p4 : byte;
    color : byte;
    offset : word;

begin
     p3 := pos3;
     p4 := pos4;
     offset := 0;

     for i := 0 to 199 do
     begin
          p1 := pos1;
          p2 := pos2;
          for j := 0 to 319 do
          begin
               color := ColorTable1[p1] + ColorTable1[p2] + ColorTable1[p3] +
                        ColorTable1[p4] + ColorTable2[i] + ColorTable2[j];
               mem[VirSeg:offset] := color;
               inc(offset);
               inc(p1, 1);
               inc(p2, 2);
          end;
          inc(p3, 2);
          inc(p4, 1);
     end;
end;


procedure MovePlasma;
begin
     dec(pos1, 4);
     inc(pos3, 4);
     inc(pos1, random(4) - 1);
     dec(pos2, random(4) - 1);
     inc(pos3, random(4) - 1);
     dec(pos4, random(4) - 1);
end;


procedure DoPlasma;
begin
     while keypressed do readkey;
     while not keypressed do
     begin
          RotatePalette(pal, 255, 0);
          DrawPlasma;
          VRetrace;
          SetPalette(pal);
          CopyScreen(VirSeg, VGA);
          MovePlasma;
     end;
     readkey;
end;


          { Este procedimiento genera una paleta alterna }
          procedure OtraPaleta;
          var i : byte;
          begin
               for i := 0 to 63 do
               begin
                    pal[i][0] := 63 - i; { disminuye el rojo }
                    pal[i][1] := i;      { y aumenta el verde }
                    pal[i][2] := 0;      { nada de azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 64][0] := 0;        { nada de rojo }
                    pal[i + 64][1] := 63 - i;   { disminuye el verde }
                    pal[i + 64][2] := i;        { y aumenta el azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 128][0] := i;       { aumentamos el rojo }
                    pal[i + 128][1] := i;       { y tambin el verde }
                    pal[i + 128][2] := 63 - i;  { y disminuye el azul }
               end;
               for i := 0 to 63 do
               begin
                    pal[i + 192][0] := 63;      { El rojo al mximo }
                    pal[i + 192][1] := 63 - i;  { disminuye el verde }
                    pal[i + 192][2] := 0;       { y nada de azul }
               end;
          end;


begin
     clrscr;
     writeln;
     writeln('Otro ejemplo de plasma, ms colorido que PLASMA1.PAS.');
     writeln;
     writeln('...');
     readkey;

     InitPlasma;
{     OtraPaleta; }
     DoPlasma;
     SetTextMode;
     ShutDownVirtual(VirScr);
end.