
program Plasma;

{ Ejemplo de plasma generado en tiempo real para los tutoriales de grficos }
{ por FAC                                                                   }

uses Mode13, Crt;

var pal : TPalette;
    VirScr : PTVirtual;
    VirSeg : word;
    ColorTable1 : array[0..255] of byte; { Tablas precalculadas }
    ColorTable2 : array[0..319] of byte;

    pos1, pos2, pos3, pos4 : byte;  { Indices para las tablas }



{ Este procedimiento inicializa las tablas de funciones y la paleta }
procedure InitPlasma;
var i : word;
begin
     SetupVirtual(VirScr, VirSeg);  { Reservamos memoria para la p. virtual }
     fillchar(pal, sizeof(pal), 0); { Llenamos la paleta con ceros }
     SetMode13;                     { Iniciamos el modo grfico }
     SetPalette(pal);               { Y activamos la paleta }

     { Este plasma solamente usa los colores del 0 al 127 }
     for i := 0 to 63 do
     begin
          pal[i][0] := (63 - i) div 16;
          pal[i][1] := 0;
          pal[i][2] := 0;
     end;
     for i := 64 to 95 do
     begin
          pal[i][0] := i - 64;
          pal[i][1] := 0;
          pal[i][2] := 0;
     end;
     for i := 96 to 127 do
     begin
          pal[i][0] := 127 - i;
          pal[i][1] := 0;
          pal[i][2] := 0;
     end;

     { Aqu generamos las tablas precalculadas... }
     for i := 0 to 255 do
         ColorTable1[i] := round(cos(2 * Pi * i / 256) * 31) + 32;

     for i := 0 to 319 do
         ColorTable2[i] := round(sin(i / 100) * 5 * exp(i / 240) * i) div 2;
end;


{ Este procedimiento dibuja el plasma }
procedure DrawPlasma;
var i, j : integer;
    p1, p2, p3, p4 : byte; { Indices temporales (para conservar los originales) }
    color : byte;
    offset : word;

begin
     p3 := pos3;
     p4 := pos4;
     offset := 0;

     for i := 0 to 199 do
     begin
          p1 := pos1;
          p2 := pos2;
          for j := 0 to 319 do
          begin
               { Calculamos el color como una suma de 6 funciones }
               color := ColorTable1[p1] + ColorTable1[p2] + ColorTable1[p3] +
                        ColorTable1[p4] + ColorTable2[i] + ColorTable2[j];
               { Ya que el valor del color est entre 0 y 255, lo dividimos
                 entre 2 (color shr 1) para obtener un valor entre 0 y 127 }
               mem[VirSeg:offset] := color shr 1;
               inc(offset); { Incrementamos el offset en la pantalla }
               inc(p1, 3);  { Incrementamos dos de los ndices }
               inc(p2, 2);
          end;
          inc(p3, 3); { Incrementamos los otros dos ndices }
          inc(p4, 2);
     end;
end;


{ Este procedimiento actualiza los ndices para darle movimiento al plasma }
procedure MovePlasma;
begin
     dec(pos1, 3);
     inc(pos3, 3);
     inc(pos1, random(3) - 1);
     dec(pos2, random(3) - 1);
     inc(pos3, random(3));
     dec(pos4, random(3));
end;


procedure DoPlasma;
begin
     SetPalette(pal);
     while not keypressed do
     begin
          DrawPlasma;
{          VRetrace;   { Usar el VRetrace en caso de parpadeos }
          CopyScreen(VirSeg, VGA);
          MovePlasma;
     end;
     readkey;
end;


begin
     clrscr;
     writeln;
     writeln('Ejemplo de plasma en tiempo real');
     writeln;
     writeln('Presiona una tecla para continuar...');
     readkey;

     InitPlasma;
     DoPlasma;
     FadeOut(1);
     SetTextMode;
     ShutDownVirtual(VirScr);
end.