
program LlamasAMi;

{ Ejemplo de llamas que toman una forma definida y el efecto "flamazo".
  Todo el cdigo fu tomado de LLAMAS1.PAS. Solamente se aadi un
  procedimiento y algunas lneas, por lo tanto, no hay muchos comentarios }

uses mode13, crt;

const ColorSemilla = 255;  { Color de los "puntos calientes" en las llamas }
      ColorSemilla2 = 160; { Color de los "puntos calientes" en las letras }


var DestScr, OrigenScr : PTVIrtual;
    Destino, Origen : word;
    pal : TPalette;
    key : char;     { Aqu almacenamos la tecla pulsada }
    flag : boolean; { Esta variable indica cundo termina el programa }
    flamazo : word; { Si esta variable es mayor que cero, entonces
                      dibujamos las letras en llamas }


procedure GeneraPaleta;
var i : byte;
begin
     for i := 0 to 15 do
     begin
          pal[i][0] := i;       { un poco de rojo para hacer humo prpura }
          pal[i][1] := 0;       { nada de verde }
          pal[i][2] := i;       { aumentamos un poco el azul (humo) }
     end;
     for i := 0 to 15 do
     begin
          pal[i + 16][0] := 15 - i;     { disminumos el rojo }
          pal[i + 16][1] := 0;          { nada de verde }
          pal[i + 16][2] := 15 - i;     { disminumos el azul (humo) }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 32][0] := i;  { aumentamos el rojo }
          pal[i + 32][1] := 0;  { nada de verde }
          pal[i + 32][2] := 0;  { nada de azul }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 96][0] := 63; { el rojo al mximo }
          pal[i + 96][1] := i;  { aumentamos el verde para formar amarillo }
          pal[i + 96][2] := 0;  { nada de azul }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 160][0] := 63;  { el rojo al mximo }
          pal[i + 160][1] := 63;  { el verde al mximo }
          pal[i + 160][2] := i;   { aumentamos el azul para obtener blanco }
     end;
     for i := 0 to 31 do
     begin
          pal[i + 224][0] := 63;
          pal[i + 224][1] := 63;
          pal[i + 224][2] := 63;
     end;
end;


{ Este procedimiento dibuja las letras FAC en la pantalla utilizando
  "puntos calientes" al azar }
procedure DibujaFAC;

          { Procedimiento auxiliar que dibuja una lnea horizontal
            con "puntos calientes" al azar en Origen}
          procedure LineaH(x1, x2, y : word);
          var off, i : word;
          begin
               off := YOffset[y] + x1;
               for i := x1 to x2 do
               begin
                    mem[Origen:off] := random(2) * ColorSemilla2;
                    inc(off);
               end;
          end;

          { Lnea vertical de "puntos calientes" al azar en Origen}
          procedure LineaV(x, y1, y2 : word);
          var off, i : word;
          begin
               off := YOffset[y1] + x;
               for i := y1 to y2 do
               begin
                    mem[Origen:off] := random(2) * ColorSemilla2;
                    inc(off, 320);
               end;
          end;

begin
     { Dibujamos la 'F' }
     LineaH(20, 100, 50);
     LineaH(20, 80, 100);
     LineaV(20, 50, 150);

     { Dibujamos la 'A' }
     LineaH(120, 200, 50);
     LineaH(120, 200, 100);
     LineaV(120, 50, 150);
     LineaV(200, 50, 150);

     { Dibujamos la 'C' }
     LineaH(220, 300, 50);
     LineaH(220, 300, 150);
     LineaV(220, 50, 150);
end;


procedure IniciaLlamas;
var x : word;
begin
     ClearScreen(0, Destino);
     ClearScreen(0, Origen);
     for x := 0 to 319 do
     begin
          PutPixel(x, 198, random(2) * ColorSemilla, Origen);
          PutPixel(x, 199, random(2) * ColorSemilla, Origen);
     end;
end;


{ Este procedimiento es casi el mismo que el de LLAMAS1.PAS, con la
  excepcin de que cuando la variable flamazo es mayor que 0, se
  dibujan las letras FAC en el arreglo origen }
procedure MueveLlamas;
var off, x, y : word;
    color : integer;
begin
     off := 1;
     for y := 0 to 197 do
     begin
          for x := 1 to 318 do
          begin
               color := mem[Origen:off] + mem[Origen:off+640] +
                        mem[Origen:off+319] + mem[Origen:off+321];
               color := (color shr 2) - 1;
               if color < 0 then color := 0;
               mem[Destino:off] := color;
               inc(off);
          end;
          inc(off, 2);
     end;

     CopyScreen(Destino, Origen);

     if flamazo > 0 then
     begin
          DibujaFAC;
          dec(flamazo);
     end;

     for x := 0 to 319 do
     begin
          mem[Origen:YOffset[198] + x] := random(2) * ColorSemilla;
          mem[Origen:YOffset[199] + x] := random(2) * ColorSemilla;
     end;
end;


begin
     clrscr;
     writeln;
     writeln('Efecto de llamas a las que se les da una forma determinada');
     writeln('y ejemplo del efecto de flamazo.');
     writeln;
     writeln(' ESPACIO - Produce el "flamazo"');
     writeln('   ESC   - Termina el programa');
     writeln;
     writeln('Cualquier tecla para continuar...');
     readkey;

     randomize;
     SetupVirtual(DestScr, Destino);
     SetupVirtual(OrigenScr, Origen);
     GeneraPaleta;
     SetMode13;
     SetPalette(pal);
     IniciaLlamas;

     flag := true;

     while flag do
     begin
          if keypressed then   { Si se oprime una tecla... }
          begin
               key := readkey; { la leemos y la guardamos }
               if key = #27 then flag := false; { ESC - Sale del programa }
               if key = ' ' then flamazo := 15; { Espacio - flamazo }
          end;
          MueveLlamas;
{          VRetrace;}
          CopyScreen(Destino, VGA);
     end;

     ShutDownVirtual(DestScr);
     ShutDownVirtual(OrigenScr);
     SetTextMode;
end.