
program LlamasAMi;

{ Ejemplo del efecto de llamas. Muy lento debido a que utiliza la
  resolucin completa (320 * 200) y est 100% en Pascal, pero sirve
  para mostrar cmo se hace el efecto.

  por FAC & Johnny Storm
}

uses mode13, crt;

const ColorSemilla = 255; { Este es el color de los "puntos calientes"
                            que se generan al azar }

var DestScr, OrigenScr : PTVIrtual; { 2 pantallas virtuales }
    Destino, Origen : word;
    pal : TPalette;


{ La paleta se establece de la siguiente forma:

  0 a 31  - Degradado de negro a prpura oscuro y a negro otra vez.
            (para el "humo")

  32 a 95 - Degradado de negro a rojo

  96 a 159 - Degradado de rojo a amarillo

  160 a 223 - Degradado de amarillo a blanco

  224 - 255 - Blanco
}
procedure GeneraPaleta;
var i : byte;
begin
     for i := 0 to 15 do
     begin
          pal[i][0] := i;       { un poco de rojo para hacer humo prpura }
          pal[i][1] := 0;       { nada de verde }
          pal[i][2] := i;       { aumentamos un poco el azul (humo) }
     end;
     for i := 0 to 15 do
     begin
          pal[i + 16][0] := 15 - i;     { disminumos el rojo }
          pal[i + 16][1] := 0;          { nada de verde }
          pal[i + 16][2] := 15 - i;     { disminumos el azul (humo) }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 32][0] := i;  { aumentamos el rojo }
          pal[i + 32][1] := 0;  { nada de verde }
          pal[i + 32][2] := 0;  { nada de azul }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 96][0] := 63; { el rojo al mximo }
          pal[i + 96][1] := i;  { aumentamos el verde para formar amarillo }
          pal[i + 96][2] := 0;  { nada de azul }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 160][0] := 63;  { el rojo al mximo }
          pal[i + 160][1] := 63;  { el verde al mximo }
          pal[i + 160][2] := i;   { aumentamos el azul para obtener blanco }
     end;
     for i := 0 to 31 do
     begin
          pal[i + 224][0] := 63;
          pal[i + 224][1] := 63;
          pal[i + 224][2] := 63;
     end;
end;


{ Este procedimiento inicializa las pantallas virtuales y genera
  "puntos calientes" en las 2 lneas inferiores de la pantalla OrigenScr,
  que funciona como el arreglo origen }
procedure IniciaLlamas;
var x : word;
begin
     SetupVirtual(DestScr, Destino);
     SetupVirtual(OrigenScr, Origen);
     ClearScreen(0, Destino);
     ClearScreen(0, Origen);
     for x := 0 to 319 do
     begin
          PutPixel(x, 198, random(2) * ColorSemilla, Origen);
          PutPixel(x, 199, random(2) * ColorSemilla, Origen);
     end;
end;


{ Este procedimiento realiza el efecto.
  Todo el procedimiento est explicado en el tutorial, por lo que
  no tiene muchos comentarios. }
procedure MueveLlamas;
var off, x, y : word;
    color : integer;
begin
     off := 1;  { Comenzamos desde el punto (1, 0) -> 0 * 320 + 1 == 1 }

     for y := 0 to 197 do
     begin
          for x := 1 to 318 do
          begin
               { Calculamos el color promediando los cuatro puntos
                 adyacentes y restando 1 }
               color := mem[Origen:off] + mem[Origen:off+640] +
                        mem[Origen:off+319] + mem[Origen:off+321];
               if color > 3 then color := (color shr 2) - 1
                            else color := 0;

               { Almacenamos el color en el OTRO arreglo (destino) }
               mem[Destino:off] := color;
               inc(off); { Incrementamos el offset }
          end;
          inc(off, 2); { Incrementamos el offset en 2 para pasar a la }
     end;              { siguiente lnea con coordenada X igual a 1   }

     { Copiamos el arreglo destino al arreglo origen }
     CopyScreen(Destino, Origen);

     { Generamos nuevos "puntos calientes" }
     for x := 0 to 319 do
     begin
          mem[Origen:YOffset[198] + x] := random(2) * ColorSemilla;
          mem[Origen:YOffset[199] + x] := random(2) * ColorSemilla;
     end;

{  La siguiente seccin genera un gran "punto caliente" en algn lugar }
{  produciendo pequeas "explosiones" dentro de las llamas }
{
     off := YOffset[193] + random(316);
     meml[Origen:off] := $FFFFFFFF;
     meml[Origen:off+320] := $FFFFFFFF;
     meml[Origen:off+640] := $FFFFFFFF;
     meml[Origen:off+960] := $FFFFFFFF;
}
end;


{ Programa principal }
begin
     clrscr;
     writeln;
     writeln('Ejemplo del efecto de llamas.');
     writeln('Este ejemplo es MUY LENTO puesto que utiliza una resolucin');
     writeln('de 320 * 200 y puro Pascal.');
     writeln;
     writeln('El teclado espera...');
     readkey;

     randomize;
     GeneraPaleta;
     SetMode13;
     SetPalette(pal);
     IniciaLlamas;

     while not keypressed do
     begin
          MueveLlamas;
{          VRetrace; }  { Des-comentar esta lnea si hay parpadeos }
          CopyScreen(Destino, VGA);
     end;

     readkey;
     ShutDownVirtual(DestScr);
     ShutDownVirtual(OrigenScr);
     SetTextMode;
end.