
// SCROLLH.CPP  -- Ejemplo de scrolling horizontal -- por FAC

#include <iostream.h>      // cout
#include <conio.h>         // clrscr, getch
#include <mem.h>           // memmove
#include "mode13.h"
#include "mode13.cpp"


PTVirtual VirScr;
word VirSeg;


void DibujaFondo()
{
     int x, y, i, color;

     color = 1;
     for (y = 0; y < 8; y++)
     {
          for (x = 0; x < 10; x++)
          {
               for (i = 0; i < 25; i++)
                   HLine(x * 32, x * 32 + 31, y * 25 + i, color, VirSeg);
               if (++color > 2) color = 1;
          }
          if (++color > 2) color = 1;
     }
}

void ScrollIzquierda()
{
     byte buffer[200];
     word i;

     for (i = 0; i < 200; i++) buffer[i] = GetPixel(0, i, VirSeg);

     // En la funcin memmove, el primer parmetro es el apuntador destino
     // y el segundo parmetro es el apuntador fuente.
     // Esto es inverso a la funcin move del Pascal.
//   memmove(VirScr, VirScr + 1, 63999);
// La funcin memmove no funciona correctamente cuando una regin se
// desplaza uno o dos bytes. El siguiente cdigo en ASM funciona bien:

     asm {
           mov es, [VirSeg]
           xor di, di
           mov cx, 63999
         }
     loop: asm {
                 mov al, es:[di + 1]
                 mov es:[di], al
                 inc di
                 dec cx
                 jnz loop
               }

     for (i = 0; i < 200; i++) PutPixel(319, i, buffer[i], VirSeg);
     VRetrace();
     CopyScreen(VirSeg, VGA);
}


void ScrollDerecha()
{
     byte buffer[200];
     word i;

     for (i = 0; i < 200; i++) buffer[i] = GetPixel(319, i, VirSeg);
//   memmove(VirScr + 1, VirScr, 63999);
     asm {
           mov es, [VirSeg]
           mov di, 63999
         }
     loop: asm {
                 mov al, es:[di - 1]
                 mov es:[di], al
                 dec di
                 jnz loop
               }

     for (i = 0; i < 200; i++) PutPixel(0, i, buffer[i], VirSeg);
     VRetrace();
     CopyScreen(VirSeg, VGA);
}


void main()
{
     clrscr();
     cout << "\nEjemplo de scroll horizontal de pantalla completa.\n"
          << "\nPresiona cualquier tecla para continuar...\n";
     getch();

     SetMode13();
     SetupVirtual(VirScr, VirSeg);
     DibujaFondo();

     while (!kbhit()) ScrollIzquierda();
     getch();
     while (!kbhit()) ScrollDerecha();
     getch();

     ShutDownVirtual(VirScr);
     SetTextMode();
}
