.386p
.model flat,syscall
.code

                include p:\nms.mac
		include	p:\nms.ext
		include	p:\nms.str
                include p:\devices\dma.ext

;
; Music Setup 
;
; INFO        Asks user for soundcard setup.
; IN    EAX - Pointer to driver structures.
; OUT   EAX - Pointer to driver structure.
;
nms_manualsetup         PROC    PUBLIC USES es
			push	ds
			pop	es
                        pushad
                        mov     driverptr,eax

			call	SYS_getprginfo
			mov	eax,0b8000h
			sub	eax,ebx
			mov     screen_addr,eax

			mov     ax,03h                  ;Set Screen to 80x25
                        int     10h

nms_manualsetup_again:	lea     esi,screen1             ;Paint the screen
                        mov     edi,screen_addr
                        mov     ecx,80*25*2/4
                rep     movsd
                        mov     snd1,0
nms_manualsetup_step0:  call    getsnd1
                        jc      nms_manualsetup_abort
                        mov     snd2,0
nms_manualsetup_step1:  call    getsnd2
                        jc      nms_manualsetup_step0
                        mov     port1,0
nms_manualsetup_step2:  call    getport1
                        jc      nms_manualsetup_step1
                        mov     port2,0
nms_manualsetup_step3:  call    getport2
                        jc      nms_manualsetup_step2
                        mov     irq1,0
nms_manualsetup_step4:  call    getirq1
                        jc      nms_manualsetup_step3
                        mov     irq2,0
nms_manualsetup_step5:  call    getirq2
                        jc      nms_manualsetup_step4
                        mov     dma1,0
nms_manualsetup_step6:  call    getdma1
                        jc      nms_manualsetup_step5
nms_manualsetup_step7:  call    getdma2
                        jc      nms_manualsetup_step6
                        call    confirm
                        jc      nms_manualsetup_again
			mov     ax,03h                  ;Set Screen to 80x25
                        int     10h
                        clc
                        jmp     nms_manualsetup_done
nms_manualsetup_abort:  mov     ax,03h                  ;Set Screen to 80x25
                        int     10h
			mov	nms_error,0h
nms_manualsetup_fail:   stc
nms_manualsetup_done:   popad
                        mov     eax,driverptr
                        ret
nms_manualsetup		ENDP

;Ŀ
; Main Code 
;

initdisp		PROC
			push    esi
                        mov     eax,0404h
                        lea     esi,msg_empty+8
                        call    write
                        pop     esi
                        lea     edi,asciiout
                        call    cnvstring
                        lea     esi,asciiout
                        mov     eax,0504h
                        call    write
                        ret
initdisp		ENDP

cleardisp		PROC
                        mov     edx,0206h
cleardisp_l:		mov     eax,edx
                        lea     esi,msg_empty+4
                        call    write
                        mov     eax,edx
                        mov     ecx,76
                        call    clrbar
                        inc     dl
                        cmp     dl,12h
                        jne     cleardisp_l
                        ret
cleardisp		ENDP

selectdisp		PROC
			mov     selectdispjmp,esi
selectdisp_l:           mov     eax,edx
                        add     eax,0206h
                        mov     ecx,76
                        call    setbar
                        cmp     selectdispjmp,0
                        je      selectdisp_l2
                        call    [selectdispjmp]
selectdisp_l2:          call    readkey
                        cmp     al,0dh
                        je      selectdisp_done
                        cmp     al,1bh
                        je      selectdisp_abort
                        cmp     al,00h
                        jne     selectdisp_l2
                        call    readkey
                        cmp     al,48h
                        je      selectdisp_up
                        cmp     al,50h
                        je      selectdisp_down
                        jmp     selectdisp_l2
selectdisp_up:          cmp     edx,0
                        je      selectdisp_l2
                        mov     eax,edx
                        add     eax,0206h
                        mov     ecx,76
                        call    clrbar
                        dec     edx
                        jmp     selectdisp_l
selectdisp_down:        cmp     edx,selections
                        je      selectdisp_l2
                        mov     eax,edx
                        add     eax,0206h
                        mov     ecx,76
                        call    clrbar
                        inc     edx
                        jmp     selectdisp_l
selectdisp_done:        clc
			jmp	selectdisp_quit
selectdisp_abort:       stc
selectdisp_quit:	ret
selectdispjmp           dd      0
selectdisp		ENDP

;Ĵ Ask for soundcard 

getsnd1			PROC
			lea     esi,msg_sndcard
                        call    initdisp

                        call    cleardisp

                        mov     ebp,driverptr
                        mov     ecx,-1
                        mov     edx,0206h
getsnd1_l1:             mov     edi,ds:[ebp]
                        cmp     edi,-1
                        je      getsnd1_done1
                        lea     esi,msg_nomore
                        cmp     drv.cards[edi],0
                        je      getsnd1_just1
                        lea     esi,msg_more
getsnd1_just1:          mov     eax,edx
                        call    write
                        mov     esi,drv.text[edi]
                        lea     edi,asciiout
                        call    cnvstring
                        lea     esi,asciiout
                        call    write
                        inc     ecx
                        inc     dl
                        add     ebp,4
                        jmp     getsnd1_l1
getsnd1_done1:          cmp     ecx,-1
                        je      getsnd1_abort
                        mov     selections,ecx

                        mov     edx,snd1
                        lea     esi,getsnd1_info
                        call    selectdisp
                        mov     snd1,edx
			jmp	getsnd1_done
getsnd1_abort:          stc
getsnd1_done:          	ret
getsnd1			ENDP

getsnd1_info		PROC
			lea     esi,msg_empty+6
                        mov     eax,0314h
                        call    write
                        mov     esi,driverptr
                        mov     esi,[esi+edx*4]
                        mov     esi,drv.version[esi]
                        cmp     esi,-1
                        je      getsnd1_info1
                        lea     edi,asciiout
                        call    cnvstring
                        lea     esi,asciiout
                        mov     eax,0314h
                        call    write
getsnd1_info1:          lea     esi,msg_empty+6
                        mov     eax,0316h
                        call    write
                        mov     esi,driverptr
                        mov     esi,[esi+edx*4]
                        mov     esi,drv.note[esi]
                        cmp     esi,-1
                        je      getsnd1_info2
                        lea     edi,asciiout
                        call    cnvstring
                        lea     esi,asciiout
                        mov     eax,0316h
                        call    write
getsnd1_info2:          ret
getsnd1_info		ENDP

;Ĵ Ask for soundcard version 

getsnd2			PROC
			pushfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ecx,drv.config[eax]
                        mov     config,ecx
                        mov     ecx,drv.cards[eax]
                        mov     ebp,drv.cardlst[eax]
                        cmp     ecx,0
                        je      getsnd2_skip
                        popfd
                        dec     ecx
                        mov     selections,ecx

                        lea     esi,msg_sndcard
                        call    initdisp

                        call    cleardisp

                        mov     edx,0606h
                        mov     ecx,selections
getsnd2_l1:             mov     esi,ds:[ebp]
                        lea     edi,asciiout
                        call    cnvstring
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        inc     dl
                        add     ebp,8
                        dec     ecx
                        jns     getsnd2_l1

                        clr     esi
                        mov     edx,snd2
                        call    selectdisp
                        jc      getsnd2_abort
                        mov     snd2,edx

                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     eax,drv.cardlst[eax]
                        mov     ecx,4[eax+edx*8]
                        mov     config,ecx
getsnd2_abort:          jmp	getsnd2_done
getsnd2_skip:           popfd
getsnd2_done:		ret
getsnd2			ENDP

;Ĵ Ask for soundcard port1 

getport1		PROC
			pushfd
                        test    config,00000001b
                        jz      getport1_skip
                        popfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ebp,drv.port1lst[eax]
                        mov     esi,drv.port1desc[eax]
                        call    initdisp

                        call    cleardisp

                        mov     edi,-1
                        mov     edx,0606h
getport1_l1:            mov     eax,ds:[ebp]
                        cmp     eax,-1
                        je      getport1_ready1
                        mov     ecx,0
                        call    dword2hex
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        mov     bh,'h'
                        call    writech
                        inc     edi
                        inc     dl
                        add     ebp,4
                        jmp     getport1_l1
getport1_ready1:        mov     selections,edi

                        clr     esi
                        mov     edx,port1
                        call    selectdisp
                        mov     port1,edx
			jmp	getport1_done
getport1_skip:          popfd
getport1_done:		ret
getport1		ENDP

;Ĵ Ask for soundcard port2 

getport2		PROC
			pushfd
                        test    config,00000010b
                        jz      getport2_skip
                        popfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ebp,drv.port2lst[eax]
                        mov     esi,drv.port2desc[eax]
                        call    initdisp

                        call    cleardisp

                        mov     edi,-1
                        mov     edx,0606h
getport2_l1:            mov     eax,ds:[ebp]
                        cmp     eax,-1
                        je      getport2_ready1
                        mov     ecx,0
                        call    dword2hex
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        mov     bh,'h'
                        call    writech
                        inc     edi
                        inc     dl
                        add     ebp,4
                        jmp     getport2_l1
getport2_ready1:        mov     selections,edi

                        clr     esi
                        mov     edx,port2
                        call    selectdisp
                        mov     port2,edx
			jmp	getport2_done
getport2_skip:          popfd
getport2_done:		ret
getport2		ENDP

;Ĵ Ask for soundcard irq1 

getirq1			PROC
			pushfd
                        test    config,00000100b
                        jz      getirq1_skip
                        popfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ebp,drv.irq1lst[eax]
                        mov     esi,drv.irq1desc[eax]
                        call    initdisp

                        call    cleardisp

                        mov     edi,-1
                        mov     edx,0606h
getirq1_l1:             mov     eax,ds:[ebp]
                        cmp     eax,-1
                        je      getirq1_ready1
                        mov     ecx,0
                        call    dword2dec
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        inc     edi
                        inc     dl
                        add     ebp,4
                        jmp     getirq1_l1
getirq1_ready1:         mov     selections,edi

                        clr     esi
                        mov     edx,irq1
                        call    selectdisp
                        mov     irq1,edx
			jmp	getirq1_done
getirq1_skip:		popfd
getirq1_done:		ret
getirq1			ENDP

;Ĵ Ask for soundcard irq2 

getirq2			PROC
			pushfd
                        test    config,00001000b
                        jz      getirq2_skip
                        popfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ebp,drv.irq2lst[eax]
                        mov     esi,drv.irq2desc[eax]
                        call    initdisp

                        call    cleardisp

                        mov     edi,-1
                        mov     edx,0606h
getirq2_l1:             mov     eax,ds:[ebp]
                        cmp     eax,-1
                        je      getirq2_ready1
                        mov     ecx,0
                        call    dword2dec
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        inc     edi
                        inc     dl
                        add     ebp,4
                        jmp     getirq2_l1
getirq2_ready1:         mov     selections,edi

                        clr     esi
                        mov     edx,irq2
                        call    selectdisp
                        mov     irq2,edx
			jmp	getirq2_done
getirq2_skip:		popfd
getirq2_done:		ret
getirq2			ENDP

;Ĵ Ask for soundcard dma1 

getdma1			PROC
			pushfd
                        test    config,00010000b
                        jz      getdma1_skip
                        popfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ebp,drv.dma1lst[eax]
                        mov     esi,drv.dma1desc[eax]
                        call    initdisp

                        call    cleardisp

                        mov     edi,-1
                        mov     edx,0606h
getdma1_l1:             mov     eax,ds:[ebp]
                        cmp     eax,-1
                        je      getdma1_ready1
                        mov     ecx,0
                        call    dword2dec
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        inc     edi
                        inc     dl
                        add     ebp,4
                        jmp     getdma1_l1
getdma1_ready1:         mov     selections,edi

                        clr     esi
                        mov     edx,dma1
                        call    selectdisp
                        mov     dma1,edx
			jmp	getdma1_done
getdma1_skip:		popfd
getdma1_done:		ret
getdma1			ENDP

;Ĵ Ask for soundcard dma2 

getdma2			PROC
			pushfd
                        test    config,00100000b
                        jz      getdma2_skip
                        popfd
                        mov     eax,snd1
                        shl     eax,2
                        add     eax,driverptr
                        mov     eax,[eax]
                        mov     ebp,drv.dma2lst[eax]
                        mov     esi,drv.dma2desc[eax]
                        call    initdisp

                        call    cleardisp

                        mov     edi,-1
                        mov     edx,0606h
getdma2_l1:             mov     eax,ds:[ebp]
                        cmp     eax,-1
                        je      getdma2_ready1
                        mov     ecx,0
                        call    dword2dec
                        lea     esi,asciiout
                        mov     eax,edx
                        call    write
                        inc     edi
                        inc     dl
                        add     ebp,4
                        jmp     getdma2_l1
getdma2_ready1:         mov     selections,edi

                        clr     esi
                        mov     edx,dma2
                        call    selectdisp
                        mov     dma2,edx
			jmp	getdma2_done
getdma2_skip:		popfd
getdma2_done:		ret
getdma2			ENDP

;Ĵ Confirm Settings 

confirm			PROC
			lea     esi,screen2
                        mov     edi,screen_addr
                        mov     ecx,80*25*2/4
                rep     movsd

                        mov     edi,snd1
                        shl     edi,2
                        add     edi,driverptr
                        mov     edi,[edi]
                        mov     snd1+4,edi
                        mov     eax,snd2
                        mov     snd2+4,eax
                        inc     snd2+4
                        shl     eax,3
                        mov     esi,drv.text[edi]
                        cmp     drv.cards[edi],0
                        je      confirm_cards
                        mov     esi,drv.cardlst[edi]
                        add     esi,eax
                        mov     esi,[esi]
confirm_cards:          push    edi
                        lea     edi,asciiout
                        call    cnvstring
                        lea     esi,asciiout
                        mov     eax,1007h
                        call    write
                        pop     edi

                        lea     esi,msg_na
                        mov     eax,1008h
                        call    write
                        test    config,00000001b
                        jz      confirm_port1
                        mov     esi,port1
                        shl     esi,2
                        add     esi,drv.port1lst[edi]
                        mov     eax,[esi]
                        mov     port1+4,eax
                        clr     ecx
                        call    dword2hex
                        lea     esi,asciiout
                        mov     eax,1008h
                        call    write
                        mov     bh,'h'
                        call    writech
confirm_port1:
                        lea     esi,msg_na
                        mov     eax,1009h
                        call    write
                        test    config,00000010b
                        jz      confirm_port2
                        mov     esi,port1
                        shl     esi,2
                        add     esi,drv.port2lst[edi]
                        mov     eax,[esi]
                        mov     port2+4,eax
                        clr     ecx
                        call    dword2hex
                        lea     esi,asciiout
                        mov     eax,1009h
                        call    write
                        mov     bh,'h'
                        call    writech
confirm_port2:
                        lea     esi,msg_na
                        test    config,00000100b
                        jz      confirm_irq1
                        mov     esi,irq1
                        shl     esi,2
                        add     esi,drv.irq1lst[edi]
                        mov     eax,[esi]
                        mov     irq1+4,eax
                        clr     ecx
                        call    dword2dec
                        lea     esi,asciiout
confirm_irq1:           mov     eax,100ah
                        call    write

                        lea     esi,msg_na
                        test    config,00001000b
                        jz      confirm_irq2
                        mov     esi,irq2
                        shl     esi,2
                        add     esi,drv.irq2lst[edi]
                        mov     eax,[esi]
                        mov     irq2+4,eax
                        clr     ecx
                        call    dword2dec
                        lea     esi,asciiout
confirm_irq2:           mov     eax,100bh
                        call    write

                        lea     esi,msg_na
                        test    config,00010000b
                        jz      confirm_dma1
                        mov     esi,dma1
                        shl     esi,2
                        add     esi,drv.dma1lst[edi]
                        mov     eax,[esi]
                        mov     dma1+4,eax
                        clr     ecx
                        call    dword2dec
                        lea     esi,asciiout
confirm_dma1:           mov     eax,100ch
                        call    write

                        lea     esi,msg_na
                        test    config,00100000b
                        jz      confirm_dma2
                        mov     esi,dma2
                        shl     esi,2
                        add     esi,drv.dma2lst[edi]
                        mov     eax,[esi]
                        mov     dma2+4,eax
                        clr     ecx
                        call    dword2dec
                        lea     esi,asciiout
confirm_dma2:           mov     eax,100dh
                        call    write


confirm_again:          call    readkey
                        cmp     al,1bh
                        je      confirm_fail
                        cmp     al,0dh
                        jne     confirm_again
                        mov     esi,snd1+4
                        mov     driverptr,esi
                        cmp     drv.cards[esi],0
                        je      confirm_skipcard
                        mov     eax,snd2+4
                        mov     drv.card[esi],eax
confirm_skipcard:       mov     eax,port1+4
                        mov     drv.port1[esi],eax
                        mov     eax,port2+4
                        mov     drv.port2[esi],eax
                        mov     eax,irq1+4
                        mov     drv.irq1[esi],eax
                        mov     eax,irq2+4
                        mov     drv.irq2[esi],eax
                        mov     eax,dma1+4
                        mov     drv.dma1[esi],eax
                        mov     eax,dma2+4
                        mov     drv.dma2[esi],eax
                        clc
			jmp	confirm_done
confirm_fail:           stc
confirm_done:		ret
confirm			ENDP


;Ŀ
; Subroutines 
;

;Ĵ Convert String to asciiz 

cnvstring		PROC	USES eax esi
cnvstring_l:            lodsb
                        cmp     al,0
                        je      cnvstring_done
                        cmp     al,13
                        je      cnvstring_done
                        cmp     al,10
                        je      cnvstring_done
                        cmp     al,36
                        je      cnvstring_done
                        stosb
                        jmp     cnvstring_l
cnvstring_done:         clr     al
                        stosb
			ret
cnvstring		ENDP

;Ĵ Write asciiZ string 

writech			PROC	USES esi
			mov	writech_dat,bh
			lea	esi,writech_dat
			call	write
			ret
writech_dat		db	0,0
writech			ENDP

write			PROC	USES ebx ecx esi edi
			push	eax
			movzx	ebx,al
			shl	ebx,5
			mov	edi,ebx
			shl	edi,2
			add	edi,ebx
			movzx	ebx,ah
			add	edi,ebx
			add	edi,ebx
			add	edi,screen_addr
			clr	ecx
write_l:		lodsb
			or	al,al
			jz	write_done
			mov	[edi],al
			add	edi,2
			inc	ecx
			jmp	write_l
write_done:		pop	eax
write_fix_l:		cmp	cl,80
			jb	write_nomorey
			inc	al
			sub	cl,80
			jmp	write_fix_l
write_nomorey:		add	ah,cl
			cmp	ah,80
			jb	write_ok
			inc	al
			sub	ah,80
write_ok:		ret
write			ENDP

;Ĵ Write asciiZ string with attribute 

writecolch		PROC	USES esi
			mov	writecolch_dat,bh
			lea	esi,writecolch_dat
			call	writecol
			ret
writecolch_dat		db	0,0
writecolch		ENDP

writecol		PROC	USES ebx ecx esi edi
			push	eax
			xchg	bl,al
			and	ebx,0ffh
			shl	ebx,5
			mov	edi,ebx
			shl	edi,2
			add	edi,ebx
			movzx	ebx,ah
			add	edi,ebx
			add	edi,ebx
			add	edi,screen_addr
			mov	ah,al
			clr	ecx
writecol_l:		lodsb
			or	al,al
			jz	writecol_done
			stosw
			inc	ecx
			jmp	writecol_l
writecol_done:		pop	eax
writecol_fix_l: 	cmp	cl,80
			jb	writecol_nomorey
			inc	al
			sub	cl,80
			jmp	writecol_fix_l
writecol_nomorey:	add	ah,cl
			cmp	ah,80
			jb	writecol_ok
			inc	al
			sub	ah,80
writecol_ok:		ret
writecol		ENDP

;Ĵ Convert dword to ascii decimal 

dword2dec		PROC
			pushad
			push	ecx
			lea	esi,decdivs
			lea	edi,asciitemp
dword2dec_l:		clr	edx
			mov	ebx,[esi]
			div	ebx
			and	al,0fh
			or	al,30h
			stosb
			mov	eax,edx
			add	esi,4
			cmp	esi,ofs decdivs+10*4
			jne	dword2dec_l
			lea	esi,asciitemp
			clr	eax
			clr	ecx
			mov	edx,10
dword2dec_postl:	lodsb
			cmp	ax,030h
			je	dword2dec_post_not
			mov	ah,0ffh
			inc	ecx
dword2dec_post_not:	dec	edx
			jnz	dword2dec_postl

			lea	edi,asciiout
			pop	edx
			cmp	cl,dl
			jae	dword2dec_post_ok
			sub	dl,cl
			mov	bl,cl
			mov	cl,dl
			mov	al,20h
		rep	stosb
			mov	cl,bl
			or	cl,cl
			jnz	dword2dec_post_ok
			dec	edi
dword2dec_post_ok:	lea	esi,asciitemp
			add	esi,10
			sub	esi,ecx
			cmp	esi,ofs asciitemp+10
			jne	dword2dec_skip
			inc	ecx
			dec	esi
dword2dec_skip: rep	movsb
			clr	al
			stosb
			popad
			ret
dword2dec		ENDP

;Ĵ Convert dword to ascii hexadecimal 

dword2hex		PROC
			pushad
			lea	edi,asciitemp
			mov	edx,ecx
			mov	ebx,eax
			rol	ebx,4
			mov	ecx,8
dword2hex_l:		mov	al,bl
			and	eax,0fh
			mov	al,hextab[eax]
			stosb
			rol	ebx,4
			dec	ecx
			jnz	dword2hex_l

			lea	esi,asciitemp
			clr	eax
			clr	ecx
			mov	ebx,8
dword2hex_postl:	lodsb
			cmp	ax,030h
			je	dword2hex_post_not
			mov	ah,0ffh
			inc	ecx
dword2hex_post_not:	dec	ebx
			jnz	dword2hex_postl

			lea	edi,asciiout

			cmp	cl,dl
			jae	dword2hex_post_ok
			sub	dl,cl
			mov	bl,cl
			mov	cl,dl
			mov	al,30h
		rep	stosb
			mov	cl,bl
			or	cl,cl
			jnz	dword2hex_post_ok
			dec	edi
dword2hex_post_ok:	lea	esi,asciitemp
			add	esi,8
			sub	esi,ecx
			cmp	esi,ofs asciitemp+8
			jne	dword2hex_skip
			inc	ecx
			dec	esi
dword2hex_skip: rep	movsb
			clr	al
			stosb
			popad
			ret
dword2hex		ENDP

setbar			PROC
			pushad
                        movzx   ebx,al
			shl	ebx,5
			mov	edi,ebx
			shl	edi,2
			add	edi,ebx
			movzx	ebx,ah
			add	edi,ebx
			add	edi,ebx
			add	edi,screen_addr
setbar_l:               mov     eax,[edi]
                        and     eax,0fffh
                        or      eax,1000h
                        mov     [edi],ax
                        add     edi,2
                        dec     ecx
                        jnz     setbar_l
                        popad
			ret
setbar			ENDP

clrbar			PROC
			pushad
                        movzx   ebx,al
			shl	ebx,5
			mov	edi,ebx
			shl	edi,2
			add	edi,ebx
			movzx	ebx,ah
			add	edi,ebx
			add	edi,ebx
			add	edi,screen_addr
clrbar_l:               mov     eax,[edi]
                        and     eax,0fffh
                        or      eax,7000h
                        mov     [edi],ax
                        add     edi,2
                        dec     ecx
                        jnz     clrbar_l
                        popad
                        ret
clrbar			ENDP

keypressed		PROC
			cmp     scancode,0
                        jne     keypressed_1
                        mov     ah,1
                        int     16h
                        jne     keypressed_1
                        clc
			jmp	keypressed_2
keypressed_1:           stc
keypressed_2:   	ret
keypressed		ENDP

readkey			PROC
			mov     al,scancode
                        mov     scancode,0
                        or      al,al
                        jne     readkey_1
                        xor     ah,ah
                        int     16h
                        or      al,al
                        jne     readkey_1
                        mov     scancode,ah
                        or      ah,ah
                        jne     readkey_1
                        mov     al,'c'-64
readkey_1:              ret
readkey			ENDP
scancode		db	0

;Ŀ
;Ŀ
; Data 
;ٰ
;

.data
screen1                 label   byte
                include setup\screen1.inc
screen2                 label   byte
                include setup\screen2.inc

decdivs                 dd      1000000000
                        dd      100000000
                        dd      10000000
                        dd      1000000
                        dd      100000
                        dd      10000
                        dd      1000
                        dd      100
                        dd      10
                        dd      1
hextab                  db      '0123456789abcdef'
msg_sndcard             db      'Soundcard',eol
msg_empty               db      80 dup(' '),0
msg_more                db      '[+] ',0
msg_nomore              db      '    ',0
msg_na                  db      'N/A',0
snd1                    dd      0,-1
snd2                    dd      0,-1
port1                   dd      0,-1
port2                   dd      0,-1
port3                   dd      0,-1
irq1                    dd      0,-1
irq2                    dd      0,-1
dma1                    dd      0,-1
dma2                    dd      0,-1
.data?
driverptr               dd      ?
selections              dd      ?
config                  dd      ?
asciitemp               db      11 dup(?)
asciiout                db      256 dup(?)
screen_addr             dd      ?
			END

