
#ifndef __NMS_H
#define __NMS_H

#ifdef __cplusplus
extern "C"
{
#endif

char *nms_init(void *systemlist);
  #pragma aux nms_init "*" = \
	 "call nms_init", \
	 "jnc ok", \
	 "xor eax,eax", \
	 "ok:", \
   parm [eax] value [eax];

int nms_exit();
  #pragma aux nms_exit "*" =\
	 "call nms_exit",\
	 "mov eax,0",\
	 "jc fail",\
	 "dec eax",\
	 "fail:",\
	 value [eax];

char *nms_driverinit(void *driver);
  #pragma aux nms_driverinit "*" =\
	 "call nms_driverinit", \
	 "jnc ok", \
	 "xor eax,eax", \
	 "ok:", \
	 parm [eax] value [eax];

int nms_driverexit();
  #pragma aux nms_driverexit "*" =\
	 "call nms_driverexit",\
	 "mov eax,0",\
	 "jc fail",\
	 "dec eax",\
	 "fail:",\
	 value [eax];

char *nms_moduleinit(void *formatlist,void *module);
  #pragma aux nms_moduleinit "*" =\
	 "call nms_moduleinit", \
	 "jnc ok", \
	 "xor eax,eax", \
	 "ok:", \
	 parm [eax] [ebx] value [eax];

int nms_moduleexit();
  #pragma aux nms_moduleexit "*" =\
	 "call nms_moduleexit",\
	 "mov eax,0",\
	 "jc fail",\
	 "dec eax",\
	 "fail:",\
	 value [eax];

int nms_modulestart();
  #pragma aux nms_modulestart "*" =\
	 "call nms_modulestart",\
	 "mov eax,0",\
	 "jc fail",\
	 "dec eax",\
	 "fail:",\
	 value [eax];

int nms_modulestop();
  #pragma aux nms_modulestop "*" =\
	 "call nms_modulestop",\
	 "mov eax,0",\
	 "jc fail",\
	 "dec eax",\
	 "fail:",\
	 value [eax];

void *nms_autosetup(void *driverlist);
  #pragma aux nms_autosetup "*" =\
	 "call nms_autosetup", \
	 "jnc ok", \
	 "xor eax,eax", \
	 "ok:", \
	 parm [eax] value [eax];

void *nms_manualsetup(void *driverlist);
  #pragma aux nms_manualsetup "*" =\
   "call nms_manualsetup", \
	 "jnc ok", \
	 "xor eax,eax", \
	 "ok:", \
	 parm [eax] value [eax];

void nms_activatesync(void(*syncjmp)());
  #pragma aux nms_activesync "*" =\
   parm [eax];

void nms_deactivatesync();
  #pragma aux nms_deactivesync "*"

void nms_setmastervol(int globalvol);
  #pragma aux nms_setmastervol "*" =\
   parm [eax];

extern unsigned long nms_error;
	#pragma aux nms_error "*"
extern unsigned long nms_errors[];
	#pragma aux nms_errors "*"

extern long nms_modulepos;
	#pragma aux nms_modulepos "*"

extern long nms_jmp_row;
  #pragma aux nms_jmp_row "*"

extern unsigned long DOS32_cmdlist;
	#pragma aux DOS32_cmdlist "*"
extern unsigned long DOS4G_cmdlist;
	#pragma aux DOS4G_cmdlist "*"
extern unsigned long PMODE_cmdlist;
        #pragma aux PMODE_cmdlist "*"

extern unsigned long GUS_cmdlist;
	#pragma aux GUS_cmdlist "*"
//extern unsigned long AWE_cmdlist;
//	#pragma aux AWE_cmdlist "*"
extern unsigned long PAS_cmdlist;
	#pragma aux PAS_cmdlist "*"
extern unsigned long SB_cmdlist;
	#pragma aux SB_cmdlist "*"
extern unsigned long WSS_cmdlist;
	#pragma aux PAS_cmdlist "*"
extern unsigned long NS_cmdlist;
	#pragma aux NS_cmdlist "*"
extern unsigned long DSK_cmdlist;
        #pragma aux DSK_cmdlist "*"

extern unsigned long MOD_cmdlist;
	#pragma aux MOD_cmdlist "*"
extern unsigned long DSM_cmdlist;
	#pragma aux DSM_cmdlist "*"
extern unsigned long S3M_cmdlist;
	#pragma aux S3M_cmdlist "*"
extern unsigned long XM_cmdlist;
	#pragma aux XM_cmdlist "*"

#ifdef __cplusplus
};
#endif

#endif
