.386p
.model flat,syscall
.code

		include p:\nms.mac
                include p:\nms.str
		include p:\nms.ext

		public	S3M_cmdlist

;Ĵ S3M test 

S3M_test		PROC
                        cmp     wptr 1ch[esi],101ah
			jne	S3M_test_fail
                        cmp     dwptr 2ch[esi],"MRCS"
			jne	S3M_test_fail
			clc
			ret
S3M_test_fail:		stc
			ret
S3M_test		ENDP

;Ĵ S3M start 

S3M_init		PROC
			pushad
			mov	nms_error,23h
			call	S3M_test
			jc	S3M_init_fail

			lea	edi,S3M_voiceinfo
			clr	eax
                        mov     ecx,32*size s3mvoc
		rep	stosb

			mov	S3M_module,esi

			mov	nms_error,22h
			cmp	wptr 28h[esi],01300h	;Minimum V3.01Beta
			jbe	S3M_init_fail
			mov	nms_error,21h
			cmp	wptr 28h[esi],01320h	;Maximum V3.20
			ja	S3M_init_fail

			mov	nms_error,20h	      	;Unsupported feature(Adlib channel)
			lea	edi,S3M_voiceinfo
			lea	ebx,40h[esi]
			mov	ecx,32
			clr	edx
S3M_init_setchns:	mov	al,[ebx]
			inc	ebx

                        and     s3mvoc.control[edi],NOT 80h
			test	al,080h
			jnz	S3M_init_setchns_skip

			inc	edx
                        or      s3mvoc.control[edi],80h
			test	al,010h
			jnz	S3M_init_fail

			and	al,0fh
                        mov     s3mvoc.panning[edi],3
			cmp	al,8h
			jae	S3M_init_setchns_skip
                        mov     s3mvoc.panning[edi],12
S3M_init_setchns_skip:  add     edi,size s3mvoc
			dec	ecx
			jnz	S3M_init_setchns

			mov	S3M_chns,edx
			mov	eax,edx
			call	[DRV_setchns]

			mov	eax,esi
			add	eax,60h
			mov	S3M_orderptr,eax
			movzx	ebx,wptr 20h[esi]
			mov	S3M_orders,ebx
			add	eax,ebx
			mov	S3M_instptrs,eax
			movzx	ebx,wptr 22h[esi]
			mov	S3M_samples,ebx
			add	ebx,ebx
			add	eax,ebx
			mov	S3M_pattptrs,eax

			cmp	bptr 35h[esi],0fch		;252=FC=future crew=lame
			jne	S3M_init_nopan
			movzx	ebx,wptr 24h[esi]
			add	ebx,ebx
			add	ebx,eax
			lea	edi,S3M_voiceinfo
			mov	ecx,32
S3M_init_setpans:	mov	al,[ebx]
			inc	ebx
			test	al,020h
			jz	S3M_init_setpans_skip
			and	al,0fh
                        mov     s3mvoc.panning[edi],al
S3M_init_setpans_skip:  add     edi,size s3mvoc
			dec	ecx
			jnz	S3M_init_setpans
S3M_init_nopan:
			mov	S3M_samplesign,128
                        cmp     bptr 2ah[esi],1
			jne	S3M_init_unsigned
			mov	S3M_samplesign,0
S3M_init_unsigned:
			call	[DRV_clrsamples]

			lea	esi,S3M_init_sample
			mov	edi,S3M_instptrs
                        mov     sam.number[esi],1
			mov	edx,S3M_samples
S3M_init_dosamples:	movzx	eax,wptr [edi]
			add	edi,2
			shl	eax,4
			add	eax,S3M_module

                        mov     nms_error,20h         ;Unsupported feature(Adlib instrument)
                        cmp     bptr [eax],1
			ja	S3M_init_fail
                        jb      S3M_init_skipsample

			movzx	ebx,wptr 14[eax]
			shl	ebx,4
			add	ebx,S3M_module
                        mov     sam.sstart[esi],ebx
			movzx	ecx,wptr 16[eax]
			add	ecx,ebx
                        mov     sam.send[esi],ecx
			movzx	ecx,wptr 20[eax]
			add	ecx,ebx
                        mov     sam.lstart[esi],ecx
			movzx	ecx,wptr 24[eax]
			add	ecx,ebx
                        mov     sam.lend[esi],ecx

                        mov     nms_error,20h         ;Unsupported feature(16bit or stereo sample)
			test	bptr 31[eax],2+4
			jnz	S3M_init_fail

                        mov     sam.stype[esi],0
			test	bptr 31[eax],1
			jz	S3M_init_noloop
                        mov     sam.stype[esi],cnt_loop
S3M_init_noloop:
                        mov     ebx,sam.sstart[esi]
                        mov     cl,S3M_samplesign
S3M_init_convert:       sub     [ebx],cl
                        inc     ebx
                        cmp     ebx,sam.send[esi]
			jb	S3M_init_convert

			call	[DRV_setsample]

S3M_init_skipsample:    inc     sam.number[esi]
                        dec     edx
			jnz	S3M_init_dosamples

			call	[DRV_initsamples]
			jc	S3M_init_fail

			mov	esi,S3M_module

			mov	al,31h[esi]
			mov	S3M_speed,al
			movzx	eax,bptr 32h[esi]
			call	[DRV_setbpm]
			mov	S3M_counter,0
			mov	S3M_songpos,0
			mov	S3M_pattpos,0

			mov	eax,S3M_orderptr
			add	eax,S3M_songpos
			movzx	eax,bptr [eax]
			add	eax,eax
			add	eax,S3M_pattptrs
			movzx	eax,wptr [eax]
			shl	eax,4
			add	eax,S3M_module
			add	eax,2
			mov	S3M_pattposofs,eax

			popad
			clc
			ret
S3M_init_fail:		popad
			stc
			ret
S3M_init_sample         db      size sam dup(0)
S3M_init		ENDP

;Ĵ S3M exit 

S3M_exit		PROC
			ret
S3M_exit		ENDP

;Ĵ S3M play 

S3M_play		PROC
			call	[DRV_activate]
			ret
S3M_play		ENDP

;Ĵ S3M stop 

S3M_stop		PROC	USES eax
			call	[DRV_deactivate]
			mov	eax,S3M_chns
			dec	eax
S3M_stop_l1:		call	[DRV_setactivechn]
			call	[DRV_stopchn]
			dec	eax
			jns	S3M_stop_l1
			ret
S3M_stop		ENDP

;Ĵ S3M playtick 

S3M_playtick		PROC
			pushad

			call	[FMT_jmp_tick]

			inc	S3M_counter
			mov	al,S3M_counter
			cmp	S3M_speed,al
			je	S3M_playtick_new
			call	S3M_nonew
			jmp	S3M_playtick_done
S3M_playtick_new:	mov	S3M_counter,0

			mov	eax,S3M_songpos
			and	eax,07fh
			mov	ebx,S3M_pattpos
			and	ebx,03fh
			shl	eax,16
			or	eax,ebx
			mov	FMT_pos,eax
			call	[FMT_jmp_row]

			call	S3M_setupvoices
			call	S3M_playvoices

			inc	S3M_pattpos
			cmp	S3M_pattpos,64
			jb	S3M_playtick_nonewpatt
S3M_playtick_nextpatt:	mov	eax,S3M_pattbreakpos
			mov	S3M_pattbreakpos,0
			mov	S3M_pattpos,eax
			mov	S3M_posjumpflag,0
S3M_playtick_skippatt:	inc	S3M_songpos
			mov	eax,S3M_module
			movzx	eax,wptr 20h[eax]
			cmp	S3M_songpos,eax
			jl	S3M_playtick_notend
S3M_playtick_end:	mov	S3M_songpos,0
			call	[FMT_jmp_end]
S3M_playtick_notend:	mov	eax,S3M_orderptr
			add	eax,S3M_songpos
			movzx	eax,bptr [eax]

			cmp	eax,0feh
			je	S3M_playtick_skippatt

			cmp	eax,0ffh
			je	S3M_playtick_end

			add	eax,eax
			add	eax,S3M_pattptrs
			movzx	eax,wptr [eax]
			shl	eax,4
			add	eax,S3M_module
			add	eax,2
			mov	S3M_pattposofs,eax

S3M_playtick_nonewpatt: test	S3M_posjumpflag,1
			jnz	S3M_playtick_nextpatt
S3M_playtick_done:
			popad
			ret
S3M_playtick		ENDP

;Ĵ S3M playtick nonewnotes 

S3M_nonew:		clr	eax
			lea	edi,S3M_voiceinfo
S3M_nonew_l1:		call	[DRV_setactivechn]
			push	eax
			call	S3M_checkfx
                        test    s3mvoc.control[edi],20h
			jz	S3M_nonew_novol
                        mov     eax,s3mvoc.vol[edi]
			shl	eax,2
			call	[DRV_setvol]
S3M_nonew_novol:	pop	eax
                        add     edi,size s3mvoc
			inc	eax
			cmp	eax,S3M_chns
			jne	S3M_nonew_l1
			ret

;Ĵ S3M playtick setupvoices 

S3M_setupvoices:	mov	esi,S3M_pattposofs
			lea	edi,S3M_row
			mov	ecx,32
S3M_setupvoices_l1:     mov     bptr [edi],0ffh
                        mov     bptr 1[edi],000h
                        mov     bptr 2[edi],0ffh
                        mov     bptr 3[edi],0ffh
                        mov     bptr 4[edi],000h
			add	edi,5
			dec	ecx
			jnz	S3M_setupvoices_l1
S3M_setupvoices_l2:     cmp     bptr [esi],0
			je	S3M_setupvoices_done
			mov	edi,[esi]
			and	edi,01fh
			imul	edi,5
			lea	edi,S3M_row[edi]
			mov	dl,[esi]
			inc	esi
			test	dl,20h
			jz	S3M_setupvoices_nonote
			mov	ax,[esi]
			mov	[edi],ax
			add	esi,2
S3M_setupvoices_nonote: test	dl,40h
			jz	S3M_setupvoices_novol
			mov	al,[esi]
			mov	2[edi],al
			inc	esi
S3M_setupvoices_novol:	test	dl,80h
			jz	S3M_setupvoices_nocmd
			mov	ax,[esi]
			mov	3[edi],ax
			add	esi,2
S3M_setupvoices_nocmd:	jmp	S3M_setupvoices_l2
S3M_setupvoices_done:	inc	esi
			mov	S3M_pattposofs,esi

			lea	esi,S3M_row
			lea	edi,S3M_voiceinfo
			clr	eax
S3M_setupvoices_l3:	call	[DRV_setactivechn]
			push	eax
			call	S3M_setupvoice
			pop	eax
			add	esi,5
                        add     edi,size s3mvoc
			inc	eax
			cmp	eax,S3M_chns
			jne	S3M_setupvoices_l3
			ret

;Ĵ S3M playtick playvoices 

S3M_playvoices: 	clr	eax
			lea	edi,S3M_voiceinfo
S3M_playvoices_l1:	call	[DRV_setactivechn]
			push	eax
                        test    s3mvoc.control[edi],20h
			jz	S3M_playvoices_novol
                        mov     eax,s3mvoc.vol[edi]
			shl	eax,2
			call	[DRV_setvol]
S3M_playvoices_novol:   mov     al,s3mvoc.control[edi]
			test	al,80h
			jz	S3M_playvoices_skip
			test	al,40h
			jz	S3M_playvoices_skip
			and	eax,not 040h
                        mov     s3mvoc.control[edi],al
			and	eax,not 080h+020h
			call	[DRV_setmode]
                        mov     eax,s3mvoc.sstart[edi]
			call	[DRV_setstart]
                        mov     eax,s3mvoc.send[edi]
			call	[DRV_setend]
                        mov     eax,s3mvoc.lstart[edi]
			call	[DRV_setlstart]
                        mov     eax,s3mvoc.lend[edi]
			call	[DRV_setlend]
                        movzx   eax,s3mvoc.panning[edi]
			call	[DRV_setpan]
                        mov     eax,s3mvoc.period[edi]
			call	S3M_per2freq
			call	[DRV_setfreq]
			call	[DRV_startchn]
S3M_playvoices_skip:	pop	eax
                        add     edi,size s3mvoc
			inc	eax
			cmp	eax,S3M_chns
			jne	S3M_playvoices_l1
			ret

;Ĵ S3M setupvoice 

S3M_setupvoice: 	cmp	bptr [esi],0ffh
			je	S3M_setupvoice_nonote
			call	[DRV_stopchn]
			cmp	bptr [esi],0feh
			je	S3M_setupvoice_nonote
			clr	dl
			movzx	eax,bptr 1[esi]
			or	eax,eax
			jnz	S3M_setupvoice_newnote
			dec	dl
                        mov     eax,s3mvoc.inst[edi]
S3M_setupvoice_newnote: mov     s3mvoc.inst[edi],eax
			or	eax,eax
                        jz      S3M_setupvoice_nonote
			call	[DRV_setactivesample]
			dec	eax
			add	eax,eax
			add	eax,S3M_instptrs
			movzx	ebx,wptr[eax]
			shl	ebx,4
			add	ebx,S3M_module
                        mov     s3mvoc.instptr[edi],ebx
                        mov     s3mvoc.sstart[edi],0
			movzx	eax,wptr 16[ebx]
                        mov     s3mvoc.send[edi],eax
			movzx	eax,wptr 20[ebx]
                        mov     s3mvoc.lstart[edi],eax
			movzx	eax,wptr 24[ebx]
			dec	eax
			jns	S3M_setupvoice_lend_ok
			clr	eax
S3M_setupvoice_lend_ok: mov     s3mvoc.lend[edi],eax
			cmp	dl,0
			jne	S3M_setupvoice_oldvol
			movzx	eax,bptr 28[ebx]
                        mov     s3mvoc.vol[edi],eax
S3M_setupvoice_oldvol:  and     s3mvoc.control[edi],NOT cnt_loop
			test	bptr 31[ebx],00000001b
			jz	S3M_setupvoice_noloop
                        mov     eax,s3mvoc.lend[edi]
                        cmp     eax,s3mvoc.lstart[edi]
			jle	S3M_setupvoice_noloop
                        mov     s3mvoc.send[edi],eax
                        or      s3mvoc.control[edi],cnt_loop
S3M_setupvoice_noloop:	movzx	eax,wptr 32[ebx]
                        mov     s3mvoc.basefreq[edi],eax
			mov	al,[esi]
			mov	cl,al
			and	eax,0fh
			shr	cl,4
			and	ecx,0fh
                        mov     s3mvoc.note[edi],eax
                        mov     s3mvoc.octave[edi],ecx
			mov	eax,S3M_periods[eax*4]
			imul	eax,8363*16
			shr	eax,cl
			clr	edx
                        idiv    s3mvoc.basefreq[edi]
                        mov     s3mvoc.period[edi],eax
                        or      s3mvoc.control[edi],40h+20h
S3M_setupvoice_nonote:
                        cmp     bptr 2[esi],0ffh
			je	S3M_setupvoice_novol
			movzx	eax,bptr 2[esi]
                        mov     s3mvoc.vol[edi],eax
                        or      s3mvoc.control[edi],20h
S3M_setupvoice_novol:
                        mov     s3mvoc.command[edi],0
                        cmp     bptr 3[esi],0ffh
			je	S3M_setupvoice_nocmd
			movzx	eax,bptr 3[esi]
                        mov     s3mvoc.command[edi],eax
			movzx	eax,bptr 4[esi]
                        mov     s3mvoc.syntax[edi],eax
			call	S3M_checkmorefx
S3M_setupvoice_nocmd:	ret

S3M_checkmorefx:        mov     ebx,s3mvoc.command[edi]
			or	bl,bl
			jz	S3M_FX_nofx
                        jmp     S3M_FX_lst[(ebx*4)-4]
S3M_FX_lst		dd	S3M_FX_setspeed
			dd	S3M_FX_breakpatt
			dd	S3M_FX_breakrow
			dd	S3M_FX_volslide
			dd	S3M_FX_portadown
			dd	S3M_FX_portaup
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_samofs
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_setbpm
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx

S3M_checkfx:            mov     ebx,s3mvoc.command[edi]
			or	bl,bl
			jz	S3M_FX_nofx
                        jmp     S3M_FX_lst2[(ebx*4)-4]
S3M_FX_lst2		dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_volslide
			dd	S3M_FX_portadown
			dd	S3M_FX_portaup
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx
			dd	S3M_FX_nofx

S3M_FX_nofx:		ret

S3M_FX_setspeed:        mov     eax,s3mvoc.syntax[edi]
;			 cmp	 eax,01fh
;			 ja	 S3M_FX_setbpm
			or	eax,eax
			jz	S3M_FX_setspeed_not
			mov	S3M_counter,0
			mov	S3M_speed,al
S3M_FX_setspeed_not:	ret

S3M_FX_breakpatt:       mov     eax,s3mvoc.syntax[edi]
			dec	eax
			mov	S3M_pattpos,eax
			mov	S3M_pattbreakpos,0
			mov	S3M_posjumpflag,1
			ret

S3M_FX_breakrow:        mov     eax,s3mvoc.syntax[edi]
			mov	S3M_pattbreakpos,eax
			mov	S3M_posjumpflag,1
			ret

S3M_FX_volslide:        mov     ebx,s3mvoc.vol[edi]
                        mov     eax,s3mvoc.syntax[edi]
			cmp	eax,00h
			jne	S3M_FX_volslide_new
                        mov     al,s3mvoc.oldvolslide[edi]
S3M_FX_volslide_new:    mov     s3mvoc.oldvolslide[edi],al
			cmp	al,0f0h
			ja	S3M_FX_volslide_finedown
			mov	dl,al
			rol	dl,4
			cmp	dl,0f0h
			ja	S3M_FX_volslide_fineup
			cmp	S3M_counter,0
			je	S3M_FX_volslide_done
			mov	ecx,eax
			shr	ecx,4
			jz	S3M_FX_volslide_down
			jmp	S3M_FX_volslide_up
S3M_FX_volslide_fineup: cmp	S3M_counter,0
			jne	S3M_FX_volslide_done
S3M_FX_volslide_up:	add	ebx,ecx
			cmp	ebx,40h
			jbe	S3M_FX_volslide_ok
			mov	ebx,40h
			jmp	S3M_FX_volslide_ok
S3M_FX_volslide_finedown:
			cmp	S3M_counter,0
			jne	S3M_FX_volslide_done
S3M_FX_volslide_down:	and	eax,0fh
			sub	ebx,eax
			jns	S3M_FX_volslide_ok
			clr	ebx
S3M_FX_volslide_ok:     mov     s3mvoc.vol[edi],ebx
                        or      s3mvoc.control[edi],20h
S3M_FX_volslide_done:	ret

S3M_FX_portadown:       mov     ecx,s3mvoc.syntax[edi]
                        mov     eax,s3mvoc.period[edi]
			mov	bl,cl
			and	bl,0f0h
			cmp	bl,0f0h
			je	S3M_FX_fineportadn
			cmp	bl,0e0h
			je	S3M_FX_exfineportadn
			cmp	S3M_counter,0
			je	S3M_FX_portadn_skip
			shl	ecx,2
			jmp	S3M_FX_portadn2
S3M_FX_fineportadn:	cmp	S3M_counter,0
			jne	S3M_FX_portadn_skip
			and	ecx,0fh
			shl	ecx,2
			jmp	S3M_FX_portadn2
S3M_FX_exfineportadn:	cmp	S3M_counter,0
			jne	S3M_FX_portadn_skip
			and	ecx,0fh
S3M_FX_portadn2:	add	eax,ecx
			cmp	eax,7fffh		;Strange?
			ja	S3M_FX_portadn_ok	;A bug in S3M!
                        mov     s3mvoc.period[edi],eax  ;If it has , I should!
S3M_FX_portadn_ok:	call	S3M_per2freq		;It only saves the period
			call	[DRV_setfreq]		;if it's within the range
S3M_FX_portadn_skip:	ret

S3M_FX_portaup:         mov     ecx,s3mvoc.syntax[edi]
                        mov     eax,s3mvoc.period[edi]
			mov	bl,cl
			and	bl,0f0h
			cmp	bl,0f0h
			je	S3M_FX_fineportaup
			cmp	bl,0e0h
			je	S3M_FX_exfineportaup
			cmp	S3M_counter,0
			je	S3M_FX_portaup_skip
			shl	ecx,2
			jmp	S3M_FX_portaup2
S3M_FX_fineportaup:	cmp	S3M_counter,0
			jne	S3M_FX_portaup_skip
			and	ecx,0fh
			shl	ecx,2
			jmp	S3M_FX_portaup2
S3M_FX_exfineportaup:	cmp	S3M_counter,0
			jne	S3M_FX_portaup_skip
			and	ecx,0fh
S3M_FX_portaup2:	sub	eax,ecx
			cmp	eax,64			;Strange?
			jb	S3M_FX_portaup_ok	;A bug in S3M!
                        mov     s3mvoc.period[edi],eax  ;If it has , I should!
S3M_FX_portaup_ok:	call	S3M_per2freq		;It only saves the period
			call	[DRV_setfreq]		;if it's within the range
S3M_FX_portaup_skip:	ret

S3M_FX_samofs:          mov     eax,s3mvoc.syntax[edi]
			shl	eax,8
                        add     eax,s3mvoc.sstart[edi]
                        test    s3mvoc.control[edi],cnt_loop
			jnz	S3M_FX_samofs_loop
                        cmp     eax,s3mvoc.send[edi]
			jge	S3M_FX_samofs_stop
S3M_FX_samofs_normal:   mov     s3mvoc.sstart[edi],eax
			ret
S3M_FX_samofs_stop:     and     s3mvoc.control[edi],NOT 040h
			ret
S3M_FX_samofs_loop:     cmp     eax,s3mvoc.send[edi]
			jb	S3M_FX_samofs_normal
                        mov     eax,s3mvoc.lstart[edi]
                        mov     s3mvoc.sstart[edi],eax
			ret

S3M_FX_setbpm:          mov     eax,s3mvoc.syntax[edi]
			call	[DRV_setbpm]
			ret

;Ĵ S3M Period -> Frequency 

S3M_per2freq:		mov	ebx,14317056
			clr	edx
			xchg	eax,ebx
			div	ebx
			ret

.data

s3mvoc                  STRUC,NONUNIQUE
inst                    dd      ?
instptr                 dd      ?
note                    dd      ?
octave                  dd      ?
vol                     dd      ?
command                 dd      ?
syntax                  dd      ?
sstart                  dd      ?
send                    dd      ?
lstart                  dd      ?
lend                    dd      ?
basefreq                dd      ?
period                  dd      ?
panning                 db      ?
control                 db      ?
oldvolslide             db      ?
s3mvoc                  ENDS

S3M_samplesign		db	0

S3M_speed		db	6
S3M_counter		db	0
S3M_posjumpflag 	db	0
S3M_pattbreakpos	dd	0
S3M_pattpos		dd	0
S3M_pattposofs		dd	0
S3M_songpos		dd	0

S3M_orderptr		dd	0
S3M_instptrs		dd	0
S3M_pattptrs		dd	0

S3M_chns		dd	0
S3M_orders		dd	0
S3M_samples		dd	0

S3M_module		dd	0


S3M_periods		dd	1712,1616,1524,1440,1356,1280,1208,1140,1076,1016,0960,0907
S3M_name		db	'Scream Tracker V3.01-V3.20',eol

S3M_cmdlist		db	'S3M',0                 ;fmt_id
			dd	S3M_name		;fmt_name
			dd	S3M_test		;fmt_test
			dd	S3M_init		;fmt_init
			dd	S3M_exit		;fmt_exit
			dd	S3M_play		;fmt_play
			dd	S3M_stop		;fmt_stop
			dd	S3M_playtick		;fmt_playtick

.data?
S3M_voiceinfo           db      32*size s3mvoc dup(?)
S3M_row 		db	5*32 dup(?)

			END

