.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.ext
                include p:\nms.str
		include p:\devices\mix.ext
                include p:\devices\mix.str
                include p:\devices\timer.ext
                include p:\devices\dma.ext

		public	WSS_cmdlist


;Ĵ SB Start mixing 

WSS_activate		PROC	USES eax
			lea	eax,WSS_TIRQ
			call	TMR_activatemix
			mov	WSS_active,1
			ret
WSS_activate		ENDP

;Ĵ WSS Stop mixing 

WSS_deactivate		PROC	USES eax ebx ecx edx edi
			mov	WSS_active,0
			call	TMR_deactivatemix
			clr	eax
WSS_deactivate_l:	call	MIX_setactivechn
			call	MIX_stopchn
			inc	eax
			cmp	eax,MIX_chns
			jne	WSS_deactivate_l
			mov	edi,DMA_addr
			mov	ecx,WSS_mixsize
			clr	eax
		rep	stosb
			ret
WSS_deactivate		ENDP

;Ĵ WSS detect 

WSS_detect		PROC
			stc
			ret
WSS_detect		ENDP

;Ĵ WSS init 

WSS_init		PROC
			pushad

                        call    DMA_init
                        jc      WSS_init_fail

                        mov     ebx,WSS_card
                        jmp     WSS_init_jmptab[ebx*4]
WSS_init_nocard:	mov	nms_error,1ah
			jmp	WSS_init_fail
WSS_init_card1:		mov	WSS_config,0
			mov	WSS_rate,22050
			jmp	WSS_init_card_done
WSS_init_card2:		mov	WSS_config,mixctrl_stereo
			mov	WSS_rate,22050
			jmp	WSS_init_card_done
WSS_init_card3:		mov	WSS_config,mixctrl_16bit
			mov	WSS_rate,44100
			jmp	WSS_init_card_done
WSS_init_card4:		mov	WSS_config,mixctrl_16bit+mixctrl_stereo
			mov	WSS_rate,44100
			jmp	WSS_init_card_done
WSS_init_card_done:     mov	edx,WSS_port
			add	edx,4
			in	al,dx
			or	al,al
			jns	WSS_init_portok
			mov	nms_error,16h
			jmp	WSS_init_fail
WSS_init_portok:

			mov	ebx,WSS_irq
			mov	al,WSS_irqtab[ebx]
			or	al,al
			jns	WSS_init_irqok
			mov	nms_error,19h
			jmp	WSS_init_fail
WSS_init_irqok:
			mov	ebx,WSS_dma
			mov	bl,WSS_dmatab[ebx]
			or	bl,bl
			jns	WSS_init_dmaok
			mov	nms_error,19h
			jmp	WSS_init_fail
WSS_init_dmaok:		or	al,bl
			mov	edx,WSS_port
			out	dx,al

			mov	ecx,16
			xor	esi,esi
			mov	edx,32768
			xor	ebx,ebx
WSS_init_getfreq:	mov	eax,WSS_rates[esi]
			sub	eax,WSS_rate
			js	WSS_init_getfreq_not
			cmp	eax,edx
			jae	WSS_init_getfreq_not
			mov	ebx,WSS_rates[esi+4]
			mov	edx,eax
WSS_init_getfreq_not:   add	esi,4*2
			dec	ecx
			jns	WSS_init_getfreq

			mov	WSS_ratenum,ebx
			shl	ebx,3
			mov	eax,WSS_rates[esi]
			mov	WSS_rate,eax

			clr	edx
			mov	ebx,25
			div	ebx
                        test    WSS_config,mixctrl_16bit
                        jz      WSS_init_not16bit
			shl	eax,1
WSS_init_not16bit:	test    WSS_config,mixctrl_stereo
                        jz      WSS_init_notstereo
			shl	eax,1
WSS_init_notstereo:	add	eax,16
			and	eax,0fff0h
                        mov     WSS_mixsize,eax

			mov	edx,WSS_port		;External Mute on
			add	edx,4
			mov	al,0ah
			out	dx,al
			inc	edx
			in	al,dx
			or	al,40h
			out	dx,al

			mov	ecx,1200h		;Delay to prevent clicks
WSS_init_wait_l1:	in	al,84h
			dec	ecx
			jnz	WSS_init_wait_l1


			mov	edx,WSS_port		;Write zero to pin control
			add	edx,4
			mov	al,0ah
			out	dx,al
			inc	edx
			xor	al,al
			out	dx,al

			mov	edx,WSS_port
			add	edx,4
			mov	al,49h			;Enable MCE
			out	dx,al
			inc	edx
			mov	al,04 or 08h		;Single DMA channel,enable
			out	dx,al			;Autocalibration

			; Read the ports coz Midas does like this... =)

			in	al,dx
			in	al,dx

			; Set Playing rate and output format

			mov	edx,WSS_port
			add	edx,4
			mov	al,48h			;Enable MCE and select clock
			out	dx,al			;and data format register (08h)

			inc	edx
			mov	eax,WSS_ratenum		;Clock frequency source &divide
			test	WSS_config,mixctrl_16bit
			jz	WSS_init_8bit		;16-bit signed linear (0= 8-bit unsigned linear)
			or	al,40h
WSS_init_8bit:		test	WSS_config,mixctrl_stereo
			jz	WSS_init_mono
			or	al,10h
WSS_init_mono:          out	dx,al

        		;Now according to GUS MAX SDK source we need to read from the CODEC
        		;data port twice. Don't ask me why, but I really hope this solves
        		;the problem in setting the sample rate...

        		in      al,dx
        		in      al,dx

			call	WSS_wait
			jnc	WSS_init_ok1
			mov	nms_error,15h
			jmp	WSS_init_fail
WSS_init_ok1:
			mov	edx,WSS_port
			add	edx,4
WSS_init_disablemce:	mov	al,08h			;Disable MCE
			out	dx,al
			nop
			nop
			in	al,dx			;According to the GUS MAX SDK we need
			cmp	al,08h                  ;to check the out got through - maybe
			jne	WSS_init_disablemce     ;a bug in the CODEC?


			mov	ecx,10000
WSS_init_wait_l2:	in	al,84
			dec	ecx
			jns	WSS_init_wait_l2

        		;Now we need to wait until autocalibration is finished. First check
        		;that we actually do get the Test and Initialization register
        		;number written to the index: (Again from GUS MAX SDK)

WSS_init_test_l1:	mov	al,0bh
			out	dx,al
			nop
			nop
			in	al,dx
			cmp	al,0bh
			jne	WSS_init_test_l1

WSS_init_test_l2:	mov	al,0bh
			out	dx,al
			inc	edx
			in	al,dx
			dec	edx
			test	al,20h
			jnz	WSS_init_test_l2

			;Set Single DMA channel mode, disable autocalibration

			mov	edx,WSS_port
			add	edx,4
			in	al,49h
			out	dx,al
			inc	edx
			mov	al,04h
			out	dx,al

        		;Disable MCE

			dec	edx
			xor	al,al
			out	dx,al

			mov	ecx,1200h		;Delay to prevent clicks
WSS_init_wait_l3:	in	al,84h
			dec	ecx
			jnz	WSS_init_wait_l3

			;External Mute off

			mov	edx,WSS_port
			add	edx,4
			mov	al,0ah
			out	dx,al
			inc	edx
			in	al,dx
			and	al,NOT 40h
			out	dx,al

			;For safety:
			;Acknowledge CODEC interrupt
			;Since we aren't using IRQ's

			mov	edx,WSS_port
			add	edx,6
			xor	al,al
			out	dx,al

			mov	edx,WSS_port
			add	edx,4			;Select the lower base count
			mov	al,0fh
			out	dx,al
			inc	edx			;Set the low byte of count (DMAC
			mov	al,-1                   ;takes care of wrapping)
			out	dx,al
			dec	edx
			mov	al,0eh			;Select the upper base count
			out	dx,al
			inc	edx
			mov	al,-1			;Set the high byte of count
			out	dx,al

			;Write 0 to Pin Control register

			dec	edx
			mov	al,0ah
			out	dx,al
			inc	edx
			xor	al,al
			out	dx,al

			mov	edx,WSS_port
			add	edx,4
			mov	al,09h			;Write to the Interface Configuration
			out	dx,al

			inc	edx
			mov	al,05h
			out	dx,al

			dec	edx
			mov	al,06h
			out	dx,al
			inc	edx
			in	al,dx
			mov	WSS_old_lmute,al
			and	al,not 128
			out	dx,al

			dec	ecx
			mov	al,07h
			out	dx,al
			inc	edx
			in	al,dx
			mov	WSS_old_rmute,al
			and	al,NOT 128
			out	dx,al

			mov     eax,WSS_config
                        mov     ebx,WSS_rate
                        call    MIX_init

			mov	eax,5000/40
			call	WSS_setbpm

			call	TMR_init
			clc
			jmp	WSS_init_done
WSS_init_fail:		stc
WSS_init_done:		popad
			ret
WSS_init_jmptab		dd	WSS_init_nocard
			dd	WSS_init_card1
			dd	WSS_init_card2
			dd	WSS_init_card3
			dd	WSS_init_card4
WSS_init		ENDP

;Ĵ WSS exit 

WSS_exit		PROC
			pushad

			call	TMR_exit

			mov	edx,WSS_port
			add	edx,4

			mov	al,06h			;Restore Left mute
			out	dx,al
			inc	edx
			mov	al,WSS_old_lmute
			out	dx,al

			mov	al,07h			;Restore Right mute
			out	dx,al
			inc	edx
			mov	al,WSS_old_rmute
			out	dx,al


			dec	edx
			mov	al,0ah
			out	dx,al
			inc	edx
			xor	al,al			;Turn of interrupts
			out	dx,al

			inc	edx			;Acknowledge outstanding interrupts
			out	dx,al

			sub	edx,2
			mov	al,09h			;Interface Configuration Register
			out	dx,al
			inc	edx
			xor	al,al			;Turn off CODEC's DMA
			out	dx,al

			popad
			ret
WSS_exit		ENDP

;Ĵ WSS reset 

WSS_wait 		PROC
			mov	edx,WSS_port
			add	edx,4
			mov	ecx,8000h
WSS_wait_l:		in	al,dx
			or	al,al
			jns	WSS_wait_done
			loop	WSS_wait_l
			stc
WSS_wait_done:		ret
WSS_wait 		ENDP
;Ĵ WSS get version 

WSS_getver		PROC
			ret
WSS_getver		ENDP

;Ĵ SB Set/Get bpm 

WSS_setbpm		PROC	USES eax ebx ecx edx
			mov	ebx,eax
			imul	ebx,40
			mov	eax,100
			mul	WSS_rate
			div	ebx

			inc	eax
			and	eax,not 1

			mov	ebx,1
			clr	ecx
			test	WSS_config,mixctrl_16bit
			jz	WSS_setbpm_8bit
			shl	ebx,1
			inc	ecx
WSS_setbpm_8bit:	test	WSS_config,mixctrl_stereo
			jz	WSS_setbpm_mono
			shl	ebx,1
			inc	ecx
WSS_setbpm_mono:	mov	WSS_bytespercount,ebx
			mov	WSS_shiftpercount,ecx
			shl	eax,cl
                     	mov	WSS_ticksize,eax
			mov	WSS_tickleft,eax
			ret
WSS_setbpm		ENDP

;Ĵ WSS Timer procedure 

WSS_TIRQ                PROC
			pushad
			mov	eax,WSS_dma
                        call	DMA_getpos
			mov	ebx,WSS_mixsize
			sub	ebx,eax
			mov	WSS_dmapos,ebx
			mov	eax,WSS_playpos
			xchg	eax,ebx
			cmp	ebx,eax
			jge	WSS_TIRQ_after
WSS_TIRQ_before:	mov	ecx,eax
			sub	ecx,ebx
			jmp	WSS_TIRQ_check
WSS_TIRQ_after:		mov	ecx,WSS_mixsize
			sub	ecx,ebx
			add	ecx,eax
WSS_TIRQ_check:		sub	ecx,16
			cmp	ecx,16
			jl	WSS_TIRQ_noplay
			cmp	ecx,WSS_tickleft
			jbe	WSS_TIRQ_ok
			mov	ecx,WSS_tickleft
WSS_TIRQ_ok:   		and	ecx,NOT 3
                	and	ecx,NOT 1

			mov	eax,WSS_playpos
			mov	ebx,WSS_mixsize
			mov	edi,DMA_addr

			call    MIX
			mov	WSS_playpos,eax

			sub	WSS_tickleft,ecx
			jnz     WSS_TIRQ_noplay
                	cmp	[FMT_playtick],0
			je	WSS_TIRQ_noplay
			call	[FMT_playtick]
			mov	eax,WSS_ticksize
			mov	WSS_tickleft,eax
WSS_TIRQ_noplay:	popad
			ret
WSS_TIRQ		ENDP

;Ĵ WSS data 

.data
WSS_name		db	'Windows sound system (Crystal/Analog CODEC)',eol
WSS_name1		db	'8-bit mono',eol
WSS_name2		db	'8-bit stereo',eol
WSS_name3		db	'16-bit mono',eol
WSS_name4		db	'16-bit stereo',eol

WSS_version		db	'Windows sound system driver v1.00',eol
WSS_note		db	'In development right now!',eol

WSS_cardlst		dd	WSS_name1,00010101b
			dd	WSS_name2,00010101b
			dd	WSS_name3,00100101b
			dd	WSS_name4,00100101b

WSS_portdesc		db	'Port',eol
WSS_portlst		dd	530h,604h,0e80h,0f40h,-1
WSS_irqdesc		db	'IRQ',eol
WSS_irqlst		dd	7,9,10,11,-1
WSS_dma1desc		db	'8-bit DMA',eol
WSS_dma1lst		dd	0,1,3,-1
WSS_dma2desc		db	'16-bit DMA',eol
WSS_dma2lst		dd	5,6,7,-1

WSS_cmdlist		db	'WSS',0                 ;drv_id
                        dd      WSS_name                ;drv_text
			dd	WSS_version		;drv_version
			dd	WSS_note		;drv_note
WSS_card		dd	0			;drv_card
			dd	4          		;drv_cards
			dd	WSS_cardlst		;drv_cardlst
			dd	00010101b		;drv_config
WSS_port		dd	530h			;drv_port1
			dd	WSS_portlst		;drv_port1lst
			dd	WSS_portdesc		;drv_port1desc
			dd	-1			;drv_port2
			dd	-1			;drv_port2lst
			dd	-1			;drv_port2desc
WSS_irq 		dd	9			;drv_irq1
			dd	WSS_irqlst		;drv_irq1lst
			dd	WSS_irqdesc		;drv_irq1desc
			dd	-1			;drv_irq2
			dd	-1			;drv_irq2lst
			dd	-1			;drv_irq2desc
WSS_dma 		dd	3			;drv_dma1
			dd	WSS_dma1lst		;drv_dma1lst
			dd	WSS_dma1desc		;drv_dma1desc
			dd	5			;drv_dma2
			dd	WSS_dma2lst		;drv_dma2lst
			dd	WSS_dma2desc		;drv_dma2desc
			dd	WSS_detect		;drv_detect
			dd	WSS_init		;drv_init
			dd	WSS_exit		;drv_exit
			dd	WSS_activate		;drv_activate
			dd	WSS_deactivate		;drv_deactivate
			dd	WSS_setbpm		;drv_setbpm
			dd	TMR_activatesync	;drv_activatesync
			dd	TMR_deactivatesync	;drv_deactivatesync
			dd	TMR_sync		;drv_sync
			dd	MIX_setsample		;drv_setsample
			dd	MIX_clrsamples		;drv_clrsamples
			dd	MIX_initsamples 	;drv_initsamples
			dd	MIX_setactivesample	;drv_setactivesample
			dd	MIX_setchns		;drv_setchns
			dd	MIX_setmastervol	;drv_setmastervol
			dd	MIX_setactivechn	;drv_setactivechn
			dd	MIX_setmode		;drv_setmode
			dd	MIX_setstart		;drv_setstart
			dd	MIX_setend		;drv_setend
			dd	MIX_setlstart		;drv_setlstart
			dd	MIX_setlend		;drv_setlend
			dd	MIX_setfreq		;drv_setfreq
			dd	MIX_setvol		;drv_setvol
			dd	MIX_setpan		;drv_setpan
			dd	MIX_startchn		;drv_startchn
			dd	MIX_stopchn		;drv_stopchn

WSS_config              dd      0
WSS_rate                dd      0
WSS_ratenum		dd      0

WSS_ticksize		dd	0
WSS_tickleft		dd	0
WSS_bytespercount	dd	0
WSS_shiftpercount	dd	0
WSS_playpos		dd	0
WSS_dmapos		dd	0

WSS_active		dd	0

WSS_mixsize		dd	8192

WSS_old_rmute		db	0
WSS_old_lmute		db	0

WSS_irqtab		db	-1,-1,-1,-1,-1,-1,-1,08h,-1,10h,18h,20h,-1,-1,-1,-1
WSS_dmatab		db	0,1,-1,3,-1,-1,-1,-1
WSS_rates		dd	8000	,0
			dd	5513	,1
			dd	16000	,2
			dd	11025	,3
			dd	27429	,4
			dd	18900	,5
			dd	32000	,6
			dd	22050	,7
			dd	0	,8
			dd	37800	,9
			dd	0	,10
			dd	44100	,11
			dd	48000	,12
			dd	33075	,13
			dd	9600	,14
			dd	6615	,15


WSS_irqlist		db	08h,09h,0ah,0bh,0ch,0dh,0eh,0fh,70h,71h,72h,73h,74h,75h,76h,77h
		align		4
WSS_oldirq		df	0

			END
