.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.ext
                include p:\nms.str
                include p:\devices\mix.ext
                include p:\devices\mix.str
                include p:\devices\timer.ext
                include p:\devices\dma.ext

		public	SB_cmdlist

SB_mixsize		=	4096

;Ĵ SB Start mixing 

SB_activate		PROC	USES eax
			lea	eax,SB_TIRQ
			call	TMR_activatemix
			mov	SB_active,1
			ret
SB_activate		ENDP

;Ĵ SB Stop mixing 

SB_deactivate           PROC    USES eax ecx edi
			mov	SB_active,0
			call	TMR_deactivatemix
			clr	eax
SB_deactivate_l:	call	MIX_setactivechn
			call	MIX_stopchn
			inc	eax
			cmp	eax,MIX_chns
			jne	SB_deactivate_l
			mov	edi,DMA_addr
                        mov     ecx,SB_mixsize
			clr	eax
		rep	stosb
			ret
SB_deactivate		ENDP

;Ĵ SB detect 

SB_detect		PROC
			pushad
			mov	nms_error,10h
			lea	esi,SB_envstr
			mov	ecx,SB_envstrl
			call	NMS_findenvstr
			jc	SB_detect_fail
			clr	edx
			mov	nms_error,11h
SB_detect_l1:		lodsb
			or	al,al
			jz	SB_detect_done
			cmp	al,' '
			je	SB_detect_l1
			and	eax,0dfh

			cmp	eax,'A'                         ;A - port1
			jne	SB_detect_notport1
			lodsb
			cmp	al,'2'
			jne	SB_detect_fail
			lodsb
			sub	al,'0'
			js	SB_detect_fail
			cmp	al,8h
			ja	SB_detect_fail
			and	eax,0fh
			shl	eax,4
			or	eax,200h
			mov	SB_port1,eax
			lodsb
			cmp	al,'0'
			jne	SB_detect_fail
			or	edx,1h
			jmp	SB_detect_getdone
SB_detect_notport1:	cmp	eax,'E'                         ;E - port2
			jne	SB_detect_notport2
			lodsb
			cmp	al,'6'
			jne	SB_detect_fail
			lodsb
			sub	al,'0'
			js	SB_detect_fail
			cmp	al,8h
			ja	SB_detect_fail
			and	eax,0fh
			shl	eax,4
			or	eax,600h
			mov	SB_port2,eax
			lodsb
			cmp	al,'0'
			jne	SB_detect_fail
			or	edx,4h
			jmp	SB_detect_getdone
SB_detect_notport2:	cmp	eax,'P'                         ;P - port3
			jne	SB_detect_notport3
			lodsb
			cmp	al,'3'
			jne	SB_detect_fail
			lodsb
			sub	al,'0'
			js	SB_detect_fail
			cmp	al,3h
			ja	SB_detect_fail
			and	eax,0fh
			shl	eax,4
			or	eax,300h
			;mov	 SB_port3,eax
			lodsb
			cmp	al,'0'
			jne	SB_detect_fail
			or	edx,2h
			jmp	SB_detect_getdone
SB_detect_notport3:	cmp	eax,'I'                         ;I - Irq
			jne	SB_detect_notirq
			lodsb
			mov	bl,al
			and	ebx,0ffh
			sub	bl,'0'
			js	SB_detect_fail
			cmp	bptr [esi],' '
			je	SB_detect_lowirq
			lodsb
                        and     eax,0ffh
                        sub     al,'0'
			js	SB_detect_fail
			imul	ebx,10
                        add     bl,al
SB_detect_lowirq:	mov	SB_irq1,ebx
			or	edx,8h
			jmp	SB_detect_getdone
SB_detect_notirq:	cmp	eax,'D'                         ;D - lowdma
			jne	SB_detect_notdma
			lodsb
			sub	al,'0'
			js	SB_detect_fail
			and	eax,07h
			mov	SB_dma1,eax
			or	edx,10h
			jmp	SB_detect_getdone
SB_detect_notdma:	cmp	eax,'H'                         ;H - highdma
			jne	SB_detect_nothdma
			lodsb
			sub	al,'0'
			js	SB_detect_fail
			and	eax,07h
			mov	SB_dma2,eax
			or	edx,20h
			jmp	SB_detect_getdone
SB_detect_nothdma:	cmp	eax,'T'                         ;T - version
			jne	SB_detect_notdsp
			lodsb
			sub	al,'0'
			js	SB_detect_fail
			and	eax,07h
			mov	SB_ver,eax
			or	edx,40h
			jmp	SB_detect_getdone
SB_detect_notdsp:	jmp	SB_detect_fail
SB_detect_getdone:	jmp	SB_detect_l1
SB_detect_done: 	mov	ecx,edx
			and	edx,19h
			cmp	edx,19h
			jne	SB_detect_fail

			mov	nms_error,12h
			call	SB_reset
			jc	SB_detect_fail

			mov	nms_error,13h
			call	SB_getver
			jc	SB_detect_fail

			cmp	eax,100h
			je	SB_detect_sb1
			cmp	eax,200h
			jbe	SB_detect_sb2
			cmp	eax,300h
			jb	SB_detect_sb3
			cmp	eax,300h
			je	SB_detect_sb4
			cmp	eax,400h
			jb	SB_detect_sb5

			mov	nms_error,11h	      ;Cards below needs 16-bit DMA
			test	ecx,20h
			jz	SB_detect_fail

			cmp	eax,40bh
			jb	SB_detect_sb6
			cmp	eax,40bh
			je	SB_detect_sb7
			mov	SB_card,8
			jmp	SB_detect_nameset
SB_detect_sb1:		mov	SB_card,1
			jmp	SB_detect_nameset
SB_detect_sb2:		mov	SB_card,2
			jmp	SB_detect_nameset
SB_detect_sb3:		mov	SB_card,3
			jmp	SB_detect_nameset
SB_detect_sb4:		mov	SB_card,4
			jmp	SB_detect_nameset
SB_detect_sb5:		mov	SB_card,5
			jmp	SB_detect_nameset
SB_detect_sb6:		mov	SB_card,6
			jmp	SB_detect_nameset
SB_detect_sb7:		mov	SB_card,7
			jmp	SB_detect_nameset
SB_detect_nameset:	popad
                        clc
			ret
SB_detect_fail: 	popad
			stc
			ret
SB_detect		ENDP

;Ĵ SB init 

SB_init 		PROC
			pushad
			call	SB_reset
			jc	SB_init_fail

                        call    DMA_init
			jc	SB_init_fail

                        mov     edi,DMA_addr
                        mov     ecx,SB_mixsize/4
                        clr     eax
                rep     stosd

			mov	SB_playpos,0

			cli
			push	ds
			pop	eax
			mov	SB_dataseg,ax

			mov	ebx,SB_irq1
			mov	bl,SB_irqlist[ebx]
			call	[SYS_getvect]
			mov	dwptr SB_oldirq,edx
			mov	wptr SB_oldirq+4,cx

			mov	ebx,SB_irq1
			mov	bl,SB_irqlist[ebx]
			lea	edx,SB_IRQ
			mov	cx,cs
			call	[SYS_setvect]

			in	al,0a1h
			mov	ah,al
			in	al,021h
			mov	ecx,SB_irq1
			mov	ebx,1
			shl	ebx,cl
			not	ebx
                        and     eax,ebx
			out	021h,al
			mov	al,ah
			out	0a1h,al
			sti
                        mov     SB_config,0
                        mov     ebx,SB_card
                        jmp     SB_init_jmptab[ebx*4]

SB_init_card1:          mov     SB_rate,21739

			mov	eax,1000000		;SB 1.0
                        mov     ebx,SB_rate
			clr	edx
			div	ebx
			mov	ebx,256
			sub	ebx,eax
			mov	al,40h			;Set samplerate
			call	SB_write
			mov	al,bl
			call	SB_write

                        mov     al,01011000b
			mov	ah,bptr SB_dma1
                        mov     ecx,SB_mixsize
                        mov     ebx,DMA_phys
			call	DMA_setup

			mov	al,0d1h 		;Enable speaker
			call	SB_write

                        mov     ebx,SB_mixsize
			mov	al,014h 		;Set DMA buffer size
			call	SB_write
			mov	al,bl
			call	SB_write
			mov	al,bh
			call	SB_write

			jmp	SB_init_done

SB_init_card2:		mov     SB_rate,21739

			mov	eax,1000000		;SB 1.5
                        mov     ebx,SB_rate
			clr	edx
			div	ebx
			mov	ebx,256
			sub	ebx,eax
			mov	al,40h			;Set samplerate
			call	SB_write
			mov	al,bl
			call	SB_write

			mov	al,01011000b
			mov	ah,bptr SB_dma1
                        mov     ecx,SB_mixsize
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	al,048h 		;Set DMA buffer size
                        mov     ebx,SB_mixsize
			call	SB_write
			mov	al,bl
			call	SB_write
			mov	al,bh
			call	SB_write

			mov	al,0d1h 		;Enable speaker
			call	SB_write

			mov	al,01ch 		;Start playing (Autoinit)
			call	SB_write

			jmp	SB_init_done

SB_init_card3:          mov     SB_rate,43478

			mov	eax,1000000		;SB 2.0
                        mov     ebx,SB_rate
			clr	edx
			div	ebx
			mov	ebx,256
			sub	ebx,eax
			mov	al,40h			;Set samplerate
			call	SB_write
			mov	al,bl
			call	SB_write

                        mov     ebx,SB_mixsize
			mov	al,048h 		;Set DMA buffer size
			call	SB_write
			mov	al,bl
			call	SB_write
			mov	al,bh
			call	SB_write

			mov	al,01011000b
			mov	ah,bptr SB_dma1
                        mov     ecx,SB_mixsize
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	al,0d1h 		;Enable speaker
			call	SB_write

			mov	al,090h 		;Start autoinit DMA transfer
			call	SB_write

			jmp	SB_init_done

SB_init_card4:          mov     SB_rate,21739
                        or      SB_config,mixctrl_stereo

			mov	edx,SB_port1		;SB PRO
			add	edx,04h
			mov	al,0Eh
			out	dx,al			;Set stereo mode
			inc	edx
			in	al,dx
			or	al,2
			out	dx,al

			mov	al,01001000b
			mov	ah,bptr SB_dma1
			mov	ecx,1
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	SB_IRQ_active,0

			mov	al,14h
			call	SB_write
			clr	al
			call	SB_write
			clr	al
			call	SB_write

			mov	ecx,10000h
SB_init_card4_l1:	cmp	SB_IRQ_active,1
			je	SB_init_card4_IRQactive
			loop	SB_init_card4_l1
			stc
			jmp	SB_init_fail

SB_init_card4_IRQactive:
			mov	eax,1000000
                        mov     ebx,SB_rate
			shl	ebx,1
			clr	edx
			div	ebx
			mov	ebx,256
			sub	ebx,eax
			mov	al,40h			;Set samplerate
			call	SB_write
			mov	al,bl
			call	SB_write

                        mov     ebx,SB_mixsize
			mov	al,048h 		;Set DMA buffer size
			call	SB_write
			mov	al,bl
			call	SB_write
			mov	al,bh
			call	SB_write

			mov	al,01011000b
			mov	ah,bptr SB_dma1
                        mov     ecx,SB_mixsize
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	al,0d1h 		;Enable speaker
			call	SB_write

			mov	al,090h 		;Start autoinit DMA transfer
			call	SB_write

			jmp	SB_init_done

SB_init_card5:		jmp	SB_init_card4		;SB PRO II

SB_init_card6:          mov     SB_rate,43478		;For safety.. I hear rumors...
                        or      SB_config,mixctrl_16bit+mixctrl_stereo

			mov	al,041h 		;SB 16
			call	SB_write		;Set Rate
                        mov     eax,SB_rate
			shr	eax,8
			call	SB_write
                        mov     eax,SB_rate
			call	SB_write

			mov	al,01011000b
			mov	ah,bptr SB_dma2
                        mov     ecx,SB_mixsize
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	al,0d1h 		;Enable speaker
			call	SB_write


			mov	al,0b4h 		;Set command + dmalen
			call	SB_write
			mov	al,030h
			call	SB_write

                        mov     eax,SB_mixsize
			call	SB_write
                        mov     eax,SB_mixsize
			shr	eax,8
			call	SB_write

			jmp	SB_init_done
SB_init_card7:		jmp	SB_init_card6
SB_init_card8:		jmp	SB_init_card6
			mov	nms_error,13h
			stc
			jmp	SB_init_fail

SB_init_done:           mov     eax,SB_config
                        mov     ebx,SB_rate
                        call    MIX_init

			mov	eax,5000/40
			call	SB_setbpm

			call	TMR_init

SB_init_fail:		popad
			ret
SB_init_jmptab		dd	-1	;If no card was detected and we came this far , it deserves to crash!
			dd	SB_init_card1
			dd	SB_init_card2
			dd	SB_init_card3
			dd	SB_init_card4
			dd	SB_init_card5
			dd	SB_init_card6
			dd	SB_init_card7
			dd	SB_init_card8
SB_init 		ENDP

;Ĵ SB exit 

SB_exit 		PROC
			pushad

			call	TMR_exit

			call	SB_reset
			mov	eax,SB_dma1
			cmp	SB_card,6
			jb	SB_exit_not16bit
			mov	eax,SB_dma2
SB_exit_not16bit:	call	DMA_stop

			mov	ebx,SB_card
			jmp	SB_exit_jmptab[ebx*4]
SB_exit_card1:		jmp	SB_exit_done
SB_exit_card2:		jmp	SB_exit_done
SB_exit_card3:		mov	al,0d3h
			call	SB_write
			mov	al,0d0h
			call	SB_write
			mov	al,0dah
			call	SB_write
			mov	al,0d0h
			call	SB_write
			jmp	SB_exit_done
SB_exit_card4:		jmp	SB_exit_card3
SB_exit_card5:		jmp	SB_exit_card3
SB_exit_card6:		jmp	SB_exit_card3
SB_exit_card7:		jmp	SB_exit_card3
SB_exit_card8:		jmp	SB_exit_card3

SB_exit_done:		cli
			mov	ebx,SB_irq1
			mov	bl,SB_irqlist[ebx]
			mov	edx,dwptr SB_oldirq
			mov	cx,wptr SB_oldirq+4
			call	[SYS_setvect]
			sti
			popad
			ret
SB_exit_jmptab		dd	-1	;If no card was detected and we came this far , it deserves to crash!
			dd	SB_exit_card1
			dd	SB_exit_card2
			dd	SB_exit_card3
			dd	SB_exit_card4
			dd	SB_exit_card5
			dd	SB_exit_card6
			dd	SB_exit_card7
			dd	SB_exit_card8
SB_exit 		ENDP


;Ĵ SB wait 

SB_wait 		PROC	USES eax edx
			mov	edx,SB_port1
			add	edx,0ch
			mov	ecx,0ffffh
SB_wait_l1:		in	al,dx
			test	al,al
			jns	SB_wait_ok
			dec	ecx
			jns	SB_wait_l1
			stc
SB_wait_ok:		ret
SB_wait 		ENDP

;Ĵ SB write 

SB_write		PROC	USES ebx ecx edx
			mov	ebx,eax
			mov	edx,SB_port1
			add	edx,0ch
                        mov     ecx,0ffffh
SB_write_l1:		in	al,dx
			test	al,al
			jns	SB_write_ok
			dec	ecx
			jns	SB_write_l1
			stc
			jmp	SB_write_done
SB_write_ok:		mov	eax,ebx
			out	dx,al
			clc
SB_write_done:		ret
SB_write		ENDP

;Ĵ SB read 

SB_read 		PROC	USES ecx edx
			mov	edx,SB_port1
			add	edx,0eh
                        mov     ecx,0ffffh
SB_read_l1:		in	al,dx
			test	al,al
			js	SB_read_ok
			dec	ecx
			jns	SB_read_l1
			stc
			ret
SB_read_ok:		sub	edx,4h
			in	al,dx
			clc
			ret
SB_read 		ENDP

;Ĵ SB reset 

SB_reset		PROC
			pushad

			mov	al,0d3h 		;Disable speaker
			call	SB_write

			mov	edx,SB_port1
			add	edx,6
			mov	al,1
			out	dx,al
			mov	ecx,8
SB_reset_l1:		in	al,dx
			dec	ecx
			jns	SB_reset_l1
			clr	al
			out	dx,al

			add	edx,8h
			mov	ecx,1000
SB_reset_l2:		in	al,dx
			test	al,al
			js	SB_reset_ok2
			dec	ecx
			jns	SB_reset_l2
			jmp	SB_reset_fail

SB_reset_ok2:		sub	edx,4h
			mov	ecx,1000
SB_reset_l3:		in	al,dx
			cmp	al,0aah
			je	SB_reset_ok3
			dec	ecx
			jns	SB_reset_l3
			jmp	SB_reset_fail

SB_reset_ok3:		popad
			clc
			ret
SB_reset_fail:		mov	nms_error,15h
			popad
			stc
			ret
SB_reset		ENDP
;Ĵ SB get version 

SB_getver		PROC
			mov	al,0e1h
			call	SB_write
			jc	SB_getver_fail
			call	SB_read
			jc	SB_getver_fail
			mov	bh,al
			call	SB_read
			jc	SB_getver_fail
			mov	bl,al
			and	ebx,0ffffh
			mov	SB_ver,ebx
			mov	eax,ebx
			clc
			ret
SB_getver_fail: 	stc
			ret
SB_getver		ENDP

;Ĵ SB Set/Get bpm 

SB_setbpm		PROC	USES eax ebx ecx edx
			mov	ebx,eax
			imul	ebx,40
			mov	eax,100
			mul	SB_rate
			div	ebx

			inc	eax
			and	eax,not 1

			mov	ebx,1
			clr	ecx
			test	SB_config,mixctrl_16bit
			jz	SB_setbpm_8bit
			shl	ebx,1
			inc	ecx
SB_setbpm_8bit:		test	SB_config,mixctrl_stereo
			jz	SB_setbpm_mono
			shl	ebx,1
			inc	ecx
SB_setbpm_mono:		mov	SB_bytespercount,ebx
			mov	SB_shiftpercount,ecx
			shl	eax,cl
                     	mov	SB_ticksize,eax
			mov	SB_tickleft,eax
			ret
SB_setbpm		ENDP

;Ĵ SB Timer procedure 

SB_TIRQ                 PROC
			pushad

;		@setcol 0,63,0,0

                        mov     eax,SB_dma1
			cmp	SB_card,6
			jb	SB_TIRQ_not16bit
			mov	eax,SB_dma2
SB_TIRQ_not16bit:	call	DMA_getpos

                        mov     ebx,SB_mixsize
			sub	ebx,eax
			mov	SB_dmapos,ebx
			mov	eax,SB_playpos
			xchg	eax,ebx
			cmp	ebx,eax
			jge	SB_TIRQ_after
SB_TIRQ_before:		mov	ecx,eax
			sub	ecx,ebx
			jmp	SB_TIRQ_check
SB_TIRQ_after:		mov	ecx,SB_mixsize
			sub	ecx,ebx
			add	ecx,eax
SB_TIRQ_check:		sub	ecx,16
			cmp	ecx,SB_mixsize
			jle	SB_TIRQ_ok1
			mov	ecx,SB_mixsize
SB_TIRQ_ok1:		cmp	ecx,16
			jl	SB_TIRQ_noplay
			cmp	ecx,SB_tickleft
			jle	SB_TIRQ_ok2
			mov	ecx,SB_tickleft
SB_TIRQ_ok2:
			and	ecx,NOT 3
;                	and	ecx,NOT 1


			mov	eax,SB_playpos
			mov	ebx,SB_mixsize
			mov	edi,DMA_addr

			call    MIX
			mov	SB_playpos,eax
			sub	SB_tickleft,ecx
			jnz     SB_TIRQ_noplay
                      	cmp	[FMT_playtick],0
			je	SB_TIRQ_noplay
			call	[FMT_playtick]
			mov	eax,SB_ticksize
			mov	SB_tickleft,eax
SB_TIRQ_noplay:
;		@setcol 0,0,0,0
                        popad
			ret
SB_TIRQ			ENDP

;Ĵ SB main IRQ 

SB_dataseg		dw	0

SB_IRQ			PROC
			pushad
			push	ds
			push	es

			mov	ax,cs:SB_dataseg
			mov	ds,ax
			mov	es,ax

			sti

;                @setcol 0,63,0,0

			cmp	SB_card,1
			jne	SB_IRQ_autoinit
;                @setcol 0,63,0,0

                        mov     ebx,SB_mixsize
			mov	al,014h 		;Set DMA buffer size
			call	SB_write
			mov	al,bl
			call	SB_write
			mov	al,bh
			call	SB_write

SB_IRQ_autoinit:	mov	SB_IRQ_active,1
			mov	edx,SB_port1
			add	edx,0eh
                        test    SB_config,mixctrl_16bit
                        jz      SB_IRQ_8bit
			inc	edx
SB_IRQ_8bit:		in	al,dx

;                @setcol 0,0,0,0

			mov	al,020h
			out	020h,al
			out	0a0h,al

			pop	es
			pop	ds
			popad
			iretd
SB_IRQ			ENDP
SB_IRQ_active		db	0

;Ĵ SB data 

.data

SB_envstr		db	'BLASTER='
SB_envstrl		=	$-SB_envstr

SB_name                 db      'Sound Blaster',eol
SB_name1		db	'Sound Blaster 1.0 or clone (DSP v1.00)',eol
SB_name2		db	'Sound Blaster 1.5 (DSP v1.01-v2.00)',eol
SB_name3		db	'Sound Blaster 2.0 (DSP v2.01+)',eol
SB_name4		db	'Sound Blaster Pro (DSP v3.00)',eol
SB_name5		db	'Sound Blaster Pro ][ (DSP v3.01+)',eol
SB_name6		db	'Sound Blaster 16 (DSP v4.0x)',eol
SB_name7		db	'Sound Blaster 16 SCSI-2 (DSP v4.11)',eol
SB_name8		db	'Sound Blaster AWE32 (DSP v4.12+) (Software Mixing)',eol

SB_version              db      'Sound Blaster driver v1.40',eol
SB_note 		db	'The driver does need creatives tsr drivers!',eol

SB_cardlst		dd	SB_name1,00010101b
			dd	SB_name2,00010101b
			dd	SB_name3,00010101b
			dd	SB_name4,00010101b
			dd	SB_name5,00010101b
			dd	SB_name6,00100101b
			dd	SB_name7,00100101b
			dd	SB_name8,00100101b
			dd	-1

SB_port1desc		db	'Port',eol
SB_port1lst             dd      220h,230h,240h,250h,260h,-1
SB_irq1desc		db	'IRQ',eol
SB_irq1lst		dd	2,3,5,7,10,11,12,15,-1
SB_dma1desc		db	'8-bit DMA',eol
SB_dma1lst		dd	1,3,-1
SB_dma2desc		db	'16-bit DMA',eol
SB_dma2lst		dd	5,6,7,-1

SB_cmdlist		db	'SB',0,0                ;drv_id
                        dd      SB_name                 ;drv_text
			dd	SB_version		;drv_version
			dd	SB_note 		;drv_note
SB_card 		dd	0			;drv_card
			dd	8			;drv_cards
			dd	SB_cardlst		;drv_cardlst
			dd	00010101b		;drv_config
SB_port1		dd	220h			;drv_port1
			dd	SB_port1lst		;drv_port1lst
			dd	SB_port1desc		;drv_port1desc
			dd	-1			;drv_port2
			dd	-1			;drv_port2lst
			dd	-1			;drv_port2desc
SB_irq1 		dd	7			;drv_irq1
			dd	SB_irq1lst		;drv_irq1lst
			dd	SB_irq1desc		;drv_irq1desc
			dd	-1			;drv_irq2
			dd	-1			;drv_irq2lst
			dd	-1			;drv_irq2desc
SB_dma1 		dd	1			;drv_dma1
			dd	SB_dma1lst		;drv_dma1lst
			dd	SB_dma1desc		;drv_dma1desc
SB_dma2 		dd	5			;drv_dma2
			dd	SB_dma2lst		;drv_dma2lst
			dd	SB_dma2desc		;drv_dma2desc
			dd	SB_detect		;drv_detect
			dd	SB_init 		;drv_init
			dd	SB_exit 		;drv_exit
			dd	SB_activate		;drv_activate
			dd	SB_deactivate		;drv_deactivate
			dd	SB_setbpm		;drv_setbpm
                        dd      TMR_activatesync        ;drv_activatesync
                        dd      TMR_deactivatesync      ;drv_deactivatesync
                        dd      TMR_sync                ;drv_sync
			dd	MIX_setsample		;drv_setsample
			dd	MIX_clrsamples		;drv_clrsamples
			dd	MIX_initsamples 	;drv_initsamples
			dd	MIX_setactivesample	;drv_setactivesample
			dd	MIX_setchns		;drv_setchns
			dd	MIX_setmastervol	;drv_setmastervol
			dd	MIX_setactivechn	;drv_setactivechn
			dd	MIX_setmode		;drv_setmode
			dd	MIX_setstart		;drv_setstart
			dd	MIX_setend		;drv_setend
			dd	MIX_setlstart		;drv_setlstart
			dd	MIX_setlend		;drv_setlend
			dd	MIX_setfreq		;drv_setfreq
			dd	MIX_setvol		;drv_setvol
			dd	MIX_setpan		;drv_setpan
			dd	MIX_startchn		;drv_startchn
			dd	MIX_stopchn		;drv_stopchn


SB_config               dd      0
SB_rate                 dd      0

SB_ticksize		dd	0
SB_tickleft		dd	0
SB_bytespercount	dd	0
SB_shiftpercount	dd	0
SB_playpos		dd	0
SB_dmapos		dd	0

SB_active		dd	0

SB_port2		dd	0
SB_ver			dd	0

SB_irqlist		db	08h,09h,0ah,0bh,0ch,0dh,0eh,0fh,70h,71h,72h,73h,74h,75h,76h,77h
		align		4
SB_oldirq		df	0


			END
