.386p
.model flat,syscall
.code

		include p:\nms.mac
                include p:\nms.str
                include p:\nms.ext
		include p:\devices\timer.ext
		include p:\devices\imm.ext
                include p:\devices\dma.ext


		public	GUS_cmdlist

GUS_rampspeed		=	63;32
GUS_uploadsize		=	2000h

;Ĵ GUS macros 

@GUS_setfunc		MACRO	func
			mov	edx,GUS_port1
			add	edx,103h
			mov	al,func
			out	dx,al
			ENDM
@GUS_setword		MACRO	data
			mov	edx,GUS_port1
			add	edx,104h
			mov	ax,data
			out	dx,ax
			ENDM
@GUS_setbyte		MACRO	data
			mov	edx,GUS_port1
			add	edx,105h
			mov	al,data
			out	dx,al
			ENDM
@GUS_getword		MACRO	data
			mov	edx,GUS_port1
			add	edx,104h
			in	ax,dx
			ENDM
@GUS_getbyte		MACRO	data
			mov	edx,GUS_port1
			add	edx,105h
			in	al,dx
			ENDM
@GUS_delay1		MACRO
			mov	ah,7
			mov	edx,GUS_port1
			add	edx,107h
			in	al,dx
			dec	ah
			jns	$-15
			ENDM
@GUS_delay2		MACRO
			mov	ah,70
			mov	edx,GUS_port1
			add	edx,107h
			in	al,dx
			dec	ah
			jns	$-15
			ENDM

;Ĵ GUS Set/Get master volume 

GUS_setmastervol	PROC	USES eax ecx edx
			mov	GUS_mastervol,eax
			cmp	GUS_chns,0
			je	GUS_setmastervol_skip
			cli
			clr	eax
GUS_setmastervol_l:	push	eax
			mov	edx,GUS_port1
			add	edx,102h
			out	dx,al
			imul	eax,size gusvoc
			lea	eax,GUS_voices[eax]
			mov	eax,gusvoc.vol[eax]
			imul	eax,GUS_mastervol
			shr	eax,10
			mov	ecx,GUS_voltab[eax*4]
		@GUS_setfunc	09h
		@GUS_setword	cx
		@GUS_delay1
		@GUS_setfunc	09h
		@GUS_setword	cx
			pop	eax
			inc	eax
			cmp	al,GUS_chns
			jne	GUS_setmastervol_l
			movzx	eax,GUS_chn
			call	GUS_setactivechn
			sti
GUS_setmastervol_skip:	ret
GUS_setmastervol	ENDP

;Ĵ GUS Set/Get active channel 

GUS_setactivechn	PROC	USES eax edx
			and	eax,0ffh
			mov	GUS_chn,al
			mov	edx,GUS_port1
			add	edx,102h
			out	dx,al
			imul	eax,size gusvoc
			lea	eax,GUS_voices[eax]
			mov	GUS_voice,eax
			ret
GUS_setactivechn	ENDP

;Ĵ GUS Set/Get mode 

GUS_setmode		PROC	USES eax ebx ecx
			mov	ecx,GUS_voice
			mov	bl,gusvoc.mode[ecx]
			mov	gusvoc.mode[ecx],0
			test	al,cnt_16bit
			jz	GUS_setmode_not16bit
			or	gusvoc.mode[ecx],00000100b
			test	bl,00000100b
			jnz	GUS_setmode_done
GUS_setmode_reset:      push	eax
			mov	eax,gusvoc.sstart[ecx]
			call	GUS_setstart
			mov	eax,gusvoc.send[ecx]
			call	GUS_setend
			mov	eax,gusvoc.lstart[ecx]
			call	GUS_setlstart
			pop	eax
			jmp	GUS_setmode_done
GUS_setmode_not16bit:	test	bl,00000100b
			jnz     GUS_setmode_reset
GUS_setmode_done:	test	al,cnt_loop
			jz	GUS_setmode_notloop
			or	gusvoc.mode[ecx],00001000b
GUS_setmode_notloop:	test	al,cnt_biloop
			jz	GUS_setmode_notbiloop
			or	gusvoc.mode[ecx],00010000b
GUS_setmode_notbiloop:	test	al,cnt_backward
			jz	GUS_setmode_notbackward
			or	gusvoc.mode[ecx],01000000b
GUS_setmode_notbackward:ret
GUS_setmode		ENDP

;Ĵ GUS Set/Get start 

GUS_setstart		PROC	USES eax ebx ecx edx
			mov	ebx,GUS_voice
;			cmp	gusvoc.sstart[ebx],eax
;			je 	GUS_setstart_skip
			mov	gusvoc.sstart[ebx],eax
                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_setstart_skip

			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_setstart_8bit
			shl	eax,1
GUS_setstart_8bit:      add	eax,gusvoc.samstart[ebx]
			mov	ebx,eax
			mov	ecx,eax
			shr	ebx,7
		@GUS_setfunc	0ah
		@GUS_setword	bx
			and	ecx,07fh
			shl	ecx,9
		@GUS_setfunc	0bh
		@GUS_setword	cx
GUS_setstart_skip:	ret
GUS_setstart		ENDP

;Ĵ GUS Set/Get end 

GUS_setend		PROC	USES eax ebx ecx edx
			mov	ebx,GUS_voice
;			cmp	gusvoc.send[ebx],eax
;			je 	GUS_setend_skip
			mov	gusvoc.send[ebx],eax
                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_setend_skip

			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_setend_8bit
			shl	eax,1
GUS_setend_8bit:      	add	eax,gusvoc.samstart[ebx]
			mov	ebx,eax
			mov	ecx,eax
			shr	ebx,7
		@GUS_setfunc	04h
		@GUS_setword	bx
			and	ecx,07fh
			shl	ecx,9
		@GUS_setfunc	05h
		@GUS_setword	cx
GUS_setend_skip:	ret
GUS_setend		ENDP

;Ĵ GUS Set/Get loop start 

GUS_setlstart		PROC	USES eax ebx ecx edx
			mov	ebx,GUS_voice
;			cmp	gusvoc.lstart[ebx],eax
;			je 	GUS_setlstart_skip
	       		mov	gusvoc.lstart[ebx],eax
                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_setlstart_skip

			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_setlstart_8bit
			shl	eax,1
GUS_setlstart_8bit:	add	eax,gusvoc.samstart[ebx]
			mov	ebx,eax
			mov	ecx,eax
			shr	ebx,7
		@GUS_setfunc	02h
		@GUS_setword	bx
			and	ecx,07fh
			shl	ecx,9
		@GUS_setfunc	03h
		@GUS_setword	cx
GUS_setlstart_skip:	ret
GUS_setlstart		ENDP

;Ĵ GUS Set/Get loop end 

GUS_setlend		PROC	USES eax ebx ecx
			mov	ebx,GUS_voice
;			cmp	gusvoc.lend[ebx],eax
;			je 	GUS_setlend_skip
			mov	gusvoc.lend[ebx],eax
                        test    gusvoc.status[ebx],gustat_stopped
			jz	GUS_setlend_skip
                        and     gusvoc.status[ebx],NOT gustat_stopped

		@GUS_setfunc	80h
		@GUS_getbyte
			mov	cl,al
			or	cl,00100000b
		@GUS_setfunc	00h
		@GUS_setbyte	cl

GUS_setlend_skip:	ret
GUS_setlend		ENDP

;Ĵ GUS Set/Get frequency 

GUS_setfreq		PROC	USES eax ebx ecx edx
			mov	ebx,GUS_voice
			mov	gusvoc.freq[ebx],eax
                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_setfreq_stoping

                        mov     cl,gusvoc.freqshift[ebx]
			shr     eax,cl
                        shl     eax,9
                        movzx   ebx,GUS_realchns
                        mov     ecx,GUS_divisors[ebx*4]
			shr	ecx,1
			add	eax,ecx
			clr	edx
			div	GUS_divisors[ebx*4]
			shl	eax,1
			mov	ebx,GUS_voice
			mov	gusvoc.period[ebx],eax
			mov	ebx,eax
		@GUS_setfunc	01h
		@GUS_setword	bx
GUS_setfreq_stoping:	ret
GUS_setfreq		ENDP

;Ĵ GUS Set/Get volume 

GUS_setvol		PROC	USES eax ebx ecx edx esi
			mov	esi,GUS_voice
			mov	gusvoc.vol[esi],eax
                        test    gusvoc.status[esi],gustat_stoping
			jnz	GUS_setvol_stoping

		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b
		@GUS_setfunc	89h
		@GUS_getword
			and	eax,0ffffh

			mov	ebx,gusvoc.vol[esi]
			imul	ebx,GUS_mastervol
			shr	ebx,10
			mov	ebx,GUS_voltab[ebx*4]

			mov	cl,00100000b
			push	eax
			push	ebx
			and	eax,0ff00h
			and	ebx,0ff00h
			cmp	eax,ebx
			je	GUS_setvol_skip
			jb	GUS_setvol_forward
			pop	eax
			pop	ebx
			mov	cl,01100000b
			jmp	GUS_setvol_backward
GUS_setvol_forward:	pop	ebx
			pop	eax
GUS_setvol_backward:	push	ebx
			mov	ebx,eax
		@GUS_setfunc	07h
		@GUS_setbyte	bh
			pop	ebx
		@GUS_setfunc	08h
		@GUS_setbyte	bh
		@GUS_setfunc	06h
		@GUS_setbyte	GUS_rampspeed
		@GUS_setfunc	0dh
		@GUS_setbyte	cl
		@GUS_delay1
		@GUS_setfunc	0dh
		@GUS_setbyte	cl
GUS_setvol_stoping:	ret
GUS_setvol_skip:	pop	ebx
			pop	eax
			ret
GUS_setvol		ENDP

;Ĵ Gus Set panning 

GUS_setpan		PROC	USES eax ebx edx
			and	eax,0fh
			mov	ebx,GUS_voice
			mov	gusvoc.pan[ebx],al
                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_setpan_stoping

			mov	bl,al
		@GUS_setfunc	0ch
		@GUS_setbyte	bl
GUS_setpan_stoping:	ret
GUS_setpan		ENDP

;Ĵ GUS Start/Stop channel 

GUS_startchn		PROC	USES eax ebx ecx edx
			mov	ecx,GUS_voice

                        mov     eax,gusvoc.send[ecx]
                        sub     eax,gusvoc.sstart[ecx]
                        cmp     eax,2
                        jl      GUS_startchn_dontplay

                        test    gusvoc.mode[ecx],00011000b
                        jz      GUS_startchn_ok
                        mov     eax,gusvoc.lend[ecx]
                        sub     eax,gusvoc.lstart[ecx]
                        cmp     eax,2
                        jg      GUS_startchn_ok
                        and     gusvoc.mode[ecx],NOT 00011000b
GUS_startchn_ok:        test    gusvoc.status[ecx],gustat_ready
			jz	GUS_startchn_dontplay
                        test    gusvoc.status[ecx],gustat_stoping
			jnz	GUS_startchn_stoping
		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b

		@GUS_setfunc	09h
		@GUS_setword	1500h
		@GUS_delay1
		@GUS_setfunc	09h
		@GUS_setword	1500h
		@GUS_setfunc	07h
		@GUS_setbyte	15h
			mov	ebx,gusvoc.vol[ecx]
			imul	ebx,GUS_mastervol
			shr	ebx,10
			mov	ebx,GUS_voltab[ebx*4]
		@GUS_setfunc	08h
		@GUS_setbyte	bh
		@GUS_setfunc	06h
		@GUS_setbyte	GUS_rampspeed
		@GUS_setfunc	0dh
		@GUS_setbyte	00100000b
			mov	bl,gusvoc.mode[ecx]
			test	bl,00001000b
			jz	GUS_startchn_nl
			or	bl,00100000b
GUS_startchn_nl:@GUS_setfunc	00h
		@GUS_setbyte	bl
                        and     gusvoc.status[ecx],NOT gustat_stopped
GUS_startchn_dontplay:	ret
GUS_startchn_stoping:   or      gusvoc.status[ecx],gustat_retrig
			ret
GUS_startchn		ENDP

GUS_stopchn		PROC	USES eax ebx edx
			mov	ebx,GUS_voice
                        and     gusvoc.status[ebx],NOT gustat_retrig
                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_stopchn_stoping
		@GUS_setfunc	80h
		@GUS_getbyte
			test	al,00000010b
			jnz	GUS_stopchn_notplaying

                        and     gusvoc.status[ebx],NOT gustat_stopped
		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b

		@GUS_setfunc	89h
		@GUS_getword
			cmp	eax,1500h
			jbe	GUS_stopchn_noramp
                        or      gusvoc.status[ebx],gustat_stoping
			mov	ebx,eax
		@GUS_setfunc	08h
		@GUS_setbyte	bh
		@GUS_setfunc	07h
		@GUS_setbyte	15h
		@GUS_setfunc	06h
		@GUS_setbyte	GUS_rampspeed
		@GUS_setfunc	0dh
		@GUS_setbyte	01100000b
			ret
GUS_stopchn_noramp:
		@GUS_setfunc	00h
		@GUS_setbyte	00000011b
GUS_stopchn_stoping:
GUS_stopchn_notplaying: ret
GUS_stopchn		ENDP

;Ĵ Gus Set BPM 

GUS_setbpm		PROC	USES eax ebx ecx edx
			mov	GUS_bpm,al
			clr	edx
			shl	eax,3
			mov	ebx,eax
			add	eax,eax
			add	ebx,eax
			mov	eax,750000
			div	ebx
			clr	edx
			mov	ebx,255
			div	ebx
			neg	dl
			mov	GUS_gusbpm,dl
			mov	GUS_gusbpmhi,al
			mov	GUS_gusbpmhicnt,al
			ret
GUS_setbpm		ENDP



;Ĵ GUS Activate/DeActivate 

GUS_activate		PROC	USES eax ecx edx edi
			lea	edi,GUS_voices
			mov	ecx,32*size gusvoc
			clr	eax
		rep	stosb

			lea	edi,GUS_voices
			mov	edx,32
GUS_activate_l:		mov	gusvoc.sstart[edi],-1
			mov	gusvoc.send[edi],-1
			mov	gusvoc.lstart[edi],-1
			mov	gusvoc.lend[edi],-1
			add	edi,size gusvoc
			dec	edx
			jnz	GUS_activate_l

			cli
		@GUS_setfunc	46h
		@GUS_setbyte	255
		@GUS_setfunc	45h
		@GUS_setbyte	04h
			mov	edx,GUS_port1
			add	edx,008H
			mov	al,04h
			out	dx,al
			mov	edx,GUS_port1
			add	edx,009h
			mov	al,01h
			out	dx,al
			sti
			clc
			ret
GUS_activate		ENDP

GUS_deactivate		PROC	USES eax ebx ecx edx
			mov	bl,0
GUS_deactivate_l1:	mov	edx,GUS_port1		 ;Select voice to operate with
			add	edx,102h
			mov	al,bl
			out	dx,al

		@GUS_setfunc	000h			;Set Voice control (Stop voice )
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	000h			;Set Voice control (Stop voice )
		@GUS_setbyte	00000011b
		@GUS_setfunc	00dh			;Set Volume Ramp control (Stop ramping)
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	00dh			;Set Volume Ramp control (Stop ramping)
		@GUS_setbyte	00000011b
		@GUS_setfunc	009h			;Current Volume fully off
		@GUS_setword	000h
		@GUS_delay1
		@GUS_setfunc	009h			;Current Volume fully off
		@GUS_setword	000h
		@GUS_setfunc	00ah			;Current position to zero
		@GUS_setword	0
		@GUS_setfunc	00bh			;Current position to zero
		@GUS_setword	0

		@GUS_delay2
			inc	bl
			cmp	bl,32
			jb	GUS_deactivate_l1

		@GUS_setfunc	45h
		@GUS_setbyte	0h
			ret
GUS_deactivate		ENDP

;Ĵ GUS Set/Get Sample 

GUS_setsample		PROC	USES eax ebx
			mov	ebx,sam.number[esi]
			imul	ebx,size gussam
			lea	ebx,GUS_samples[ebx]
			mov	eax,sam.sstart[esi]
			mov	gussam.memstart[ebx],eax
			mov	eax,sam.send[esi]
			mov	gussam.memend[ebx],eax
			mov	gussam.freqshift[ebx],0
			ret
GUS_setsample		ENDP

;Ĵ GUS Set/Get Active sample 

GUS_setactivesample	PROC	USES eax ebx ecx
			mov	ebx,GUS_voice
			mov	gusvoc.sample[ebx],eax
			imul	ecx,eax,size gussam
			lea	ecx,GUS_samples[ecx]
			mov	eax,gussam.gusstart[ecx]
			mov	gusvoc.samstart[ebx],eax
			mov	eax,gussam.gusend[ecx]
			mov	gusvoc.samend[ebx],eax
			mov	al,gussam.freqshift[ecx]
			mov	gusvoc.freqshift[ebx],al
                        or      gusvoc.status[ebx],gustat_ready
			ret
GUS_setactivesample	ENDP

;Ĵ GUS Clear Samples 

GUS_clrsamples		PROC
			pushad
			lea	edi,GUS_samples
			mov	ecx,4096*size gussam
			clr	eax
		rep	stosb
			mov	GUS_lastmem,0
			popad
			ret
GUS_clrsamples		ENDP

;Ĵ GUS Init Samples 

GUS_initsamples 	PROC
			mov	edx,0
GUS_initsamples_l:	call	GUS_initsamples_chk
			jnc	GUS_initsamples_upload
			call	GUS_initsamples_find
			jc	GUS_initsamples_nomore
			mov	gussam.freqshift[esi],dl
			inc	gussam.freqshift[esi]
			jmp	GUS_initsamples_l
GUS_initsamples_nomore: inc	edx
			cmp	edx,3
			jne	GUS_initsamples_l
			mov	nms_error,17h
			jmp	GUS_initsamples_fail
GUS_initsamples_upload:
			lea	ebx,GUS_samples
			mov	edx,4096
			clr	edi
GUS_initsamples_upload_l:
			mov	esi,gussam.memend[ebx]
			sub	esi,gussam.memstart[ebx]
			jz	GUS_initsamples_upload_skip
			mov	cl,gussam.freqshift[ebx]
			shr	esi,cl
			mov	al,cl
			mov	ecx,esi
			mov	esi,gussam.memstart[ebx]
			mov	gussam.gusstart[ebx],edi
			mov	gussam.gusend[ebx],edi
			add	gussam.gusend[ebx],ecx

;			call	GUS_upload
;			jnc     GUS_initsamples_dmaok
			call	GUS_upload2
GUS_initsamples_dmaok:

			mov	eax,gussam.memend[ebx]
			sub	eax,gussam.memstart[ebx]
			mov	cl,gussam.freqshift[ebx]
			shr	eax,cl
			add	edi,eax
			add	edi,15
			and	edi,0fffffff0h
GUS_initsamples_upload_skip:
			add	ebx,size gussam
			dec	edx
			jnz	GUS_initsamples_upload_l
			clc
			jmp	GUS_initsamples_done
GUS_initsamples_fail:	stc
GUS_initsamples_done:	ret
GUS_initsamples 	ENDP

GUS_initsamples_chk	PROC	USES eax ebx ecx edx esi
			lea	esi,GUS_samples
			mov	edx,4096
			clr	ebx
GUS_initsamples_chk_l:	mov	eax,gussam.memend[esi]
			sub	eax,gussam.memstart[esi]
			mov	cl,gussam.freqshift[esi]
			shr	eax,cl
			add	ebx,eax
			add	esi,size gussam
			dec	edx
			jnz	GUS_initsamples_chk_l
			cmp	ebx,GUS_mem
			jbe	GUS_initsample_chk_ok
			stc
			jmp	GUS_initsample_chk_done
GUS_initsample_chk_ok:	clc
GUS_initsample_chk_done:ret
GUS_initsamples_chk	ENDP

GUS_initsamples_find	PROC	USES eax ebx ecx edx edi
			lea	edi,GUS_samples
			clr	esi
			clr	ebx
			mov	ecx,4096
GUS_initsamples_find_l: cmp	gussam.freqshift[edi],dl
			jne	GUS_initsamples_find_skip
			mov	eax,gussam.memend[edi]
			sub	eax,gussam.memstart[edi]
			cmp	eax,128
			jbe	GUS_initsamples_find_skip
			push	ecx
			mov	cl,gussam.freqshift[edi]
			shr	eax,cl
			pop	ecx
			cmp	eax,ebx
			jbe	GUS_initsamples_find_skip
			mov	ebx,eax
			mov	esi,edi
GUS_initsamples_find_skip:
			add	edi,size gussam
			dec	ecx
			jnz	GUS_initsamples_find_l
			or	esi,esi
			jnz	GUS_initsamples_find_ok
			stc
			jmp	GUS_initsamples_find_done
GUS_initsamples_find_ok:clc
GUS_initsamples_find_done:
			ret
GUS_initsamples_find	ENDP

;Ĵ GUS Set/Get active channels 

GUS_setchns		PROC	USES eax ebx edx
			mov	GUS_chns,al
			cmp	al,14
			jae	GUS_setchns_ok
			mov	al,14
GUS_setchns_ok: 	dec	al
			mov	bl,al
		@GUS_setfunc	14
		@GUS_setbyte	bl
			mov	GUS_realchns,bl
			clc
			ret
GUS_setchns		ENDP

;Ĵ Gus detect 

GUS_detect		PROC	USES eax ebx ecx edx esi edi
			lea	esi,GUS_envstr
			mov	ecx,GUS_envstrl
			call	NMS_findenvstr
			jnc     GUS_detect_envfound
			mov	nms_error,10h
			jmp	GUS_detect_fail
GUS_detect_envfound:
			lodsd
			mov	ebx,eax
			and	ebx,0fffff0ffh
			cmp	ebx,02c303032h
			jne	GUS_detect_error
			and	eax,0f00h
			shr	eax,4
			add	eax,200h
			mov	GUS_port1,eax

			lodsw
			mov	ebx,eax
			and	ebx,0fff0h
			cmp	ebx,02c30h
			jne	GUS_detect_error
			and	eax,07h
			mov	GUS_dma1,eax

			lodsw
			mov	ebx,eax
			and	ebx,0fff0h
			cmp	ebx,02c30h
			jne	GUS_detect_error
			and	eax,07h
			mov	GUS_dma2,eax

			lodsw
			mov	ecx,eax
			and	ecx,0fh
			mov	ebx,eax
			and	ebx,0fff0h
			cmp	ebx,02c30h
			je	GUS_detect_irq1low
			and	ebx,0f0f0h
			cmp	ebx,03030h
			jne	GUS_detect_error
			and	eax,0f00h
			xchg	al,ah
			imul	ecx,10
			add	ecx,eax
			lodsb
			cmp	al,','
			jne	GUS_detect_error
GUS_detect_irq1low:	mov	GUS_irq1,ecx

			lodsw
			mov	ecx,eax
			and	ecx,0fh
			mov	ebx,eax
			and	ebx,0fff0h
			cmp	ebx,00030h
			je	GUS_detect_irq2low
			and	ebx,0f0f0h
			cmp	ebx,03030h
			jne	GUS_detect_error
			and	eax,0f00h
			xchg	al,ah
			imul	ecx,10
			add	ecx,eax
			lodsb
			cmp	al,0
			jne	GUS_detect_error
GUS_detect_irq2low:	mov	GUS_irq2,ecx

			call	GUS_getver
			jmp	GUS_detect_done
GUS_detect_error:	mov	nms_error,11h
GUS_detect_fail:	stc
GUS_detect_done:	ret
GUS_detect		ENDP

;Ĵ Gus get version 

GUS_getver:		mov	edx,GUS_port1
			add	edx,506h
			in	al,dx
			cmp	al,0ffh
			je	GUS_getver_pre37
			cmp	al,10
			jb	GUS_getver_37
			mov	GUS_card,4
			jmp	GUS_getver_done
GUS_getver_37:		mov	GUS_card,3
			jmp	GUS_getver_done
GUS_getver_pre37:
			mov	edx,GUS_port1
			add	edx,0fh
			mov	al,20h
			out	dx,al
			mov	edx,GUS_port1
			add	edx,0fh
			in	al,dx
			cmp	al,0ffh
			je	GUS_getver_22
			test	al,00000110b
			jz	GUS_getver_22
			mov	GUS_card,2
			jmp	GUS_getver_done
GUS_getver_22:		mov	GUS_card,1
GUS_getver_done:	clc
			ret

;Ĵ Gus init 
GUS_init		PROC	USES eax ebx ecx edx

			cmp	GUS_card,-1		;Check for missconfiguration
			je	GUS_init_notconfigured
			cmp	GUS_port1,-1
			je	GUS_init_notconfigured
			cmp	GUS_irq1,-1
			je	GUS_init_notconfigured
			cmp	GUS_dma1,-1
			je	GUS_init_notconfigured
			jmp	GUS_init_configured
GUS_init_notconfigured:	mov	nms_error,19h
			jmp	GUS_init_fail
GUS_init_configured:	mov	eax,GUS_dma1		;I don't really need
			cmp	GUS_dma2,-1		;the second IRQ&DMA
			jne	GUS_init_dmaok		;So if they aren't
			mov	GUS_dma2,eax		;set , just set them
GUS_init_dmaok:         mov	eax,GUS_irq1		;to what the first are.
			cmp	GUS_irq2,-1
			jne	GUS_init_irqok
			mov	GUS_irq2,eax
GUS_init_irqok:

			mov	nms_errors+30h*4,ofs GUS_error030
			mov	nms_errors+31h*4,ofs GUS_error031
			mov	nms_errors+32h*4,ofs GUS_error032
			mov	nms_errors+33h*4,ofs GUS_error033

                        call    DMA_init
                        jc      GUS_init_fail

;                        call    GUS_checkmegaem
;                        jc      GUS_init_fail

;                        call    GUS_checksbos
;                        jc      GUS_init_fail

;                        call    GUS_checkprg
;                        jc      GUS_init_fail

			call	GUS_probe
			jc	GUS_init_fail

			call	GUS_ultrinit		;Clear channels
			jc	GUS_init_fail

			call	GUS_config		;Set irq's & dma's
			jc	GUS_init_fail

			call	GUS_ultrinit		;Clear channels
			jc	GUS_init_fail

			call	TMR_init		;Init Timer device
			jc	GUS_init_fail

			call	IMM_init		;Init IMM
			jc	GUS_init_fail

			cli
			push	ds
			pop	eax
			mov	GUS_dataseg,ax

			mov	ebx,GUS_irq1
			mov	bl,GUS_irqlist[ebx]
			call	[SYS_getvect]
			mov	dwptr GUS_oldirq,edx
			mov	wptr GUS_oldirq+4,cx

			mov	ebx,GUS_irq1
			mov	bl,GUS_irqlist[ebx]
			lea	edx,GUS_IRQ
			mov	cx,cs
			call	[SYS_setvect]
			sti

			clc
GUS_init_fail:		ret
GUS_init		ENDP

;Ĵ Gus exit 
GUS_exit		PROC	USES eax ebx ecx edx
			call	IMM_exit

			call	TMR_exit
			cli

			mov	ax,oldpic

			out	021h,al
			mov	al,ah
			out	0a1h,al

		@GUS_setfunc	45h
		@GUS_setbyte	0
			mov	ebx,GUS_irq1
			mov	bl,GUS_irqlist[ebx]
			mov	edx,dwptr GUS_oldirq
			mov	cx,wptr GUS_oldirq+4
			call	[SYS_setvect]
			sti
			call	GUS_ultrinit
			ret
GUS_exit		ENDP

;Ĵ Gus Hardware config 

GUS_config		PROC	USES eax ebx ecx edx
			cli
			mov	ebx,GUS_irq1
			mov	al,GUS_config_irqtab[ebx]
			or	al,al
			jz	GUS_config_fail
			mov	ebx,GUS_irq2
			mov	cl,GUS_config_irqtab[ebx]
			or	cl,cl
			jz	GUS_config_fail
			cmp	al,cl
			je	GUS_config_sameirq
			shl	cl,3
			or	al,cl
			jmp	GUS_config_setirq
GUS_config_sameirq:	or	al,40h
GUS_config_setirq:	mov	GUS_config_irqsetting,al

			mov	ebx,GUS_dma1
			mov	al,GUS_config_dmatab[ebx]
			or	al,al
			jz	GUS_config_fail
			mov	ebx,GUS_dma2
			mov	cl,GUS_config_dmatab[ebx]
			or	cl,cl
			jz	GUS_config_fail
			cmp	al,cl
			je	GUS_config_samedma
			shl	cl,3
			or	al,cl
			jmp	GUS_config_setdma
GUS_config_samedma:	or	al,40h
GUS_config_setdma:	mov	GUS_config_dmasetting,al

		@GUS_delay2

;/* Set up for Digital ASIC */
			mov	edx,GUS_port1
			add	edx,0fh
			mov	al,5
			out	dx,al
			mov	edx,GUS_port1
			mov	al,GUS_config_mixersetting
			out	dx,al
			mov	edx,GUS_port1
			add	edx,00bh
			mov	al,0
			out	dx,al
			mov	edx,GUS_port1
			add	edx,0fh
			mov	al,0
			out	dx,al

;/* First do DMA control register */
			mov	edx,GUS_port1
			mov	al,GUS_config_mixersetting
			out	dx,al
			mov	edx,GUS_port1
			add	edx,00bh
			mov	al,GUS_config_dmasetting
			or	al,80h
			out	dx,al

;/* IRQ CONTROL REG */
			mov	edx,GUS_port1
			mov	al,GUS_config_mixersetting
			or	al,40h
			out	dx,al
			mov	edx,GUS_port1
			add	edx,00bh
			mov	al,GUS_config_irqsetting
			out	dx,al

;/* First do DMA control register */
			mov	edx,GUS_port1
			mov	al,GUS_config_mixersetting
			out	dx,al
			mov	edx,GUS_port1
			add	edx,00bh
			mov	al,GUS_config_dmasetting
			out	dx,al

;/* IRQ CONTROL REG */
			mov	edx,GUS_port1
			mov	al,GUS_config_mixersetting
			or	al,40h
			out	dx,al
			mov	edx,GUS_port1
			add	edx,00bh
			mov	al,GUS_config_irqsetting
			out	dx,al

;/* IRQ CONTROL, ENABLE IRQ */
;/* just to Lock out writes to irq\dma register ... */
			mov	edx,GUS_port1
			add	edx,102h
			clr	al
			out	dx,al

;/* enable output & irq, disable line & mic input */
			mov	edx,GUS_port1
			mov	al,GUS_config_mixersetting
			and	al,00001001b
			out	dx,al

;/* outp just to Lock out writes to irq\dma register ... */
			mov	edx,GUS_port1
			add	edx,102h
			clr	al
			out	dx,al

		@GUS_delay2
;/*
; Unmask the IRQ lines	for the GF1 and MIDI IRQ settings
;
; NOTE: the pin labled IRQ 2 on the BUS connects to IRQ 9 of the PIC
; controllers. The IRQ 2 on the PIC is used for slave.
; The ultrasound SDK ( Software Development Kit ) says that the gus can use
; IRQ 2 this means you must actualy hook IRQ 9.*/

			in	al,0a1h
			mov	ah,al
			in	al,021h
			mov	oldpic,ax

			mov	ecx,GUS_irq1
			cmp	cl,2
			jne	GUS_config_notpicslave1
			mov	cl,9
GUS_config_notpicslave1:mov	ebx,1
			shl	ebx,cl
			not	ebx
			and	eax,ebx

			mov	ecx,GUS_irq2
			cmp	cl,2
			jne	GUS_config_NotPicSlave2
			mov	cl,9
GUS_config_NotPicSlave2:mov	ebx,1
			shl	ebx,cl
			not	ebx
			and	eax,ebx
			out	021h,al
			mov	al,ah
			out	0a1h,al
			sti
		@GUS_delay2
			clc
			jmp	GUS_config_done
GUS_config_fail:	mov	nms_error,19h
			stc
GUS_config_done:	sti
			ret
GUS_config		ENDP

GUS_config_irqsetting	db	0
GUS_config_dmasetting	db	0
GUS_config_mixersetting db	00001011b
GUS_config_dmatab	db	0,1,0,2,0,3,4,5
GUS_config_irqtab	db	0,0,1,3,0,2,0,4,0,0,0,5,6,0,0,7

;Ĵ Gus Ultrainit 

GUS_ultrinit		PROC	USES eax ebx ecx edx
			cli

;/* Pull a reset on the GF1 */

		@GUS_setfunc	04ch
		@GUS_setbyte	000h

;/* Wait a little while ... */

		@GUS_delay2

;/* Release Reset */

		@GUS_setfunc	04ch
		@GUS_setbyte	001h

;/* Wait a little while ... */

		@GUS_delay2

;/* Reset the MIDI port also */

			mov	edx,GUS_port1
			add	edx,100h
			mov	al,03h
			out	dx,al
		@GUS_delay2
			mov	edx,GUS_port1
			add	edx,100h
			clr	al
			out	dx,al

;/* Clear all interrupts. */

		@GUS_setfunc	041h			;DRAM DMA Control Register
		@GUS_setbyte	000h

		@GUS_setfunc	045h			;Timer Control Register
		@GUS_setbyte	000h

		@GUS_setfunc	049h			;Sampling Control Register
		@GUS_setbyte	000h

		@GUS_setfunc	00eh			;Set active voices to 32
		@GUS_setbyte	031h or 0c0h

;/* Clear interrupts on voices. */
;/* Reading the status ports will clear the irqs. */

			mov	edx,GUS_port1		 ;Reading IRQStatus will cause a reset
			add	edx,006h
			in	al,dx

		@GUS_setfunc	041h			;DRAM DMA Control Register
		@GUS_getbyte

		@GUS_setfunc	049h			;Sampling Control Register
		@GUS_getbyte

GUS_ultrinit_clrfifo:
		@GUS_setfunc	08fh			;IRQ source Register
		@GUS_getbyte
			and	al,11000000b
			cmp	al,11000000b
			jne	GUS_ultrinit_clrfifo	;Keep on reading to clear IRQ's


			mov	bl,0
GUS_ultrinit_stopvoice_l1:
			mov	edx,GUS_port1		 ;Select voice to operate with
			add	edx,102h
			mov	al,bl
			out	dx,al

		@GUS_setfunc	000h			;Set Voice control (Stop voice )
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	000h			;Set Voice control (Stop voice )
		@GUS_setbyte	00000011b

		@GUS_setfunc	00dh			;Set Volume Ramp control (Stop ramping)
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	00dh			;Set Volume Ramp control (Stop ramping)
		@GUS_setbyte	00000011b

		@GUS_setfunc	009h			;Current Volume fully off
		@GUS_setword	000h
		@GUS_delay1
		@GUS_setfunc	009h			;Current Volume fully off
		@GUS_setword	000h

		@GUS_setfunc	00ah			;Current position to zero
		@GUS_setword	0
		@GUS_setfunc	00bh			;Current position to zero
		@GUS_setword	0



		@GUS_delay2

			inc	bl
			cmp	bl,32
			jb	GUS_ultrinit_stopvoice_l1

			mov	edx,GUS_port1		 ;Reading IRQStatus will cause a reset
			add	edx,006h
			in	al,dx

		@GUS_setfunc	041h			;DRAM DMA Control Register
		@GUS_getbyte

		@GUS_setfunc	049h			;Sampling Control Register
		@GUS_getbyte

GUS_ultrinit_clr2fifo:
		@GUS_setfunc	08fh			;IRQ source Register
		@GUS_getbyte
			and	al,11000000b
			cmp	al,11000000b
			jne	GUS_ultrinit_clr2fifo	;Keep on reading to clear IRQ's

		@GUS_setfunc	00eh
		@GUS_setbyte	13 or 0c0h		;Set active voices to 14 again

;/* Set up GF1 Chip for interrupts & enable DACs. */

		@GUS_setfunc	04ch
		@GUS_setbyte	00000111b

			sti
			clc
			ret
GUS_ultrinit		ENDP

;Ĵ Gus probe 

GUS_probe		PROC
			call	GUS_getmemsize
			cmp	GUS_mem,0
			jne	GUS_probe_memfound
			mov	nms_error,18h
			stc
			jmp	GUS_probe_done
GUS_probe_memfound:	clc
GUS_probe_done: 	ret
GUS_probe		ENDP

;Ĵ Gus get memory size 

GUS_getmemsize		PROC	USES eax ebx
			mov	eax,0
			mov	GUS_mem,eax
GUS_getmemsize_l:	mov	ebx,eax
			call	GUS_testmem
			jc	GUS_getmemsize_done
			mov	GUS_mem,eax
			add	eax,1024
			cmp	eax,1024*1024
			jne	GUS_getmemsize_l
GUS_getmemsize_done:	ret
GUS_getmemsize		ENDP

;Ĵ Gus test memory location 

GUS_testmem		PROC	USES eax ebx ecx edx
			cli
			mov	eax,ebx
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			in	al,dx
			mov	cl,al

			mov	eax,ebx
			inc	eax
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			in	al,dx
			mov	ch,al

			mov	eax,ebx
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			mov	al,0C0h
			out	dx,al

			mov	eax,ebx
			inc	eax
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			mov	al,0DEh
			out	dx,al

			mov	eax,ebx
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			in	al,dx
			cmp	al,0C0h
			jne	GUS_testmem_fail

			mov	eax,ebx
			inc	eax
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			in	al,dx
			cmp	al,0DEh
			jne	GUS_testmem_fail

			mov	eax,ebx
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			mov	al,cl
			out	dx,al

			mov	eax,ebx
			inc	eax
			call	GUS_setdrampos
			mov	edx,GUS_port1
			add	edx,107h
			mov	al,ch
			out	dx,al

			sti
			clc
			ret
GUS_testmem_fail:	sti
			stc
			ret
GUS_testmem		ENDP


;Ĵ Gus set DRAM location 

GUS_setdrampos		PROC	USES eax ebx edx
			mov	ebx,eax
			ror	ebx,16
			cmp	bl,bptr GUS_drampos+2
			je	GUS_setdrampos_skiph
		@GUS_setfunc	44h
		@GUS_setbyte	bl
GUS_setdrampos_skiph:	ror	ebx,16
			cmp	bx,wptr GUS_drampos
			je	GUS_setdrampos_skipl
		@GUS_setfunc	43h
		@GUS_setword	bx
GUS_setdrampos_skipl:	mov	GUS_drampos,ebx
			ret
GUS_setdrampos		ENDP

;Ĵ Gus upload 

GUS_upload		PROC	USES eax ebx ecx edx esi edi ebp
			test	GUS_dma1,100b
			jz	GUS_upload_8bit
			call	GUS_upload2
			clc
			jmp	GUS_upload_done
GUS_upload_8bit:	mov	GUS_upload_src,esi
			mov	GUS_upload_dst,edi
			mov	GUS_upload_tot,ecx
			mov	GUS_upload_mode,al

GUS_upload_l:       	mov	ecx,GUS_uploadsize
			cmp	GUS_upload_tot,ecx
			jge	GUS_upload_max
			mov	ecx,GUS_upload_tot
GUS_upload_max:		mov	GUS_upload_cnt,ecx	;Copy and if needed convert
			mov	esi,GUS_upload_src	;the sample.
			mov	edi,DMA_addr
			mov	al,GUS_upload_mode
			call	IMM_copyconvert
                        mov	GUS_upload_cnt,ecx	;Returns new size in ecx..

			cli				;No risk
			mov	al,01001000b
			mov	ah,bptr GUS_dma1
			mov	ebx,DMA_phys
			call	DMA_setup

			mov	ebx,GUS_upload_dst	;Set destionation memory
                   	shr	ebx,4			;position in memory
		@GUS_setfunc	42h
		@GUS_setword	bx

			mov	bl,bptr GUS_dma1	;Set dma transfer mode
			and	bl,100b			;And start transfer
			or	bl,00100001b
		@GUS_setfunc	41h
		@GUS_setbyte	bl

			sti

			mov	ecx,100000h		;Timeout value
GUS_upload_wait:	test	GUS_IRQ_dmaready,1
			loopz	GUS_upload_wait
			jz	GUS_upload_fail
			mov	GUS_IRQ_dmaready,0
		@GUS_setfunc	41h			;Stop dma transfer
		@GUS_setbyte	0			;(For safety)

			add	GUS_upload_src,GUS_uploadsize
                        mov	ecx,GUS_upload_cnt
			add	GUS_upload_dst,ecx
			sub	GUS_upload_tot,GUS_uploadsize
			jz	GUS_upload_done
			jns	GUS_upload_l
GUS_upload_done:	clc
			jmp	GUS_upload_exit
GUS_upload_fail:        stc
GUS_upload_exit:	ret
GUS_upload_src		dd	0
GUS_upload_dst		dd	0
GUS_upload_tot		dd	0
GUS_upload_cnt		dd	0
GUS_upload_mode		db	0
GUS_upload		ENDP

GUS_upload2		PROC	USES eax ebx ecx edx esi edi
			mov	GUS_upload2_src,esi
			mov	GUS_upload2_dst,edi
			mov	GUS_upload2_tot,ecx
			mov	GUS_upload2_mode,al

GUS_upload2_l:       	mov	ecx,GUS_uploadsize
			cmp	GUS_upload2_tot,ecx
			jge	GUS_upload2_max
			mov	ecx,GUS_upload2_tot
GUS_upload2_max:



			mov	GUS_upload2_cnt,ecx	;Copy and if needed convert
			mov	esi,GUS_upload2_src	;the sample.
			mov	edi,DMA_addr
			mov	al,GUS_upload2_mode
			call	IMM_copyconvert
                        mov	GUS_upload2_cnt,ecx
			;Returns new size in ecx..

			mov	esi,DMA_addr
			mov	edi,GUS_upload2_dst
GUS_upload2_l2:		mov	eax,edi
			call	GUS_setdrampos
			lodsb
			mov	edx,GUS_port1
			add	edx,107h
			out	dx,al
			inc	edi
			dec	ecx
			jnz	GUS_upload2_l2

			add	GUS_upload2_src,GUS_uploadsize
                        mov	ecx,GUS_upload2_cnt
			add	GUS_upload2_dst,ecx
			sub	GUS_upload2_tot,GUS_uploadsize
			jz	GUS_upload2_done
			jns	GUS_upload2_l
GUS_upload2_done:	clc
                 	ret
GUS_upload2_src		dd	0
GUS_upload2_dst		dd	0
GUS_upload2_tot		dd	0
GUS_upload2_cnt		dd	0
GUS_upload2_mode	db	0
GUS_upload2		ENDP

;Ĵ Gus IRQ 

GUS_IRQ:		pushad
			push	ds
			push	es
			mov	ax,cs:GUS_dataseg
			mov	ds,ax
			mov	es,ax

;                @setcol 0,0,0,63


GUS_IRQ_l1:		mov	edx,GUS_port1
			add	edx,6h
			in	al,dx
			mov	GUS_IRQ_status,al

			test	GUS_IRQ_status,11111111b
			jz	GUS_IRQ_done

;
;
; Sample wave & Volume ramp handling 
;
;
			test	GUS_IRQ_status,01100000b
			jz	GUS_IRQ_noservice

			mov	edx,GUS_port1
			add	edx,102h
			in	al,dx
			and	al,1fh
			push	eax
GUS_IRQ_service_l:
		@GUS_setfunc	8fh
		@GUS_getbyte
			mov	bl,al
			and	al,11000000b
			cmp	al,11000000b
			je	GUS_IRQ_service_done

			mov	GUS_IRQ_source,al
			and	ebx,1fh
			mov	edx,GUS_port1
			add	edx,102h
			mov	al,bl
			out	dx,al

			imul	ebx,size gusvoc
			lea	ebx,GUS_voices[ebx]

;
; Wavetable handling 
;
			test	GUS_IRQ_source,10000000b
			jnz	GUS_IRQ_service_notwave

                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_IRQ_service_notwave

			mov	eax,gusvoc.lend[ebx]
			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_IRQ_setlend_8bit
			shl	eax,1
GUS_IRQ_setlend_8bit:	add	eax,gusvoc.samstart[ebx]
			push	eax
			shr	eax,7
			mov	ecx,eax
		@GUS_setfunc	04h
		@GUS_setword	cx
			pop	eax
			and	eax,07fh
			shl	eax,9
			mov	ecx,eax
		@GUS_setfunc	05h
		@GUS_setword	cx
                        or      gusvoc.status[ebx],gustat_stopped

		@GUS_setfunc	80h
		@GUS_getbyte
			mov	cl,al
			and	cl,11011111b
		@GUS_setfunc	00h
		@GUS_setbyte	cl
		@GUS_delay1
		@GUS_setfunc	00h
		@GUS_setbyte	cl
GUS_IRQ_service_notwave:
;
; Volume ramp handling 
;
			test	GUS_IRQ_source,01000000b
			jnz	GUS_IRQ_service_notramp

		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	0dh
		@GUS_setbyte	00000011b

                        test    gusvoc.status[ebx],gustat_stoping
			jnz	GUS_IRQ_service_stopped

			mov	ecx,gusvoc.vol[ebx]
			imul	ecx,GUS_mastervol
			shr	ecx,10
			mov	ecx,GUS_voltab[ecx*4]
		@GUS_setfunc	09h
		@GUS_setword	cx
		@GUS_delay1
		@GUS_setfunc	09h
		@GUS_setword	cx
			jmp	GUS_IRQ_service_notramp
GUS_IRQ_service_stopped:and     gusvoc.status[ebx],NOT gustat_stoping

		@GUS_setfunc	00h
		@GUS_setbyte	00000011b
		@GUS_delay1
		@GUS_setfunc	00h
		@GUS_setbyte	00000011b

                        test    gusvoc.status[ebx],gustat_retrig
			jz	GUS_IRQ_service_notramp
                        and     gusvoc.status[ebx],NOT gustat_retrig
;Set Start
			mov	eax,gusvoc.sstart[ebx]
			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_IRQ_setstart_8bit
			shl	eax,1
GUS_IRQ_setstart_8bit:	add	eax,gusvoc.samstart[ebx]
			push	eax
			shr	eax,7
			mov	ecx,eax
		@GUS_setfunc	0ah
		@GUS_setword	cx
			pop	eax
			and	eax,07fh
			shl	eax,9
			mov	ecx,eax
		@GUS_setfunc	0bh
		@GUS_setword	cx
;Set End
			mov	eax,gusvoc.send[ebx]
			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_IRQ_setend_8bit
			shl	eax,1
GUS_IRQ_setend_8bit:	add	eax,gusvoc.samstart[ebx]
			push	eax
			shr	eax,7
			mov	ecx,eax
		@GUS_setfunc	04h
		@GUS_setword	cx
			pop	eax
			and	eax,07fh
			shl	eax,9
			mov	ecx,eax
		@GUS_setfunc	05h
		@GUS_setword	cx
;Set Loop Start
			mov	eax,gusvoc.lstart[ebx]
			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			test	gusvoc.mode[ebx],00000100b
			jz	GUS_IRQ_setlstart_8bit
			shl	eax,1
GUS_IRQ_setlstart_8bit:	add	eax,gusvoc.samstart[ebx]
			push	eax
			shr	eax,7
			mov	ecx,eax
		@GUS_setfunc	02h
		@GUS_setword	cx
			pop	eax
			and	eax,07fh
			shl	eax,9
			mov	ecx,eax
		@GUS_setfunc	03h
		@GUS_setword	cx
;Set Frequency
			push	ebx
			mov	eax,gusvoc.freq[ebx]
			mov	cl,gusvoc.freqshift[ebx]
			shr	eax,cl
			shl	eax,9h
			movzx	ebx,GUS_realchns
			mov	ecx,GUS_divisors[ebx*4]
			shr	ecx,1
			add	eax,ecx
			clr	edx
			div	GUS_divisors[ebx*4]
			shl	eax,1
			mov	ebx,GUS_voice
			mov	gusvoc.period[ebx],eax
			mov	ebx,eax
		@GUS_setfunc	1
		@GUS_setword	bx
			pop	ebx
;Set Panning
			mov	cl,gusvoc.pan[ebx]
		@GUS_setfunc	0ch
		@GUS_setbyte	cl
;Start with volume
		@GUS_setfunc	09h
		@GUS_setword	1500h
		@GUS_delay1
		@GUS_setfunc	09h
		@GUS_setword	1500h
		@GUS_setfunc	07h
		@GUS_setbyte	15h
			mov	ecx,gusvoc.vol[ebx]
			imul	ecx,GUS_mastervol
			shr	ecx,10
			mov	ecx,GUS_voltab[ecx*4]
		@GUS_setfunc	08h
		@GUS_setbyte	ch
		@GUS_setfunc	06h
		@GUS_setbyte	GUS_rampspeed
		@GUS_setfunc	0dh
		@GUS_setbyte	00100000b
			mov	cl,gusvoc.mode[ebx]
			test	cl,00001000b
			jz	GUS_IRQ_service_ramp_nl
			or	cl,00100000b
GUS_IRQ_service_ramp_nl:
		@GUS_setfunc	00h
		@GUS_setbyte	cl
                        and     gusvoc.status[ebx],NOT gustat_stopped
GUS_IRQ_service_notramp:
			jmp	GUS_IRQ_service_l
;
;
;
GUS_IRQ_service_done:	pop	eax
			mov	edx,GUS_port1
			add	edx,102h
			out	dx,al
GUS_IRQ_noservice:
;
;
; Timer 1 handling 
;
;
			test	GUS_IRQ_status,00000100b
			jz	GUS_IRQ_nottimer1

			clr	cl
			dec	GUS_gusbpmhicnt
			jns	GUS_IRQ_bpmnotready
			mov	al,GUS_gusbpmhi
			mov	GUS_gusbpmhicnt,al
			cmp	[FMT_playtick],0
			je	GUS_IRQ_skiptick
			call	[FMT_playtick]
GUS_IRQ_skiptick:	mov	cl,GUS_gusbpm
GUS_IRQ_bpmnotready:
		@GUS_setfunc	46h
		@GUS_setbyte	cl
		@GUS_setfunc	45h
		@GUS_getbyte
			and	al,NOT 00000100b
			out	dx,al
			or	al,00000100b
			out	dx,al
GUS_IRQ_nottimer1:
;
;
; Timer 2 handling 
;
;
			test	GUS_IRQ_status,00001000b
			jz	GUS_IRQ_nottimer2
		@GUS_setfunc	45h
		@GUS_getbyte
			and	al,NOT 00001000b
			out	dx,al
			or	al,00001000b
			out	dx,al
GUS_IRQ_nottimer2:
;
;
; DMA handling 
;
;
			test	GUS_IRQ_status,10000000b
			jz	GUS_IRQ_notdma
		@GUS_setfunc	41h
		@GUS_getbyte
			test	al,01000000b
			jz	GUS_IRQ_sampledma
			or	GUS_IRQ_dmaready,1
			jmp	GUS_IRQ_notdma
GUS_IRQ_sampledma:
		@GUS_setfunc	49h
		@GUS_getbyte
GUS_IRQ_notdma:
;
;
;
			jmp	GUS_IRQ_l1
;
;
; No More GUS IRQ's 
;
;
GUS_IRQ_done:

;                @setcol 0,0,0,0

			mov	al,020h
			out	020h,al
			out	0a0h,al

			pop	es
			pop	ds
			popad
			iretd
;                        jmp     cs:[GUS_oldirq]

GUS_IRQ_dmaready	db	0
GUS_IRQ_status		db	0
GUS_IRQ_source		db	0
GUS_dataseg		dw	0

;Ĵ Gus Check for MegaEM 

GUS_checkmegaem:	mov	eax,0fd12h
			mov	ebx,3457h
			int	21h
			cmp	ax,05678h
			jne	GUS_checkmegaem_not
			cmp	bh,012h
			jne	GUS_checkmegaem_not
			cmp	bl,037h
			jae	GUS_checkmegaem_3x
			mov	nms_error,30h
			stc
			ret
GUS_checkmegaem_3x:	mov	al,dh
			and	al,0fh
			or	al,30h
			mov	GUS_error031+8,al
			mov	al,dl
			shr	al,4
			or	al,30h
			mov	GUS_error031+10,al
			mov	al,dl
			and	al,0fh
			or	al,30h
			mov	GUS_error031+11,al
			mov	nms_error,31h
			stc
			ret
GUS_checkmegaem_not:	clc
			ret

;Ĵ Gus Check for SBOS 

GUS_checksbos:		clc
			ret

;Ĵ Gus Check for PRG 

GUS_checkprg:		mov	eax,0cd00h
			mov	ebx,0464fh
			mov	ecx,05254h
			mov	edx,04520h
			mov	NMS_dosint_int,02fh
			call	NMS_dosint
;			 cmp	 al,0ffh
;			 jne	 GUS_checkprg_not
			cmp	bx,04155h
			jne	GUS_checkprg_not
			cmp	cx,04449h
			jne	GUS_checkprg_not
			cmp	dx,04f20h
			jne	GUS_checkprg_not
			movzx	edi,NMS_dosint_ES
			shl	edi,4
			and	esi,0ffffh
			add	esi,edi
			push	esi
			call	[SYS_getprginfo]
			pop	esi
			sub	esi,ebx
			lea	edi,GUS_error033_name
GUS_checkptr_l: 	lodsb
			or	al,al
			jz	GUS_checkptr_done
			stosb
			jmp	GUS_checkptr_l
GUS_checkptr_done:	mov	eax,0240a0d2eh
			stosd
			mov	nms_error,33h
			stc
			ret
GUS_checkprg_not:	clc
			ret

;Ŀ
;Ŀ
; Data 
;ٰ
;
.data

gustat_stopped          =       1 shl 0
gustat_ready            =       1 shl 1
gustat_stoping          =       1 shl 2
gustat_retrig           =       1 shl 3


gusvoc                  STRUC,NONUNIQUE
sstart			dd	?
send			dd	?
lstart			dd	?
lend			dd	?
vol			dd	?
gusvol			dd	?
freq			dd	?
period			dd	?
pan			db	?
mode			db	?
sample			dd	?
samstart		dd	?
samend			dd	?
status			db	?
freqshift		db	?
gusvoc			ENDS

gussam                  STRUC,NONUNIQUE
memstart		dd	?
memend			dd	?
gusstart		dd	?
gusend			dd	?
freqshift		db	?
gussam			ENDS

GUS_voice		dd	GUS_voices

GUS_mastervol		dd	256

GUS_envstr		db	'ULTRASND='
GUS_envstrl		=	$-GUS_envstr

GUS_name                db      "Gravis Ultrasound",eol
GUS_name1		db	"Gravis Ultrasound v2.2 or v2.4",eol
GUS_name2		db	"Gravis Ultrasound v3.4",eol
GUS_name3		db	"Gravis Ultrasound v3.7",eol
GUS_name4		db	"Gravis Ultrasound MAX (Hardware Mixing)",eol
GUS_name5		db	"Gravis Ultrasound ACE",eol

GUS_version		db	"Gravis Ultrasound driver v3.03",eol
GUS_note		db	"If it won't play, try running ultrinit.exe",eol

GUS_cardlst		dd	GUS_name1,00010101b
			dd	GUS_name2,00010101b
			dd	GUS_name3,00010101b
			dd	GUS_name4,00010101b
			dd	GUS_name5,00010101b

GUS_port1desc		db	'Port',eol
GUS_port1lst		dd	210h,220h,230h,240h,250h,260h,-1
GUS_irq1desc		db	'GF1 IRQ',eol
GUS_irq1lst		dd	2,3,5,7,11,12,15,-1
GUS_dma1desc		db	'Playback DMA',eol
GUS_dma1lst		dd	1,3,5,6,7,-1

GUS_cmdlist		db	'GUSH'                  ;drv_id
                        dd      GUS_name                ;drv_text
			dd	GUS_version		;drv_version
			dd	GUS_note		;drv_note
GUS_card		dd	0			;drv_card
			dd	5			;drv_cards
			dd	GUS_cardlst		;drv_cardlst
			dd	00010101b		;drv_config
GUS_port1		dd	-1			;drv_port1
			dd	GUS_port1lst		;drv_port1lst
			dd	GUS_port1desc		;drv_port1desc
			dd	-1			;drv_port2
			dd	-1			;drv_port2lst
			dd	-1			;drv_port2desc
GUS_irq1		dd	-1			;drv_irq1
			dd	GUS_irq1lst		;drv_irq1lst
			dd	GUS_irq1desc		;drv_irq1desc
GUS_irq2		dd	-1			;drv_irq2
			dd	-1			;drv_irq2lst
			dd	-1			;drv_irq2desc
GUS_dma1		dd	-1			;drv_dma1
			dd	GUS_dma1lst		;drv_dma1lst
			dd	GUS_dma1desc		;drv_dma1desc
GUS_dma2		dd	-1			;drv_dma2
			dd	-1			;drv_dma2lst
			dd	-1			;drv_dma2desc
			dd	GUS_detect		;drv_detect
			dd	GUS_init		;drv_init
			dd	GUS_exit		;drv_exit
			dd	GUS_activate		;drv_activate
			dd	GUS_deactivate		;drv_deactivate
			dd	GUS_setbpm		;drv_setbpm
			dd	TMR_activatesync	;drv_scrsync
			dd	TMR_deactivatesync	;drv_scrsync
			dd	TMR_sync		;drv_scrsync
			dd	GUS_setsample		;drv_setsample
			dd	GUS_clrsamples		;drv_clrsamples
			dd	GUS_initsamples 	;drv_initsamples
			dd	GUS_setactivesample	;drv_setactivesample
			dd	GUS_setchns		;drv_setchns
			dd	GUS_setmastervol	;drv_setmastervol
			dd	GUS_setactivechn	;drv_setactivechn
			dd	GUS_setmode		;drv_setmode
			dd	GUS_setstart		;drv_setstart
			dd	GUS_setend		;drv_setend
			dd	GUS_setlstart		;drv_setlstart
			dd	GUS_setlend		;drv_setlend
			dd	GUS_setfreq		;drv_setfreq
			dd	GUS_setvol		;drv_setvol
			dd	GUS_setpan		;drv_setpan
			dd	GUS_startchn		;drv_startchn
			dd	GUS_stopchn		;drv_stopchn

GUS_bpm 		db	125
GUS_gusbpm		db	0
GUS_gusbpmhi		db	0
GUS_gusbpmhicnt 	db	0
GUS_drampos             dd      -1

GUS_mem 		dd	0
GUS_lastmem		dd	0

GUS_chn 		db	0
GUS_chns		db	14
GUS_realchns		db	14
GUS_divisors		dd	617400,308700,205800,154350,123480,102900,88200,77175,68600,61740,56127,51450,47492
			dd	44100,41160,38587,36317,34300,32494,30870,29400,28063,26843,25725,24696,23746,22866,22050,21289,20580,19916,19293

GUS_voltab		dd	01500h,08f10h,09f10h,0ab50h,0af10h,0b970h,0bb50h,0bd30h
			dd	0bf10h,0c880h,0c970h,0ca60h,0cb50h,0cc40h,0cd30h,0ce20h
			dd	0cf10h,0d800h,0d880h,0d8f0h,0d970h,0d9e0h,0da60h,0dad0h
			dd	0db50h,0dbc0h,0dc40h,0dcb0h,0dd30h,0dda0h,0de20h,0de90h
			dd	0df10h,0df80h,0e800h,0e840h,0e880h,0e8b0h,0e8f0h,0e930h
			dd	0e970h,0e9a0h,0e9e0h,0ea20h,0ea60h,0ea90h,0ead0h,0eb10h
			dd	0eb50h,0eb80h,0ebc0h,0ec00h,0ec40h,0ec70h,0ecb0h,0ecf0h
			dd	0ed30h,0ed60h,0eda0h,0ede0h,0ee20h,0ee50h,0ee90h,0eed0h
			dd	0ef00h

GUS_irqlist		db	08h,09h,0ah,0bh,0ch,0dh,0eh,0fh,70h,71h,72h,73h,74h,75h,76h,77h
		align		4
GUS_oldirq		df	0
oldpic			dw	0

GUS_error030		db	"MegaEm v1.x or v2.x is installed, please remove!",eol
GUS_error031		db	"MegaEm vx.xx is installed, please remove!",eol
GUS_error032		db	"SBOS is installed, please remove!",eol
GUS_error033		db	"The Ultrasound is already in use. Please remove "
GUS_error033_name	db	128 dup ("$")

.data?
GUS_voices		db	32*size gusvoc dup(?)
GUS_samples		db	4096*size gussam dup(?)

			END
