.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.ext
                include p:\nms.str
                include p:\devices\mix.ext
                include p:\devices\mix.str
                include p:\devices\timer.ext
                include p:\devices\dma.ext

		public	DSK_cmdlist

DSK_mixsize		=	8192

;Ĵ DSK Start mixing 

DSK_activate		PROC

			call	DSK_play

			ret
DSK_activate		ENDP

;Ĵ DSK Stop mixing 

DSK_deactivate		PROC
			ret
DSK_deactivate		ENDP

;Ĵ DSK detect 

DSK_detect		PROC
			clc
			ret
DSK_detect		ENDP

;Ĵ DSK init 

DSK_init 		PROC
                        pushad

                        mov     nms_errors+34h*4,ofs DSK_error034

                        call    DMA_init
                        jc      DSK_init_fail

;			call	TMR_init

			cli
			push	ds
			pop	eax
			mov	DSK_dataseg,ax

                        mov     ebx,DSK_card
                        jmp     DSK_init_jmptab[ebx*4]

DSK_init_card1:		mov     DSK_rate,22050
			mov	DSK_config,0
			mov	DSK_file_init,ofs DSK_WAV_init
			mov	DSK_file_write,ofs DSK_WAV_write
			mov	DSK_file_exit,ofs DSK_WAV_exit
			jmp	DSK_init_done
DSK_init_card2:		mov     DSK_rate,22050
			mov	DSK_config,mixctrl_stereo
			mov	DSK_file_init,ofs DSK_WAV_init
			mov	DSK_file_write,ofs DSK_WAV_write
			mov	DSK_file_exit,ofs DSK_WAV_exit
			jmp	DSK_init_done
DSK_init_card3:		mov     DSK_rate,44100
			mov	DSK_config,mixctrl_16bit
			mov	DSK_file_init,ofs DSK_WAV_init
			mov	DSK_file_write,ofs DSK_WAV_write
			mov	DSK_file_exit,ofs DSK_WAV_exit
			jmp	DSK_init_done
DSK_init_card4:		mov     DSK_rate,44100
			mov	DSK_config,mixctrl_16bit+mixctrl_stereo
			mov	DSK_file_init,ofs DSK_WAV_init
			mov	DSK_file_write,ofs DSK_WAV_write
			mov	DSK_file_exit,ofs DSK_WAV_exit
			jmp	DSK_init_done
DSK_init_card5:		mov     DSK_rate,22050
			mov	DSK_config,0
			mov	DSK_file_init,ofs DSK_VOC_init
			mov	DSK_file_write,ofs DSK_VOC_write
			mov	DSK_file_exit,ofs DSK_VOC_exit
			jmp	DSK_init_done
DSK_init_card6:		mov     DSK_rate,22050
			mov	DSK_config,mixctrl_stereo
			mov	DSK_file_init,ofs DSK_VOC_init
			mov	DSK_file_write,ofs DSK_VOC_write
			mov	DSK_file_exit,ofs DSK_VOC_exit
			jmp	DSK_init_done
DSK_init_card7:		mov     DSK_rate,22050
			mov	DSK_config,0
                        mov     DSK_file_init,ofs DSK_SND_init
                        mov     DSK_file_write,ofs DSK_SND_write
                        mov     DSK_file_exit,ofs DSK_SND_exit
			jmp	DSK_init_done
DSK_init_card8:		mov     DSK_rate,22050
			mov	DSK_config,mixctrl_stereo
                        mov     DSK_file_init,ofs DSK_SND_init
                        mov     DSK_file_write,ofs DSK_SND_write
                        mov     DSK_file_exit,ofs DSK_SND_exit
			jmp	DSK_init_done
DSK_init_card9:		mov     DSK_rate,44100
			mov	DSK_config,mixctrl_16bit
                        mov     DSK_file_init,ofs DSK_SND_init
                        mov     DSK_file_write,ofs DSK_SND_write
                        mov     DSK_file_exit,ofs DSK_SND_exit
			jmp	DSK_init_done
DSK_init_card10:	mov     DSK_rate,44100
			mov	DSK_config,mixctrl_16bit+mixctrl_stereo
                        mov     DSK_file_init,ofs DSK_SND_init
                        mov     DSK_file_write,ofs DSK_SND_write
                        mov     DSK_file_exit,ofs DSK_SND_exit
			jmp	DSK_init_done

DSK_init_done:		mov     eax,DSK_config
                        mov     ebx,DSK_rate
			call    MIX_init
                        jc      DSK_init_fail

			mov     eax,5000/40
			call	DSK_setbpm

			call	[DSK_file_init]
DSK_init_fail:		popad
			ret
DSK_init_jmptab		dd	-1	;If no card was detected and we came this far , it deserves to crash!
			dd	DSK_init_card1
			dd	DSK_init_card2
			dd	DSK_init_card3
			dd	DSK_init_card4
			dd	DSK_init_card5
			dd	DSK_init_card6
			dd	DSK_init_card7
			dd	DSK_init_card8
			dd	DSK_init_card9
			dd	DSK_init_card10
DSK_init 		ENDP

;Ĵ DSK exit 

DSK_exit 		PROC
			pushad
			call	[DSK_file_exit]

;			call	TMR_exit
			popad
			ret
DSK_exit 		ENDP

;Ĵ DSK Set/Get bpm 

DSK_setbpm		PROC	USES eax ebx edx
                        mov	DSK_bpm,eax
			mov	ebx,eax
			imul	ebx,40
			mov	eax,100
			mul	DSK_rate
			div	ebx

			inc	eax
			and	eax,not 1

			mov	ebx,1
			test	DSK_config,mixctrl_16bit
			jz	DSK_setbpm_8bit
                        shl     eax,1
                        shl     ebx,1
DSK_setbpm_8bit:	test	DSK_config,mixctrl_stereo
			jz	DSK_setbpm_mono
                        shl     eax,1
                        shl     ebx,1
DSK_setbpm_mono:        mov     DSK_bytespercount,ebx
                        mov     DSK_ticksize,eax
			mov	DSK_tickleft,eax
                        ret
DSK_setbpm		ENDP

;Ĵ DSK WAV Init 

DSK_WAV_init    	PROC	USES eax ebx ecx edx
			mov	DSK_file_length,0
                        mov     DSK_file_ext,00766177h
                        mov     ah,3ch
			mov	ecx,0
                        lea     edx,DSK_file_name
                        int     21h
                        mov     nms_error,34h
                        jc      DSK_WAV_init_fail
                        mov     DSK_file_handle,eax

			mov	DSK_WAV_header_align,1
			mov	DSK_WAV_header_bits,8
			test	DSK_config,mixctrl_16bit
			jz	DSK_WAV_init_8bits
			mov	DSK_WAV_header_align,2
			mov	DSK_WAV_header_bits,16
DSK_WAV_init_8bits:	mov	DSK_WAV_header_chns,1
			test	DSK_config,mixctrl_stereo
			jz	DSK_WAV_init_mono
			mov	DSK_WAV_header_chns,2
			shl	DSK_WAV_header_align,1
DSK_WAV_init_mono:	mov	eax,DSK_rate
			mov	DSK_WAV_header_sps,eax
			movsx   ebx,DSK_WAV_header_align
			imul	eax,ebx
			mov	DSK_WAV_header_bps,eax

			mov	ah,40h
			mov	ebx,DSK_file_handle
                        mov     ecx,44
                        lea     edx,DSK_WAV_header
			int	21h
                        clc
                        jmp     DSK_WAV_init_exit
DSK_WAV_init_fail:      stc
DSK_WAV_init_exit:      ret
DSK_WAV_init    	ENDP

;Ĵ DSK WAV Exit 

DSK_WAV_exit    	PROC	USES eax ebx
			mov	eax,DSK_file_length
			mov	DSK_WAV_header_len2,eax
			add	eax,44-8
			mov	DSK_WAV_header_len1,eax

			mov	eax,4200h
			mov	ebx,DSK_file_handle
			clr	ecx
			clr	edx
			int	21h

			mov	ah,40h
			mov	ebx,DSK_file_handle
                        mov     ecx,44
                        lea     edx,DSK_WAV_header
			int	21h

			mov	ah,3eh
			mov	ebx,DSK_file_handle
			int	21h
			clc
			ret
DSK_WAV_exit    	ENDP

;Ĵ DSK WAV Write 

DSK_WAV_write   	PROC	USES eax ebx ecx edx
			add	DSK_file_length,ecx
			mov	edx,edi
			mov	ebx,DSK_file_handle
			mov	ah,40h
			int	21h
			ret
DSK_WAV_write   	ENDP

;Ĵ DSK VOC Init 

DSK_VOC_init    	PROC
			ret
DSK_VOC_init    	ENDP

;Ĵ DSK VOC Exit 

DSK_VOC_exit    	PROC
			ret
DSK_VOC_exit    	ENDP

;Ĵ DSK VOC Write 

DSK_VOC_write   	PROC
			ret
DSK_VOC_write   	ENDP

;Ĵ DSK SND Init 

DSK_SND_init    	PROC
                        mov     DSK_file_ext,00646e73h
                        mov     ah,3ch
			mov	ecx,0
                        lea     edx,DSK_file_name
                        int     21h
                        mov     nms_error,34h
                        jc      DSK_SND_init_fail
                        mov     DSK_file_handle,eax
                        clc
DSK_SND_init_fail:      ret
DSK_SND_init    	ENDP

;Ĵ DSK SND Exit 

DSK_SND_exit    	PROC
                        mov     ah,3eh
			mov	ebx,DSK_file_handle
			int	21h
			clc
                        ret
DSK_SND_exit    	ENDP

;Ĵ DSK SND Write 

DSK_SND_write   	PROC
                        mov     edx,edi
			mov	ebx,DSK_file_handle
			mov	ah,40h
			int	21h
                        ret
DSK_SND_write   	ENDP

;Ĵ DSK Timer procedure 

DSK_play:		pushad
DSK_play_l:             mov	ecx,DSK_tickleft
                        cmp     ecx,DSK_mixsize
			jb	DSK_play_ok
			mov	ecx,DSK_mixsize
DSK_play_ok:
			mov	edi,DMA_addr
			clr	eax
			mov	ebx,DSK_mixsize
                        call    MIX

			sub	DSK_tickleft,ecx
			jnz     DSK_play_noplay
			cmp	[FMT_playtick],0
			je	DSK_play_noplay
			call	[FMT_playtick]
			mov	edi,DSK_ticksize
			mov	DSK_tickleft,edi
DSK_play_noplay:	mov	edi,DMA_addr
                	call	[DSK_file_write]

			in	al,60h
			cmp	al,1h
			jnz	DSK_play_l
			popad
			ret

;Ĵ DSK data 

.data

DSK_error034            db      'Error opening file for output',eol

DSK_name                db      'Direct Disk',eol
DSK_name1		db	'WAV 8-bit Mono 22Khz',eol
DSK_name2		db	'WAV 8-bit Stereo 22Khz',eol
DSK_name3		db	'WAV 16-bit Mono 44Khz',eol
DSK_name4		db	'WAV 16-bit Stereo 44Khz',eol
DSK_name5		db	'VOC 8-bit Mono 22Khz',eol
DSK_name6		db	'VOC 8-bit Stereo 22Khz',eol
DSK_name7		db	'SND 8-bit Mono 22Khz',eol
DSK_name8		db	'SND 8-bit Stereo 22Khz',eol
DSK_name9		db	'SND 16-bit Mono 44Khz',eol
DSK_name10      	db	'SND 16-bit Stereo 44Khz',eol

DSK_version		db	'Direct Disk driver v0.20',eol
DSK_note 		db	'Will save a file called sound.<ext>',eol

DSK_cardlst		dd	DSK_name1,00000000b
			dd	DSK_name2,00000000b
			dd	DSK_name3,00000000b
			dd	DSK_name4,00000000b
			dd	DSK_name5,00000000b
			dd	DSK_name6,00000000b
			dd	DSK_name7,00000000b
			dd	DSK_name8,00000000b
			dd	DSK_name9,00000000b
			dd	DSK_name10,00000000b
			dd	-1

DSK_cmdlist		db	'DSK',0                	;drv_id
                        dd      DSK_name                ;drv_text
			dd	DSK_version		;drv_version
			dd	DSK_note 		;drv_note
DSK_card                dd      4                       ;drv_card
			dd	10      		;drv_cards
			dd	DSK_cardlst		;drv_cardlst
			dd	00000000b		;drv_config
                	dd	-1      		;drv_port1
			dd	-1              	;drv_port1lst
			dd	-1              	;drv_port1desc
			dd	-1			;drv_port2
			dd	-1			;drv_port2lst
			dd	-1			;drv_port2desc
         		dd	-1      		;drv_irq1
			dd	-1              	;drv_irq1lst
			dd	-1              	;drv_irq1desc
			dd	-1			;drv_irq2
			dd	-1			;drv_irq2lst
			dd	-1			;drv_irq2desc
         		dd	-1      		;drv_dma1
			dd	-1         		;drv_dma1lst
			dd	-1          		;drv_dma1desc
         		dd	-1      		;drv_dma2
			dd	-1              	;drv_dma2lst
			dd	-1          		;drv_dma2desc
			dd	DSK_detect		;drv_detect
			dd	DSK_init 		;drv_init
			dd	DSK_exit 		;drv_exit
			dd	DSK_activate		;drv_activate
			dd	DSK_deactivate		;drv_deactivate
			dd	DSK_setbpm		;drv_setbpm
			dd	TMR_activatesync	;drv_activatesync
			dd	TMR_deactivatesync	;drv_deactivatesync
			dd	TMR_sync		;drv_sync
			dd	MIX_setsample		;drv_setsample
			dd	MIX_clrsamples		;drv_clrsamples
			dd	MIX_initsamples 	;drv_initsamples
			dd	MIX_setactivesample	;drv_setactivesample
			dd	MIX_setchns		;drv_setchns
			dd	MIX_setmastervol	;drv_setmastervol
			dd	MIX_setactivechn	;drv_setactivechn
			dd	MIX_setmode		;drv_setmode
			dd	MIX_setstart		;drv_setstart
			dd	MIX_setend		;drv_setend
			dd	MIX_setlstart		;drv_setlstart
			dd	MIX_setlend		;drv_setlend
			dd	MIX_setfreq		;drv_setfreq
			dd	MIX_setvol		;drv_setvol
			dd	MIX_setpan		;drv_setpan
			dd	MIX_startchn		;drv_startchn
			dd	MIX_stopchn		;drv_stopchn

DSK_bpm			dd	0

DSK_ticksize 		dd	0
DSK_tickleft    	dd	0

DSK_bytespercount	dd	0

DSK_config		dd      0
DSK_rate		dd      0

DSK_dataseg		dw	0

DSK_active		dd	0

DSK_file_name           db      'sound.'
DSK_file_ext            dd      0
DSK_file_handle         dd      0
DSK_file_length		dd	0
DSK_file_init           dd      0
DSK_file_write  	dd	0
DSK_file_exit		dd	0

DSK_WAV_header          db      'RIFF'
DSK_WAV_header_len1     dd      0               ;file length - 8
                        db      'WAVE'
                        db      'fmt '
                        dd      16
                        dw      1               ;1 ?
DSK_WAV_header_chns     dw      0               ;1&2
DSK_WAV_header_sps      dd      0               ;Freq
DSK_WAV_header_bps      dd      0               ;Freq
DSK_WAV_header_align    dw      1               ;1 - 8bits ; 2 - 16bits
DSK_WAV_header_bits     dw      8               ;bits
                        db      'data'
DSK_WAV_header_len2     dd      0               ;file length - 44
			END

