.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.ext
		public	AWE_cmdlist

;Ĵ AWE macros 

@AWE_setfunc		MACRO	func
			mov	edx,AWE_port2
			add	edx,0802h
			mov	eax,func
			out	dx,ax
			ENDM
@AWE_setbyte		MACRO	port,data
			mov	edx,AWE_port2
			add	edx,port
			mov	al,data
			out	dx,al
			ENDM
@AWE_setword		MACRO	port,data
			mov	edx,AWE_port2
			add	edx,port
			mov	ax,data
			out	dx,ax
			ENDM
@AWE_setdword		MACRO	port,data
			mov	edx,AWE_port2
			add	edx,port
			mov	eax,data
			out	dx,ax
			shr	eax,16
			add	edx,2
			out	dx,ax
			ENDM
@AWE_getbyte		MACRO	port
			mov	edx,AWE_port2
			add	edx,port
			in	al,dx
			ENDM
@AWE_getword		MACRO	port
			mov	edx,AWE_port2
			add	edx,port
			in	ax,dx
			ENDM
@AWE_getdword		MACRO	port
			mov	edx,AWE_port2
			add	edx,port+2
			in	ax,dx
			shl	eax,16
			dec	edx,2
			in	ax,dx
			ENDM

;Ĵ AWE detect 

AWE_detect		PROC
			pushad
			mov	nms_error,10h
			lea	esi,AWE_envstr
			mov	ecx,AWE_envstrl
			call	NMS_findenvstr
			jc	AWE_detect_fail
			clr	edx
			mov	nms_error,11h
AWE_detect_l1:		lodsb
			or	al,al
			jz	AWE_detect_done
			cmp	al,' '
			je	AWE_detect_l1
			and	eax,0dfh

			cmp	eax,'A'                         ;A - port1
			jne	AWE_detect_notport1
			lodsb
			cmp	al,'2'
			jne	AWE_detect_fail
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			cmp	al,8h
			ja	AWE_detect_fail
			and	eax,0fh
			shl	eax,4
			or	eax,200h
			mov	AWE_port1,eax
			lodsb
			cmp	al,'0'
			jne	AWE_detect_fail
			or	edx,1h
			jmp	AWE_detect_getdone
AWE_detect_notport1:	cmp	eax,'E'                         ;E - port2
			jne	AWE_detect_notport2
			lodsb
			cmp	al,'6'
			jne	AWE_detect_fail
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			cmp	al,8h
			ja	AWE_detect_fail
			and	eax,0fh
			shl	eax,4
			or	eax,600h
			mov	AWE_port2,eax
			lodsb
			cmp	al,'0'
			jne	AWE_detect_fail
			or	edx,4h
			jmp	AWE_detect_getdone
AWE_detect_notport2:	cmp	eax,'P'                         ;P - port3
			jne	AWE_detect_notport3
			lodsb
			cmp	al,'3'
			jne	AWE_detect_fail
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			cmp	al,3h
			ja	AWE_detect_fail
			and	eax,0fh
			shl	eax,4
			or	eax,300h
			;mov	 AWE_port3,eax
			lodsb
			cmp	al,'0'
			jne	AWE_detect_fail
			or	edx,2h
			jmp	AWE_detect_getdone
AWE_detect_notport3:	cmp	eax,'I'                         ;I - Irq
			jne	AWE_detect_notirq
			lodsb
			mov	bl,al
			and	ebx,0ffh
			sub	bl,'0'
			js	AWE_detect_fail
			cmp	bptr [esi],' '
			je	AWE_detect_lowirq
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			imul	ebx,10
			or	bl,al
AWE_detect_lowirq:	mov	AWE_irq,ebx
			or	edx,8h
			jmp	AWE_detect_getdone
AWE_detect_notirq:	cmp	eax,'D'                         ;D - lowdma
			jne	AWE_detect_notdma
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			and	eax,07h
			;mov	 AWE_dma1,eax
			or	edx,10h
			jmp	AWE_detect_getdone
AWE_detect_notdma:	cmp	eax,'H'                         ;H - highdma
			jne	AWE_detect_nothdma
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			and	eax,07h
			;mov	 AWE_dma2,eax
			or	edx,20h
			jmp	AWE_detect_getdone
AWE_detect_nothdma:	cmp	eax,'T'                         ;T - version
			jne	AWE_detect_notdsp
			lodsb
			sub	al,'0'
			js	AWE_detect_fail
			and	eax,07h
			mov	AWE_ver,eax
			or	edx,40h
			jmp	AWE_detect_getdone
AWE_detect_notdsp:	jmp	AWE_detect_fail
AWE_detect_getdone:	jmp	AWE_detect_l1
AWE_detect_done:	and	edx,2dh 			;A+E+I+H
			cmp	edx,2dh
			jne	AWE_detect_fail

			mov	nms_error,13h
			call	AWE_getver
			jc	AWE_detect_fail
			cmp	eax,040ch
			jb	AWE_detect_fail

			popad
			clc
                        stc
                        ret
AWE_detect_fail:	popad
			stc
			ret
AWE_detect		ENDP

;Ĵ AWE init 

AWE_init		PROC
			pushad

			mov	nms_error,12h
		@AWE_setfunc	00e0h
		@AWE_getword	0800h
		@AWE_getword	0800h
			and	eax,0fh
			cmp	eax,0ch
			jne	AWE_init_fail
		@AWE_setfunc	0020h+29
		@AWE_getword	0400h
			and	eax,07eh
			cmp	eax,058h
			jne	AWE_init_fail
		@AWE_setfunc	0020h+30
		@AWE_getword	0400h
			and	eax,03h
			cmp	eax,03h
			jne	AWE_init_fail

			call	AWE_clearvoices

		@AWE_setfunc	0a0h+30
		@AWE_setword	0400h,080h
		@AWE_setfunc	0c0h+30
		@AWE_setdword	0000h,0ffffffe0h
		@AWE_setfunc	0e0h+30
		@AWE_setdword	0000h,0ffffe8h
		@AWE_setfunc	020h+30
		@AWE_setdword	0000h,0h
		@AWE_setfunc	000h+30
		@AWE_setdword	0000h,0h
		@AWE_setfunc	000h+30
		@AWE_setdword	0400h,0ffffe3h

		@AWE_setfunc	0a0h+31
		@AWE_setword	0400h,080h
		@AWE_setfunc	0c0h+31
		@AWE_setdword	0000h,0fffff0h
		@AWE_setfunc	0e0h+31
		@AWE_setdword	0000h,0fffff8h
		@AWE_setfunc	020h+31
		@AWE_setdword	0000h,0ffh
		@AWE_setfunc	000h+31
		@AWE_setdword	0000h,0h
		@AWE_setfunc	000h+31
		@AWE_setdword	0400h,0fffff3h

		@AWE_setfunc	020h+30
		@AWE_setword	0000h,0
AWE_init_l2:	@AWE_getword	0802h
			test	eax,01000h
			jz	AWE_init_l2
AWE_init_l3:	@AWE_getword	0802h
			test	eax,01000h
			jnz	AWE_init_l3
		@AWE_setword	0002h,04828h
		@AWE_setfunc	020h+28
		@AWE_setword	0400h,0
		@AWE_setfunc	060h+30
		@AWE_setdword	0000h,-1
		@AWE_setfunc	060h+31
		@AWE_setdword	0000h,-1

			call	AWE_getmemsize
			call	AWE_clearvoices

			mov	nms_error,18h
			cmp	AWE_mem,0
			je	AWE_init_fail

			popad
			clc
			ret
AWE_init_fail:		stc
			popad
			ret
AWE_init		ENDP

;Ĵ AWE exit 

AWE_exit		PROC
			ret
AWE_exit		ENDP

AWE_activate:
AWE_deactivate:
AWE_setbpm:
AWE_setsample:
AWE_clrsamples:
AWE_initsamples:
AWE_setactivesample:
AWE_setchns:
AWE_setmastervol:
AWE_setactivechn:
AWE_setmode:
AWE_setstart:
AWE_setend:
AWE_setlstart:
AWE_setlend:
AWE_setfreq:
AWE_setvol:
AWE_setpan:
AWE_startchn:
AWE_stopchn:		ret

;Ĵ AWE clear voices 

AWE_clearvoices 	PROC	USES eax ebx ecx edx
			clr	ecx
AWE_clearvoices_l0:
		@AWE_setfunc	ecx
		@AWE_setdword	0400h,0
			mov	ebx,0a0h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setword	0400h,0807fh

			inc	ecx
			cmp	ecx,30
			jbe	AWE_clearvoices_l0

			ret
AWE_clearvoices 	ENDP

;Ĵ AWE get memory size 

AWE_getmemsize		PROC
			pushad
			clr	ecx
AWE_getmemsize_l0:	mov	ebx,0a0h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setword	0400h,80h
			mov	ebx,060h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setdword	0000h,0h
			mov	ebx,040h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setdword	0000h,0h
			mov	ebx,0c0h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setdword	0000h,0h
			mov	ebx,0e0h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setdword	0000h,0h
			mov	ebx,020h
			add	ebx,ecx
		@AWE_setfunc	ebx
		@AWE_setdword	0000h,040000000h
		@AWE_setfunc	ecx
		@AWE_setdword	0000h,040000000h
		@AWE_setfunc	ecx
		@AWE_setword	0400h,0h
			mov	ebx,ecx
			and	ebx,0001h
			shl	ebx,9
			or	ebx,0400h
		@AWE_setword	0400h,bx
			inc	ecx
			cmp	ecx,30
			jb	AWE_getmemsize_l0

		@AWE_setfunc	020h+22
		@AWE_setdword	0400h,2*1024*1024
		@AWE_setfunc	020h+26
		@AWE_setword	0400h,0C0DEh

			mov	AWE_mem,0
			mov	eax,0
			call	AWE_checkmem
			jc	AWE_getmemsize_done
AWE_getmemsize_l1:	call	AWE_checkmem
			jc	AWE_getmemsize_done
			add	eax,256*1024
			mov	AWE_mem,eax
			cmp	eax,28*1024*1024
			jne	AWE_getmemsize_l1
AWE_getmemsize_done:	popad
			ret
AWE_getmemsize		ENDP

AWE_checkmem		PROC	USES eax
			mov	ecx,eax
			add	ecx,2*1024*1024
		@AWE_setfunc	0020h+22
		@AWE_setdword	0400h,ecx
		@AWE_setfunc	0020h+26
		@AWE_setword	0400h,00123h
		@AWE_setword	0400h,04567h
		@AWE_setword	0400h,089abh
		@AWE_setword	0400h,0cdefh

		@AWE_setfunc	0020h+20
		@AWE_setdword	0400h,2*1024*1024
		@AWE_setfunc	0020h+26
		@AWE_getword	0400h
		@AWE_getword	0400h
			cmp	ax,0C0DEh
			je	AWE_checkmem_fail

		@AWE_setfunc	0020h+20
		@AWE_setdword	0400h,ecx
		@AWE_setfunc	0020h+26
		@AWE_getword	0400h
		@AWE_getword	0400h
			cmp	ax,00123h
			jne	AWE_checkmem_fail
		@AWE_getword	0400h
			cmp	ax,04567h
			jne	AWE_checkmem_fail
		@AWE_getword	0400h
			cmp	ax,089abh
			jne	AWE_checkmem_fail
		@AWE_getword	0400h
			cmp	ax,0cdefh
			jne	AWE_checkmem_fail
			clc
			jmp	AWE_checkmem_ok
AWE_checkmem_fail:	stc
AWE_checkmem_ok:	ret
AWE_checkmem		ENDP

;Ĵ AWE get version 

AWE_getver		PROC	USES ebx
			mov	al,0e1h
			call	AWE_write
			jc	AWE_getver_fail
			call	AWE_read
			jc	AWE_getver_fail
			mov	bh,al
			call	AWE_read
			jc	AWE_getver_fail
			mov	bl,al
			and	ebx,0ffffh
			mov	AWE_ver,ebx
			mov	eax,ebx
			clc
			ret
AWE_getver_fail:	stc
			ret
AWE_getver		ENDP

;Ĵ AWE write 

AWE_write		PROC	USES edx ecx eax
			mov	edx,AWE_port1
			add	edx,0ch
			mov	ecx,0ffffh
AWE_write_l1:		in	al,dx
			test	al,al
			jns	AWE_write_ok
			dec	ecx
			jns	AWE_write_l1
			stc
			ret
AWE_write_ok:		mov	eax,[esp]
			out	dx,al
			clc
			ret
AWE_write		ENDP

;Ĵ AWE read 

AWE_read		PROC	USES ecx edx
			mov	edx,AWE_port1
			add	edx,0eh
			mov	ecx,0ffffh
AWE_read_l1:		in	al,dx
			test	al,al
			js	AWE_read_ok
			dec	ecx
			jns	AWE_read_l1
			stc
			ret
AWE_read_ok:		sub	edx,4h
			in	al,dx
			clc
			ret
AWE_read		ENDP

;Ĵ AWE Sync Screen 

AWE_scrsync		PROC

			ret
AWE_scrsync		ENDP

;Ĵ AWE data 

.data

awevoc_struct           STRUC,NONUNIQUE
awevoc_start            dd      ?
awevoc_end              dd      ?
awevoc_lstart           dd      ?
awevoc_lend             dd      ?
awevoc_vol              dd      ?
awevoc_gusvol           dd      ?
awevoc_freq             dd      ?
awevoc_period           dd      ?
awevoc_pan              db      ?
awevoc_mode             db      ?
awevoc_sample           dd      ?
awevoc_samstart         dd      ?
awevoc_samend           dd      ?
awevoc_status           db      ?
awevoc_freqshift        db      ?
awevoc_struct		ENDS

awesam_struct		STRUC
awesam_memstart         dd      ?
awesam_memend           dd      ?
awesam_gusstart         dd      ?
awesam_gusend           dd      ?
awesam_freqshift        db      ?
awesam_struct		ENDS

AWE_voice		dd	AWE_voices

AWE_mastervol		dd	256

AWE_envstr		db	'BLASTER='
AWE_envstrl		=	$-AWE_envstr

AWE_name		db	'Soundblaster AWE32 (Hardware Mixing)',eol

AWE_version		db	'SoundBlaster AWE32 Driver v0.10',eol
AWE_note		db	'Warning!, Driver not yet ready!',eol

AWE_port1desc		db	'SB Port',eol
AWE_port1lst		dd	220h,240h,260h,280h,-1
AWE_port2desc		db	'AWE Port',eol
AWE_port2lst		dd	620h,640h,660h,680h,-1
AWE_irqdesc		db	'IRQ',eol
AWE_irqlst		dd	5,7,11,12,14,15,-1

AWE_cmdlist		db	'AWE',0                 ;drv_id
                        dd      AWE_name                ;drv_text
			dd	AWE_version		;drv_version
			dd	AWE_note		;drv_note
AWE_card		dd	0			;drv_card
			dd	0			;drv_cards
			dd	-1			;drv_cardlst
			dd	00000111b		;drv_config
AWE_port1		dd	220h			;drv_port1
			dd	AWE_port1lst		;drv_port1lst
			dd	AWE_port1desc		;drv_port1desc
AWE_port2		dd	620h			;drv_port2
			dd	AWE_port2lst		;drv_port2lst
			dd	AWE_port2desc		;drv_port2desc
AWE_irq 		dd	5			;drv_irq1
			dd	AWE_irqlst		;drv_irq1lst
			dd	AWE_irqdesc		;drv_irq1desc
			dd	-1			;drv_irq2
			dd	-1			;drv_irq2lst
			dd	-1			;drv_irq2desc
			dd	-1			;drv_dma1
			dd	-1			;drv_dma1lst
			dd	-1			;drv_dma1desc
			dd	-1			;drv_dma2
			dd	-1			;drv_dma2lst
			dd	-1			;drv_dma2desc
			dd	AWE_detect		;drv_detect
			dd	AWE_init		;drv_init
			dd	AWE_exit		;drv_exit
			dd	AWE_activate		;drv_activate
			dd	AWE_deactivate		;drv_deactivate
			dd	AWE_setbpm		;drv_setbpm
			dd	AWE_scrsync		;drv_scrsync
			dd	AWE_setsample		;drv_setsample
			dd	AWE_clrsamples		;drv_clrsamples
			dd	AWE_initsamples 	;drv_initsamples
			dd	AWE_setactivesample	;drv_setactivesample
			dd	AWE_setchns		;drv_setchns
			dd	AWE_setmastervol	;drv_setmastervol
			dd	AWE_setactivechn	;drv_setactivechn
			dd	AWE_setmode		;drv_setmode
			dd	AWE_setstart		;drv_setstart
			dd	AWE_setend		;drv_setend
			dd	AWE_setlstart		;drv_setlstart
			dd	AWE_setlend		;drv_setlend
			dd	AWE_setfreq		;drv_setfreq
			dd	AWE_setvol		;drv_setvol
			dd	AWE_setpan		;drv_setpan
			dd	AWE_startchn		;drv_startchn
			dd	AWE_stopchn		;drv_stopchn

AWE_mem 		dd	0
AWE_lastmem		dd	0
AWE_ver 		dd	0

AWE_chn 		db	0
AWE_chns		db	14
AWE_realchns		db	14

AWE_irqlist		db	08h,09h,0ah,0bh,0ch,0dh,0eh,0fh,70h,71h,72h,73h,74h,75h,76h,77h
		align		4
AWE_oldirq		df	0

;Ĵ AWE Buffers 

.data?
AWE_voices		db	32*size awevoc_struct dup(?)
AWE_samples		db	4096*size awesam_struct dup(?)

			END
