.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.ext

mixsyncspeed		=	25	;In %
screensafe		=	95	;In %

@TMR_waitvbl		MACRO
			LOCAL	w8_1,w8_2
                        mov     edx,3dah
w8_1:			in	al,dx
			test	al,8h
                        jnz     w8_1
w8_2:			in	al,dx
			test	al,8h
                        jz      w8_2
			ENDM



;Ĵ Timer init 

TMR_init                PROC    PUBLIC USES eax ebx ecx edx

			mov	TMR_mix_active,0
                        mov     TMR_scr_active,0
                        mov     TMR_scr_mix,0
                        mov     TMR_sys_count,0
                        mov     TMR_IRQ_jmp,ofs TMR_IRQ_sys

			push	ds
			pop	eax
			mov	TMR_dataseg,ax

			cli
			mov	ebx,8
			call	[SYS_getvect]
                        mov     dwptr TMR_oldtimer,edx
                        mov     wptr TMR_oldtimer+4,cx

			mov	ebx,8
			lea	edx,TMR_IRQ
			mov	cx,cs
			call	[SYS_setvect]
			sti

			clr	ebx
			call	TMR_timerspeed
			ret
TMR_init		ENDP

;Ĵ Timer init 

TMR_exit                PROC    PUBLIC USES eax ebx ecx edx
			cli
			mov	al,36h
			out	43h,al
			clr	al
			out	40h,al
			out	40h,al

			mov	ebx,8
			mov	edx,dwptr TMR_oldtimer
			mov	cx,wptr TMR_oldtimer+4
			call	[SYS_setvect]

			clr	ebx
			call	TMR_timerspeed
			sti

			mov	al,36h
			out	43h,al
			clr	al
			out	40h,al
			out	40h,al
			ret
TMR_exit		ENDP

;Ĵ Timer activate mixing 

TMR_activatemix         PROC    PUBLIC USES eax ebx edx
                        cli
                        mov     TMR_mix_jmp,eax
                        cmp     TMR_scr_active,0
                        je      TMR_activatemix_noss
                        mov     eax,25
                        mul     TMR_scr_tmrcount
                        mov     ebx,100
                        div     ebx
                        mov     ebx,eax
                        mov     TMR_scr_mix,1
                        jmp     TMR_activatemix_1
TMR_activatemix_noss:   mov     ebx,1193180/100
                        mov     TMR_scr_mix,0
TMR_activatemix_1:      mov     TMR_mix_tmrcount,ebx
                        mov     TMR_mix_count,ebx
                        mov     TMR_mix_active,1
                        cmp     TMR_IRQ_jmp,ofs TMR_IRQ_sys
                        jne     TMR_activatemix_noset
                        mov     TMR_IRQ_jmp,ofs TMR_IRQ_mix
                        call    TMR_timerspeed
                        mov     TMR_sys_count,0
TMR_activatemix_noset:  sti
                        ret
TMR_activatemix 	ENDP

;Ĵ Timer deactivate mixing 

TMR_deactivatemix       PROC    PUBLIC USES ebx
                        cli
                        mov     TMR_mix_active,0
                        cmp     TMR_scr_active,1
                        je      TMR_deactivatemix_noset
                        mov     TMR_IRQ_jmp,ofs TMR_IRQ_sys
                        clr     ebx
                        call    TMR_timerspeed
TMR_deactivatemix_noset:sti
                        ret
TMR_deactivatemix	ENDP

;Ĵ Timer deactivate mixing 

TMR_setmixspeed		PROC    PUBLIC USES edx ebx eax
                        cli
			mov	ebx,eax
			clr	edx
			mov	eax,119318000
			div	ebx
			mov	ebx,eax
			mov     TMR_mix_tmrcount,ebx
                        mov     TMR_mix_count,ebx
			sti
                        ret
TMR_setmixspeed		ENDP

;Ĵ Timer activate vblank 

TMR_activatesync        PROC    PUBLIC USES eax ebx ecx edx
                        cli
                        mov     TMR_scr_jmp,eax
                        mov     TMR_scr_active,1
                        call    TMR_getsyncrate
                        mov     ecx,eax
                        mov     eax,screensafe*10
                        mul     ecx
                        mov     ebx,1000
                        div     ebx
                        shr     eax,1
                        mov     TMR_scr_count,eax
                        mov     TMR_scr_tmrcount,eax
                        mov     ebx,eax
                        shr     ecx,1
                        sub     ecx,eax
                        mov     TMR_scr_restcount,ecx
                        mov     TMR_IRQ_jmp,ofs TMR_IRQ_scr
                @TMR_waitvbl
                        call    TMR_timerspeed
                        sti
                        cmp     TMR_mix_active,1
                        jne     TMR_activatesync_nomix

;			mov     eax,mixsyncspeed
;			mul     TMR_scr_tmrcount
;			mov     ebx,100
;			div     ebx
			mov     TMR_scr_mix,1
;			mov     TMR_mix_tmrcount,eax
;			mov     TMR_mix_count,eax
TMR_activatesync_nomix: ret
TMR_activatesync	ENDP

;Ĵ Timer deactivate vblank 

TMR_deactivatesync      PROC    PUBLIC USES ebx eax
                        cli
                        clr     ebx
                        lea	eax,TMR_IRQ_sys
                        cmp     TMR_scr_mix,1
                        jne     TMR_deactivatesync_nomix
                        lea	eax,TMR_IRQ_mix
;                        mov     ebx,1193180/100
;                        mov     TMR_mix_tmrcount,ebx
;                        mov     TMR_mix_count,ebx
                        mov     TMR_scr_mix,0
TMR_deactivatesync_nomix:
			mov	TMR_IRQ_jmp,eax
                        mov     TMR_scr_active,0
                        call    TMR_timerspeed
                        sti
                        ret
TMR_deactivatesync	ENDP

;Ĵ Timer Sync 

TMR_sync                PROC    USES eax ebx ecx
                        cmp     TMR_scr_active,1
                        jne     TMR_sync_done
                        cli
                        call    TMR_getsyncrate
                        mov     ecx,eax
                        mov     eax,950
                        mul     ecx
                        mov     ebx,1000
                        div     ebx
                        shr     eax,1
                        mov     TMR_scr_count,eax
                        mov     TMR_scr_tmrcount,eax
                        mov     ebx,eax
                        shr     ecx,1
                        sub     ecx,eax
                        mov     TMR_scr_restcount,ecx
                        mov     TMR_IRQ_jmp,ofs TMR_IRQ_scr
                @TMR_waitvbl
                        call    TMR_timerspeed
                        sti
TMR_sync_done:          ret
TMR_sync                ENDP

;Ĵ Timer get screen sync rate 

TMR_getsyncrate         PROC    PUBLIC USES ebx ecx edx
			cli
TMR_getsyncrate_l:
		@TMR_waitvbl
			mov	al,36h
			out	43h,al
			clr	al
			out	40h,al
			out	40h,al
		@TMR_waitvbl
			clr	eax
			out	43h,al
			in	al,40h
			mov	ah,al
			in	al,40h
			xchg	al,ah
                        neg     ax
			mov	ecx,eax
		@TMR_waitvbl
			mov	al,36h
			out	43h,al
			clr	al
			out	40h,al
			out	40h,al
		@TMR_waitvbl
			clr	eax
			out	43h,al
			in	al,40h
			mov	ah,al
			in	al,40h
			xchg	al,ah
                        neg     ax
			mov	edx,eax
			sub	edx,ecx
			cmp	edx,2
			jg	TMR_getsyncrate_l
			cmp	edx,-2
			jl	TMR_getsyncrate_l
			sti
			ret
TMR_getsyncrate 	ENDP

;Ĵ Timer set timer speed 

TMR_timerspeed		PROC	USES ax bx
			mov	al,30h
			out	43h,al
			mov	al,bl
			out	40h,al
			mov	al,bh
			out	40h,al
			ret
TMR_timerspeed		ENDP

;Ĵ Timer Fix timer 

TMR_fixtimer            PROC    USES ebx
                        cmp     TMR_scr_active,1
                        je      TMR_fixtimer_scr
                        cmp     TMR_mix_active,1
                        je      TMR_fixtimer_mix

TMR_fixtimer_sys:       mov     TMR_IRQ_jmp,ofs TMR_IRQ_sys
                        clr     ebx
                        call    TMR_timerspeed
                        jmp     TMR_fixtimer_done

TMR_fixtimer_scr:       cmp     TMR_mix_active,1
                        je      TMR_fixtimer_both
TMR_fixtimer_scrdo:     mov     ebx,TMR_scr_count
                        or      ebx,ebx
                        jns     TMR_fixtimer_nos1
                        mov     ebx,10
                        mov     TMR_scr_count,ebx
TMR_fixtimer_nos1:      mov     TMR_IRQ_jmp,ofs TMR_IRQ_scr
                        call    TMR_timerspeed
                        jmp     TMR_fixtimer_done

TMR_fixtimer_mix:       cmp     TMR_scr_active,1
                        je      TMR_fixtimer_both
                        mov     ebx,TMR_mix_count
                        or      ebx,ebx
                        jns     TMR_fixtimer_nos2
                        mov     ebx,10
                        mov     TMR_mix_count,ebx
TMR_fixtimer_nos2:      mov     TMR_IRQ_jmp,ofs TMR_IRQ_mix
                        call    TMR_timerspeed
                        jmp     TMR_fixtimer_done

TMR_fixtimer_both:      mov     ebx,TMR_mix_count
                        or      ebx,ebx
                        jns     TMR_fixtimer_nos3
                        mov     ebx,10
                        mov     TMR_mix_count,ebx
                        jmp     TMR_fixtimer_nos2
TMR_fixtimer_nos3:      cmp     ebx,TMR_scr_count
                        jl      TMR_fixtimer_nos2
                        jmp     TMR_fixtimer_scrdo
TMR_fixtimer_done:      ret
TMR_fixtimer            ENDP

;Ĵ Timer IRQ 

TMR_IRQ:		pushad
			push	ds
			push	es

			mov	ax,cs:TMR_dataseg
			mov	ds,ax
			mov	es,ax

                        jmp     [TMR_IRQ_jmp]

TMR_IRQ_scr:            cli
;		@setcol	0,0,0,63
                        cmp     TMR_IRQ_scr_stat,1
                        jne     TMR_IRQ_scr_ok
                        mov     eax,TMR_scr_count
                        add     eax,TMR_scr_restcount
                        sub     TMR_mix_count,eax
                        add     TMR_sys_count,eax
                        mov     eax,TMR_scr_tmrcount
                        mov     TMR_scr_count,eax
                        call    TMR_fixtimer
                        mov     al,020h
			out	020h,al
                        sti
                        jmp     TMR_IRQ_done
TMR_IRQ_scr_ok:         cmp     TMR_scr_active,1
                        jne     TMR_IRQ_checktimer
                        mov     TMR_IRQ_scr_stat,1
                        mov     edx,03dah
TMR_IRQ_scr_w8_1:       in      al,dx
                        test    al,08h
                        jnz     TMR_IRQ_scr_w8_1
                        mov     eax,TMR_scr_count
                        add     eax,TMR_scr_restcount
                        add     TMR_sys_count,eax
                        cmp     TMR_scr_mix,1
                        jne	TMR_IRQ_scr_nomix
                        sub     TMR_mix_count,eax
TMR_IRQ_scr_nomix:      mov     eax,TMR_scr_tmrcount
                        mov     TMR_scr_count,eax
                        mov     edx,03dah
TMR_IRQ_scr_w8_2:       in      al,dx
                        test    al,08h
                        jz      TMR_IRQ_scr_w8_2
                        call    TMR_fixtimer
                        mov     TMR_IRQ_scr_stat,0
                        sti
                        mov     al,020h
			out	020h,al
                        call    [TMR_scr_jmp]
                        jmp     TMR_IRQ_checktimer
TMR_IRQ_scr_stat        db      0

TMR_IRQ_mix:            cli
;		@setcol	0,0,63,0
                        cmp     TMR_IRQ_mix_stat,1
                        jne     TMR_IRQ_mix_ok
                        mov     eax,TMR_mix_count
                        sub     TMR_scr_count,eax
                        add     TMR_sys_count,eax
                        mov     eax,TMR_mix_tmrcount
                        mov     TMR_mix_count,eax
                        call    TMR_fixtimer
                        sti
                        mov     al,020h
			out	020h,al
                        jmp     TMR_IRQ_done
TMR_IRQ_mix_ok:         mov     TMR_IRQ_mix_stat,1
                        mov     eax,TMR_mix_count
                        or      eax,eax
                        js      TMR_IRQ_mix_pn1
                        sub     TMR_scr_count,eax
                        add     TMR_sys_count,eax
TMR_IRQ_mix_pn1:	mov     ebx,TMR_mix_tmrcount
                        mov     TMR_mix_count,ebx
TMR_IRQ_mix_pnt:        call    TMR_fixtimer
			sti
                        mov     al,020h
			out	020h,al
                        cmp     TMR_mix_active,1
                        je      TMR_IRQ_mix_play
                        mov     TMR_IRQ_mix_stat,0
                        jmp     TMR_IRQ_checktimer
TMR_IRQ_mix_play:       call    TMR_mix_jmp
                        mov     TMR_IRQ_mix_stat,0
                        jmp     TMR_IRQ_checktimer
TMR_IRQ_mix_stat        db      0

TMR_IRQ_checktimer:     cmp     TMR_sys_count,10000h
                        jl      TMR_IRQ_done
                        sub     TMR_sys_count,10000h
                        pushfd
                        call    [TMR_oldtimer]
			jmp	TMR_IRQ_checktimer

TMR_IRQ_sys:
;		@setcol	0,63,0,0
			clr     ebx
			call	TMR_timerspeed
                        pushfd
                        call    [TMR_oldtimer]
TMR_IRQ_done:
;		@setcol	0,0,0,0
			pop	es
			pop	ds
			popad
                        nop
                        iretd

TMR_IRQ_eoi             db      0
TMR_IRQ_jmp		dd	0
TMR_IRQ_stat            db      0

;Ĵ Timer data 

.data

TMR_dataseg		dw	0

TMR_sys_count		dd	0
TMR_mix_active          dd      0
TMR_mix_count		dd	0
TMR_mix_tmrcount	dd	0
TMR_mix_jmp		dd	0
TMR_scr_active          dd      0
TMR_scr_count           dd      0
TMR_scr_tmrcount        dd      0
TMR_scr_restcount       dd      0
TMR_scr_mix             dd      0
TMR_scr_jmp             dd      0
		align	4
TMR_oldtimer		df	0

			END


