.386p
.model flat,syscall
.code

                include p:\devices\mix.str
                include p:\devices\mix.mix

                public  MIX_m16sf
                public  MIX_m16sb

;Ŀ
; Code 
;

MIX_m16sf               PROC
			or	eax,eax
			jle     MIX_m16sf_skip
			push	ebp
			cli

                        mov     ecx,eax
                        shr     ecx,5
                        mov     MIX_m16s_count,ecx
                        shl     ecx,5
                        sub     eax,ecx
                        mov     MIX_m16s_restcount,eax
                        mov     edx,ebx

                        mov     MIX_m16s_stackseg,ss
			mov	MIX_m16s_stackptr,esp
			mov	ax,ds
			mov	ss,ax

			mov     esi,mixvoc.pan[ebp]
                        mov     eax,mixvoc.vol[ebp]
                        imul    eax,MIX_pantab[esi*8]
                        imul    eax,MIX_mastervol
                        shr     eax,16
                        shl     eax,8
                        mov     ebx,mixvoc.vol[ebp]
                        imul    ebx,MIX_pantab+4[esi*8]
                        imul    ebx,MIX_mastervol
                        shr     ebx,16
                        shl     ebx,8

                        mov     edi,mixvoc.inch[ebp]
                        mov     esp,mixvoc.incl[ebp]
                        mov     esi,mixvoc.samstart[ebp]
			test	esi,1
			jnz	MIX_m16sf_odd

;ESI.EBP     - Source (32.32)
;EDI.ESP     - Increase (32.32)
;AH          - Right Volume
;BH          - Left Volume
;EDX         - Destination

MIX_m16sf_even:		shr	esi,1
                	add     esi,mixvoc.posh[ebp]
                        mov     ebp,mixvoc.posl[ebp]
                        cmp     MIX_m16s_count,0
                        je      MIX_m16sf_even_rest
MIX_m16sf_even_l1:
                buffofs=0
                REPT    32
                        add     ebp,esp                 ;Add fractional part to source
			mov     al,1[esi+esi]		;Get byte from source
			adc     esi,edi                 ;If fractional part was overflown add increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
                        add     buffofs[edx],ecx        ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
                        add     buffofs+4[edx],ecx      ;Add left value to buffer
                buffofs =buffofs+8
                ENDM
                        add     edx,32*8
                        dec     MIX_m16s_count
                        jnz     MIX_m16sf_even_l1
MIX_m16sf_even_rest:	cmp     MIX_m16s_restcount,0
                        je      MIX_m16sf_done
MIX_m16sf_even_l2:	add     ebp,esp                 ;Add fractional part to source
			mov     al,1[esi+esi]		;Get byte from source
			adc     esi,edi                 ;If fractional part was overflown add increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
			add     [edx],ecx               ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
			add     4[edx],ecx              ;Add left value to buffer
			add     edx,8
                        dec     MIX_m16s_restcount
                        jnz     MIX_m16sf_even_l2
                        jmp     MIX_m16sf_done

MIX_m16sf_odd:		shr	esi,1
                	add     esi,mixvoc.posh[ebp]
                        mov     ebp,mixvoc.posl[ebp]
                        cmp     MIX_m16s_count,0
                        je      MIX_m16sf_odd_rest
MIX_m16sf_odd_l1:
                buffofs=0
                REPT    32
                        add     ebp,esp                 ;Add fractional part to source
			mov     al,[esi+esi]		;Get byte from source
			adc     esi,edi                 ;If fractional part was overflown add increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
                        add     buffofs[edx],ecx        ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
                        add     buffofs+4[edx],ecx      ;Add left value to buffer
                buffofs =buffofs+8
                ENDM
                        add     edx,32*8
                        dec     MIX_m16s_count
                        jnz     MIX_m16sf_odd_l1
MIX_m16sf_odd_rest:	cmp     MIX_m16s_restcount,0
                        je      MIX_m16sf_done
MIX_m16sf_odd_l2:	add     ebp,esp                 ;Add fractional part to source
			mov     al,[esi+esi]		;Get byte from source
			adc     esi,edi                 ;If fractional part was overflown add increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
			add     [edx],ecx               ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
			add     4[edx],ecx              ;Add left value to buffer
			add     edx,8
                        dec     MIX_m16s_restcount
                        jnz     MIX_m16sf_odd_l2

MIX_m16sf_done:		mov     edi,ebp
			mov	esp,MIX_m16s_stackptr
			mov	ss,MIX_m16s_stackseg
			sti
			pop	ebp

			mov	ebx,edx
			mov	eax,mixvoc.samstart+ds:[ebp]
			shr	eax,1
			sub	esi,eax
                        mov     mixvoc.posh+ds:[ebp],esi
                        mov     mixvoc.posl+ds:[ebp],edi
MIX_m16sf_skip:		ret
MIX_m16sf               ENDP

MIX_m16sb		PROC
			or	eax,eax
			jle     MIX_m16sb_skip
			push	ebp
			cli

                        mov     ecx,eax
                        shr     ecx,5
                        mov     MIX_m16s_count,ecx
                        shl     ecx,5
                        sub     eax,ecx
                        mov     MIX_m16s_restcount,eax
                        mov     edx,ebx

			mov	MIX_m16s_stackseg,ss
			mov	MIX_m16s_stackptr,esp
			mov	ax,ds
			mov	ss,ax

			mov     esi,mixvoc.pan[ebp]
                        mov     eax,mixvoc.vol[ebp]
                        imul    eax,MIX_pantab[esi*8]
                        imul    eax,MIX_mastervol
                        shr     eax,16
                        shl     eax,8
                        mov     ebx,mixvoc.vol[ebp]
                        imul    ebx,MIX_pantab+4[esi*8]
                        imul    ebx,MIX_mastervol
                        shr     ebx,16
                        shl     ebx,8

			mov     edi,mixvoc.inch[ebp]
                        mov     esp,mixvoc.incl[ebp]
                        mov     esi,mixvoc.samstart[ebp]
			test	esi,1
			jnz	MIX_m16sb_odd

;ESI.EBP     - Source (32.32)
;EDI.ESP     - Increase (32.32)
;AH          - Right Volume
;BH          - Left Volume
;EDX         - Destination

MIX_m16sb_even:		shr	esi,1
                	add     esi,mixvoc.posh[ebp]
                        mov     ebp,mixvoc.posl[ebp]
                        cmp     MIX_m16s_count,0
                        je      MIX_m16sb_even_rest
MIX_m16sb_even_l1:
                buffofs=0
                REPT    32
                        sub     ebp,esp                 ;Sub fractional part to source
			mov     al,1[esi+esi]		;Get byte from source
                        sbb     esi,edi                 ;If fractional part was overflown sub increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
                        add     buffofs[edx],ecx        ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
                        add     buffofs+4[edx],ecx      ;Add left value to buffer
                buffofs =buffofs+8
                ENDM
                        add     edx,32*8
                        dec     MIX_m16s_count
                        jnz     MIX_m16sb_even_l1
MIX_m16sb_even_rest:	cmp     MIX_m16s_restcount,0
                        je      MIX_m16sb_done
MIX_m16sb_even_l2:	sub     ebp,esp                 ;Sub fractional part to source
			mov     al,1[esi+esi]		;Get byte from source
                        sbb     esi,edi                 ;If fractional part was overflown sub increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
			add     [edx],ecx               ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
			add     4[edx],ecx              ;Add left value to buffer
			add     edx,8
                        dec     MIX_m16s_restcount
                        jnz     MIX_m16sb_even_l2
                        jmp     MIX_m16sb_done

MIX_m16sb_odd:		shr	esi,1
                	add     esi,mixvoc.posh[ebp]
                        mov     ebp,mixvoc.posl[ebp]
                        cmp     MIX_m16s_count,0
                        je      MIX_m16sb_odd_rest
MIX_m16sb_odd_l1:
                buffofs=0
                REPT    32
                        sub     ebp,esp                 ;Sub fractional part to source
			mov     al,[esi+esi]		;Get byte from source
                        sbb     esi,edi                 ;If fractional part was overflown sub increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
                        add     buffofs[edx],ecx        ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
                        add     buffofs+4[edx],ecx      ;Add left value to buffer
                buffofs =buffofs+8
                ENDM
                        add     edx,32*8
                        dec     MIX_m16s_count
                        jnz     MIX_m16sb_odd_l1
MIX_m16sb_odd_rest:	cmp     MIX_m16s_restcount,0
                        je      MIX_m16sb_done
MIX_m16sb_odd_l2:	sub     ebp,esp                 ;Sub fractional part to source
			mov     al,[esi+esi]		;Get byte from source
                        sbb     esi,edi                 ;If fractional part was overflown sub increase value
			mov     ecx,MIX_voltab[eax*4]   ;Get Volume for right channel , voltab(offset-16).ah(volume-8).al(value-8)
			add     [edx],ecx               ;Add right value to buffer
			mov     bl,al                   ;mov value to left volume offset
			mov     ecx,MIX_voltab[ebx*4]   ;Get Volume for left channel , voltab(offset-16).ah(volume-8).bl(value-8)
			add     4[edx],ecx              ;Add left value to buffer
			add     edx,8
                        dec     MIX_m16s_restcount
                        jnz     MIX_m16sb_odd_l2

MIX_m16sb_done:         mov	edi,ebp
			mov	esp,MIX_m16s_stackptr
			mov	ss,MIX_m16s_stackseg
			pop	ebp

			mov	ebx,edx
			mov	eax,mixvoc.samstart+ds:[ebp]
			shr	eax,1
			sub	esi,eax
                        mov     mixvoc.posh+ds:[ebp],esi
                        mov     mixvoc.posl+ds:[ebp],edi
MIX_m16sb_skip:  	ret
MIX_m16sb		ENDP

;Ŀ
; Data 
;

.data

MIX_m16s_count		dd	0
MIX_m16s_restcount	dd      0
MIX_m16s_stackptr	dd      0
MIX_m16s_stackseg	dw	0

;Ŀ
;
;
                END

