.386p
.model flat,syscall
.code

		include p:\nms.mac

		include p:\devices\mix.str
		include p:\devices\mix.dev

; MIX_amp is like a global volume , but with the power of amplification.
; MIX_baseamp is another amplification , this value in % is for 1 channel
; MIX_ampadd is used with XMI_baseamp , the value in % is added for every
;  channel after 1. (2=baseamp+amp 3=baseamp+amp*2 .. 32=baseamp+amp*32)

MIX_amp                 =       100
MIX_baseamp             =       100
MIX_ampadd              =       0
MIX_maxvoices		=	64

;Ĵ MIX 

MIX                     PROC    PUBLIC USES edx esi ebp
			mov	MIX_outputbuff,edi
			mov	MIX_outputofs,eax
			mov	MIX_outputsize,ebx
			mov	MIX_mixsize,ecx
;                        cmp     ebx,32
;                        jl      MIX_skipall
			cmp	ebx,8192
			jg	MIX_skipall
;                        cmp     ecx,32
;                        jl      MIX_skipall
			cmp	ecx,8192
			jg	MIX_skipall


                        test    MIX_config,mixctrl_16bit
                        jz      MIX_8bit
                        shr     ecx,1
MIX_8bit:               lea     edi,MIX_prebuff
			mov	eax,MIX_clrbuff
 		rep	stosd

			cmp	MIX_chns,0
			je	MIX_skipmix
			mov	MIX_chn,0

MIX_mainl:		mov	eax,MIX_chn
			imul	esi,eax,size mixvoc
			lea	esi,MIX_voices[esi]
			lea	edi,MIX_prebuff
			mov	edx,MIX_mixsize
                        mov     ecx,MIX_shiftpercount
			shr	edx,cl
			mov	ecx,edx

			call	MIX_mixchn

			inc	MIX_chn
			mov	eax,MIX_chns
			cmp	MIX_chn,eax
			jb 	MIX_mainl
MIX_skipmix:
			call	[MIX_tobuff]

MIX_skipall:    	mov	edi,MIX_outputbuff
			mov	eax,MIX_outputofs
			mov	ebx,MIX_outputsize
			mov	ecx,MIX_mixsize
        		ret
MIX_chn			dd	0
MIX			ENDP

;Ĵ MIX channel 

MIX_mixchn              PROC    PUBLIC USES eax ebx ecx edx esi edi ebp
			mov	ebp,esi
                        mov     mixvoc.buffsize+ds:[ebp],ecx
			mov	mixvoc.buffpos+ds:[ebp],edi

			test	mixvoc.state+ds:[ebp],mixstate_playing
			jz	MIX_skipchn

                        test    mixvoc.mode+ds:[ebp],cnt_loop
			jnz     MIX_l

       ;--------------------------------------------------------
MIX_nl:;-------------------------------------------------------- No Loop
       ;--------------------------------------------------------

                	mov	eax,mixvoc.inch+ds:[ebp]
			mul	mixvoc.buffsize+ds:[ebp]
			mov	esi,eax
			mov	eax,mixvoc.incl+ds:[ebp]
			mul	mixvoc.buffsize+ds:[ebp]
			add	esi,edx
			mov	edi,eax
			mov	eax,mixvoc.posh+ds:[ebp]

			test	mixvoc.state+ds:[ebp],mixstate_backward
			jnz     MIX_nlb
MIX_nlf:;------------------------------------------------------- No Loop Forward
			cmp	eax,mixvoc.send+ds:[ebp]
			jle	MIX_nlf_ok
			and	mixvoc.state+ds:[ebp],NOT mixstate_playing
			jmp	MIX_skipchn
MIX_nlf_ok:		add	edi,mixvoc.posl+ds:[ebp]
			adc	esi,0
			add	esi,eax
			cmp	esi,mixvoc.send+ds:[ebp]
			jl 	MIX_nlf_mix
MIX_nlf_last:;-------------------------------------------------- No Loop Forward Last
			and	mixvoc.state+ds:[ebp],NOT mixstate_playing
                        mov     edx,mixvoc.send+ds:[ebp]
                        sub     edx,mixvoc.posh+ds:[ebp]
                        clr     eax
                        sub     eax,mixvoc.posl+ds:[ebp]
                        shrd    eax,edx,5
                        shr     edx,5
                        mov     ecx,mixvoc.inch+ds:[ebp]
                        mov     ebx,mixvoc.incl+ds:[ebp]
                        shrd    ebx,ecx,5
                        div    	ebx
			jz	MIX_skipchn
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.fjmp+ds:[ebp]
			jmp	MIX_skipchn
MIX_nlf_mix:;--------------------------------------------------- No Loop Forward Mix
			mov	eax,mixvoc.buffsize+ds:[ebp]
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.fjmp+ds:[ebp]
			jmp	MIX_skipchn
MIX_nlb:;------------------------------------------------------- No Loop Backward
			cmp	eax,mixvoc.sstart+ds:[ebp]
			jge	MIX_nlb_ok
			and	mixvoc.state+ds:[ebp],NOT mixstate_playing
			jmp	MIX_skipchn
MIX_nlb_ok:		mov	ebx,mixvoc.posl+ds:[ebp]
			sub	ebx,edi
			sbb     eax,0
			sub	eax,esi
			cmp	eax,mixvoc.sstart+ds:[ebp]
			jg 	MIX_nlb_mix
MIX_nlb_last:;-------------------------------------------------- No Loop Backward Last
			and	mixvoc.state+ds:[ebp],NOT mixstate_playing
                        mov     edx,mixvoc.posh+ds:[ebp]
                        sub     edx,mixvoc.sstart+ds:[ebp]
                        mov     eax,mixvoc.posl+ds:[ebp]
                        shrd    eax,edx,5
                        shr     edx,5
                        mov     ecx,mixvoc.inch+ds:[ebp]
                        mov     ebx,mixvoc.incl+ds:[ebp]
                        shrd    ebx,ecx,5
                        div    	ebx
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.bjmp+ds:[ebp]
			jmp	MIX_skipchn
MIX_nlb_mix:;--------------------------------------------------- No Loop Bacward Mix
			mov	eax,mixvoc.buffsize+ds:[ebp]
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.bjmp+ds:[ebp]
			jmp	MIX_skipchn
      ;---------------------------------------------------------
MIX_l:;--------------------------------------------------------- Loop
      ;---------------------------------------------------------
			test	mixvoc.state+ds:[ebp],mixstate_inloop
			jnz     MIX_il

                	mov	eax,mixvoc.inch+ds:[ebp]
			mul	mixvoc.buffsize+ds:[ebp]
			mov	esi,eax
			mov	eax,mixvoc.incl+ds:[ebp]
			mul	mixvoc.buffsize+ds:[ebp]
			add	esi,edx
			mov	edi,eax
			mov	eax,mixvoc.posh+ds:[ebp]

			test	mixvoc.state+ds:[ebp],mixstate_backward
			jnz     MIX_lb
MIX_lf:;-------------------------------------------------------- Loop Forward
			cmp	eax,mixvoc.send+ds:[ebp]
			jle	MIX_lf_ok
			sub	eax,mixvoc.send+ds:[ebp]
			mov	mixvoc.posh+ds:[ebp],eax
			jmp	MIX_lf
MIX_lf_ok:		add	edi,mixvoc.posl+ds:[ebp]
			adc	esi,0
			add	esi,eax
			cmp	esi,mixvoc.send+ds:[ebp]
			jl 	MIX_lf_mix
MIX_lf_last:;--------------------------------------------------- Loop Forward Last
			or 	mixvoc.state+ds:[ebp],mixstate_inloop
                        mov     edx,mixvoc.send+ds:[ebp]
                        sub     edx,mixvoc.posh+ds:[ebp]
                        clr     eax
                        sub     eax,mixvoc.posl+ds:[ebp]
                        shrd    eax,edx,5
                        shr     edx,5
                        mov     ecx,mixvoc.inch+ds:[ebp]
                        mov     ebx,mixvoc.incl+ds:[ebp]
                        shrd    ebx,ecx,5
                        div    	ebx
			jz	MIX_skipchn
			sub	mixvoc.buffsize+ds:[ebp],eax
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.fjmp+ds:[ebp]
			mov	mixvoc.buffpos+ds:[ebp],ebx
			mov	eax,mixvoc.reqsamstart+ds:[ebp]
			mov	mixvoc.samstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlstart+ds:[ebp]
			mov	mixvoc.lstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlend+ds:[ebp]
			mov	mixvoc.lend+ds:[ebp],eax

                        test    mixvoc.mode+ds:[ebp],cnt_biloop
			jnz	MIX_lf_biloop
			mov	eax,mixvoc.send+ds:[ebp]
			sub	mixvoc.posh+ds:[ebp],eax
			mov	eax,mixvoc.lstart+ds:[ebp]
			add	mixvoc.posh+ds:[ebp],eax
	       		jmp	MIX_il
MIX_lf_biloop:		xor 	mixvoc.state+ds:[ebp],mixstate_backward
			mov	eax,mixvoc.send+ds:[ebp]
			sub	mixvoc.posh+ds:[ebp],eax
			mov	eax,mixvoc.lend+ds:[ebp]
			add	mixvoc.posh+ds:[ebp],eax
			neg	mixvoc.posl+ds:[ebp]
			jmp	MIX_il
MIX_lf_mix:;---------------------------------------------------- Loop Forward Mix
			mov	eax,mixvoc.buffsize+ds:[ebp]
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.fjmp+ds:[ebp]
			jmp	MIX_skipchn
MIX_lb:;-------------------------------------------------------- Loop Backward
			cmp	eax,mixvoc.sstart+ds:[ebp]
			jge	MIX_lb_ok
			add	eax,mixvoc.sstart+ds:[ebp]
			mov	mixvoc.posh+ds:[ebp],eax
			jmp	MIX_lb
MIX_lb_ok:		mov	ebx,mixvoc.posl+ds:[ebp]
			sub	ebx,edi
			sbb     eax,0
			sub	eax,esi
			cmp	eax,mixvoc.lstart+ds:[ebp]
			jg 	MIX_ilb_mix
MIX_lb_last:;--------------------------------------------------- Loop Backward Last
			or 	mixvoc.state+ds:[ebp],mixstate_inloop
                        mov     edx,mixvoc.posh+ds:[ebp]
                        sub     edx,mixvoc.sstart+ds:[ebp]
                        mov     eax,mixvoc.posl+ds:[ebp]
                        shrd    eax,edx,5
                        shr     edx,5
                        mov     ecx,mixvoc.inch+ds:[ebp]
                        mov     ebx,mixvoc.incl+ds:[ebp]
                        shrd    ebx,ecx,5
                        div    	ebx
			sub	mixvoc.buffsize+ds:[ebp],eax
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.bjmp+ds:[ebp]
			mov	mixvoc.buffpos+ds:[ebp],ebx
			mov	eax,mixvoc.reqsamstart+ds:[ebp]
			mov	mixvoc.samstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlstart+ds:[ebp]
			mov	mixvoc.lstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlend+ds:[ebp]
			mov	mixvoc.lend+ds:[ebp],eax

                        test    mixvoc.mode+ds:[ebp],cnt_biloop
			jnz	MIX_lb_biloop
			mov	eax,mixvoc.sstart+ds:[ebp]
			sub	mixvoc.posh+ds:[ebp],eax
			mov	eax,mixvoc.lend+ds:[ebp]
			add	mixvoc.posh+ds:[ebp],eax
			neg	mixvoc.posl+ds:[ebp]
	       		jmp	MIX_il
MIX_lb_biloop:		xor 	mixvoc.state+ds:[ebp],mixstate_backward
			mov	eax,mixvoc.sstart+ds:[ebp]
			sub	mixvoc.posh+ds:[ebp],eax
			mov	eax,mixvoc.lstart+ds:[ebp]
			add	mixvoc.posh+ds:[ebp],eax
			jmp	MIX_il
MIX_lb_mix:;---------------------------------------------------- Loop Bacward Mix
			mov	eax,mixvoc.buffsize+ds:[ebp]
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.bjmp+ds:[ebp]
			jmp	MIX_skipchn

       ;--------------------------------------------------------
MIX_il:;-------------------------------------------------------- In Loop
       ;--------------------------------------------------------
			cmp	mixvoc.buffsize+ds:[ebp],0
			jle     MIX_skipchn

			mov	eax,mixvoc.inch+ds:[ebp]
			mul	mixvoc.buffsize+ds:[ebp]
			mov	esi,eax
			mov	eax,mixvoc.incl+ds:[ebp]
			mul	mixvoc.buffsize+ds:[ebp]
			add	esi,edx
			mov	edi,eax
			mov	eax,mixvoc.posh+ds:[ebp]

			test	mixvoc.state+ds:[ebp],mixstate_backward
			jnz     MIX_ilb
MIX_ilf:;------------------------------------------------------- In Loop Forward
			cmp	eax,mixvoc.lend+ds:[ebp]
			jle	MIX_ilf_ok
			sub	eax,mixvoc.lend+ds:[ebp]
			mov	mixvoc.posh+ds:[ebp],eax
			jmp	MIX_ilf
MIX_ilf_ok:		add	edi,mixvoc.posl+ds:[ebp]
			adc	esi,0
			add	esi,eax
			cmp	esi,mixvoc.lend+ds:[ebp]
			jl 	MIX_ilf_mix
MIX_ilf_last:;-------------------------------------------------- In Loop Forward Last
                        mov     edx,mixvoc.lend+ds:[ebp]
                        sub     edx,mixvoc.posh+ds:[ebp]
                        clr     eax
                        sub     eax,mixvoc.posl+ds:[ebp]
                        shrd    eax,edx,5
                        shr     edx,5
                        mov     ecx,mixvoc.inch+ds:[ebp]
                        mov     ebx,mixvoc.incl+ds:[ebp]
                        shrd    ebx,ecx,5
                        div    	ebx
			jz	MIX_skipchn
			sub	mixvoc.buffsize+ds:[ebp],eax
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.fjmp+ds:[ebp]
			mov	mixvoc.buffpos+ds:[ebp],ebx
			mov	eax,mixvoc.reqsamstart+ds:[ebp]
			mov	mixvoc.samstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlstart+ds:[ebp]
			mov	mixvoc.lstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlend+ds:[ebp]
			mov	mixvoc.lend+ds:[ebp],eax

                        test    mixvoc.mode+ds:[ebp],cnt_biloop
			jnz	MIX_ilf_biloop
			mov	eax,mixvoc.lend+ds:[ebp]
			sub	mixvoc.posh+ds:[ebp],eax
			mov	eax,mixvoc.lstart+ds:[ebp]
			add	mixvoc.posh+ds:[ebp],eax
	       		jmp	MIX_il
MIX_ilf_biloop:		xor 	mixvoc.state+ds:[ebp],mixstate_backward
			neg	mixvoc.posl+ds:[ebp]
			jmp	MIX_il
MIX_ilf_mix:;--------------------------------------------------- In Loop Forward Mix
			mov	eax,mixvoc.buffsize+ds:[ebp]
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.fjmp+ds:[ebp]
			jmp	MIX_skipchn
MIX_ilb:;------------------------------------------------------- In Loop Backward
			cmp	eax,mixvoc.lstart+ds:[ebp]
			jge	MIX_ilb_ok
			add	eax,mixvoc.lstart+ds:[ebp]
			mov	mixvoc.posh+ds:[ebp],eax
			jmp	MIX_ilb
MIX_ilb_ok:		mov	ebx,mixvoc.posl+ds:[ebp]
			sub	ebx,edi
			sbb     eax,0
			sub	eax,esi
			cmp	eax,mixvoc.lstart+ds:[ebp]
			jg 	MIX_ilb_mix
MIX_ilb_last:;-------------------------------------------------- In Loop Backward Last
                        mov     edx,mixvoc.posh+ds:[ebp]
                        sub     edx,mixvoc.lstart+ds:[ebp]
                        mov     eax,mixvoc.posl+ds:[ebp]
                        shrd    eax,edx,5
                        shr     edx,5
                        mov     ecx,mixvoc.inch+ds:[ebp]
                        mov     ebx,mixvoc.incl+ds:[ebp]
                        shrd    ebx,ecx,5
                        div    	ebx
			sub	mixvoc.buffsize+ds:[ebp],eax
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.bjmp+ds:[ebp]
			mov	mixvoc.buffpos+ds:[ebp],ebx
			mov	eax,mixvoc.reqsamstart+ds:[ebp]
			mov	mixvoc.samstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlstart+ds:[ebp]
			mov	mixvoc.lstart+ds:[ebp],eax
			mov	eax,mixvoc.reqlend+ds:[ebp]
			mov	mixvoc.lend+ds:[ebp],eax

                        test    mixvoc.mode+ds:[ebp],cnt_biloop
			jnz	MIX_ilb_biloop
			mov	eax,mixvoc.lstart+ds:[ebp]
			sub	mixvoc.posh+ds:[ebp],eax
			mov	eax,mixvoc.lend+ds:[ebp]
			add	mixvoc.posh+ds:[ebp],eax
			neg	mixvoc.posl+ds:[ebp]
	       		jmp	MIX_il
MIX_ilb_biloop:		xor 	mixvoc.state+ds:[ebp],mixstate_backward
			jmp	MIX_il
MIX_ilb_mix:;--------------------------------------------------- In Loop Bacward Mix
			mov	eax,mixvoc.buffsize+ds:[ebp]
			mov	ebx,mixvoc.buffpos+ds:[ebp]
			call	mixvoc.bjmp+ds:[ebp]
MIX_skipchn:		ret
MIX_mixchn		ENDP

;Ĵ MIX Init 

MIX_init                PROC    PUBLIC USES eax ebx ecx edi
			mov	MIX_config,eax
			mov	MIX_rate,ebx

			mov	MIX_bytespercount,1
			mov	MIX_shiftpercount,0
			clr	ebx
			mov	MIX_clrbuff,80000000h
			mov	ecx,1
			test	eax,mixctrl_16bit
			jz      MIX_init_8bit
			inc	MIX_shiftpercount
			or	ebx,1
			shl	MIX_bytespercount,1
			mov	MIX_clrbuff,00000000h
MIX_init_8bit:  	test	eax,mixctrl_stereo
			jz      MIX_init_mono
			inc	MIX_shiftpercount
			or	ebx,2
			shl	MIX_bytespercount,1
MIX_init_mono: 		test	eax,mixctrl_outalt
			jz      MIX_init_mixed
			or	ebx,4
MIX_init_mixed:		mov	eax,MIX_lst_tobuff[ebx*4]
			mov	MIX_tobuff,eax
			mov	eax,MIX_lst_mix8f[ebx*4]
			mov	MIX_mix8f,eax
			mov	eax,MIX_lst_mix16f[ebx*4]
			mov	MIX_mix16f,eax
			mov	eax,MIX_lst_mix8b[ebx*4]
			mov	MIX_mix8b,eax
			mov	eax,MIX_lst_mix16b[ebx*4]
			mov	MIX_mix16b,eax

			mov	eax,0
			call	MIX_setchns

			lea	edi,MIX_voices
			mov	ecx,MIX_maxvoices*size mixvoc
			clr	eax
		rep	stosb
                        clc
                        ret
MIX_init		ENDP

;Ĵ MIX Set/Get channel 

MIX_setactivechn        PROC    PUBLIC USES eax
			mov	MIX_channel,eax
			imul	eax,size mixvoc
			add	eax,ofs MIX_voices
			mov	MIX_voice,eax
			ret
MIX_setactivechn	ENDP

;Ĵ MIX Set/Get mode 

MIX_setmode             PROC    PUBLIC USES ebx
			mov	ebx,MIX_voice
			mov	mixvoc.mode[ebx],al
MIX_setmode_8bit:	ret
MIX_setmode		ENDP

;Ĵ MIX Set/Get start 

MIX_setstart            PROC    PUBLIC USES ebx
			mov	ebx,MIX_voice
                        mov	mixvoc.sstart[ebx],eax
			ret
MIX_setstart		ENDP

;Ĵ MIX Set/Get end 

MIX_setend              PROC    PUBLIC USES ebx
			mov	ebx,MIX_voice
                        mov	mixvoc.send[ebx],eax
			ret
MIX_setend		ENDP

;Ĵ MIX Set/Get loop start 

MIX_setlstart           PROC    PUBLIC USES ebx
			mov	ebx,MIX_voice
                        mov	mixvoc.reqlstart[ebx],eax
			test	mixvoc.state[ebx],mixstate_playing
			jnz	MIX_setlstart_playing
			mov	mixvoc.lstart[ebx],eax
MIX_setlstart_playing:	ret
MIX_setlstart		ENDP

;Ĵ MIX Set/Get loop end 

MIX_setlend             PROC    PUBLIC USES ebx
			mov	ebx,MIX_voice
                        mov	mixvoc.reqlend[ebx],eax
			test	mixvoc.state[ebx],mixstate_playing
			jnz	MIX_setlend_playing
			mov	mixvoc.lend[ebx],eax
MIX_setlend_playing:	ret
MIX_setlend		ENDP

;Ĵ MIX Set/Get frequency 

MIX_setfreq             PROC    PUBLIC USES eax ebx ecx edx
			mov	ecx,MIX_voice
			mov	mixvoc.freq+ds:[ecx],eax
			clr	edx
			shld	edx,eax,24
			shl	eax,24
			mov	ebx,MIX_rate
			div	ebx
			clr	edx
			shld	edx,eax,8
			shl	eax,8
			mov	mixvoc.inch[ecx],edx
			mov	mixvoc.incl[ecx],eax
			ret
MIX_setfreq		ENDP

;Ĵ MIX Set/Get volume 

MIX_setvol              PROC    PUBLIC USES eax ebx
			mov	ebx,MIX_voice
			mov	mixvoc.vol[ebx],eax
			ret
MIX_setvol		ENDP

;Ĵ MIX Set/Get panning 

MIX_setpan              PROC    PUBLIC USES eax ebx
			mov	ebx,MIX_voice
			and	eax,0fh
			mov	mixvoc.pan[ebx],eax
			ret
MIX_setpan		ENDP

;Ĵ MIX start channel 

MIX_startchn            PROC    PUBLIC USES eax ebx ecx
			mov	ecx,MIX_voice
			mov	eax,mixvoc.send[ecx]
			sub	eax,mixvoc.sstart[ecx]
			cmp	eax,2
			jle	MIX_startchn_not

			mov	eax,mixvoc.reqsamstart[ecx]
			mov	mixvoc.samstart[ecx],eax

			test	mixvoc.mode[ecx],cnt_loop
			jz	MIX_startchn_nl
			mov	eax,mixvoc.lend[ecx]
			sub	eax,mixvoc.lstart[ecx]
			cmp	eax,2
                        jg      MIX_startchn_nl
                        and     mixvoc.mode[ecx],NOT cnt_loop+cnt_biloop
MIX_startchn_nl: 	mov	eax,MIX_mix8f
			mov	ebx,MIX_mix8b
			test	mixvoc.mode[ecx],cnt_16bit
			jz	MIX_startchn_8bit
			mov	eax,MIX_mix16f
			mov	ebx,MIX_mix16b
MIX_startchn_8bit:      mov	mixvoc.fjmp[ecx],eax
			mov	mixvoc.bjmp[ecx],ebx

			mov	mixvoc.state[ecx],mixstate_playing
			mov	eax,mixvoc.sstart[ecx]
			mov	mixvoc.posh[ecx],eax
			clr	eax
			mov	mixvoc.posl[ecx],eax
MIX_startchn_not:	ret
MIX_startchn		ENDP

;Ĵ MIX stop channel 

MIX_stopchn             PROC    PUBLIC USES ebx
			mov	ebx,MIX_voice
			and	mixvoc.state[ebx],NOT 1
			ret
MIX_stopchn		ENDP

;Ĵ MIX Set/Get active channels 

MIX_setchns             PROC    PUBLIC USES eax ebx ecx edx esi edi ebp
			mov	MIX_chns,eax
			cmp	eax,0
                        jz      MIX_setchns_skip
                        mov     esi,eax
                        mov     ecx,MIX_amplst[eax*4]
                        imul    ecx,MIX_amp
                        mov     eax,(256*100*100)
                        clr     edx
                        idiv    ecx
                        mov     ebp,eax
                        lea     edi,MIX_voltab
			clr	ecx

MIX_setchns_l1: 	mov	eax,ecx
			and	eax,0ffh
			cbw
			cwde
			sal	eax,16
			mov	ebx,ecx
			sar	ebx,8
			imul	ebx

                        mov     ebx,ebp
                        idiv    ebx

			cmp	eax,000800000h
			jl	MIX_setchns_hok
			mov	eax,007fffffh
MIX_setchns_hok:	cmp	eax,0ff800000h
			jge	MIX_setchns_lok
			mov	eax,0ff800000h
MIX_setchns_lok:        cdq
                        idiv    esi
                        sal     eax,8
			stosd
			inc	ecx
			cmp	ecx,10100h
			jne	MIX_setchns_l1
MIX_setchns_skip:       ret
MIX_setchns		ENDP


;Ĵ MIX Set/Get master volume 

MIX_setmastervol	PROC
			mov	MIX_mastervol,eax
			ret
MIX_setmastervol	ENDP

;Ĵ MIX Set/Get sample 

MIX_setsample           PROC    PUBLIC USES eax ebx
			mov	ebx,sam.number[esi]
			imul	ebx,size mixsam
			lea	ebx,MIX_samples[ebx]
			mov	eax,sam.stype[esi]
			mov	mixsam.stype[ebx],eax
			mov	eax,sam.sstart[esi]
			mov	mixsam.sstart[ebx],eax
			mov	eax,sam.send[esi]
			mov	mixsam.send[ebx],eax
			mov	eax,sam.lstart[esi]
			mov	mixsam.lstart[ebx],eax
			mov	eax,sam.lend[esi]
			mov	mixsam.lend[ebx],eax
			ret
MIX_setsample		ENDP

;Ĵ MIX Clear samples 

MIX_clrsamples          PROC    PUBLIC USES eax ecx edi
			lea	edi,MIX_samples
			mov	ecx,4096*size mixsam
			clr	eax
		rep	stosb
			ret
MIX_clrsamples		ENDP

;Ĵ MIX Init samples 

MIX_initsamples         PROC    PUBLIC
			clc
			ret
MIX_initsamples 	ENDP

;Ĵ MIX Set/Get active sample 

MIX_setactivesample     PROC    PUBLIC USES eax ebx ecx
			mov	ebx,MIX_voice
			mov	mixvoc.sample[ebx],eax
			imul	ecx,eax,size mixsam
			lea	ecx,MIX_samples[ecx]
			mov	eax,mixsam.sstart[ecx]
			mov	mixvoc.reqsamstart[ebx],eax
			test	mixvoc.state[ebx],mixstate_playing
			jnz	MIX_setactivesample_playing
			mov	mixvoc.samstart[ebx],eax
MIX_setactivesample_playing:
			ret
MIX_setactivesample	ENDP

;Ŀ
; Data 
;

.data
                public  MIX_chns
MIX_chns		dd	0
MIX_voldiv      	dd	0
MIX_channel		dd	0
MIX_voice		dd	MIX_voices
                        public  MIX_mastervol
MIX_mastervol           dd      256
MIX_rate		dd	22050

MIX_config		dd	0

                        public  MIX_bytespercount
MIX_bytespercount	dd	0
                        public  MIX_shiftpercount
MIX_shiftpercount	dd	0
                        public  MIX_mixsize
MIX_mixsize     	dd	0
                        public  MIX_outputbuff
MIX_outputbuff  	dd	0
                        public  MIX_outputsize
MIX_outputsize  	dd	0
                        public  MIX_outputofs
MIX_outputofs   	dd	0

MIX_clrbuff		dd	0

			public	MIX_pantab
MIX_pantab		dd	256,000 ,256,032 ,256,064 ,256,096 ,256,128 ,256,160 ,256,192 ,256,224 ,224,256 ,192,256 ,160,256 ,128,256 ,096,256 ,064,256 ,032,256 ,000,256
;			dd	256,000 ,240,016 ,224,032 ,208,048 ,192,064 ,176,080 ,160,096 ,144,112 ,112,144 ,096,160 ,080,176 ,064,191 ,048,208 ,032,224 ,016,240 ,000,256

MIX_lst_mix8f    	dd	MIX_m8mf ,MIX_m8mf ,MIX_m8sf ,MIX_m8sf ,MIX_m8mf ,MIX_m8mf ,MIX_m8sf ,MIX_m8sf
MIX_lst_mix16f    	dd	MIX_m16mf,MIX_m16mf,MIX_m16sf,MIX_m16sf,MIX_m16mf,MIX_m16mf,MIX_m16sf,MIX_m16sf
MIX_lst_mix8b    	dd	MIX_m8mb ,MIX_m8mb ,MIX_m8sb ,MIX_m8sb ,MIX_m8mb ,MIX_m8mb ,MIX_m8sb ,MIX_m8sb
MIX_lst_mix16b    	dd	MIX_m16mb,MIX_m16mb,MIX_m16sb,MIX_m16sb,MIX_m16mb,MIX_m16mb,MIX_m16sb,MIX_m16sb
MIX_lst_tobuff		dd	MIX_b8m,MIX_b16m,MIX_b8s1,MIX_b16s1,MIX_b8m,MIX_b16m,MIX_b8s2,MIX_b16s2

MIX_mix8f       	dd	0
MIX_mix16f       	dd	0
MIX_mix8b       	dd	0
MIX_mix16b       	dd	0
MIX_tobuff		dd	0

MIX_amplst              dd      0
                REPT    MIX_maxvoices
                        dd      MIX_baseamp
                MIX_baseamp=MIX_baseamp+MIX_ampadd
                ENDM

.data?
MIX_voices		db	MIX_maxvoices*size mixvoc dup(?)
			public	MIX_voltab
MIX_voltab		dd	257*256 dup(?)
			public	MIX_prebuff
MIX_prebuff   		dd	8192 dup(?)
MIX_samples		db	4096*size mixsam dup(?)


			END
